/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.GraphUserElement;
import com.parablu.paracloud.element.SiteElement;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.MSGraphUserProperties;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AsyncService {
    private static Logger logger = LogManager.getLogger(AsyncService.class);
    private static final String EXCEPTION = " Exception  :";
    @Autowired
    private CloudMailService cloudMailService;
    @Autowired
    private final UserManagementService managementService;

    public AsyncService(UserManagementService managementService) {
        this.managementService = managementService;
    }

    @Async(value="taskExecutor")
    public void createUserSiteAsync(Cloud cloud, SiteElement siteElement, String userName, String cloudName, String requesterUser) {
        try {
            logger.debug("Starting site creation for: " + siteElement.getPolicyName());
            int cloudId = cloud.getCloudId();
            int code = this.managementService.createUserSite(cloudId, siteElement, userName);
            logger.debug("Site creation response code: " + code);
            if (code == 1536) {
                this.sendEmailSP(cloud, "site-limit-reached", "", "", cloudName);
                logger.error("Site limit reached for cloud: " + cloudName);
            } else {
                logger.info("Site successfully created: " + siteElement.getPolicyName());
            }
        }
        catch (Exception e) {
            logger.error("Exception during async site creation", (Throwable)e);
        }
    }

    private void sendEmailSP(Cloud cloud, String action, String siteName, String userName, String cloudName) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction(action);
        EmailRecipent emailRecipent = new EmailRecipent();
        try {
            List<User> allAdmins = this.managementService.getAllAdmins(1, "");
            for (User adminUser : allAdmins) {
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(adminUser.getUserName());
                emailRecipent.setEmail(adminUser.getEmailId());
                emailRecipents.add(emailRecipent);
                logger.debug("...admin...." + adminUser.getUserName());
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        logger.debug("Toatal email recipents count...:" + emailRecipents.size());
        email.setActionBy(userName);
        email.setRecipents(emailRecipents);
        email.setUserName(siteName);
        email.setToUser(true);
        email.setToAdmins(true);
        email.setCloudName(cloudName);
        this.cloudMailService.sendMail(cloud, email);
    }

    public int createGraphUserAsync(Cloud cloud, GraphUserElement graphUserElement, String userName, String cloudName, String policyType, String productType) {
        int code = 0;
        try {
            logger.debug("Starting graph user creation for: " + graphUserElement.getDefaultExchangePolicyName() + "......." + graphUserElement.getDefaultOdbPolicyName());
            int cloudId = cloud.getCloudId();
            boolean exchangeProd = false;
            boolean odbProd = false;
            MSGraphUserProperties graphUserProperties = this.managementService.getMSGraphUserProperties(cloudId);
            String changedFields = GraphUserDiffUtil.findDiff(graphUserElement, graphUserProperties);
            if (!StringUtils.isEmpty((CharSequence)changedFields)) {
                this.managementService.saveStatisticToDatabase(cloud.getCloudId(), cloudName, changedFields + " ", userName, "", "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_UPDATE.getActionTypeValue());
            }
            this.managementService.saveMSGraphUserProperties(cloudId, graphUserElement);
            if ("Exchange".equalsIgnoreCase(productType)) {
                exchangeProd = true;
            }
            if ("ODB".equalsIgnoreCase(productType)) {
                odbProd = true;
            }
            if (exchangeProd) {
                code = this.managementService.validateExchangeUserRestrictions(cloudId, cloud);
            }
            if (odbProd) {
                code = this.managementService.validateODBUserRestrictions(cloudId, cloud);
            }
            long countOfPresentUsers = 0L;
            long noOfUsersAllowed = 0L;
            if (exchangeProd) {
                countOfPresentUsers = this.managementService.countOfPresentExchangeUsers(cloud.getCloudId(), true);
                noOfUsersAllowed = cloud.getNoOfExchangeUsersAllowed();
            } else {
                countOfPresentUsers = this.managementService.countOfPresentOnedriveUsers(cloud.getCloudId(), true);
                noOfUsersAllowed = cloud.getNoOfOneDriveUsersAllowed();
            }
            logger.debug(countOfPresentUsers + "...trying to-countOfPresentUsers usersla ... " + noOfUsersAllowed);
            logger.debug(productType + "...trying to- validate usersla ... " + code);
            if (countOfPresentUsers >= noOfUsersAllowed) {
                code = 1535;
                logger.debug(productType + "...limit reached... " + code);
                return code;
            }
            code = this.managementService.createGraphUser(cloudId, graphUserElement, userName, productType);
            logger.debug(userName + "...graph user response code: " + code);
            if (graphUserElement.getDefaultOdbPolicyName().startsWith("ODB_") && code == 1535) {
                this.sendEmailSP(cloud, "site-limit-reached", "", "", cloudName);
                logger.error("Site limit reached for cloud: " + cloudName);
            } else if (graphUserElement.getDefaultExchangePolicyName().startsWith("EX_") && code == 1535) {
                this.sendEmailSP(cloud, "site-limit-reached", "", "", cloudName);
                logger.error("Site limit reached for cloud: " + cloudName);
            } else {
                logger.info("Site successfully created: " + graphUserElement.getDefaultExchangePolicyName() + "......." + graphUserElement.getDefaultOdbPolicyName());
            }
        }
        catch (Exception e) {
            logger.error("Exception during async user creation", (Throwable)e);
        }
        return code;
    }

    public class GraphUserDiffUtil {
        public GraphUserDiffUtil(AsyncService this$0) {
        }

        public static String findDiff(GraphUserElement existingElement, MSGraphUserProperties newElement) {
            StringBuilder fieldChangesResponse = new StringBuilder();
            HashMap<String, String> fieldChanges = new HashMap<String, String>();
            GraphUserDiffUtil.compareField("Default ODB Policy", newElement.getDefaultOdbPolicyName(), existingElement.getDefaultOdbPolicyName(), fieldChanges);
            GraphUserDiffUtil.compareField("Default Exchange Policy", newElement.getDefaultExchangePolicyName(), existingElement.getDefaultExchangePolicyName(), fieldChanges);
            GraphUserDiffUtil.compareField("ODB Auto Migration Enabled", newElement.isOdbAutoMigrationEnabled(), existingElement.isOdbAutoMigrationEnabled(), fieldChanges);
            GraphUserDiffUtil.compareField("Exchange Auto Migration Enabled", newElement.isExAutoMigrationEnabled(), existingElement.isExAutoMigrationEnabled(), fieldChanges);
            for (Map.Entry entry : fieldChanges.entrySet()) {
                fieldChangesResponse.append(" (").append((String)entry.getKey()).append(" values ").append((String)entry.getValue()).append("), ");
            }
            if (fieldChangesResponse.length() > 0) {
                fieldChangesResponse.delete(fieldChangesResponse.length() - 2, fieldChangesResponse.length());
            }
            return fieldChangesResponse.toString();
        }

        private static void compareField(String fieldName, boolean oldValue, boolean newValue, Map<String, String> fieldChanges) {
            if (oldValue != newValue) {
                fieldChanges.put(fieldName, "\"" + oldValue + "\" => \"" + newValue + "\"");
            }
        }

        private static void compareField(String fieldName, String oldValue, String newValue, Map<String, String> fieldChanges) {
            if (oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue)) {
                fieldChanges.put(fieldName, "\"" + oldValue + "\" => \"" + newValue + "\"");
            }
        }
    }
}

