/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.paracloud.element.AADUserElement;
import com.parablu.pcbd.domain.IdentityProviderSettings;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import org.json.JSONObject;

public class AADUserService {
    private static final String AUTHORIZATION_CODE = "authorization_code";
    private static final int NONCE_LENGTH = 16;

    public AADUserElement getAADUserByCode(String code, IdentityProviderSettings aadCredentials, String loginUrl) {
        AADUserElement aadUserElement;
        block22: {
            aadUserElement = null;
            try {
                BufferedReader br;
                URL url = URI.create(loginUrl).toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Authorization", this.getBasicAuthHeader(aadCredentials));
                connection.setDoOutput(true);
                String postData = "grant_type=authorization_code&code=" + code + "&redirect_uri=" + aadCredentials.getRedirectURI() + "&nonce=" + AADUserService.generateNonce();
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = postData.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                    try {
                        String responseLine;
                        StringBuilder response = new StringBuilder();
                        while ((responseLine = br.readLine()) != null) {
                            response.append(responseLine.trim());
                        }
                        String accessToken = new JSONObject(response.toString()).getString("access_token");
                        aadUserElement = this.getAADUserElementByAccessToken(accessToken);
                        break block22;
                    }
                    finally {
                        br.close();
                    }
                }
                br = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));
                try {
                    String errorLine;
                    StringBuilder errorResponse = new StringBuilder();
                    while ((errorLine = br.readLine()) != null) {
                        errorResponse.append(errorLine.trim());
                    }
                    System.err.println("Error: " + errorResponse.toString());
                }
                finally {
                    br.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return aadUserElement;
    }

    private String getBasicAuthHeader(IdentityProviderSettings aadCredentials) {
        String auth = aadCredentials.getClientId() + ":" + aadCredentials.getSecretKey();
        return "Basic " + Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
    }

    private AADUserElement getAADUserElementByAccessToken(String accessToken) {
        AADUserElement aadUserElement = new AADUserElement();
        try {
            String[] parts = accessToken.split("\\.");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid JWT token");
            }
            String payload = new String(Base64.getUrlDecoder().decode(parts[1]), StandardCharsets.UTF_8);
            JSONObject payloadJson = new JSONObject(payload);
            String userId = payloadJson.getString("sub");
            aadUserElement.setUserName(userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to decode access token: " + e.getMessage());
        }
        return aadUserElement;
    }

    public static String generateNonce() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] nonceBytes = new byte[16];
        secureRandom.nextBytes(nonceBytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(nonceBytes);
    }
}

