/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.mem.MemoryStore;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.EventHubManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.CPHelperConstant;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.RestoreEventsElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.domain.ApiGateWayProperties;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.EventHubElement;
import com.parablu.pcbd.domain.GmailBackupPolicy;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.RestoreHistory;
import com.parablu.pcbd.domain.User;
import com.parablu.unified.client.element.BackupEvent;
import com.parablu.unified.client.element.FolderRequestDTO;
import com.parablu.unified.client.element.FolderResponseDTO;
import com.parablu.unified.client.element.RestoreEventDto;
import com.parablu.unified.client.element.RetrievalFormat;
import com.parablu.unified.client.element.SignedUrlDTO;
import com.parablu.unified.client.service.impl.BackupServiceImpl;
import com.parablu.unified.client.service.impl.RestoreServiceImpl;
import com.parablu.unified.client.token.AzureTokenGenerator;
import com.parablu.unified.client.token.CachedTokenGenerator;
import com.parablu.unified.client.token.TokenGenerator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EventHubContoller
extends BaseController {
    private static Logger logger = LogManager.getLogger(EventHubContoller.class);
    private static final String EXCEPTION = " Exception  :";
    protected static final String JSONVIEW = "jsonview";
    private static final String CLIENT_TYPE = "clientType";
    private static final String CRAWL_LIMIT = "crawlLimit";
    private static final String START_BACKUP = "START_BACKUP";
    public static final String DD_MMM_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";
    @Autowired
    private EventHubManagementService eventHubManagementService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private AuthorizationService authorizationService1;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private AuditHistoryDao auditHistoryDao;
    @Autowired
    private UserManagementService userManagementService;
    @Autowired
    private CloudMailService cloudMailService;
    private static final String STOP_BACKUP_ERROR_CODE = "1207";
    private static final String PAUSE_BACKUP_ERROR_CODE = "1992";
    private static final String STOP_MAIL_RESTORE_ERROR_CODE = "1993";
    private static final String PAUSE_MAIL_RESTORE_ERROR_CODE = "1994";

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/eventHub/events/"}, method={RequestMethod.POST})
    public void editAction(@PathVariable(value="cloudName") String cloudName1, @RequestBody EventHubElement eventHubElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/eventHub/events/...  to edit action");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)eventHubElement.getActionToDeviceUUID()) && CollectionUtils.isEmpty((Collection)eventHubElement.getActionToDeviceUUIDs())) {
                logger.debug("deviceUUID is null ");
                response.setStatus(406);
                return;
            }
            String actionByUserName = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token).getUser().getUserName();
            this.updateEvents(cloudName1, eventHubElement, request, response, cloudName, cl, cloudId, currentUser, actionByUserName);
            logger.debug("end of calling versions/{versionNumber}/clouds/{cloudName}/eventHub/events/...  to edit action");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    private void addAuditHistory(String cloudName, CloudLicenseTo cl, User currentUser, DeviceElement deviceElement, String actionFormPortal, boolean isDeletedSupportAction) {
        String actionname = null;
        int actionType = 0;
        if (actionFormPortal.equals(CPHelperConstant.EVENTHUB_ACTION.PULL_AGENTLOGS.toString())) {
            if (!isDeletedSupportAction) {
                actionname = "support logs for";
                actionType = PCActionTypes.PULL_AGENTLOGS_ENABLE.getActionTypeValue();
            } else {
                actionname = "Disable support logs for";
                actionType = PCActionTypes.PULL_AGENTLOGS_DISABLE.getActionTypeValue();
            }
        }
        if (actionFormPortal.equals(CPHelperConstant.EVENTHUB_ACTION.PULL_HISTORICAL_LOGS.toString())) {
            if (!isDeletedSupportAction) {
                actionname = "Historical logs for";
                actionType = PCActionTypes.PULL_HISTORICAL_LOGS_ENABLE.getActionTypeValue();
            } else {
                actionname = "Disable Historical logs for";
                actionType = PCActionTypes.PULL_HISTORICAL_LOGS_DISABLE.getActionTypeValue();
            }
        }
        if (actionFormPortal.equals(CPHelperConstant.EVENTHUB_ACTION.STOP_BACKUP_WHILE_RESTORE.toString())) {
            if (!isDeletedSupportAction) {
                actionname = "has Disabled backup  of ";
                actionType = PCActionTypes.STOP_BACKUP_WHILE_RESTORE.getActionTypeValue();
            } else {
                actionname = "has Enabled backup of ";
                actionType = PCActionTypes.STOP_BACKUP_WHILE_RESTORE.getActionTypeValue();
            }
        }
        if (actionFormPortal.equals(CPHelperConstant.EVENTHUB_ACTION.FULL_BACKUP.toString()) && !isDeletedSupportAction) {
            actionname = "a Full backup of";
            actionType = PCActionTypes.START_BACKUP.getActionTypeValue();
        }
        if (actionFormPortal.equals(CPHelperConstant.EVENTHUB_ACTION.START_BACKUP.toString()) && !isDeletedSupportAction) {
            actionname = "a Start backup of";
            actionType = PCActionTypes.START_BACKUP.getActionTypeValue();
        }
        if (actionFormPortal.equals(CPHelperConstant.EVENTHUB_ACTION.CANCEL_BACKUP.toString())) {
            actionname = "cancel backup of";
            actionType = PCActionTypes.CANCEL_BACKUP.getActionTypeValue();
        }
        if (actionFormPortal.equals(CPHelperConstant.EVENTHUB_ACTION.STOP_BACKUP.toString()) && !isDeletedSupportAction) {
            actionname = "Stop backup of";
            actionType = PCActionTypes.STOP_BACKUP.getActionTypeValue();
        }
        if (actionFormPortal.equals(CPHelperConstant.EVENTHUB_ACTION.PAUSE_BACKUP.toString()) && !isDeletedSupportAction) {
            actionname = "Pause backup of";
            actionType = PCActionTypes.PAUSE_BACKUP.getActionTypeValue();
        }
        if (actionFormPortal.equals(CPHelperConstant.EVENTHUB_ACTION.DATABASES.toString())) {
            if (!isDeletedSupportAction) {
                actionname = "databases of ";
                actionType = PCActionTypes.DATABASES.getActionTypeValue();
            } else {
                actionname = "Disable databases of";
                actionType = PCActionTypes.DATABASES.getActionTypeValue();
            }
        }
        if (actionFormPortal.equals(CPHelperConstant.EVENTHUB_ACTION.SETUP_LOGS.toString())) {
            if (!isDeletedSupportAction) {
                actionname = "Setup Logs of ";
                actionType = PCActionTypes.SETUP_LOGS.getActionTypeValue();
            } else {
                actionname = "DisableSetup Logs of";
                actionType = PCActionTypes.SETUP_LOGS.getActionTypeValue();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)deviceElement.getDeviceType()) && deviceElement.getDeviceType().equals(Device.TYPE.SHAREPOINT.toString())) {
            if (StringUtils.isNotEmpty((CharSequence)actionname)) {
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "requested " + actionname + " SharePoint Online site ", currentUser.getUserName(), deviceElement.getUserName(), "Portal", System.currentTimeMillis(), actionType);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)actionname)) {
            this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "requested " + actionname, currentUser.getUserName(), "asset name:" + deviceElement.getDeviceName() + ", user name:" + deviceElement.getUserName(), "Portal", System.currentTimeMillis(), actionType);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/eventHub/events/"}, method={RequestMethod.GET})
    public ModelAndView getEvents(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String deviceUUID = request.getParameter("deviceUUID");
        logger.debug("...old api method versions/{versionNumber}/clouds/{cloudName}/eventHub/events/ ...." + deviceUUID);
        return this.getEvents(cloudName1, deviceUUID, request, response);
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/eventHub/events/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView editActions(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        return this.getEvents(cloudName1, deviceUUID, request, response);
    }

    private ModelAndView getEvents(String cloudName1, String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(JSONVIEW);
        String client = request.getHeader(CLIENT_TYPE);
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/eventHub/events/...  to get action of " + deviceUUID);
        int cloudId = 0;
        try {
            User user;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            cloudId = cl.getCloud().getCloudId();
            if (this.getCurrentCrawlLimit(cloudId) > this.registry.get(cl.getCloud().getCloudId()).getMaxCrawlHitCount()) {
                logger.debug("@@@CRAWL_COUNT has exceeded  /eventHub/events/{deviceUUID} the max limit of>>>:" + this.registry.get(cl.getCloud().getCloudId()).getMaxCrawlHitCount() + "..sleep for 20 secs...");
                response.setStatus(500);
                return null;
            }
            this.incrementCrawlLimit(cloudId);
            if (!this.checkLicense(cl, response)) {
                this.decrementCrawlLimit(cloudId);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, user = new User(), response, userName)) {
                this.decrementCrawlLimit(cloudId);
                return null;
            }
            if (user != null && user.isSuspended()) {
                logger.debug("User is suspended.....");
                response.setStatus(400);
                return null;
            }
            logger.debug(" ...events,,,," + deviceUUID);
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null) {
                response.setStatus(406);
                this.decrementCrawlLimit(cloudId);
                logger.error("...invalid device.....");
                return null;
            }
            long currentmillis = System.currentTimeMillis();
            logger.debug("calling events1....");
            DeviceBackupOverView overView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            if (overView != null) {
                String actionByUserName = user.getUserName();
                if (StringUtils.isEmpty((CharSequence)client)) {
                    this.deviceManagementService.updateLastHeardTime(cloudId, overView.getId());
                    logger.debug("[agentHeardTimeStamp][" + actionByUserName + "][" + deviceUUID + "][" + currentmillis + "]");
                }
                EventHub eventHub = new EventHub();
                eventHub.setActionBy(actionByUserName);
                eventHub.setActionToDeviceUUID(deviceUUID);
                String actionToUserName = overView.getUserName();
                logger.debug(actionToUserName + "...calling events2...." + actionByUserName);
                eventHub.setActionToUserName(actionToUserName);
                long devicePolicyUpdatedTime = overView.getPolicyUpdatedTime();
                long timeStampOfPolicyModified = user.getPolicyModifiedTime();
                List<String> actions = this.eventHubManagementService.getActionForDevice(cloudId, cloudName, eventHub, timeStampOfPolicyModified, devicePolicyUpdatedTime);
                EventHubElement eventHubElement = new EventHubElement();
                eventHubElement.setActions(actions);
                eventHubElement.setActionToDeviceUUID(deviceUUID);
                eventHubElement.setActionToUserName(eventHub.getActionToUserName());
                modelAndView.addObject((Object)eventHubElement);
                response.setStatus(200);
                this.decrementCrawlLimit(cloudId);
            }
            return modelAndView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            this.decrementCrawlLimit(cloudId);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/eventHub/events/"}, method={RequestMethod.DELETE})
    public void deleteAction(@PathVariable(value="cloudName") String cloudName1, @RequestParam(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(JSONVIEW);
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/eventHub/events/...  TO DELETE  ");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String actions = request.getHeader("action");
            List<Object> list = new ArrayList();
            if (StringUtils.isNotEmpty((CharSequence)actions)) {
                list = Arrays.asList(actions.split(","));
            }
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return;
            }
            String actionByUserName = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token).getUser().getUserName();
            DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, deviceUUID);
            String acctionToUserName = deviceElement.getUserName();
            EventHub eventHub = new EventHub();
            eventHub.setActionToDeviceUUID(deviceUUID);
            eventHub.setActionToUserName(acctionToUserName);
            eventHub.setActionBy(actionByUserName);
            for (String string : list) {
                eventHub.setAction(string);
                logger.debug("Deleteing action for user " + acctionToUserName + " for device " + deviceUUID + " action is " + string);
                this.eventHubManagementService.deleteAction(cloudId, cloudName, eventHub);
            }
            if (StringUtils.isEmpty((CharSequence)actions)) {
                logger.debug("action list is empty so delete all even actions");
                this.eventHubManagementService.deleteAllLogEvents(cloudId, cloudName, eventHub);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return;
        }
    }

    private synchronized int getCurrentCrawlLimit(int cloudId) {
        int crawlLimit = 0;
        if (MemoryStore.get((String)CRAWL_LIMIT) != null) {
            crawlLimit = (Integer)MemoryStore.get((String)CRAWL_LIMIT);
        }
        EventHubContoller.printLogs("@@@CURRENT-Crawl count ............. " + crawlLimit, this.registry.get(cloudId).isBrevityLogging());
        return crawlLimit;
    }

    private synchronized void incrementCrawlLimit(int cloudId) {
        int crawlLimit = this.getCurrentCrawlLimit(cloudId);
        MemoryStore.delete((String)CRAWL_LIMIT);
        MemoryStore.add((String)CRAWL_LIMIT, (Object)(++crawlLimit));
        EventHubContoller.printLogs("@@@INCREMENT Crawl count ............. " + crawlLimit, this.registry.get(cloudId).isBrevityLogging());
    }

    private synchronized void decrementCrawlLimit(int cloudId) {
        int crawlLimit = this.getCurrentCrawlLimit(cloudId);
        if (crawlLimit > 0) {
            --crawlLimit;
        }
        MemoryStore.delete((String)CRAWL_LIMIT);
        MemoryStore.add((String)CRAWL_LIMIT, (Object)crawlLimit);
        logger.debug("@@@DECREMENT Crawl count ............. " + crawlLimit);
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/restoreEvents/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView getRestoreEvents(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        response.setContentType("text/html; charset=UTF-8");
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/restoreEvents/...  to get restoreEvents of " + deviceUUID);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            String destinationFolder = request.getHeader("destinationFolder");
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response, userName)) {
                return null;
            }
            if (user != null && user.isSuspended()) {
                logger.debug("User is suspended.....");
                response.setStatus(400);
                return null;
            }
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                return null;
            }
            RestoreEventsElement restoreEventByUUIDAndFolder = this.eventHubManagementService.getRestoreEventByUUIDAndFolder(cloudId, deviceUUID, destinationFolder);
            logger.debug("User ................");
            if (restoreEventByUUIDAndFolder == null) {
                restoreEventByUUIDAndFolder = new RestoreEventsElement();
            } else {
                logger.debug(".....restoreEventByUUIDAndFolder.getActionOnDeviceUUID()....." + restoreEventByUUIDAndFolder.getActionOnDeviceUUID());
                if (!deviceUUID.equalsIgnoreCase(restoreEventByUUIDAndFolder.getActionOnDeviceUUID())) {
                    device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, restoreEventByUUIDAndFolder.getActionOnDeviceUUID());
                }
                if (device != null) {
                    restoreEventByUUIDAndFolder.setActionOnDeviceType(device.getOsType());
                    restoreEventByUUIDAndFolder.setDeviceId(device.getId().toString());
                }
            }
            response.setStatus(200);
            logger.debug(device.getId().toString() + "User ................" + restoreEventByUUIDAndFolder.getSuspendBackup());
            modelAndView.addObject((Object)restoreEventByUUIDAndFolder);
            return modelAndView;
        }
        catch (Exception e) {
            logger.debug("EXCEPTION ................");
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/restoreEvents/{deviceUUID}"}, method={RequestMethod.DELETE})
    public void deleteRestoreActions(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("versions/{versionNumber}/clouds/{cloudName}/restoreEvents/{deviceUUID}   to delete restore... " + deviceUUID);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            String batchId = request.getHeader("batchId");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                return;
            }
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                return;
            }
            RestoreHistory restoreHistory = this.eventHubManagementService.getRestoreHistoryForUUID(cloudId, deviceUUID);
            boolean isPstRestore = false;
            String pstFileName = "";
            if (restoreHistory != null) {
                isPstRestore = restoreHistory.isPstRestore();
                pstFileName = restoreHistory.getPstFileName();
            }
            logger.debug("...pstfile details.." + pstFileName + "....." + isPstRestore);
            if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.getProduct()) || device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.getProduct()) || device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.getProduct())) {
                this.eventHubManagementService.deleteRestoreEventsByUUID(cloudId, deviceUUID);
                logger.debug("......restore events3....");
            } else {
                this.eventHubManagementService.deleteRestoreEventsByBatchId(cloudId, batchId);
                logger.debug("......restore events4....");
            }
            logger.debug("LATEST ...versions/{versionNumber}/clouds/{cloudName}/restoreEvents/{deviceUUID}   to delete restore2... ");
            if (StringUtils.isNotEmpty((CharSequence)device.getDeviceType()) && device.getDeviceType().equals(Device.TYPE.SHAREPOINT.toString())) {
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "requested cancelled restore of SharePoint Online site ", currentUser.getUserName(), device.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.START_RESTORE.getActionTypeValue());
            } else if (isPstRestore) {
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "cancelled pst restore " + pstFileName + " ", currentUser.getUserName(), "asset name:" + device.getDeviceName(), "Portal", System.currentTimeMillis(), PCActionTypes.START_RESTORE.getActionTypeValue());
            } else {
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "cancelled restore for", currentUser.getUserName(), "asset name:" + device.getDeviceName(), "Portal", System.currentTimeMillis(), PCActionTypes.START_RESTORE.getActionTypeValue());
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        logger.debug("end of versions/{versionNumber}/clouds/{cloudName}/restoreEvents/{deviceUUID}   to delete restore... " + deviceUUID);
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/restoreEvents/"}, method={RequestMethod.POST})
    public ModelAndView createRestoreActions(@PathVariable(value="cloudName") String cloudName1, @RequestBody RestoreEventsElement restoreEventsElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/eventHub/events/...  to edit action");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                return null;
            }
            Device sourceDevice = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, restoreEventsElement.getActionOnDeviceUUID());
            Device destinationDevice = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, restoreEventsElement.getDestinationDeviceUUID());
            if (destinationDevice == null) {
                response.setStatus(406);
                logger.error("...invalid destinationDevice.....");
                return null;
            }
            String actionByUserName = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token).getUser().getUserName();
            restoreEventsElement.setActionBy(actionByUserName);
            RestoreEventsElement updateRestoreEvents = this.eventHubManagementService.updateRestoreEvents(cloudId, restoreEventsElement, destinationDevice.getUserName());
            if (updateRestoreEvents != null) {
                modelAndView.addObject((Object)updateRestoreEvents);
                response.setStatus(417);
                return modelAndView;
            }
            String actionOnUser = this.constructActionOnUser(sourceDevice, destinationDevice, restoreEventsElement);
            this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "initiated restore for", currentUser.getUserName(), actionOnUser, "Portal", System.currentTimeMillis(), PCActionTypes.START_RESTORE.getActionTypeValue());
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        return modelAndView;
    }

    private String constructActionOnUser(Device sourceDevice, Device destinationDevice, RestoreEventsElement restoreEventsElement) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append("{Source - [User: ").append(sourceDevice.getUserName()).append("] [Asset Name: ").append(sourceDevice.getDeviceName()).append("]} ");
            stringBuilder.append("{Destination - [User: ").append(destinationDevice.getUserName()).append("] [Asset Name: ").append(destinationDevice.getDeviceName()).append("]} ");
            stringBuilder.append("{Restore Source Path: ");
            if (restoreEventsElement.getFileElement().getFileCompletePath().isEmpty()) {
                stringBuilder.append("All Drives} ");
            } else {
                stringBuilder.append(restoreEventsElement.getFileElement().getFileCompletePath()).append("} ");
            }
            if (!restoreEventsElement.isInPlaceRestore()) {
                stringBuilder.append("{Restore Destination Path: ").append(restoreEventsElement.getDestinationPath()).append("} ");
            }
            stringBuilder.append("{Properties: ");
            stringBuilder.append("[Number of Threads: ").append(restoreEventsElement.getNoOfThreads()).append("] ");
            stringBuilder.append("[Disallow new backups during this restore: ").append(restoreEventsElement.getSuspendBackup()).append("] ");
            stringBuilder.append("[Restore all Versions: ").append(restoreEventsElement.isRestoreAllVersions()).append("] ");
            stringBuilder.append("[In place Restore: ").append(restoreEventsElement.isInPlaceRestore()).append("] ");
            stringBuilder.append("[Restore Deleted Files: ").append(restoreEventsElement.isRestoreDeletedFiles()).append("] ");
            stringBuilder.append("[Overwrite Newer Files: ").append(restoreEventsElement.isOverwriteNewerFiles()).append("] ");
            stringBuilder.append("[Scan Files for Malware: ").append(restoreEventsElement.isScanRestoreFiles()).append("] ");
            if (restoreEventsElement.getRestoreDataBefore() != 0L) {
                Date date = new Date(restoreEventsElement.getRestoreDataBefore());
                stringBuilder.append("[Restore Before: ").append(date).append("]");
            }
            stringBuilder.append("}");
        }
        catch (Exception e) {
            logger.error("Failed to construct Audit History" + e.getMessage());
        }
        return stringBuilder.toString();
    }

    private void updateEventsByDevice(String cloudName1, EventHubElement eventHubElement, HttpServletRequest request, HttpServletResponse response, CloudLicenseTo cl, int cloudId, User currentUser, String actionByUserName, DeviceElement deviceElement, String acctionToUserName) {
        logger.debug(request.getHeader("isStopBackup") + "..... device type..... " + request.getHeader("isPauseBackup"));
        User deviceUser = this.userManagementService.getUserDetails(cloudId, cloudName1, deviceElement.getUserName());
        boolean officeProduct = false;
        boolean gmail = false;
        boolean gdrive = false;
        if (deviceElement.getDeviceName().contains("Microsoft Exchange") || deviceElement.getDeviceName().contains("Microsoft OneDrive") || deviceElement.getDeviceName().contains("Microsoft SharePoint")) {
            officeProduct = true;
        }
        if (deviceElement.getDeviceType().equalsIgnoreCase(Device.TYPE.GMAIL.getProduct())) {
            gmail = true;
        }
        if (deviceElement.getDeviceType().equalsIgnoreCase(Device.TYPE.GOOGLEDRIVE.getProduct())) {
            gdrive = true;
        }
        String policyName = "";
        String policyType = "";
        if (officeProduct || gmail || gdrive) {
            if (deviceElement.getDeviceName().contains("Microsoft Exchange")) {
                policyName = deviceUser.getExchangePolicyName();
                policyType = "Exchange";
            }
            if (deviceElement.getDeviceName().contains("Microsoft SharePoint")) {
                policyName = deviceUser.getSpPolicyName();
                policyType = "Sharepoint";
            }
            if (deviceElement.getDeviceName().contains("Microsoft OneDrive")) {
                policyName = deviceUser.getOneDrivePolicyName();
                policyType = "ODB";
            }
            if (deviceElement.getDeviceType().equalsIgnoreCase(Device.TYPE.GMAIL.getProduct())) {
                policyName = deviceUser.getGmailPolicyName();
                policyType = "Gmail";
            }
            if (deviceElement.getDeviceType().equalsIgnoreCase(Device.TYPE.GOOGLEDRIVE.getProduct())) {
                policyName = deviceUser.getGmailPolicyName();
                policyType = "Google Drive";
            }
        }
        if (Boolean.parseBoolean(request.getHeader("isPauseBackup"))) {
            logger.debug(actionByUserName + "..entering pause event..." + acctionToUserName);
            String errorCode = PAUSE_BACKUP_ERROR_CODE;
            if (PAUSE_BACKUP_ERROR_CODE.equalsIgnoreCase(errorCode)) {
                errorCode = "1208";
            }
            logger.debug("error code for action ... " + errorCode);
            this.eventHubManagementService.updateBackupBatchForStopAndPauseBkp(cloudId, eventHubElement.getActionToDeviceUUID(), errorCode, CPHelperConstant.EVENTHUB_ACTION.PAUSE_BACKUP.toString(), policyName);
            this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, CPHelperConstant.EVENTHUB_ACTION.PAUSE_BACKUP.toString(), false);
            this.eventHubManagementService.deleteEventHubForDeviceUUID(cloudId, deviceElement.getDeviceUUID(), START_BACKUP);
            response.setStatus(200);
            logger.debug("...pause backup... " + eventHubElement.getActionToDeviceUUID());
            return;
        }
        if (Boolean.parseBoolean(request.getHeader("isStopBackup"))) {
            String errorCode = STOP_BACKUP_ERROR_CODE;
            logger.debug(actionByUserName + "..entering StopBackup event..." + acctionToUserName);
            if (STOP_BACKUP_ERROR_CODE.equalsIgnoreCase(errorCode)) {
                errorCode = "1209";
            }
            logger.debug(officeProduct + "error code for action ... " + errorCode);
            logger.debug("CPHelperConstant.isMultiTenancy()" + this.registry.get(cloudId).isMultiTenancy());
            if (this.registry.get(cloudId).isMultiTenancy()) {
                logger.debug("CPHelperConstant.isMultiTenancy() inside");
                this.multiTenancyBackupInitiate(eventHubElement.getHostName(), eventHubElement.getActionToDeviceUUID(), false, response, errorCode, cloudId);
            } else {
                this.eventHubManagementService.updateBackupBatchForStopAndPauseBkp(cloudId, eventHubElement.getActionToDeviceUUID(), errorCode, CPHelperConstant.EVENTHUB_ACTION.STOP_BACKUP.toString(), policyName);
            }
            if (officeProduct) {
                logger.debug(officeProduct + "error code for action1 ... " + policyName);
                this.eventHubManagementService.deleteBatchFromOdServer(deviceElement.getDeviceUUID(), policyName);
                this.eventHubManagementService.deleteEventHubForDeviceUUID(cloudId, deviceElement.getDeviceUUID(), START_BACKUP);
            }
            this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, CPHelperConstant.EVENTHUB_ACTION.STOP_BACKUP.toString(), false);
            response.setStatus(200);
            logger.debug("...stopped backup... " + eventHubElement.getActionToDeviceUUID());
            return;
        }
        logger.debug("... creating event hub....");
        EventHub eventHub = new EventHub();
        eventHub.setActionBy(actionByUserName);
        eventHub.setActionStatus(CPHelperConstant.EVENTHUB_ACTION_STATUS.CREATED.toString());
        eventHub.setActionToUserName(acctionToUserName);
        eventHub.setActionToDeviceUUID(eventHubElement.getActionToDeviceUUID());
        if (Device.TYPE.ONEDRIVE.getProduct().equals(deviceElement.getDeviceType()) || Device.TYPE.OUTLOOK.getProduct().equals(deviceElement.getDeviceType()) || Device.TYPE.SHAREPOINT.getProduct().equals(deviceElement.getDeviceType())) {
            eventHub.setOdStatus(EventHub.ODSTATUS.STARTED.toString());
        }
        List<String> actionsFromDb = this.eventHubManagementService.getActionsByUserNameAndAction(cloudId, cloudName1, eventHub);
        if (eventHubElement.getActions().size() == 1 && eventHubElement.getActions().contains(START_BACKUP) && actionsFromDb.contains(START_BACKUP)) {
            logger.debug("The request for start backup is already queued in Event hub");
            response.setStatus(417);
        }
        logger.debug("actions From Db" + String.valueOf(actionsFromDb));
        Cloud cloudFinal = cl.getCloud();
        boolean officeProductFinal = officeProduct;
        boolean gmailFinal = gmail;
        boolean gdriveFinal = gdrive;
        String policyNameFinal = policyName;
        ArrayList<String> actionsFromDb1 = new ArrayList<String>();
        actionsFromDb1.addAll(actionsFromDb);
        List actionsFormReqst = eventHubElement.getActions();
        if (!CollectionUtils.isEmpty((Collection)eventHubElement.getActions())) {
            GmailBackupPolicy policy;
            logger.debug("...inside if 1.....");
            actionsFromDb1.removeAll(actionsFormReqst);
            actionsFormReqst.removeAll(actionsFromDb);
            policyName = "";
            if (deviceElement.getDeviceName().contains("Microsoft Exchange")) {
                policyName = deviceUser.getExchangePolicyName();
                policyType = "Exchange";
            }
            if (deviceElement.getDeviceName().contains("Microsoft SharePoint")) {
                policyName = deviceUser.getSpPolicyName();
                policyType = "Sharepoint";
            }
            if (deviceElement.getDeviceName().contains("Microsoft OneDrive")) {
                policyName = deviceUser.getOneDrivePolicyName();
                policyType = "ODB";
            }
            if (deviceElement.getDeviceType().equalsIgnoreCase(Device.TYPE.GMAIL.getProduct())) {
                policyName = deviceUser.getGmailPolicyName();
                policyType = Device.TYPE.GMAIL.getProduct();
            }
            if (deviceElement.getDeviceType().equalsIgnoreCase(Device.TYPE.GOOGLEDRIVE.getProduct())) {
                policyName = deviceUser.getGdrivePolicyName();
                policyType = Device.TYPE.GOOGLEDRIVE.getProduct();
            }
            logger.debug(deviceUser.getUserName() + "...user not in active policy... " + policyName + "...." + policyType);
            if ((policyType.equalsIgnoreCase(GmailBackupPolicy.TYPE.GMAIL.getProductType()) || policyType.equalsIgnoreCase(GmailBackupPolicy.TYPE.GOOGLEDRIVE.getProductType())) && (policy = this.eventHubManagementService.getGmailBackupPolicy(cloudId, cloudName1, policyName, policyType)) != null && !policy.isActive()) {
                response.setStatus(403);
                logger.debug("...user not in active policy... " + policy.getPolicyName());
                return;
            }
            OfficeBackupPolicy officeBackupPolicy = this.eventHubManagementService.getOfficeBackupPolicyForNameAndType(cloudId, policyName, policyType);
            if (officeBackupPolicy != null && !officeBackupPolicy.isActive()) {
                response.setStatus(403);
                logger.debug("...user not in active policy... " + officeBackupPolicy.getPolicyName());
                return;
            }
            if (officeBackupPolicy == null) {
                logger.debug("... policy null... ");
            } else {
                logger.debug("... policy not null... " + officeBackupPolicy.getPolicyName());
            }
            actionsFormReqst.forEach(action -> {
                EventHub eventHubObj = new EventHub();
                BeanUtils.copyProperties((Object)eventHub, (Object)eventHubObj);
                logger.debug("actions Form Reqst" + String.valueOf(actionsFormReqst));
                logger.debug("action:" + action);
                eventHubObj.setAction(action);
                eventHubObj.setDeviceType(deviceElement.getDeviceType());
                if (officeProductFinal || gmailFinal || gdriveFinal) {
                    if (officeProductFinal || gmailFinal || gdriveFinal && ("FULL_BACKUP".equalsIgnoreCase(eventHubObj.getAction()) || START_BACKUP.equalsIgnoreCase(eventHubObj.getAction()))) {
                        boolean isFullBackup = false;
                        if ("FULL_BACKUP".equalsIgnoreCase(eventHubObj.getAction())) {
                            isFullBackup = true;
                        }
                        logger.debug(isFullBackup + "...overview1...." + eventHubObj.getAction());
                        Device device = this.deviceManagementService.getDeviceByDeviceUUID(cloudId, "", deviceElement.getDeviceUUID());
                        DeviceBackupOverView deviceBackupOverView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceElement.getDeviceUUID());
                        if (!isFullBackup && StringUtils.isEmpty((CharSequence)deviceBackupOverView.getFirstBkpStartTime())) {
                            isFullBackup = true;
                        }
                        logger.debug(isFullBackup + "...overview...." + deviceBackupOverView.getLastBkpStatus());
                        if (deviceBackupOverView != null && !StringUtils.isEmpty((CharSequence)deviceBackupOverView.getLastBkpStatus()) && deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase("PAUSED")) {
                            this.eventHubManagementService.resumeBackup(policyNameFinal, device, cloudFinal);
                        } else {
                            logger.debug("CPHelperConstant.isMultiTenancy()" + this.registry.get(cloudId).isMultiTenancy());
                            if (this.registry.get(cloudId).isMultiTenancy()) {
                                this.multiTenancyBackupInitiate(eventHubElement.getHostName(), eventHubElement.getActionToDeviceUUID(), isFullBackup, response, null, cloudId);
                            } else {
                                this.eventHubManagementService.saveAction(cloudId, cloudName1, eventHubObj);
                                this.saveBatchDetails(cloudId, policyNameFinal, device, isFullBackup, cloudFinal);
                            }
                        }
                    }
                } else {
                    this.eventHubManagementService.saveAction(cloudId, cloudName1, eventHubObj);
                }
                logger.debug("....Before calling v3....");
                logger.debug("....eventhub...." + officeProductFinal + "......" + eventHubObj.getAction());
                this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, (String)action, false);
            });
            actionsFromDb1.forEach(action -> {
                logger.debug("actions From Db1" + String.valueOf(actionsFromDb1));
                eventHub.setAction(action);
                this.eventHubManagementService.deleteAction(cloudId, cloudName1, eventHub);
                if (action.contains(CPHelperConstant.EVENTHUB_ACTION.PULL_AGENTLOGS.toString()) || action.contains(CPHelperConstant.EVENTHUB_ACTION.PULL_HISTORICAL_LOGS.toString()) || action.contains(CPHelperConstant.EVENTHUB_ACTION.DATABASES.toString()) || action.contains(CPHelperConstant.EVENTHUB_ACTION.SETUP_LOGS.toString())) {
                    this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, (String)action, true);
                }
            });
        } else {
            logger.debug("...inside else 1....." + String.valueOf(actionsFromDb));
            this.eventHubManagementService.deleteAllActionByDeviceUUID(cloudId, eventHub);
            boolean isCancelBackup = true;
            if (actionsFromDb.contains(CPHelperConstant.EVENTHUB_ACTION.PULL_AGENTLOGS.toString())) {
                this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, "PULL_AGENTLOGS", true);
                isCancelBackup = false;
            }
            if (actionsFromDb.contains(CPHelperConstant.EVENTHUB_ACTION.PULL_HISTORICAL_LOGS.toString())) {
                this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, "PULL_HISTORICAL_LOGS", true);
                isCancelBackup = false;
            }
            if (actionsFromDb.contains(CPHelperConstant.EVENTHUB_ACTION.DATABASES.toString())) {
                this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, "DATABASES", true);
                isCancelBackup = false;
            }
            if (actionsFromDb.contains(CPHelperConstant.EVENTHUB_ACTION.SETUP_LOGS.toString())) {
                this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, "SETUP_LOGS", true);
                isCancelBackup = false;
            }
            if (isCancelBackup) {
                this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, CPHelperConstant.EVENTHUB_ACTION.CANCEL_BACKUP.toString(), true);
            }
        }
    }

    private void updateEvents(String cloudName1, EventHubElement eventHubElement, HttpServletRequest request, HttpServletResponse response, String cloudName, CloudLicenseTo cl, int cloudId, User currentUser, String actionByUserName) {
        if (!StringUtils.isEmpty((CharSequence)eventHubElement.getActionToDeviceUUID())) {
            DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, eventHubElement.getActionToDeviceUUID());
            String acctionToUserName = deviceElement.getUserName();
            logger.debug("..... device type..... " + deviceElement.getDeviceType());
            this.updateEventsByDevice(cloudName1, eventHubElement, request, response, cl, cloudId, currentUser, actionByUserName, deviceElement, acctionToUserName);
        } else {
            for (String deviceUUID : eventHubElement.getActionToDeviceUUIDs()) {
                logger.debug(".....deviceUUID........" + deviceUUID);
                DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, deviceUUID);
                if (deviceElement != null) {
                    String acctionToUserName = deviceElement.getUserName();
                    logger.debug("..... acctionToUserName..... " + acctionToUserName);
                    eventHubElement.setActionToDeviceUUID(deviceUUID);
                    this.updateEventsByDevice(cloudName1, eventHubElement, request, response, cl, cloudId, currentUser, actionByUserName, deviceElement, acctionToUserName);
                    continue;
                }
                logger.debug("..................Device is null............");
            }
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/restore/stop"}, method={RequestMethod.POST})
    public void createRestoreActions(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/restore/stop...  to edit action");
        try {
            String[] deviceUUIDs;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                return;
            }
            String deviceUUIDsList = request.getHeader("deviceUUIDs");
            if (StringUtils.isEmpty((CharSequence)deviceUUIDsList)) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                return;
            }
            String actionByUserName = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token).getUser().getUserName();
            for (String deviceUUID : deviceUUIDs = deviceUUIDsList.split(",")) {
                logger.debug("....deviceUUID stop.........." + deviceUUID);
                DeviceElement deviceElement = null;
                if (deviceUUID.equals("Global Search (Microsoft Exchange)")) {
                    BackupBatch backupBatch = this.eventHubManagementService.getBackupBatch(cloudId, deviceUUID);
                    if (backupBatch == null) continue;
                    this.eventHubManagementService.deleteRestoreEventsByBatchId(cloudId, backupBatch.getId().toString());
                    this.eventHubManagementService.updateBackupBatchForStopRestore(cloudId, "Global Search (Microsoft Exchange)", STOP_BACKUP_ERROR_CODE);
                    String actionname = "Stop restore";
                    this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "requested " + actionname, actionByUserName, "asset name:Global Search (Microsoft Exchange)", "Portal", System.currentTimeMillis(), PCActionTypes.STOP_RESTORE.getActionTypeValue());
                    continue;
                }
                deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, deviceUUID);
                String actionname = "Stop restore";
                if (deviceElement.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.getProduct()) || deviceElement.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.getProduct()) || deviceElement.getDeviceType().equalsIgnoreCase(Device.TYPE.BACKUP.getProduct()) || StringUtils.isEmpty((CharSequence)deviceElement.getDeviceType())) {
                    this.eventHubManagementService.deleteRestoreEventsByUUID(cloudId, deviceUUID);
                    this.eventHubManagementService.updateBackupBatchForStopRestore(cloudId, deviceUUID, STOP_BACKUP_ERROR_CODE);
                    this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "requested " + actionname, actionByUserName, "asset name:" + deviceElement.getDeviceName() + ", user Name:" + deviceElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.STOP_RESTORE.getActionTypeValue());
                    continue;
                }
                if (!deviceElement.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.getProduct())) continue;
                this.eventHubManagementService.deleteRestoreEventsByUUID(cloudId, deviceUUID);
                this.eventHubManagementService.updateBackupBatchForStopRestore(cloudId, deviceUUID, STOP_BACKUP_ERROR_CODE);
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "requested " + actionname, actionByUserName, "site name:" + deviceElement.getDeviceName(), "Portal", System.currentTimeMillis(), PCActionTypes.STOP_RESTORE.getActionTypeValue());
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error("exception e={}", (Throwable)e);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/cp/stop"}, method={RequestMethod.POST})
    public void cpStop(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/cp/stop...." + request.getHeader("productType") + "...." + request.getHeader("status"));
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                return;
            }
            String productType = request.getHeader("productType");
            String actionByUserName = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token).getUser().getUserName();
            logger.debug("....deviceUUID stop.........." + productType);
            this.deviceManagementService.stopCapacitySavings(cloudId, productType, request.getHeader("status"), currentUser.getUserName());
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error("exception e={}", (Throwable)e);
            response.setStatus(500);
        }
    }

    public String saveBatchDetails(int cloudId, String policyName, Device device, boolean isFullBackup, Cloud cloudFinal) {
        return this.eventHubManagementService.saveBatchDetails(cloudId, policyName, device, isFullBackup, cloudFinal);
    }

    public void multiTenancyBackupInitiate(String cloudName, String deviceUUID, Boolean isFullBackup, HttpServletResponse response, String errorCode, int cloudId) {
        try {
            logger.debug("multiTenancyBackupInitiate--->inside");
            logger.debug("multiTenancyBackupInitiate--->inside" + isFullBackup);
            AzureTokenGenerator tokenGenerator = new AzureTokenGenerator();
            CachedTokenGenerator cachedTokenGenerator = new CachedTokenGenerator((TokenGenerator)tokenGenerator);
            ApiGateWayProperties apiGateWayProperties = this.eventHubManagementService.getApiGateWayProperties(cloudId);
            String clientId = apiGateWayProperties.getClientId();
            String clientSecret = apiGateWayProperties.getClientSecret();
            String scope = apiGateWayProperties.getScope();
            String tenantId = apiGateWayProperties.getTenantId();
            String baseUrl = apiGateWayProperties.getGateWayUrl();
            String token = cachedTokenGenerator.getToken(clientId, clientSecret, scope, tenantId);
            BackupEvent requestDTO = new BackupEvent();
            requestDTO.setDeviceUUID(deviceUUID);
            requestDTO.setIsFullBackup(isFullBackup);
            requestDTO.setHostName(cloudName);
            requestDTO.setErrorCode(errorCode);
            logger.debug("clientId" + clientId);
            logger.debug("clientSecret" + clientSecret);
            logger.debug("scope" + scope);
            logger.debug("tenantId" + tenantId);
            logger.debug("token" + token);
            logger.debug("requestDTOgetIsFullBackup" + requestDTO.getDeviceUUID());
            logger.debug("requestDTOgetIsFullBackup" + requestDTO.getHostName());
            logger.debug("requestDTOgetIsFullBackup" + requestDTO.getErrorCode());
            BackupServiceImpl backupService = new BackupServiceImpl();
            String backupResponse = backupService.initiateBackup(token, requestDTO, baseUrl);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error("exception ", (Throwable)e);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/retrieve"}, method={RequestMethod.POST})
    public ResponseEntity<String> restore(@RequestBody RestoreEventDto restoreEventDto, HttpServletRequest request, HttpServletResponse response, @PathVariable(value="cloudName") String cloudName) {
        try {
            logger.debug("start of calling restoreEventDto");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String tokenHeader = request.getHeader("token");
            String userName = restoreEventDto.getUserName();
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, tokenHeader, response, userName)) {
                return null;
            }
            AzureTokenGenerator tokenGenerator = new AzureTokenGenerator();
            CachedTokenGenerator cachedTokenGenerator = new CachedTokenGenerator((TokenGenerator)tokenGenerator);
            ApiGateWayProperties apiGateWayProperties = this.eventHubManagementService.getApiGateWayProperties(cloudId);
            String clientId = apiGateWayProperties.getClientId();
            String clientSecret = apiGateWayProperties.getClientSecret();
            String scope = apiGateWayProperties.getScope();
            String tenantId = apiGateWayProperties.getTenantId();
            String baseUrl = apiGateWayProperties.getGateWayUrl();
            String token = cachedTokenGenerator.getToken(clientId, clientSecret, scope, tenantId);
            RestoreServiceImpl restoreService = new RestoreServiceImpl();
            ResponseEntity backupResponse = restoreService.initiateRestore(token, restoreEventDto, baseUrl);
            logger.info("----Setting audit------");
            Device sourceDevice = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, restoreEventDto.getDeviceID());
            RetrievalFormat restoreType = restoreEventDto.getRestoreType();
            Device destinationDevice = restoreType != RetrievalFormat.FOLDER_PST && restoreType != RetrievalFormat.EML_PST ? this.deviceManagementService.getDeviceProperties(cloudId, cloudName, restoreEventDto.getDestination()) : null;
            String actionOnUser = this.constructActionOnUser(sourceDevice, destinationDevice, restoreEventDto);
            String filePath = restoreEventDto.getFileElement() != null && restoreEventDto.getFileElement().getFileCompletePath() != null ? restoreEventDto.getFileElement().getFileCompletePath() : restoreEventDto.getFolderPath();
            switch (restoreType) {
                case EML: {
                    logger.info("----Setting audit: Downloaded eml");
                    String fileName = restoreEventDto.getDestinationPath() != null ? restoreEventDto.getDestinationPath() : "download.eml";
                    this.saveAuditHistory(userName, "Downloaded eml", 11, filePath, fileName, sourceDevice.getDeviceName(), cloudId);
                    break;
                }
                case FOLDER_PST: {
                    logger.info("----Setting audit: Exported PST");
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "exported pst for", userName, actionOnUser, "Portal", System.currentTimeMillis(), 92);
                    break;
                }
                case EML_PST: {
                    logger.info("----Setting audit: Exported EML PST");
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "exported eml pst for", userName, actionOnUser, "Portal", System.currentTimeMillis(), 92);
                    break;
                }
                case SEARCH_PST: {
                    logger.info("----Setting audit: Exported EML PST");
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "exported eml pst for", userName, actionOnUser, "Portal", System.currentTimeMillis(), 92);
                    break;
                }
                case RESTORE: {
                    logger.info("----Setting audit: RESTORE");
                    String action = restoreEventDto.isInPlaceRestore() ? "initiated in-place restore for" : "initiated restore for";
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, action, userName, actionOnUser, "Portal", System.currentTimeMillis(), 92);
                    break;
                }
                case SMALL_FILE: 
                case LARGE_FILE: {
                    logger.info("----Setting audit: Downloaded Small/Large item");
                    this.saveAuditHistory(userName, "Downloaded Item", 11, restoreEventDto.getFolderPath(), restoreEventDto.getDestination(), sourceDevice.getDeviceName(), cloudId);
                    break;
                }
                case FOLDER: {
                    logger.info("----Setting audit: Downloaded Folder");
                    this.saveAuditHistory(userName, "Downloaded Folder", 11, restoreEventDto.getFolderPath(), restoreEventDto.getDestination(), sourceDevice.getDeviceName(), cloudId);
                    break;
                }
                default: {
                    logger.warn("Unhandled restore type: " + String.valueOf(restoreType));
                }
            }
            logger.debug("end of calling restoreEventDto");
            logger.debug("end of calling restoreEventDto" + String.valueOf(backupResponse));
            if (backupResponse.getStatusCodeValue() == 200) {
                logger.debug("end of calling restoreEventDto111111111" + String.valueOf(restoreEventDto.getRestoreType()));
                RetrievalFormat retrievalFormat = restoreEventDto.getRestoreType();
                restoreEventDto.getRestoreType();
                if (retrievalFormat.equals((Object)RetrievalFormat.RESTORE.toString())) {
                    this.sendEmailNotifierForRestore(cl.getCloud(), cloudId, cloudName, restoreEventDto, "restore-initiated", userName);
                }
            }
            return backupResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    private String constructActionOnUser(Device sourceDevice, Device destinationDevice, RestoreEventDto restoreEventDto) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append("{Source - [User: ").append(sourceDevice.getUserName()).append("] [Asset Name: ").append(sourceDevice.getDeviceName()).append("]} ");
            if (destinationDevice != null) {
                stringBuilder.append("{Destination - [User: ").append(destinationDevice.getUserName()).append("] [Asset Name: ").append(destinationDevice.getDeviceName()).append("]} ");
            } else {
                stringBuilder.append("{Destination - [N/A]} ");
            }
            stringBuilder.append("{Restore Source Path: ");
            if (restoreEventDto.getFileElement() != null && restoreEventDto.getFileElement().getFileCompletePath() != null && !restoreEventDto.getFileElement().getFileCompletePath().isEmpty()) {
                stringBuilder.append(restoreEventDto.getFileElement().getFileCompletePath());
            } else if (restoreEventDto.getFolderPath() != null && !restoreEventDto.getFolderPath().isEmpty()) {
                stringBuilder.append(restoreEventDto.getFolderPath());
            } else {
                stringBuilder.append("All Drives");
            }
            stringBuilder.append("} ");
            if (!restoreEventDto.isInPlaceRestore()) {
                stringBuilder.append("{Restore Destination Path: ").append(restoreEventDto.getDestinationPath() != null ? restoreEventDto.getDestinationPath() : "N/A").append("} ");
            }
            stringBuilder.append("{Properties: ");
            stringBuilder.append("[Restore all Versions: ").append(restoreEventDto.isRestoreAllVersions()).append("] ");
            stringBuilder.append("[In place Restore: ").append(restoreEventDto.isInPlaceRestore()).append("] ");
            stringBuilder.append("[Restore Deleted Files: ").append(restoreEventDto.isIncludeDeletedFiles()).append("] ");
            if (restoreEventDto.getRestoreDataBefore() != 0L) {
                Date date = new Date(restoreEventDto.getRestoreDataBefore());
                stringBuilder.append("[Restore Before: ").append(date).append("]");
            }
            stringBuilder.append("}");
        }
        catch (Exception e) {
            logger.error("Failed to construct Audit History" + e.getMessage());
        }
        return stringBuilder.toString();
    }

    private void saveAuditHistory(String userName, String action, int actionType, String filePath, String fileName, String assetName, int cloudId) {
        if (!StringUtils.isEmpty((CharSequence)userName)) {
            AuditHistory auditHistory = new AuditHistory();
            auditHistory.setAction(action.toString());
            auditHistory.setActionByUserName(userName);
            if (StringUtils.isEmpty((CharSequence)filePath) || filePath.startsWith("null")) {
                auditHistory.setActionOnObject(fileName + " for asset name : " + assetName);
            } else {
                auditHistory.setActionOnObject(filePath + " for asset name : " + assetName);
            }
            auditHistory.setActionType(actionType);
            auditHistory.setActionUsingObject("Portal");
            auditHistory.setTimestamp(System.currentTimeMillis());
            logger.debug("Action type" + auditHistory.getActionType());
            this.auditHistoryDao.saveAudit(cloudId, assetName, auditHistory);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/retrieve/eml/download/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<String> singnedUrlEml(@PathVariable(value="id") String id, HttpServletRequest request, HttpServletResponse response, @PathVariable(value="cloudName") String cloudName) {
        try {
            logger.debug("start of calling singnedUrl" + id);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"License validation failed");
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String tokenHeader = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, tokenHeader, response, userName)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Authorization failed");
            }
            AzureTokenGenerator tokenGenerator = new AzureTokenGenerator();
            CachedTokenGenerator cachedTokenGenerator = new CachedTokenGenerator((TokenGenerator)tokenGenerator);
            ApiGateWayProperties apiGateWayProperties = this.eventHubManagementService.getApiGateWayProperties(cloudId);
            String clientId = apiGateWayProperties.getClientId();
            String clientSecret = apiGateWayProperties.getClientSecret();
            String scope = apiGateWayProperties.getScope();
            String tenantId = apiGateWayProperties.getTenantId();
            String baseUrl = apiGateWayProperties.getGateWayUrl();
            String token = cachedTokenGenerator.getToken(clientId, clientSecret, scope, tenantId);
            RestoreServiceImpl restoreService = new RestoreServiceImpl();
            return restoreService.downloadEml(token, id, baseUrl);
        }
        catch (HttpClientErrorException.NotFound ex) {
            logger.warn("Signed URL not found for ID: {}", (Object)id);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Signed URL not found for ID: " + id));
        }
        catch (Exception e) {
            logger.error("Unexpected error: {}", (Object)e.getMessage(), (Object)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Internal server error");
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/retrieve/pst/download/{userName}"}, method={RequestMethod.GET})
    public List<SignedUrlDTO> singnedUrlPst(@PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response, @PathVariable(value="cloudName") String cloudName) {
        try {
            logger.debug("start of calling singnedUrl");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String tokenHeader = request.getHeader("token");
            String decodeUserName = userName;
            if (StringUtils.isNotEmpty((CharSequence)decodeUserName)) {
                decodeUserName = this.decodeBase64UTFString(decodeUserName);
            }
            if (!this.performAuthorization(cloudId, cloudName, tokenHeader, response, decodeUserName)) {
                return null;
            }
            AzureTokenGenerator tokenGenerator = new AzureTokenGenerator();
            CachedTokenGenerator cachedTokenGenerator = new CachedTokenGenerator((TokenGenerator)tokenGenerator);
            ApiGateWayProperties apiGateWayProperties = this.eventHubManagementService.getApiGateWayProperties(cloudId);
            String clientId = apiGateWayProperties.getClientId();
            String clientSecret = apiGateWayProperties.getClientSecret();
            String scope = apiGateWayProperties.getScope();
            String tenantId = apiGateWayProperties.getTenantId();
            String baseUrl = apiGateWayProperties.getGateWayUrl();
            String token = cachedTokenGenerator.getToken(clientId, clientSecret, scope, tenantId);
            logger.debug("token" + token);
            RestoreServiceImpl restoreService = new RestoreServiceImpl();
            List backupResponse = restoreService.downloadPst(token, userName, baseUrl, cloudName);
            logger.debug("end of calling singnedUrl" + String.valueOf(backupResponse));
            logger.debug("end of calling singnedUrl" + userName);
            return backupResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/retrieve/folders"}, method={RequestMethod.POST})
    public ResponseEntity<List<FolderResponseDTO>> getMailFolders(@RequestBody FolderRequestDTO requestDTO, HttpServletRequest request, HttpServletResponse response, @PathVariable(value="cloudName") String cloudName) {
        try {
            logger.debug("start of calling singnedUrl");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String tokenHeader = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, tokenHeader, currentUser, response, userName)) {
                return null;
            }
            AzureTokenGenerator tokenGenerator = new AzureTokenGenerator();
            CachedTokenGenerator cachedTokenGenerator = new CachedTokenGenerator((TokenGenerator)tokenGenerator);
            ApiGateWayProperties apiGateWayProperties = this.eventHubManagementService.getApiGateWayProperties(cloudId);
            String clientId = apiGateWayProperties.getClientId();
            String clientSecret = apiGateWayProperties.getClientSecret();
            String scope = apiGateWayProperties.getScope();
            String tenantId = apiGateWayProperties.getTenantId();
            String baseUrl = apiGateWayProperties.getGateWayUrl();
            String token = cachedTokenGenerator.getToken(clientId, clientSecret, scope, tenantId);
            logger.debug("token" + token);
            RestoreServiceImpl restoreService = new RestoreServiceImpl();
            List labels = restoreService.getMailFolders(token, requestDTO, baseUrl);
            logger.debug("end of calling singnedUrl" + String.valueOf(labels));
            return ResponseEntity.ok((Object)labels);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    private void sendEmailNotifierForRestore(Cloud cloud, int cloudId, String cloudName, RestoreEventDto restoreEventDto, String action, String actionBy) {
        try {
            String sourceDeviceUUID = restoreEventDto.getDeviceID();
            Device sourceDevice = this.deviceManagementService.getDeviceByDeviceUUID(cloudId, cloudName, sourceDeviceUUID);
            UserElement user = this.userManagementService.getUserByUserName(cloud, sourceDevice.getUserName());
            String destinationDeviceUUID = restoreEventDto.getDestinationId();
            Device destinationDevice = this.deviceManagementService.getDeviceByDeviceUUID(cloudId, cloudName, destinationDeviceUUID);
            String emailId = user.getEmailId();
            String actionOn = sourceDevice.getUserName();
            NotifierEmailBodyElement notifierEmailBodyElement = new NotifierEmailBodyElement(this);
            notifierEmailBodyElement.setDeviceName(destinationDevice.getDeviceName());
            notifierEmailBodyElement.setRestoreFolder(restoreEventDto.getFolderPath());
            notifierEmailBodyElement.setBatchStartTimestamp(System.currentTimeMillis());
            notifierEmailBodyElement.setNotifyAllAdmins(true);
            notifierEmailBodyElement.setCloudId(cloudId);
            notifierEmailBodyElement.setCloudName(cloudName);
            notifierEmailBodyElement.setUserName(actionBy);
            notifierEmailBodyElement.setRestoreDeviceName(sourceDevice.getDeviceName());
            this.sendEmail(cloud, action, actionOn, actionBy, emailId, notifierEmailBodyElement, sourceDevice.getDeviceUUID());
        }
        catch (BaseException e) {
            logger.error("Base Exception.." + e.getMessage());
            logger.error("Base Exception.." + String.valueOf((Object)e));
        }
        catch (Exception e) {
            logger.error(" Exception.." + e.getMessage());
            logger.error(" Exception.." + String.valueOf(e));
        }
    }

    private void sendEmail(Cloud cloud, String action, String actionOn, String actionBy, String emailId, NotifierEmailBodyElement bodyElement, String deviceUUID) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction(action);
        email.setActionBy(actionBy);
        email.setActionOn(actionOn);
        email.setDeviceUUID(deviceUUID);
        email.setDeviceName(bodyElement.getDeviceName());
        email.setBodyData(bodyElement.getRestoreDeviceName());
        email.setFileName(bodyElement.getRestoreFolder());
        email.setToAdmins(bodyElement.isNotifyAllAdmins());
        email.setUserName(bodyElement.getUserName());
        email.setNoOfFilesRestored(bodyElement.getNoOfFilesBackedUp());
        email.setRestoreSize(bodyElement.getRestoreSize());
        email.setBodyData(bodyElement.getDeviceName());
        if (StringUtils.isNotEmpty((CharSequence)bodyElement.getRestoreStatus())) {
            email.setRestoreStatus(bodyElement.getRestoreStatus().toLowerCase());
        } else {
            email.setRestoreStatus("");
        }
        String bkpStartTime = this.getDateFromTimeStamp(bodyElement.getBatchStartTimestamp());
        String bkpEndTime = this.getDateFromTimeStamp(bodyElement.getBatchEndTimestamp());
        logger.error("bkpEndTime...." + bkpStartTime);
        logger.error("action...." + action + "......actionBy......." + actionBy);
        logger.error("status...." + bodyElement.getRestoreStatus());
        if (bkpStartTime != null) {
            email.setBatchStartTime(bkpStartTime.toString() + "(GMT" + this.gettimeZoneInUTC() + ")");
        } else {
            email.setBatchStartTime("");
        }
        if (bkpEndTime != null) {
            email.setBatchEndTime(bkpEndTime.toString() + "(GMT" + this.gettimeZoneInUTC() + ")");
        } else {
            email.setBatchEndTime("");
        }
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(actionOn);
        emailRecipent.setEmail(emailId);
        emailRecipents.add(emailRecipent);
        try {
            logger.debug(" @@@ Before sending mail ");
            email.setRecipents(emailRecipents);
            this.cloudMailService.sendMail(cloud, email);
        }
        catch (Exception e) {
            logger.trace("Exception  :" + String.valueOf(e));
            logger.error("Exception  :" + e.getMessage());
        }
    }

    private String gettimeZoneInUTC() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.getDefault());
        Date currentLocalTime = calendar.getTime();
        logger.debug("currentLocalTime" + String.valueOf(currentLocalTime));
        SimpleDateFormat date = new SimpleDateFormat("Z");
        String localTime = date.format(currentLocalTime);
        logger.debug("GMT" + localTime);
        return localTime;
    }

    private String getDateFromTimeStamp(long timestamp) {
        String bkpEndTime = null;
        try {
            logger.debug("bodyElement.getBatchStartTimestamp()" + timestamp);
            Date date = new Date(timestamp);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
            bkpEndTime = simpleDateFormat.format(date);
        }
        catch (Exception e1) {
            logger.error("error....", (Throwable)e1);
            e1.printStackTrace();
        }
        return bkpEndTime;
    }

    class NotifierEmailBodyElement {
        private int cloudId;
        private String cloudName;
        private String userName;
        private String deviceName;
        private String restoreDeviceName;
        private String restoreFolder;
        private String noOfFilesBackedUp;
        private String totalBackupSize;
        private boolean notifyAllAdmins;
        private long batchStartTimestamp;
        private long batchEndTimestamp;
        private String restoreSize;
        private String restoreStatus;

        NotifierEmailBodyElement(EventHubContoller this$0) {
        }

        public long getBatchEndTimestamp() {
            return this.batchEndTimestamp;
        }

        public void setBatchEndTimestamp(long batchEndTimestamp) {
            this.batchEndTimestamp = batchEndTimestamp;
        }

        public String getRestoreSize() {
            return this.restoreSize;
        }

        public void setRestoreSize(String restoreSize) {
            this.restoreSize = restoreSize;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public String getRestoreDeviceName() {
            return this.restoreDeviceName;
        }

        public void setRestoreDeviceName(String restoreDeviceName) {
            this.restoreDeviceName = restoreDeviceName;
        }

        public String getRestoreFolder() {
            return this.restoreFolder;
        }

        public void setRestoreFolder(String restoreFolder) {
            this.restoreFolder = restoreFolder;
        }

        public String getTotalBackupSize() {
            return this.totalBackupSize;
        }

        public void setTotalBackupSize(String totalBackupSize) {
            this.totalBackupSize = totalBackupSize;
        }

        public String getNoOfFilesBackedUp() {
            return this.noOfFilesBackedUp;
        }

        public void setNoOfFilesBackedUp(String noOfFilesBackedUp) {
            this.noOfFilesBackedUp = noOfFilesBackedUp;
        }

        public boolean isNotifyAllAdmins() {
            return this.notifyAllAdmins;
        }

        public void setNotifyAllAdmins(boolean notifyAllAdmins) {
            this.notifyAllAdmins = notifyAllAdmins;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public int getCloudId() {
            return this.cloudId;
        }

        public void setCloudId(int cloudId) {
            this.cloudId = cloudId;
        }

        public String getCloudName() {
            return this.cloudName;
        }

        public void setCloudName(String cloudName) {
            this.cloudName = cloudName;
        }

        public long getBatchStartTimestamp() {
            return this.batchStartTimestamp;
        }

        public void setBatchStartTimestamp(long batchStartTimestamp) {
            this.batchStartTimestamp = batchStartTimestamp;
        }

        public String getRestoreStatus() {
            return this.restoreStatus;
        }

        public void setRestoreStatus(String restoreStatus) {
            this.restoreStatus = restoreStatus;
        }
    }
}

