/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.PciAuthorizationTokensService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.element.CloudUsersElement;
import com.parablu.paracloud.element.PciAuthorizationTokenElement;
import com.parablu.paracloud.element.UserDevicesElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CloudStorageType;
import com.parablu.pcbd.domain.MSGTokens;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.User;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class CloudStorageController
extends BaseController {
    private static Logger logger = LogManager.getLogger(CloudStorageController.class);
    private static final String ERROR_FAILE_TO_SAVE_EXTERNAL_STORAGE_ATUHENTICATION = "Error failed to save external storage authentication ...";
    private static final String BASE_EXCEPTION = " BaseException  :";
    private static final String ERROR_FAILED_TO_CALL_GET_ALL_CLOUD_NAMES = "Error failed to call get all cloudNames  ...";
    @Autowired
    private UserManagementService managementService;
    @Autowired
    private PciAuthorizationTokensService pciAuthorizationTokensService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private DeviceManagementService deviceManagementService;

    @RequestMapping(value={"cloud/{cloudName}/pci/token"}, method={RequestMethod.POST})
    public void authenticateExternalStorage(@PathVariable(value="cloudName") String cloudName1, @RequestBody PciAuthorizationTokenElement pciAuthorizationTokenElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling /authenticateOneDrive ..." + pciAuthorizationTokenElement.getRefreshToken());
        try {
            String username = request.getHeader("userName");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            logger.debug("&&&& STORAGE TYPE ..." + pciAuthorizationTokenElement.getCloudStorageType());
            UserElement element = this.managementService.getUserInfo(cloudId, cloudName, username);
            PciAuthorizationTokens pciAuthorizationTokens = this.getPciAuthorizationTokens(cloudName, pciAuthorizationTokenElement, element);
            pciAuthorizationTokens.setUserId(element.getUserId());
            CloudStorageType cloudStorageType = null;
            if (pciAuthorizationTokenElement.getCloudStorageType() == null) {
                response.setStatus(400);
                return;
            }
            boolean isServiceAcct = false;
            List cloudCustomisableDetailsList = cl.getCloud().getCloudCustomisableDetails();
            for (CloudCustomisableDetails customisableDetails : cloudCustomisableDetailsList) {
                if (!"Service Account Enabled".equals(customisableDetails.getName())) continue;
                isServiceAcct = true;
            }
            cloudStorageType = this.getOrSaveCloudStorageType(pciAuthorizationTokenElement, cloudId, cloudName, cloudStorageType);
            pciAuthorizationTokens.setCloudStorageType(cloudStorageType);
            pciAuthorizationTokens.setServiceAccount(isServiceAcct);
            PciAuthorizationTokens authorizationToken = this.checkTokenAlreadyPresentForUser(cloudId, cloudName, element.getUserId());
            if (authorizationToken != null) {
                this.pciAuthorizationTokensService.deletePciAuthorizationTokensForUserId(cloudId, cloudName, element.getUserId());
            }
            this.pciAuthorizationTokensService.savePciAuthorizationTokens(cloudId, cloudName, pciAuthorizationTokens);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(" Exception  :" + String.valueOf(e));
            logger.error(ERROR_FAILE_TO_SAVE_EXTERNAL_STORAGE_ATUHENTICATION + e.getMessage());
            response.setStatus(500);
        }
        logger.debug("end of calling /authenticateOneDrive ..." + pciAuthorizationTokenElement.getClientId());
    }

    private PciAuthorizationTokens checkTokenAlreadyPresentForUser(int cloudId, String cloudName, ObjectId userId) {
        PciAuthorizationTokens tokens = this.pciAuthorizationTokensService.getPciAuthorizationTokensForUserId(cloudId, cloudName, userId);
        if (tokens != null) {
            return tokens;
        }
        return null;
    }

    private PciAuthorizationTokens getPciAuthorizationTokens(String cloudName, PciAuthorizationTokenElement pciAuthorizationTokenElement, UserElement element) {
        PciAuthorizationTokens pciAuthorizationTokens = new PciAuthorizationTokens();
        BeanUtils.copyProperties((Object)pciAuthorizationTokenElement, (Object)pciAuthorizationTokens);
        pciAuthorizationTokens.setCloudName(cloudName);
        return pciAuthorizationTokens;
    }

    private CloudStorageType getOrSaveCloudStorageType(PciAuthorizationTokenElement pciAuthorizationTokenElement, int cloudId, String cloudName, CloudStorageType cloudStorageType1) {
        CloudStorageType cloudStorageType = cloudStorageType1;
        if (pciAuthorizationTokenElement.getCloudStorageType() != null) {
            cloudStorageType = this.pciAuthorizationTokensService.getCloudStorageTypeByName(cloudId, cloudName, pciAuthorizationTokenElement.getCloudStorageType());
        }
        if (cloudStorageType == null) {
            cloudStorageType = new CloudStorageType();
            cloudStorageType.setName(pciAuthorizationTokenElement.getCloudStorageType());
            this.pciAuthorizationTokensService.saveCloudStorageType(cloudId, cloudName, cloudStorageType);
        }
        return cloudStorageType;
    }

    @RequestMapping(value={"cloud/{cloudName}/pcitoken"}, method={RequestMethod.GET})
    public ResponseEntity<PciAuthorizationTokenElement> getPciAuthorizationTokenForUserName(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling getPciAuthorizationTokenForUserName ...");
        PciAuthorizationTokenElement tokenElement = null;
        try {
            String username = request.getHeader("userName");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            UserElement element = this.managementService.getUserInfo(cloudId, cloudName, username);
            PciAuthorizationTokens pciAuthorizationTokens = this.pciAuthorizationTokensService.getPciAuthorizationTokensForUserId(cloudId, cloudName, element.getUserId());
            tokenElement = this.getTokenElement(pciAuthorizationTokens);
            response.setStatus(200);
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            response.setStatus(500);
            logger.error(ERROR_FAILE_TO_SAVE_EXTERNAL_STORAGE_ATUHENTICATION + e.getMessage());
        }
        logger.debug("end of calling getPciAuthorizationTokenForUserName ...");
        return new ResponseEntity(tokenElement, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"cloud/get/pcitoken/all"}, method={RequestMethod.GET})
    public ResponseEntity<List<PciAuthorizationTokenElement>> getAllPciAuthorizationTokens(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling getPciAuthorizationTokenForUserName ...");
        ArrayList<PciAuthorizationTokenElement> tokenElements = new ArrayList<PciAuthorizationTokenElement>();
        try {
            List cloudsList = this.licenseService.getClouds();
            for (Cloud cl : cloudsList) {
                String cloudName = cl.getCloudName();
                int cloudId = cl.getCloudId();
                List<PciAuthorizationTokens> pciAuthorizationTokens = this.pciAuthorizationTokensService.getAllPciAuthorizationTokens(cloudId, cloudName);
                List<PciAuthorizationTokenElement> childTokenElements = this.convertTokenElements(pciAuthorizationTokens, cloudId);
                tokenElements.addAll(childTokenElements);
            }
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILE_TO_SAVE_EXTERNAL_STORAGE_ATUHENTICATION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        logger.debug("end of calling getPciAuthorizationTokenForUserName ...");
        return new ResponseEntity(tokenElements, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"load/all/cloudNames/"}, method={RequestMethod.GET})
    public ResponseEntity<List<String>> getAllCloudNames(HttpServletRequest request, HttpServletResponse response) {
        ArrayList<String> cloudNames = new ArrayList<String>();
        try {
            List cloudsList = this.licenseService.getClouds();
            for (Cloud cl : cloudsList) {
                cloudNames.add(cl.getCloudName());
            }
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_CALL_GET_ALL_CLOUD_NAMES + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return new ResponseEntity(cloudNames, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"load/all/userNamesForCloud/"}, method={RequestMethod.GET})
    public ResponseEntity<List<CloudUsersElement>> getAllUserNamesForCloud(HttpServletRequest request, HttpServletResponse response) {
        ArrayList<CloudUsersElement> cloudUsersElements = new ArrayList<CloudUsersElement>();
        try {
            List cloudsList = this.licenseService.getClouds();
            for (Cloud cl : cloudsList) {
                CloudUsersElement element = new CloudUsersElement();
                element.setCloudName(cl.getCloudName());
                ArrayList<String> userNames = new ArrayList<String>();
                List<UserElement> users = this.managementService.getAllUsers(cl.getCloudId(), cl.getCloudName(), false, false);
                for (UserElement userElement : users) {
                    userNames.add(userElement.getUserName());
                }
                element.setUsers(new ArrayList());
                element.setUsers(userNames);
                cloudUsersElements.add(element);
            }
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_CALL_GET_ALL_CLOUD_NAMES + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return new ResponseEntity(cloudUsersElements, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"load/all/deviceUUIDs/"}, method={RequestMethod.GET})
    public ResponseEntity<List<UserDevicesElement>> loadAllDeviceUUIDS(HttpServletRequest request, HttpServletResponse response) {
        ArrayList<UserDevicesElement> userDevicesElements = new ArrayList<UserDevicesElement>();
        try {
            List cloudsList = this.licenseService.getClouds();
            for (Cloud cl : cloudsList) {
                List<UserDevicesElement> userDevicesElementList = this.deviceManagementService.getAllUserDevices(cl.getCloudId());
                userDevicesElements.addAll(userDevicesElementList);
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_CALL_GET_ALL_CLOUD_NAMES + String.valueOf(e));
            logger.error(" Exception  :" + e.getMessage());
        }
        return new ResponseEntity(userDevicesElements, (HttpStatusCode)HttpStatus.OK);
    }

    private PciAuthorizationTokenElement getTokenElement(PciAuthorizationTokens pciAuthorizationTokens) {
        PciAuthorizationTokenElement tokenElement = new PciAuthorizationTokenElement();
        if (pciAuthorizationTokens == null) {
            return tokenElement;
        }
        tokenElement.setAccessToken(pciAuthorizationTokens.getAccessToken());
        tokenElement.setAuthenticationToken(pciAuthorizationTokens.getAuthenticationToken());
        tokenElement.setClientId(pciAuthorizationTokens.getClientId());
        tokenElement.setClientSecret(pciAuthorizationTokens.getClientSecret());
        tokenElement.setEmailId(pciAuthorizationTokens.getEmailId());
        tokenElement.setRedirectUri(pciAuthorizationTokens.getRedirectUri());
        tokenElement.setRefreshToken(pciAuthorizationTokens.getRefreshToken());
        tokenElement.setCloudStorageType(pciAuthorizationTokens.getCloudStorageType().getName());
        tokenElement.setAccountId(pciAuthorizationTokens.getAccountId());
        tokenElement.setSharePointUrl(pciAuthorizationTokens.getSharePointUrl());
        return tokenElement;
    }

    private List<PciAuthorizationTokenElement> convertTokenElements(List<PciAuthorizationTokens> pciAuthorizationTokens, int cloudId) {
        ArrayList<PciAuthorizationTokenElement> tokenElementList = new ArrayList<PciAuthorizationTokenElement>();
        for (PciAuthorizationTokens authorizationToken : pciAuthorizationTokens) {
            PciAuthorizationTokenElement tokenElement = new PciAuthorizationTokenElement();
            User user = this.managementService.getUserInfoById(cloudId, authorizationToken.getCloudName(), authorizationToken.getUserId().toString());
            if (user == null) continue;
            tokenElement.setUserName(user.getUserName());
            tokenElement.setAccessToken(authorizationToken.getAccessToken());
            tokenElement.setAuthenticationToken(authorizationToken.getAuthenticationToken());
            tokenElement.setClientId(authorizationToken.getClientId());
            tokenElement.setClientSecret(authorizationToken.getClientSecret());
            tokenElement.setEmailId(authorizationToken.getEmailId());
            tokenElement.setRedirectUri(authorizationToken.getRedirectUri());
            tokenElement.setRefreshToken(authorizationToken.getRefreshToken());
            tokenElement.setCloudStorageType(authorizationToken.getCloudStorageType().getName());
            tokenElement.setAccountId(authorizationToken.getAccountId());
            tokenElement.setSharePointUrl(authorizationToken.getSharePointUrl());
            tokenElement.setCloudName(authorizationToken.getCloudName());
            tokenElementList.add(tokenElement);
        }
        return tokenElementList;
    }

    @RequestMapping(value={"cloud/{cloudName}/msg/token"}, method={RequestMethod.POST})
    public void saveMSGTokens(@PathVariable(value="cloudName") String cloudName1, @RequestBody PciAuthorizationTokenElement pciAuthorizationTokenElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling cloud/{cloudName}/msg/token ..." + pciAuthorizationTokenElement.getRefreshToken());
        try {
            MSGTokens oldmsgTokens;
            String username = request.getHeader("userName");
            logger.debug("...user name for msg token .." + username);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (StringUtils.isEmpty((CharSequence)username) && (oldmsgTokens = this.pciAuthorizationTokensService.getMSGTokens(cloudId)) != null && oldmsgTokens.getUserId() != null) {
                logger.debug("...loading inside reauthenticating token....");
                User user = this.managementService.getUserInfoById(cloudId, cloudName, oldmsgTokens.getUserId().toString());
                if (user != null) {
                    username = user.getUserName();
                }
            }
            UserElement element = this.managementService.getUserInfo(cloudId, cloudName, username);
            MSGTokens msgTokens = new MSGTokens();
            BeanUtils.copyProperties((Object)pciAuthorizationTokenElement, (Object)msgTokens);
            msgTokens.setCloudName(cl.getCloud().getCloudName());
            msgTokens.setUserId(element.getUserId());
            logger.debug("... msg tokens user id available.. ");
            this.pciAuthorizationTokensService.saveMSGTokens(cloudId, msgTokens);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(" Exception  :" + String.valueOf(e));
            logger.error(ERROR_FAILE_TO_SAVE_EXTERNAL_STORAGE_ATUHENTICATION + e.getMessage());
            response.setStatus(500);
        }
        logger.debug("end of calling cloud/{cloudName}/msg/token ..." + pciAuthorizationTokenElement.getClientId());
    }
}

