/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.service.AADManagementService;
import com.parablu.bluvault.udc.service.AlertHistoryService;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.DeviceAndUserSecurityService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.element.ErrorElement;
import com.parablu.helper.response.ResponseHandler;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.CloudConfigRegistry;
import com.parablu.paracloud.element.AADUserElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.IdentityProviderSettingsElement;
import com.parablu.paracloud.element.LdapUserElement;
import com.parablu.paracloud.util.DateUtil;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.SearchIndex;
import com.parablu.pcbd.domain.User;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class BaseController
extends ResponseHandler {
    private static Logger logger = LogManager.getLogger(BaseController.class);
    @Autowired
    protected ErrorElement errorElement;
    @Autowired
    protected AuthorizationService authorizationService;
    @Autowired
    private MiniCloudAccessControlService miniCloudAccessControlService;
    @Autowired
    protected AlertHistoryService ahservice;
    @Autowired
    private AADManagementService aadManagementService;
    @Autowired
    private DeviceAndUserSecurityService deviceAndUserSecurityService;
    @Autowired
    private UserManagementService managementService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private CloudMailService cloudMailService;
    @Autowired
    CloudConfigRegistry registry;
    protected static final String XML_VIEW = "xmlview";
    protected static final String HTTP_ERROR_MESSAGE = "errorMessage";
    protected static final int BACKUP_USER = 0;
    protected static final int SYNC_USER = 1;
    protected static final String GZIP_VIEW = "xmlview";
    protected static final String JSON_VIEW = "jsonview";
    protected static final String APLLICATION_XML = "application/xml";
    private static final String EXCEPTION = " Exception  :";
    private static final String SYNC_ENABLED = "Sync Enabled";
    private static final String BACKUP_ENABLED = "Backup Enabled";

    public void setErrorElement(ErrorElement errorElement) {
        this.errorElement = errorElement;
    }

    protected void closeInputStreamIfExists(HttpServletRequest request) {
        try {
            if (request.getInputStream() != null) {
                request.getInputStream().close();
            }
        }
        catch (IOException e) {
            logger.debug("", (Throwable)e);
        }
    }

    protected boolean validateMiniCloudByName(HttpServletResponse response, int cloudId, String cloudName, User user, String[] sourceParams) {
        if (sourceParams.length != 1 && !this.miniCloudAccessControlService.validateMiniCloudOperationAccessForUser(cloudId, cloudName, user, sourceParams[1])) {
            response.setStatus(401);
            return false;
        }
        return true;
    }

    protected boolean validateMiniCloudByName(HttpServletResponse response, int cloudId, String cloudName, String user, String[] sourceParams) {
        if (sourceParams.length != 1 && !this.miniCloudAccessControlService.validateMiniCloudOperationAccessForUser(cloudId, cloudName, user, sourceParams[1])) {
            response.setStatus(401);
            return false;
        }
        return true;
    }

    public ErrorElement createErrorElement(String errorCode, String message) {
        if (StringUtils.hasText((String)message)) {
            this.errorElement.setMessage(message);
        } else {
            this.errorElement.setMessage("Invalid Request.");
        }
        if (StringUtils.hasText((String)errorCode)) {
            this.errorElement.setResponseCode(errorCode);
        } else {
            this.errorElement.setResponseCode("500");
        }
        return this.errorElement;
    }

    public ErrorElement createErrorElement() {
        this.errorElement.setMessage("Invalid Request.");
        this.errorElement.setResponseCode("500");
        return this.errorElement;
    }

    public void setSuccessResponseFields(HttpServletResponse response) {
        response.setStatus(200);
    }

    public boolean checkLicense(CloudLicenseTo cloudLicense, HttpServletResponse response) {
        if (cloudLicense == null) {
            logger.error("..... cloudlicense is null .... ");
            response.setStatus(400);
            return false;
        }
        int code = cloudLicense.getCloudLicenseStatus();
        BaseController.printLogs("..... cloudlicense is not null  error code .... " + code, this.registry.get(cloudLicense.getCloud().getCloudId()).isBrevityLogging());
        switch (code) {
            case 1500: {
                return true;
            }
            case 1501: {
                response.setStatus(416);
                return false;
            }
            case 1504: {
                response.setStatus(419);
                return false;
            }
            case 1520: {
                response.setStatus(420);
                return false;
            }
            case 1521: {
                response.setStatus(421);
                return false;
            }
            case 1509: {
                response.setStatus(401);
                return false;
            }
            case 1502: {
                response.setStatus(418);
                return false;
            }
            case 1503: {
                response.setStatus(417);
                return false;
            }
            case 1522: {
                response.setStatus(423);
                return false;
            }
            case 1525: {
                response.setStatus(403);
                return false;
            }
        }
        response.setStatus(400);
        return false;
    }

    public boolean checkLicense(int code, HttpServletResponse response) {
        switch (code) {
            case 1500: {
                return true;
            }
            case 1501: {
                response.setStatus(416);
                return false;
            }
            case 1502: {
                response.setStatus(418);
                return false;
            }
            case 1503: 
            case 1525: {
                response.setStatus(417);
                return false;
            }
            case 1535: {
                response.setStatus(417);
                return false;
            }
            case 1537: {
                response.setStatus(417);
                return false;
            }
            case 1522: {
                response.setStatus(423);
                return false;
            }
            case 1504: {
                response.setStatus(419);
                return false;
            }
            case 1520: {
                response.setStatus(420);
                return false;
            }
            case 1521: {
                response.setStatus(421);
                return false;
            }
            case 1509: {
                response.setStatus(401);
                return false;
            }
        }
        return false;
    }

    protected void addSearchIndexToTable(Cloud cloud, List<SearchIndex> searchIndexs) {
        if (cloud.getContentSearchEnabled() == 1) {
            this.ahservice.addFilesToTable(searchIndexs, cloud.getCloudName());
        }
    }

    protected void addSearchIndexToTable(Cloud cloud, SearchIndex searchIndexs) {
        if (cloud.getContentSearchEnabled() == 1) {
            this.ahservice.addFileToTable(searchIndexs, cloud.getCloudName());
        }
    }

    protected boolean performAuthorization(int cloudId, String cloudName, String token, HttpServletResponse response, String userName) {
        int status = this.authorizationService.validateToken(cloudId, cloudName, token, userName);
        BaseController.printLogs(cloudName + "  Validate ######  status " + status, this.registry.get(cloudId).isBrevityLogging());
        switch (status) {
            case 0: {
                return true;
            }
            case 4: {
                logger.debug("  Validate ######  USER_BLOCKED ");
                response.setStatus(420);
                return false;
            }
            case 1: {
                logger.debug("  Validate ######  UNAUTHORIZED ");
                response.setStatus(401);
                return false;
            }
            case 2: {
                logger.debug("  Validate ######  TOKEN_EXPIRED ");
                response.setStatus(421);
                return false;
            }
            case 3: {
                logger.debug("  Validate ######  MULTIPLE_USER_LOGIN ");
                response.setStatus(424);
                return false;
            }
        }
        logger.debug("  Validate ######  HTTP_UNAUTHORIZED ");
        response.setStatus(401);
        return false;
    }

    protected boolean performAuthorization(int cloudId, String cloudName, String token, User user, HttpServletResponse response, String userName) {
        int status = this.authorizationService.validateToken(cloudId, cloudName, token, user, userName);
        switch (status) {
            case 0: {
                return true;
            }
            case 4: {
                response.setStatus(420);
                return false;
            }
            case 1: {
                response.setStatus(401);
                return false;
            }
            case 2: {
                response.setStatus(421);
                return false;
            }
            case 3: {
                response.setStatus(424);
                return false;
            }
            case 5: {
                response.setStatus(400);
                return false;
            }
        }
        response.setStatus(401);
        logger.debug("HTTP Authorization error");
        return false;
    }

    protected boolean performAuthorization(int cloudId, String cloudName, AuthorizationTokens token, HttpServletResponse response, String userName) {
        int status = this.authorizationService.validateToken(cloudId, cloudName, token, userName);
        switch (status) {
            case 0: {
                return true;
            }
            case 1: {
                response.setStatus(401);
                return false;
            }
            case 2: {
                response.setStatus(421);
                return false;
            }
            case 3: {
                response.setStatus(424);
                return false;
            }
        }
        response.setStatus(401);
        logger.debug("HTTP Authorization error");
        return false;
    }

    protected boolean checkIfUserIsValid(User user, int type, HttpServletResponse response) {
        if (user.isSuperAdmin()) {
            return true;
        }
        if (type == 0) {
            if (user.isBackupEnabled() || user.isServerBackupEnabled() || user.isOnedriveBkpEnabled() || user.isExchangeBkpEnabled() || user.isAdmin() || user.isGmailBkpEnabled()) {
                return true;
            }
        } else if (type == 1) {
            if (user.isSyncEnabled()) {
                return true;
            }
            logger.debug("Invalid user type");
            return false;
        }
        response.setStatus(401);
        return false;
    }

    protected boolean checkIfDeviceIsAttached(int cloudId, String cloudName, HttpServletResponse response) {
        if (new File(this.registry.get(cloudId).getPropertyFileValueParabluFolderBasePath(cloudName)).exists()) {
            return true;
        }
        response.setStatus(427);
        return false;
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    protected String encodeBase64UTFString(String String2) {
        String encodedString = String2;
        try {
            encodedString = new String(Base64.encodeBase64String((byte[])String2.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return encodedString;
    }

    protected int getTokenValidationResponseStatusCode(HttpServletResponse response) {
        int status = response.getStatus();
        switch (status) {
            case 420: {
                return 1520;
            }
            case 401: {
                return 1210;
            }
            case 421: {
                return 1201;
            }
            case 3: {
                logger.debug("  Validate ######  MULTIPLE_USER_LOGIN ");
                response.setStatus(424);
                return 1213;
            }
        }
        return 1210;
    }

    public static void printLogs(String log, boolean isBrevityLogging) {
        if (!isBrevityLogging) {
            logger.debug(log);
        }
    }

    public boolean migrateUserFromAAD(String userPrincipleName, String password, CloudLicenseTo cl, Cloud cloud, String cloudName, HttpServletResponse response) {
        int code;
        boolean success = false;
        AADUserElement aaDUserRequestElement = new AADUserElement();
        aaDUserRequestElement.setPassword(password);
        aaDUserRequestElement.setUserName(userPrincipleName);
        AADUserElement aadUser = (AADUserElement)this.aadManagementService.getAADUser(cloud, userPrincipleName, password);
        if (aadUser == null || StringUtils.isEmpty((Object)aadUser.getProductType())) {
            logger.debug("Fail to login for " + userPrincipleName);
            return success;
        }
        if (StringUtils.isEmpty((Object)aadUser.getProductType())) {
            logger.debug("User not part of any product");
            return success;
        }
        int cloudId = cloud.getCloudId();
        boolean isSyncEnabled = false;
        boolean isBackupEnabled = false;
        boolean odbBkpEnabled = false;
        boolean exchangeBkpEnabled = false;
        boolean site = false;
        boolean gmailBkpEnabled = false;
        boolean gdriveBkpEnabled = false;
        List list = cl.getCloud().getCloudCustomisableDetails();
        for (CloudCustomisableDetails customisableDetails : list) {
            if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                isSyncEnabled = true;
            }
            if (customisableDetails.getName().equalsIgnoreCase(BACKUP_ENABLED)) {
                isBackupEnabled = true;
            }
            if ("OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                odbBkpEnabled = true;
            }
            if ("Exchange Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                exchangeBkpEnabled = true;
            }
            if ("GMAIL Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                gmailBkpEnabled = true;
            }
            if ("GDRIVE Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                gdriveBkpEnabled = true;
            }
            if (!"Sharepoint Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
            site = true;
        }
        if ("SYNC".equalsIgnoreCase(aadUser.getProductType())) {
            isBackupEnabled = false;
        }
        if ("BACKUP".equalsIgnoreCase(aadUser.getProductType())) {
            isSyncEnabled = false;
        }
        if (!this.checkLicense(code = this.deviceAndUserSecurityService.validateUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug("USER LIMIT REACHED........");
            this.sendEmailForUserLimitExceded(cloud, cloudName, userPrincipleName, "User");
            return success;
        }
        if (isSyncEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug(" SYNC USER LIMIT REACHED........");
            this.sendEmailForUserLimitExceded(cloud, cloudName, userPrincipleName, "Sync User");
            isSyncEnabled = false;
        }
        if (isBackupEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug("BACKUP USER LIMIT REACHED........");
            this.sendEmailForUserLimitExceded(cloud, cloudName, userPrincipleName, "Backup User");
            isBackupEnabled = false;
        }
        if (exchangeBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateExchangeUserRestrictions(cloud.getCloudId(), cl.getCloud()), response)) {
            logger.debug("Office USER LIMIT REACHED........");
            this.sendEmailForUserLimitExceded(cloud, cloudName, userPrincipleName, "Office Backup User");
            exchangeBkpEnabled = false;
        }
        if (odbBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateOnedriveUserRestrictions(cloud.getCloudId(), cl.getCloud()), response)) {
            logger.debug("Office USER LIMIT REACHED........");
            this.sendEmailForUserLimitExceded(cloud, cloudName, userPrincipleName, "Office Backup User");
            odbBkpEnabled = false;
        }
        if (gmailBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateGmailUserRestrictions(cloud.getCloudId(), cl.getCloud()), response)) {
            logger.debug("GMAIL BACKUP USER LIMIT REACHED........");
            gmailBkpEnabled = false;
        }
        if (gdriveBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateGdriveUserRestrictions(cloud.getCloudId(), cl.getCloud()), response)) {
            logger.debug("GDRIVE BACKUP USER LIMIT REACHED........");
            gdriveBkpEnabled = false;
        }
        if (site && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSPUserRestrictions(cloud.getCloudId(), cl.getCloud()), response)) {
            logger.debug("SITE LIMIT REACHED........");
            this.sendEmailForUserLimitExceded(cloud, cloudName, userPrincipleName, "Office Backup User");
            odbBkpEnabled = false;
        }
        if (!(isSyncEnabled || isBackupEnabled || exchangeBkpEnabled || odbBkpEnabled || site || gmailBkpEnabled || gdriveBkpEnabled)) {
            logger.debug("..USER LIMIT REACHED........");
            return false;
        }
        LdapUserElement ldapUserElement = new LdapUserElement();
        ldapUserElement.setUserName(aadUser.getUserPrincipalName());
        if (StringUtils.isEmpty((Object)aadUser.getMail())) {
            ldapUserElement.setEmailId(aadUser.getUserPrincipalName());
        } else {
            ldapUserElement.setEmailId(aadUser.getMail());
        }
        ldapUserElement.setDisplayName(aadUser.getDisplayName());
        ldapUserElement.setDefaultPolicy(aadUser.getDefaultPolicy() != null ? aadUser.getDefaultPolicy() : this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
        ldapUserElement.setDefaultSyncPolicy(aadUser.getDefaultSyncPolicy() != null ? aadUser.getDefaultSyncPolicy() : this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
        ldapUserElement.setDefaultO365Policy(this.registry.get(cloudId).getPropertyFileValueDefaultO365PolicyName());
        ldapUserElement.setLocation(aadUser.getOfficeLocation());
        ldapUserElement.setDepartment(aadUser.getDepartment());
        ldapUserElement.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
        ldapUserElement.setDefaultGdrivePolicyName(this.registry.get(cloudId).getDefaultGdrivePolicyName());
        ldapUserElement.setAccountStatus(true);
        boolean userCreated = false;
        try {
            userCreated = this.managementService.createUserFromLdap(cloud.getCloudId(), cloudName, ldapUserElement, "AUTO", isSyncEnabled, isBackupEnabled, odbBkpEnabled, exchangeBkpEnabled, gmailBkpEnabled, gdriveBkpEnabled);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(401);
            success = false;
        }
        if (userCreated) {
            this.auditHistoryService.saveStatisticToDatabase(cloud.getCloudId(), cloudName, "migrated", "Auto", ldapUserElement.getUserName(), "Agent", System.currentTimeMillis());
            success = true;
        }
        return success;
    }

    private void sendEmailForUserLimitExceded(Cloud cloud, String cloudName, String userName, String userLicense) {
        EmailProps email = new EmailProps();
        int cloudId = cloud.getCloudId();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("user-limit-reached");
        EmailRecipent emailRecipent = new EmailRecipent();
        try {
            List<User> allAdmins = this.managementService.getAllAdmins(cloudId, cloudName);
            for (User adminUser : allAdmins) {
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(adminUser.getUserName());
                emailRecipent.setEmail(adminUser.getEmailId());
                emailRecipents.add(emailRecipent);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        logger.debug("Toatal email recipents count...:" + emailRecipents.size());
        email.setActionBy("");
        email.setStartDate(DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()));
        email.setDeviceName(userName);
        email.setRecipents(emailRecipents);
        email.setToUser(true);
        email.setBodyData("EndPoint");
        email.setSupportDescription(userLicense);
        email.setUserName(userName);
        email.setActionOn(userName);
        email.setUserName(userName);
        this.cloudMailService.sendMail(cloud, email);
    }

    public boolean migrateUserFromAAD(AADUserElement aadUser, CloudLicenseTo cl, Cloud cloud, String cloudName, HttpServletResponse response, IdentityProviderSettingsElement aadCredentialsElement, boolean isCheckForCustomizabledetails) {
        boolean success = false;
        if (aadUser == null) {
            logger.debug("aadUser user is null ");
            return success;
        }
        boolean isSyncEnabled = false;
        boolean isBackupEnabled = false;
        boolean odbBkpEnabled = false;
        boolean exchangeBkpEnabled = false;
        boolean gmailBkpEnabled = false;
        boolean gdriveBkpEnabled = false;
        boolean sharePointEnabled = false;
        if (isCheckForCustomizabledetails) {
            if (StringUtils.isEmpty((Object)aadUser.getProductType())) {
                logger.debug("User not part of any product");
                return success;
            }
            List list = cl.getCloud().getCloudCustomisableDetails();
            for (CloudCustomisableDetails customisableDetails : list) {
                if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                    isSyncEnabled = true;
                }
                if (customisableDetails.getName().equalsIgnoreCase(BACKUP_ENABLED)) {
                    isBackupEnabled = true;
                }
                if (aadCredentialsElement != null && !CollectionUtils.isEmpty((Collection)aadCredentialsElement.getGroupMapping())) {
                    if ("OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                        odbBkpEnabled = true;
                    }
                    if ("Exchange Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                        exchangeBkpEnabled = true;
                    }
                }
                if ("GMAIL Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                    gmailBkpEnabled = true;
                }
                if ("GDRIVE Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                    gdriveBkpEnabled = true;
                }
                if (!"Sharepoint Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
                sharePointEnabled = true;
            }
            if ("SYNC".equalsIgnoreCase(aadUser.getProductType())) {
                isBackupEnabled = false;
            }
            if ("BACKUP".equalsIgnoreCase(aadUser.getProductType())) {
                isSyncEnabled = false;
            }
        } else {
            isSyncEnabled = aadUser.isSyncEnabled();
            isBackupEnabled = aadUser.isBackupEnabled();
            odbBkpEnabled = aadUser.isOnedriveBkpEnabled();
            exchangeBkpEnabled = aadUser.isExchangeBkpEnabled();
            gmailBkpEnabled = aadUser.isGmailBkpEnabled();
            gdriveBkpEnabled = aadUser.isGdriveBkpEnabled();
            sharePointEnabled = aadUser.isSharePointBkpEnabled();
        }
        int code = this.deviceAndUserSecurityService.validateUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud());
        if (!this.checkLicense(code, response)) {
            logger.debug("USER LIMIT REACHED........");
            return success;
        }
        if (isSyncEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug(" SYNC USER LIMIT REACHED........");
            isSyncEnabled = false;
        }
        if (isBackupEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug("BACKUP USER LIMIT REACHED........");
            isBackupEnabled = false;
        }
        if (exchangeBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateExchangeUserRestrictions(cloud.getCloudId(), cl.getCloud()), response)) {
            logger.debug("Office USER LIMIT REACHED........");
            exchangeBkpEnabled = false;
        }
        if (odbBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateOnedriveUserRestrictions(cloud.getCloudId(), cl.getCloud()), response)) {
            logger.debug("Office USER LIMIT REACHED........");
            odbBkpEnabled = false;
        }
        if (gmailBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateGmailUserRestrictions(cloud.getCloudId(), cl.getCloud()), response)) {
            logger.debug("GMAIL BACKUP USER LIMIT REACHED........");
            gmailBkpEnabled = false;
        }
        if (gdriveBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateGdriveUserRestrictions(cloud.getCloudId(), cl.getCloud()), response)) {
            logger.debug("GDRIVE BACKUP USER LIMIT REACHED........");
            gdriveBkpEnabled = false;
        }
        if (sharePointEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSPUserRestrictions(cloud.getCloudId(), cl.getCloud()), response)) {
            logger.debug("SITE LIMIT REACHED........");
            sharePointEnabled = false;
        }
        if (!(isSyncEnabled || isBackupEnabled || exchangeBkpEnabled || odbBkpEnabled || gmailBkpEnabled || gdriveBkpEnabled || sharePointEnabled)) {
            logger.debug("..USER LIMIT REACHED........");
            return false;
        }
        LdapUserElement ldapUserElement = new LdapUserElement();
        ldapUserElement.setUserName(aadUser.getUserPrincipalName());
        if (StringUtils.isEmpty((Object)aadUser.getMail())) {
            ldapUserElement.setEmailId(aadUser.getUserPrincipalName());
        } else {
            ldapUserElement.setEmailId(aadUser.getMail());
        }
        int cloudId = cloud.getCloudId();
        ldapUserElement.setDisplayName(aadUser.getDisplayName());
        ldapUserElement.setDefaultPolicy(aadUser.getDefaultPolicy() != null ? aadUser.getDefaultPolicy() : this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
        ldapUserElement.setDefaultSyncPolicy(aadUser.getDefaultSyncPolicy() != null ? aadUser.getDefaultSyncPolicy() : this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
        ldapUserElement.setDefaultO365Policy(this.registry.get(cloudId).getPropertyFileValueDefaultO365PolicyName());
        ldapUserElement.setDefaultODBPolicy(aadUser.getDefaultOdbPolicy() != null ? aadUser.getDefaultOdbPolicy() : this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
        ldapUserElement.setDefaultExchangePolicy(aadUser.getDefaultExchangePolicy() != null ? aadUser.getDefaultExchangePolicy() : this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
        ldapUserElement.setDefaultSharePointPolicy(aadUser.getDefaultSharepointPolicy() != null ? aadUser.getDefaultSharepointPolicy() : this.registry.get(cloudId).getPropertyFileValueDefaultSpPolicy());
        ldapUserElement.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
        ldapUserElement.setDefaultGdrivePolicyName(this.registry.get(cloudId).getDefaultGdrivePolicyName());
        ldapUserElement.setLocation(aadUser.getOfficeLocation());
        ldapUserElement.setDepartment(aadUser.getDepartment());
        ldapUserElement.setAccountStatus(true);
        boolean userCreated = false;
        try {
            userCreated = this.managementService.createUserFromLdap(cloud.getCloudId(), cloudName, ldapUserElement, "AUTO", isSyncEnabled, isBackupEnabled, odbBkpEnabled, exchangeBkpEnabled, gmailBkpEnabled, gdriveBkpEnabled);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(401);
            success = false;
        }
        if (userCreated) {
            this.auditHistoryService.saveStatisticToDatabase(cloud.getCloudId(), cloudName, "migrated", "Auto", ldapUserElement.getUserName(), "Agent", System.currentTimeMillis());
            success = true;
        }
        return success;
    }
}

