/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.AADManagementService;
import com.parablu.bluvault.udc.service.CloudSettingsService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.UserLimitReachedException;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.AADAuthorizationTokenElement;
import com.parablu.paracloud.element.AADUserElement;
import com.parablu.paracloud.element.AADUserNamesList;
import com.parablu.paracloud.element.AADUsersListElement;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.IdentityProviderSettingsElement;
import com.parablu.paracloud.util.DateUtil;
import com.parablu.pcbd.dao.PortalPropertiesDao;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.MigrationStatus;
import com.parablu.pcbd.domain.User;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AADManagementController
extends BaseController {
    private static Logger logger = LogManager.getLogger(AADManagementController.class);
    private static final String EXCEPTION = " Exception  :";
    private static final String MIGRATION = "MIGRATION";
    @Autowired
    private AADManagementService aadManagementService;
    @Autowired
    private UserManagementService userManagementService;
    @Autowired
    private CloudMailService cloudMailService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Resource
    private PortalPropertiesDao portalPropertiesDao;
    @Autowired
    private CloudSettingsService cloudSettingService;
    Runnable daemonRunner = null;
    Thread daemonThread = null;

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/load/all"}, method={RequestMethod.GET})
    public ModelAndView loadAllAADCredentials(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("versions/{versionNumber}/clouds/{cloudName}/load/all/ latest");
        try {
            User currentUser;
            String isInternalCall;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            ModelAndView andView = new ModelAndView();
            cloudName1 = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (StringUtils.isEmpty((Object)(isInternalCall = request.getHeader("isInternalCall"))) && !this.performAuthorization(cloudId, cloudName1, token, currentUser = new User(), response, userName)) {
                return null;
            }
            logger.debug("versions/{versionNumber}/clouds/{cloudName}/load/all/ latest1");
            List list = cl.getCloud().getCloudCustomisableDetails();
            boolean isAADEnabled = this.isAADEnabled(list, "AAD Enabled");
            if (!isAADEnabled) {
                response.setStatus(443);
                return null;
            }
            logger.debug("versions/{versionNumber}/clouds/{cloudName}/load/all/ latest2");
            CloudPropertyElement cloudPropertyElement = this.cloudSettingService.getCloudPropertyElement(cloudId);
            List<IdentityProviderSettingsElement> aadCredentialsElementList = this.aadManagementService.getAllAADCredentials(cloudId);
            logger.debug("versions/{versionNumber}/clouds/{cloudName}/load/all/ latest3");
            if (CollectionUtils.isEmpty(aadCredentialsElementList)) {
                logger.debug("versions/{versionNumber}/clouds/{cloudName}/load/all/ latest4");
                IdentityProviderSettingsElement aadCredentialsElement = new IdentityProviderSettingsElement();
                if (cloudPropertyElement != null) {
                    aadCredentialsElement.setDefaultBkpPolicyName(cloudPropertyElement.getDefaultBkpPolicyName());
                    aadCredentialsElement.setDefaultExchangePolicyName(cloudPropertyElement.getDefaultExchangePolicyName());
                    aadCredentialsElement.setDefaultOdbPolicyName(cloudPropertyElement.getDefaultOdbPolicyName());
                    aadCredentialsElement.setDefaultSharepointPolicyName(cloudPropertyElement.getDefaultSharepointPolicyName());
                    aadCredentialsElement.setDefaultSyncPolicyName(cloudPropertyElement.getDefaultSyncPolicyName());
                    aadCredentialsElement.setDefaultGmailPolicyName(cloudPropertyElement.getDefaultGmailPolicyName());
                    aadCredentialsElement.setDefaultGdrivePolicyName(cloudPropertyElement.getDefaultGdrivePolicyName());
                }
                aadCredentialsElementList.add(aadCredentialsElement);
                andView.addObject(aadCredentialsElementList);
                logger.debug("......empty...................." + aadCredentialsElementList.size());
                return andView;
            }
            logger.debug("versions/{versionNumber}/clouds/{cloudName}/load/all/ latest5");
            logger.debug(".............non empty............." + aadCredentialsElementList.size());
            ArrayList<IdentityProviderSettingsElement> aadCredentialsElementNewList = new ArrayList<IdentityProviderSettingsElement>();
            for (IdentityProviderSettingsElement aadCredentialsElement : aadCredentialsElementList) {
                if (cloudPropertyElement != null) {
                    aadCredentialsElement.setDefaultBkpPolicyName(cloudPropertyElement.getDefaultBkpPolicyName());
                    aadCredentialsElement.setDefaultExchangePolicyName(cloudPropertyElement.getDefaultExchangePolicyName());
                    aadCredentialsElement.setDefaultOdbPolicyName(cloudPropertyElement.getDefaultOdbPolicyName());
                    aadCredentialsElement.setDefaultSharepointPolicyName(cloudPropertyElement.getDefaultSharepointPolicyName());
                    aadCredentialsElement.setDefaultSyncPolicyName(cloudPropertyElement.getDefaultSyncPolicyName());
                    aadCredentialsElement.setDefaultGmailPolicyName(cloudPropertyElement.getDefaultGmailPolicyName());
                    aadCredentialsElement.setDefaultGdrivePolicyName(cloudPropertyElement.getDefaultGdrivePolicyName());
                }
                aadCredentialsElement.setUser_principal(null);
                aadCredentialsElementNewList.add(aadCredentialsElement);
            }
            andView.addObject(aadCredentialsElementNewList);
            return andView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/IDPCredentials"}, method={RequestMethod.GET})
    public ModelAndView getAADCredentials(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("versions/{versionNumber}/clouds/{cloudName}/IDPCredentials/ ...." + request.getHeader("aadCredId"));
        try {
            User currentUser;
            String isInternalCall;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            String aadCredId = request.getHeader("aadCredId");
            ModelAndView andView = new ModelAndView();
            cloudName1 = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (StringUtils.isEmpty((Object)(isInternalCall = request.getHeader("isInternalCall"))) && !this.performAuthorization(cloudId, cloudName1, token, currentUser = new User(), response, userName)) {
                return null;
            }
            List list = cl.getCloud().getCloudCustomisableDetails();
            boolean isAADEnabled = this.isAADEnabled(list, "AAD Enabled");
            if (!isAADEnabled) {
                response.setStatus(443);
                return null;
            }
            IdentityProviderSettingsElement aadCredentialsElement = this.aadManagementService.getAADCredentials(cloudId, aadCredId);
            if (aadCredentialsElement == null) {
                response.setStatus(404);
                return null;
            }
            CloudPropertyElement cloudPropertyElement = this.cloudSettingService.getCloudPropertyElement(cloudId);
            if (cloudPropertyElement != null) {
                aadCredentialsElement.setDefaultBkpPolicyName(cloudPropertyElement.getDefaultBkpPolicyName());
                aadCredentialsElement.setDefaultExchangePolicyName(cloudPropertyElement.getDefaultExchangePolicyName());
                aadCredentialsElement.setDefaultOdbPolicyName(cloudPropertyElement.getDefaultOdbPolicyName());
                aadCredentialsElement.setDefaultSharepointPolicyName(cloudPropertyElement.getDefaultSharepointPolicyName());
                aadCredentialsElement.setDefaultSyncPolicyName(cloudPropertyElement.getDefaultSyncPolicyName());
                aadCredentialsElement.setDefaultGmailPolicyName(cloudPropertyElement.getDefaultGmailPolicyName());
                aadCredentialsElement.setDefaultGdrivePolicyName(cloudPropertyElement.getDefaultGdrivePolicyName());
            }
            logger.debug("............end of loading versions/{versionNumber}/clouds/{cloudName}/AADCredentials/ .................." + aadCredentialsElement.getId());
            andView.addObject((Object)aadCredentialsElement);
            return andView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/IDPCredentials"}, method={RequestMethod.POST})
    public void saveAADCredentials(@PathVariable(value="cloudName") String cloudName1, @RequestBody IdentityProviderSettingsElement aadCredentials, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("versions/{versionNumber}/clouds/{cloudName}/IDPCredentials/ ...." + aadCredentials.getDefaultBkpPolicyName());
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName1 = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName1, token, currentUser, response, userName)) {
                return;
            }
            List list = cl.getCloud().getCloudCustomisableDetails();
            boolean isAADEnabled = this.isAADEnabled(list, "AAD Enabled");
            if (!isAADEnabled) {
                response.setStatus(443);
                return;
            }
            boolean isSuccess = this.aadManagementService.saveAADCredentials(cl.getCloud(), aadCredentials, currentUser.getUserName());
            if (!isSuccess) {
                response.setStatus(400);
            } else {
                response.setStatus(200);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/synAADUsers/"}, method={RequestMethod.POST})
    public void syncAADUsers(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("versions/{versionNumber}/clouds/{cloudName}/synAADUsers/ ....");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName1 = cl.getCloud().getCloudName();
            this.aadManagementService.synUserAttributes(cl.getCloud());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/aadauthorizationtoken"}, method={RequestMethod.POST})
    public void saveAADAuthorizationtoken(@PathVariable(value="cloudName") String cloudName1, @RequestBody AADAuthorizationTokenElement aadCredentials, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("versions/{versionNumber}/clouds/{cloudName}/aadauthorizationtoken ....");
        try {
            User currentUser;
            String isInternalCall;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            Cloud cloud = cl.getCloud();
            cloudName1 = cloud.getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (StringUtils.isEmpty((Object)(isInternalCall = request.getHeader("isInternalCall"))) && !this.performAuthorization(cloudId, cloudName1, token, currentUser = new User(), response, userName)) {
                return;
            }
            List list = cloud.getCloudCustomisableDetails();
            boolean isAADEnabled = this.isAADEnabled(list, "AAD Enabled");
            if (!isAADEnabled) {
                response.setStatus(443);
                return;
            }
            String loggedInUser = aadCredentials.getUser_principal();
            logger.debug(aadCredentials.getUser_principal() + "..AADAuthorizationTokenElement vals ............" + loggedInUser);
            AADAuthorizationTokenElement savedElement = this.aadManagementService.saveAADAuthorizationtoken(cloudId, aadCredentials);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloud.getCloudName(), " IdP mapping consent given by " + savedElement.getUser_principal(), loggedInUser, "", "Portal", System.currentTimeMillis(), PCActionTypes.AAD_USER_MIGRATION.getActionTypeValue());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/aad/users"}, method={RequestMethod.POST})
    public ModelAndView ldapconnectivityUser(@PathVariable(value="cloudName") String cloudName, @RequestBody AADUserNamesList aadUserNamesList, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("....calling versions/{versionNumber}/clouds/{cloudName}/aad/users ... ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            List list = cl.getCloud().getCloudCustomisableDetails();
            boolean isAADEnabled = this.isAADEnabled(list, "AAD Enabled");
            if (!isAADEnabled) {
                response.setStatus(443);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            List<Object> aadUsersListElement = new ArrayList();
            if (cl.getCloud().getGraphAADEnabled() == 1) {
                logger.debug("...graph enabled....");
                aadUsersListElement = this.aadManagementService.getGraphAADUsersFromUserNames(cl.getCloud(), aadUserNamesList);
            } else {
                logger.debug("...graph enabled no....");
                aadUsersListElement = this.aadManagementService.getAADUsersFromUserNames(cl.getCloud(), aadUserNamesList);
            }
            if (CollectionUtils.isEmpty(aadUsersListElement)) {
                response.setStatus(204);
                return null;
            }
            response.setStatus(200);
            modelAndView.addObject(aadUsersListElement);
        }
        catch (Exception e) {
            logger.trace("error trying to load elements  ..........." + String.valueOf(e));
            response.setStatus(400);
            logger.error(EXCEPTION + e.getMessage());
        }
        logger.debug("....end of calling versions/{versionNumber}/clouds/{cloudName}/aad/users ... ");
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/aad/users/migrate"}, method={RequestMethod.POST})
    public ModelAndView ldapconnectivityUser(@PathVariable(value="cloudName") String cloudName1, @RequestBody AADUsersListElement aadUsersListElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(request.getHeader("o365BackupEnabled") + " Inside migrate users ........ sync enabled>>" + request.getHeader("syncEnabled"));
        int totalUsersCount = aadUsersListElement.getAadUsersList().size();
        int totalUsersMigrated = 0;
        logger.debug(" Inside migrate users ........ backup enabled>>" + request.getHeader("backupEnabled"));
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String adminName = request.getHeader("adminName");
            boolean isSyncEnabled = Boolean.parseBoolean(request.getHeader("syncEnabled"));
            boolean isBackupEnabled = Boolean.parseBoolean(request.getHeader("backupEnabled"));
            boolean isOdbBackupEnabled = Boolean.parseBoolean(request.getHeader("odbBackupEnabled"));
            boolean isExchangeEnabled = Boolean.parseBoolean(request.getHeader("exchangeEnabled"));
            boolean isSharepointEnabled = Boolean.parseBoolean(request.getHeader("sharepointEnabled"));
            ArrayList<String> users = new ArrayList<String>();
            for (AADUserElement aadUserElement : aadUsersListElement.getAadUsersList()) {
                try {
                    logger.debug(".... odb policy name... " + aadUserElement.getUserName() + "..getDefaultO365Policy.." + aadUserElement.getDefaultOdbPolicy());
                    boolean userMigrated = false;
                    try {
                        if (!StringUtils.isEmpty((Object)aadUserElement.getDefaultOdbPolicy())) {
                            isOdbBackupEnabled = true;
                        }
                        if (!StringUtils.isEmpty((Object)aadUserElement.getDefaultPolicy())) {
                            isBackupEnabled = true;
                        }
                        if (!StringUtils.isEmpty((Object)aadUserElement.getDefaultSyncPolicy())) {
                            isSyncEnabled = true;
                        }
                        if (!StringUtils.isEmpty((Object)aadUserElement.getDefaultExchangePolicy())) {
                            isExchangeEnabled = true;
                        }
                        if (!StringUtils.isEmpty((Object)aadUserElement.getDefaultSharepointPolicy())) {
                            isSharepointEnabled = true;
                        }
                        userMigrated = this.migrateUserFromAAD(cl.getCloud(), aadUserElement, isSyncEnabled, isBackupEnabled, isOdbBackupEnabled, isExchangeEnabled, isSharepointEnabled, adminName);
                    }
                    catch (UserLimitReachedException e) {
                        logger.error("...user limit reached during migration... ");
                        this.sendEmailForUserLimitExceded(cl.getCloud(), cloudName, aadUserElement.getUserName(), "User");
                    }
                    if (userMigrated) {
                        ++totalUsersMigrated;
                    }
                }
                catch (Exception e) {
                    logger.error(" USERS CANNOT BE MIGRATED ................." + String.valueOf(e));
                    logger.debug("USERS CANNOT BE MIGRATED ................." + e.getMessage());
                }
                users.add(aadUserElement.getUserName());
            }
            if (totalUsersMigrated == 0) {
                response.setStatus(417);
            } else if (totalUsersMigrated != totalUsersCount) {
                modelAndView.addObject("totalUsersMigrated", (Object)totalUsersMigrated);
                modelAndView.addObject("totalUsersCount", (Object)totalUsersCount);
                response.setStatus(206);
            } else {
                response.setStatus(200);
            }
        }
        catch (Exception e) {
            logger.trace("error trying to load elements  ..........." + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        logger.debug("End of Inside migrate users ........ ");
        return modelAndView;
    }

    private void sendEmailForUserLimitExceded(Cloud cloud, String cloudName, String userName, String userLicense) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("user-limit-reached");
        EmailRecipent emailRecipent = new EmailRecipent();
        try {
            List<User> allAdmins = this.userManagementService.getAllAdmins(cloud.getCloudId(), cloudName);
            for (User adminUser : allAdmins) {
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(adminUser.getUserName());
                emailRecipent.setEmail(adminUser.getEmailId());
                emailRecipents.add(emailRecipent);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        logger.debug("Toatal email recipents count...:" + emailRecipents.size());
        email.setActionBy("");
        email.setStartDate(DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()));
        email.setDeviceName(userName);
        email.setRecipents(emailRecipents);
        email.setToUser(true);
        email.setBodyData("Portal");
        email.setSupportDescription(userLicense);
        email.setUserName(userName);
        email.setActionOn(userName);
        email.setUserName(userName);
        this.cloudMailService.sendMail(cloud, email);
    }

    private boolean isAADEnabled(List<CloudCustomisableDetails> list, String licenseName) {
        boolean isAADEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!licenseName.equals(customisableDetails.getName())) continue;
            isAADEnabled = true;
            break;
        }
        return isAADEnabled;
    }

    private boolean migrateUserFromAAD(Cloud cloud, AADUserElement aadUserElement, boolean isSyncEnable, boolean isBackupEnable, boolean isOdbBackupEnable, boolean isExchangeEnable, boolean isSharepointEnable, String migratedBy) {
        boolean userMigrated = false;
        boolean isSyncEnabled = isSyncEnable;
        boolean isBackupEnabled = isBackupEnable;
        boolean isOdbBackupEnabled = isOdbBackupEnable;
        boolean isExchangeEnabled = isExchangeEnable;
        boolean isSharepointEnabled = isSharepointEnable;
        int cloudId = cloud.getCloudId();
        logger.debug("...flags..." + isBackupEnabled + "...." + isSyncEnabled + "...." + isOdbBackupEnabled + "..." + isExchangeEnabled + "...." + isSharepointEnabled);
        try {
            boolean userCreated;
            AADUserElement user = null;
            if (cloud.getGraphAADEnabled() == 1) {
                IdentityProviderSettingsElement aadCredentialsElement = this.aadManagementService.getAADCredentials(cloudId);
                ArrayList<String> tenants = new ArrayList<String>();
                if (cloud.getMultiTenantAADEnabled() == 1) {
                    if (!CollectionUtils.isEmpty((Collection)aadCredentialsElement.getTenants())) {
                        tenants.addAll(aadCredentialsElement.getTenants());
                    } else {
                        tenants.add(aadCredentialsElement.getTenentId());
                    }
                } else {
                    tenants.add(aadCredentialsElement.getTenentId());
                }
                for (String tenantId : tenants) {
                    user = this.aadManagementService.getNewAADUserFromUserName(aadUserElement.getUserName(), aadCredentialsElement.getClientId(), aadCredentialsElement.getSecretKey(), tenantId, cloud.getCloudId());
                    if (user == null) continue;
                    break;
                }
            } else {
                user = this.aadManagementService.getAADUserFromUserName(cloud, aadUserElement.getUserName());
            }
            if (user == null) {
                return userMigrated;
            }
            if (StringUtils.isEmpty((Object)user.getProductType())) {
                logger.debug("User is not part of any type .... so skip " + user.getUserPrincipalName());
            }
            logger.debug("...productType...." + user.getProductType());
            logger.debug("...flagsafter..." + isBackupEnabled + "...." + isSyncEnabled + "...." + isOdbBackupEnabled + "..." + isExchangeEnabled + "...." + isSharepointEnabled);
            if (StringUtils.isEmpty((Object)aadUserElement.getDefaultSyncPolicy())) {
                aadUserElement.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
            }
            if (StringUtils.isEmpty((Object)aadUserElement.getDefaultOdbPolicy())) {
                aadUserElement.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
            }
            if (isBackupEnabled && StringUtils.isEmpty((Object)aadUserElement.getDefaultPolicy())) {
                aadUserElement.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
            }
            if (isOdbBackupEnabled && StringUtils.isEmpty((Object)aadUserElement.getDefaultOdbPolicy())) {
                aadUserElement.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
            }
            if (isExchangeEnabled && StringUtils.isEmpty((Object)aadUserElement.getDefaultExchangePolicy())) {
                aadUserElement.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
            }
            if (isSharepointEnabled && StringUtils.isEmpty((Object)aadUserElement.getDefaultSharepointPolicy())) {
                aadUserElement.setDefaultSharepointPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSpPolicy());
            }
            if (aadUserElement != null) {
                logger.debug(isOdbBackupEnabled + "...AAD User Element ...." + aadUserElement.toString());
            }
            if (userCreated = this.userManagementService.createUserFromAAD(cloudId, cloud.getCloudName(), aadUserElement, migratedBy, isSyncEnabled, isBackupEnabled, isOdbBackupEnabled, isExchangeEnabled, isSharepointEnabled, cloud)) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloud.getCloudName(), MIGRATION, migratedBy, aadUserElement.getUserPrincipalName(), "IdP", System.currentTimeMillis(), PCActionTypes.AAD_USER_MIGRATION.getActionTypeValue());
                userMigrated = true;
            }
        }
        catch (UserLimitReachedException e) {
            throw new UserLimitReachedException("user limit reached");
        }
        catch (Exception e) {
            MigrationStatus migrationStatus = new MigrationStatus();
            migrationStatus.setMigratedBy(migratedBy);
            migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
            migrationStatus.setMigrated(false);
            migrationStatus.setReason("Failed to get user form AD");
            migrationStatus.setUserName(aadUserElement.getUserPrincipalName());
            if (StringUtils.isEmpty((Object)aadUserElement.getMail())) {
                migrationStatus.setEmailId(aadUserElement.getUserPrincipalName());
            } else {
                migrationStatus.setEmailId(aadUserElement.getMail());
            }
            this.userManagementService.saveMigrationStatus(cloudId, migrationStatus);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return userMigrated;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/delete/AADCredentials/"}, method={RequestMethod.DELETE})
    public void deleteAADCredentials(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("..delete..versions/{versionNumber}/clouds/{cloudName}/AADCredentials/ ...." + request.getHeader("aadCredId"));
        try {
            User currentUser;
            String isInternalCall;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            String aadCredId = request.getHeader("aadCredId");
            ModelAndView andView = new ModelAndView();
            cloudName1 = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (StringUtils.isEmpty((Object)(isInternalCall = request.getHeader("isInternalCall"))) && !this.performAuthorization(cloudId, cloudName1, token, currentUser = new User(), response, userName)) {
                return;
            }
            List list = cl.getCloud().getCloudCustomisableDetails();
            boolean isAADEnabled = this.isAADEnabled(list, "AAD Enabled");
            if (!isAADEnabled) {
                response.setStatus(443);
                return;
            }
            this.aadManagementService.deleteAADCredentials(cloudId, aadCredId);
            response.setStatus(200);
            logger.debug("..end of delete..versions/{versionNumber}/clouds/{cloudName}/AADCredentials/ ....");
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/aadUser/{userName}/"}, method={RequestMethod.GET})
    public ModelAndView checkAADUserCredentials(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/aadUser/{userName}/");
        try {
            User currentUser;
            String isInternalCall;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            ModelAndView andView = new ModelAndView();
            cloudName1 = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (StringUtils.isEmpty((Object)(isInternalCall = request.getHeader("isInternalCall"))) && !this.performAuthorization(cloudId, cloudName1, token, currentUser = new User(), response, userName)) {
                return null;
            }
            List list = cl.getCloud().getCloudCustomisableDetails();
            boolean isAADEnabled = this.isAADEnabled(list, "AAD Enabled");
            if (!isAADEnabled) {
                response.setStatus(443);
                return null;
            }
            String tenantId = "";
            if (cl.getCloud().getGraphAADEnabled() == 1) {
                tenantId = this.aadManagementService.getTenantIdForGraphAADUsersFromUserNames(cl.getCloud(), userName1);
            }
            logger.debug(userName1 + ".......user in..................." + tenantId);
            response.addHeader("tenantId", tenantId);
            response.setStatus(200);
            return andView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/initiate/aadsync/"}, method={RequestMethod.GET})
    public void startAADSyncJob(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/initiate/aadsync/");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            final Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            cloudName1 = cloud.getCloudName();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            User currentUser = new User();
            if (!this.performAuthorization(cloud.getCloudId(), cloudName1, token, currentUser, response, userName)) {
                return;
            }
            if (StringUtils.isEmpty((Object)userName)) {
                userName = currentUser.getUserName();
            }
            if (this.daemonThread != null && this.daemonThread.isAlive()) {
                logger.debug("sync is already going on try after some time");
                response.setStatus(445);
                return;
            }
            this.daemonRunner = null;
            this.daemonThread = null;
            this.daemonRunner = new Runnable(){

                @Override
                public void run() {
                    if (cloud.getGraphAADEnabled() == 1) {
                        AADManagementController.this.aadManagementService.syncNewUserAttributes(cloud);
                    } else {
                        AADManagementController.this.aadManagementService.synUserAttributes(cloud);
                    }
                    IdentityProviderSettingsElement aadCredentials = AADManagementController.this.aadManagementService.getAADCredentials(cloud.getCloudId());
                    if (aadCredentials.getLoginMode().equalsIgnoreCase("Google")) {
                        AADManagementController.this.aadManagementService.syncGmailGroups(cloud);
                    }
                    if (aadCredentials.getLoginMode().equalsIgnoreCase("Okta")) {
                        AADManagementController.this.aadManagementService.syncOktaGroups(cloud);
                    }
                }
            };
            this.daemonThread = new Thread(this.daemonRunner);
            this.daemonThread.start();
            logger.debug("aad sync job started...");
            response.setStatus(200);
            IdentityProviderSettingsElement aadCredentials = this.aadManagementService.getAADCredentials(cloud.getCloudId());
            String loginMode = aadCredentials.getLoginMode();
            if ("Microsoft".equalsIgnoreCase(loginMode)) {
                loginMode = "Microsoft Entra";
            } else if ("Google".equalsIgnoreCase(loginMode)) {
                loginMode = "Google Identity";
            }
            String auditMessage = " initiated IdP [Type:" + loginMode + "] synchronization job";
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloud.getCloudName(), auditMessage, userName, "", "Portal", System.currentTimeMillis(), PCActionTypes.AAD_USER_MIGRATION.getActionTypeValue());
            return;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION, (Throwable)e);
            response.setStatus(500);
            return;
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/save/serviceaccount/"}, method={RequestMethod.POST})
    public void saveserviceaccountFileToServer(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Inside save service account File .....");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("Error checkLicense during save service account File  ....");
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (!StringUtils.isEmpty((Object)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            String internalCall = request.getHeader("internalCall");
            String currentUserName = "admin";
            cloudName = cl.getCloud().getCloudName();
            String fileName = request.getHeader("fileName");
            String filePath = this.registry.get(cloudId).getPropertyFileValueParacloudMountPoint() + "Serviceaccount";
            if (StringUtils.isEmpty((Object)fileName)) {
                response.setStatus(400);
                return;
            }
            if (internalCall == null || !internalCall.equalsIgnoreCase("true")) {
                if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                    return;
                }
                currentUserName = userName;
            }
            if (this.aadManagementService.saveServiceAccountFileInDb(cloudId, fileName, filePath)) {
                response.setStatus(200);
            } else {
                logger.debug("failed to save file in db");
                response.setStatus(500);
            }
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.error("error .." + e.getMessage());
        }
    }
}

