/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.mt.service.impl;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.parablu.cloud.security.service.impl.UserValidateService;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.mt.service.LdapService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.AdElement;
import com.parablu.paracloud.element.LdapUserElement;
import com.parablu.paracloud.util.HttpClientUtil;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.AuthorizationDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.ComputerDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.MigrationStatusDao;
import com.parablu.pcbd.dao.PersonDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AdCredentials;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.MigrationStatus;
import com.parablu.pcbd.domain.Person;
import com.parablu.pcbd.domain.User;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.util.TimeValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class LdapServiceImpl
extends UserValidateService
implements LdapService {
    private static Logger logger = LogManager.getLogger(LdapServiceImpl.class);
    private static final String EXCEPTION = " Exception  :";
    private static final String BASE_EXCEPTION = " BaseException  :";
    private static final String ALGO = "AES";
    private static final byte[] keyValue = new byte[]{101, 56, 53, 100, 54, 98, 97, 99, 50, 102, 52, 56, 101, 100, 53, 89};
    private static final String PREFIX_HTTP = "http://";
    private static final String PREFIX_HTTPS = "https://";
    @Resource
    private PersonDao personDao;
    @Resource
    private ComputerDao computerDao;
    @Resource
    private MigrationStatusDao migrationStatusDao;
    @Resource
    private UserDao userDao;
    @Resource
    private DeviceDao deviceDao;
    @Resource
    private AuthorizationDao authorizationDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private CloudDao cloudDao;

    public void setMigrationStatusDao(MigrationStatusDao migrationStatusDao) {
        this.migrationStatusDao = migrationStatusDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setAuthorizationDao(AuthorizationDao authorizationDao) {
        this.authorizationDao = authorizationDao;
    }

    public void setAuditHistoryDao(AuditHistoryDao auditHistoryDao) {
        this.auditHistoryDao = auditHistoryDao;
    }

    @Override
    public Object[] authenticate(String userName, String password) {
        if (PCHelperConstant.isAzureVM()) {
            logger.debug(" Azure vm authentication " + password);
            return this.checkUserAuthentication(userName, password);
        }
        return this.personDao.authenticate(userName, password);
    }

    @Override
    public boolean checkPersonAlreadyExist(String userName, String emailId) {
        if (StringUtils.isEmpty((String)emailId)) {
            return false;
        }
        User user = this.userDao.getUserByUserNameOrEmail(1, userName, emailId);
        return user != null && !user.isGuest();
    }

    @Override
    public Person getPerson(String userName) {
        if (PCHelperConstant.isAzureVM()) {
            return this.getPersonFromAzure(userName);
        }
        return this.personDao.getPerson(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] checkUserAuthentication(String userName, String password) {
        logger.debug("INSIDE  authenticateAzureUsers ..... ");
        Object[] objArr = new Object[2];
        PoolingHttpClientConnectionManager connManager = null;
        Object url = PCHelperConstant.getPropertyFileValueParacloudUrl() + "/paracloud/cloud/azure/authenticate";
        if (PCHelperConstant.isHttpEnabled()) {
            url = ((String)url).replace(PREFIX_HTTPS, PREFIX_HTTP);
        }
        logger.debug("Paracloud url={} and is Http enabled={}", url, (Object)PCHelperConstant.isHttpEnabled());
        HttpPost httpPost = new HttpPost((String)url);
        CloseableHttpResponse response = null;
        boolean isAuthenticated = false;
        String licenseEnabled = "";
        try {
            Header[] headerarr;
            connManager = new PoolingHttpClientConnectionManager();
            connManager.setDefaultMaxPerRoute(10);
            connManager.setMaxTotal(50);
            CloseableHttpClient httpclient = HttpClientUtil.getSSlConnection();
            MultipartEntityBuilder entity = MultipartEntityBuilder.create();
            entity.addTextBody("userName", userName);
            entity.addTextBody("password", password);
            org.apache.hc.core5.http.HttpEntity entity1 = entity.build();
            httpPost.setEntity(entity1);
            response = httpclient.execute((ClassicHttpRequest)httpPost);
            for (Header header : headerarr = response.getHeaders()) {
                if ("userAuthenticated".equals(header.getName())) {
                    isAuthenticated = Boolean.parseBoolean(header.getValue());
                    logger.debug("User authenticated  ..... " + isAuthenticated);
                }
                if (!"licenseEnabled".equals(header.getName())) continue;
                licenseEnabled = header.getValue();
                logger.debug("User licenseEnabled  ..... " + licenseEnabled);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        finally {
            connManager.closeIdle(TimeValue.of((long)1L, (TimeUnit)TimeUnit.MICROSECONDS));
            connManager.close();
        }
        objArr[0] = isAuthenticated;
        objArr[1] = licenseEnabled;
        return objArr;
    }

    private void closeHttpClient(CloseableHttpClient httpclient) {
        if (httpclient != null) {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                logger.error("error in closing http client:" + e.getMessage());
            }
        }
    }

    private void closeResponse(CloseableHttpResponse result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (IOException e) {
                logger.error("error in closing http client:" + e.getMessage());
            }
        }
    }

    @Override
    public List<Person> findUsersInGroup(String groupName) {
        return this.personDao.findUsersInGroup(groupName);
    }

    @Override
    public List<String> checkIfEmailIsValidOrNot(List<String> userEmails) {
        return this.personDao.checkIfEmailIsValidOrNot(userEmails);
    }

    @Override
    public User getUserByName(int cloudId, String userName) {
        return this.userDao.getUserByName(cloudId, userName);
    }

    @Override
    public Person getUserByEmail(String emailId) {
        return this.personDao.getPerson(emailId);
    }

    @Override
    public List<Person> searchUsersByEmail(String searchBy) {
        if (PCHelperConstant.isAzureVM()) {
            logger.debug(" Azure vm searchBy.... " + searchBy);
            return this.searchPersonByEmail(searchBy);
        }
        return this.personDao.searchPersonByEmail(searchBy);
    }

    private List<Person> searchPersonByEmail(String searchBy) {
        HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        messageConverters.add(new MappingJackson2HttpMessageConverter());
        restTemplate.setMessageConverters(messageConverters);
        HttpHeaders headers = new HttpHeaders();
        headers.add("searchBy", searchBy);
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        logger.debug(" before calling /paracloud/cloud/azure/searchEmail");
        Object url = PCHelperConstant.getPropertyFileValueParacloudUrl() + "/paracloud/cloud/azure/searchEmail";
        if (PCHelperConstant.isHttpEnabled()) {
            url = ((String)url).replace(PREFIX_HTTPS, PREFIX_HTTP);
        }
        logger.debug("Paracloud url={} and is Http enabled={}", url, (Object)PCHelperConstant.isHttpEnabled());
        ResponseEntity result = restTemplate.exchange((String)url, HttpMethod.GET, entity, Person[].class, new Object[0]);
        Person[] persons = (Person[])result.getBody();
        logger.debug(" after calling /paracloud/cloud/azure/searchEmail");
        try {
            reqFactory.destroy();
        }
        catch (Exception e) {
            logger.trace(String.valueOf(e));
        }
        for (Person personObj : persons) {
            logger.debug("   iteraiting  persons ........" + personObj.getEmailId());
        }
        List<Person> list = new ArrayList<Person>();
        if (persons != null) {
            list = Arrays.asList(persons);
        }
        return list;
    }

    private Person getPersonFromAzure(String userName) {
        HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        messageConverters.add(new MappingJackson2HttpMessageConverter());
        restTemplate.setMessageConverters(messageConverters);
        HttpHeaders headers = new HttpHeaders();
        headers.add("userName", userName);
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        logger.debug(" before calling /paracloud/cloud/azure/getPerson/ad/");
        Object url = PCHelperConstant.getPropertyFileValueParacloudUrl() + "/paracloud/cloud/azure/getPerson/ad/";
        if (PCHelperConstant.isHttpEnabled()) {
            url = ((String)url).replace(PREFIX_HTTPS, PREFIX_HTTP);
        }
        logger.debug("Paracloud url={} and is Http enabled={}", url, (Object)PCHelperConstant.isHttpEnabled());
        ResponseEntity result = restTemplate.exchange((String)url, HttpMethod.GET, entity, Person.class, new Object[0]);
        Person person = (Person)result.getBody();
        logger.debug(" after calling /paracloud/cloud/azure/getPerson/ad/");
        try {
            reqFactory.destroy();
        }
        catch (Exception e) {
            logger.trace(String.valueOf(e));
        }
        return person;
    }

    @Override
    public void saveAD(int cloudId, AdElement adElement) {
        AdCredentials adCredentials = new AdCredentials();
        BeanUtils.copyProperties((Object)adElement, (Object)adCredentials);
        String encryptPwd = LdapServiceImpl.encrypt(adElement.getAdPassword());
        adCredentials.setAdPassword(encryptPwd);
        this.personDao.saveAD(cloudId, adCredentials);
    }

    @Override
    public void editAD(int cloudId, AdElement adElement) {
        AdCredentials adCredentials = new AdCredentials();
        BeanUtils.copyProperties((Object)adElement, (Object)adCredentials);
        adCredentials.setId(new ObjectId(adElement.getId()));
        String encryptPwd = LdapServiceImpl.encrypt(adElement.getAdPassword());
        adCredentials.setAdPassword(encryptPwd);
        this.personDao.editAD(cloudId, adCredentials);
    }

    @Override
    public AdElement getADForUserDN(int cloudId, String adName) {
        AdCredentials adCredentials = this.personDao.getADForUserDN(cloudId, adName);
        AdElement adElement = null;
        if (adCredentials != null) {
            adElement = new AdElement();
            BeanUtils.copyProperties((Object)adCredentials, (Object)adElement);
            String decrypted = LdapServiceImpl.decrypt(adCredentials.getAdPassword());
            adElement.setAdPassword(decrypted);
        }
        return adElement;
    }

    @Override
    public List<AdElement> getAllAdCredentials(int cloudId) {
        List list = this.personDao.getAllAdCredentials(cloudId);
        ArrayList<AdElement> adElementList = new ArrayList<AdElement>();
        if (list == null || list.isEmpty()) {
            return adElementList;
        }
        for (AdCredentials credentials : list) {
            AdElement adElement = new AdElement();
            BeanUtils.copyProperties((Object)credentials, (Object)adElement);
            String decrypted = LdapServiceImpl.decrypt(credentials.getAdPassword());
            adElement.setAdPassword(decrypted);
            adElement.setId(credentials.getId().toString());
            adElementList.add(adElement);
        }
        return adElementList;
    }

    @Override
    public void deleteADCredential(int cloudId, String userDn) {
        this.personDao.deleteADCredential(cloudId, userDn);
    }

    public static String encrypt(String data) {
        String encryptedValue = "";
        try {
            Key key = LdapServiceImpl.generateKey();
            Cipher c = Cipher.getInstance(ALGO);
            c.init(1, key);
            byte[] encVal = c.doFinal(data.getBytes());
            encryptedValue = DatatypeConverter.printBase64Binary((byte[])encVal);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return encryptedValue;
    }

    public static String decrypt(String encryptedData) {
        String decryptedValue = "";
        try {
            Key key = LdapServiceImpl.generateKey();
            Cipher c = Cipher.getInstance(ALGO);
            c.init(2, key);
            byte[] decordedValue = DatatypeConverter.parseBase64Binary((String)encryptedData);
            byte[] decValue = c.doFinal(decordedValue);
            decryptedValue = new String(decValue);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return decryptedValue;
    }

    private static Key generateKey() throws Exception {
        return new SecretKeySpec(keyValue, ALGO);
    }

    public static String generateMD5OfString(String convertTo) {
        return new String(Hex.encodeHex((byte[])DigestUtils.md5((String)convertTo)));
    }

    @Override
    public boolean authenticateUsrInAdfs(String userName, String password) {
        boolean isUsrAuthenticated = true;
        WebClient client = null;
        HtmlPage page = null;
        try {
            client = this.getWebClient();
            if (client == null || StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)password)) {
                return false;
            }
            page = this.getPage(client);
            if (page == null) {
                return false;
            }
            List<String> domainNames = this.getAdDomainNames();
            for (String domain : domainNames) {
                logger.debug("Doamin Name>>>>>>" + domain);
                isUsrAuthenticated = this.isAuthenticated(userName, password, isUsrAuthenticated, client, page, domain);
                logger.debug("UserAuthenticated>>>>>" + isUsrAuthenticated);
                if (!isUsrAuthenticated) continue;
                break;
            }
            client.close();
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            isUsrAuthenticated = false;
        }
        return isUsrAuthenticated;
    }

    private boolean isAuthenticated(String userName, String password, boolean isUsrAuthenticated1, WebClient client, HtmlPage page1, String domainName) throws IOException, InterruptedException {
        HtmlPage page = page1;
        boolean isUsrAuthenticated = isUsrAuthenticated1;
        int retryCount = 10;
        List forms = page.getForms();
        HtmlForm form = (HtmlForm)forms.get(0);
        HtmlSpan button = (HtmlSpan)page.getHtmlElementById("submitButton");
        HtmlTextInput textField = (HtmlTextInput)form.getInputByName("UserName");
        HtmlPasswordInput passwordField = (HtmlPasswordInput)form.getInputByName("Password");
        textField.setValueAttribute(domainName + "\\" + userName);
        passwordField.setValueAttribute(password);
        WebWindow window = page.getEnclosingWindow();
        page = (HtmlPage)button.click();
        while (window.getEnclosedPage() == page && retryCount > 0) {
            logger.debug("window hasn't changed" + retryCount);
            Thread.sleep(500L);
            if (--retryCount != 1) continue;
            isUsrAuthenticated = false;
        }
        page = (HtmlPage)window.getEnclosedPage();
        logger.debug("isAuthenticated>>>>" + isUsrAuthenticated);
        logger.debug("2nd Page : " + String.valueOf(page.getUrl()));
        logger.debug("response code>>>>" + page.getWebResponse().getStatusCode());
        logger.debug("response>>>>" + page.getWebResponse().getContentAsString());
        return isUsrAuthenticated;
    }

    private List<String> getAdDomainNames() {
        List crList = this.personDao.getAllAdCredentials(1);
        ArrayList<String> domainNames = new ArrayList<String>();
        for (AdCredentials cr : crList) {
            String adBase = cr.getAdBase();
            String domain = adBase.substring(adBase.indexOf(61) + 1, adBase.indexOf(44));
            domainNames.add(domain);
        }
        return domainNames;
    }

    private WebClient getWebClient() {
        try (WebClient webClient = new WebClient();){
            webClient.getOptions().setUseInsecureSSL(true);
            webClient.getOptions().setRedirectEnabled(true);
            webClient.getOptions().setJavaScriptEnabled(true);
            webClient.getCookieManager().setCookiesEnabled(true);
            webClient.getOptions().setCssEnabled(true);
            webClient.waitForBackgroundJavaScript(10000L);
            webClient.waitForBackgroundJavaScriptStartingBefore(10000L);
            WebClient webClient2 = webClient;
            return webClient2;
        }
    }

    private HtmlPage getPage(WebClient webClient) {
        HtmlPage page = null;
        try {
            Object url = PCHelperConstant.getPropertyFileValueAdfsUrl();
            if (StringUtils.isEmpty((String)url)) {
                url = PREFIX_HTTPS + PCHelperConstant.getPropertyFileValueParacloudUrl() + ":443/springsam/";
            }
            WebRequest wr = new WebRequest(new URL((String)url));
            page = (HtmlPage)webClient.getPage(wr);
        }
        catch (FailingHttpStatusCodeException e) {
            logger.trace(" FailingHttpStatusCodeException  :" + String.valueOf((Object)e));
            logger.error(" FailingHttpStatusCodeException  :" + e.getMessage());
        }
        catch (MalformedURLException e) {
            logger.trace(" MalformedURLException  :" + String.valueOf(e));
            logger.error(" MalformedURLException  :" + e.getMessage());
        }
        catch (IOException e) {
            logger.trace(" IOException  :" + String.valueOf(e));
            logger.error(" IOException  :" + e.getMessage());
        }
        return page;
    }

    public void setPersonDao(PersonDao personDao) {
        this.personDao = personDao;
    }

    public void setComputerDao(ComputerDao computerDao) {
        this.computerDao = computerDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    @Override
    public AdElement getADForId(int cloudId, String id) {
        AdCredentials adCredentials = this.personDao.getADForId(cloudId, new ObjectId(id));
        AdElement adElement = null;
        if (adCredentials != null) {
            adElement = new AdElement();
            BeanUtils.copyProperties((Object)adCredentials, (Object)adElement);
            String decrypted = LdapServiceImpl.decrypt(adCredentials.getAdPassword());
            adElement.setAdPassword(decrypted);
            adElement.setId(adCredentials.getId().toString());
        }
        return adElement;
    }

    @Override
    public void checkAdConnection(int cloudId, HttpServletResponse response) {
        List adcredentials = this.personDao.getAllAdCredentials(cloudId);
        if (CollectionUtils.isEmpty((Collection)adcredentials)) {
            logger.debug("Either AD user not found or ad credentials are empty");
            response.setStatus(406);
        } else {
            boolean checkAdConnection = false;
            for (AdCredentials adCredential : adcredentials) {
                Person userInAD = null;
                try {
                    String userName = adCredential.getUserDn().split("=")[1].split(",")[0];
                    logger.debug("...Ad checking user name ..." + userName);
                    userInAD = this.personDao.getPersonWithoutCn(userName, adCredential);
                }
                catch (Exception e) {
                    logger.debug("..........Exception....");
                }
                if (userInAD == null) continue;
                checkAdConnection = true;
                break;
            }
            if (checkAdConnection) {
                response.setStatus(200);
            } else {
                response.setStatus(404);
            }
        }
    }

    @Override
    public boolean checkAdConnectionPortal(int cloudId, HttpServletResponse response) {
        List adcredentials = this.personDao.getAllAdCredentials(cloudId);
        if (CollectionUtils.isEmpty((Collection)adcredentials)) {
            response.setStatus(406);
        } else {
            for (AdCredentials adCredential : adcredentials) {
                Person userInAD = null;
                try {
                    String userName = adCredential.getUserDn().split("=")[1].split(",")[0];
                    logger.debug("...Ad checking user name ..." + userName);
                    userInAD = this.personDao.getPersonWithoutCn(userName, adCredential);
                }
                catch (BaseException e) {
                    if (e.getMessage().equalsIgnoreCase("Communiation Exception")) {
                        response.setStatus(503);
                        response.setHeader("AD_Unrechable", "true");
                    } else if (e.getMessage().equalsIgnoreCase("Authentication Exception")) {
                        response.setStatus(417);
                        response.setHeader("AD_Unauthorized", "true");
                    }
                }
                catch (Exception e) {
                    response.setStatus(404);
                }
                if (userInAD == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void autoMigrateUsersFormAD(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        List allAdcredentials = this.personDao.getAllAdCredentials(cloudId);
        try {
            boolean result = this.checkADCredentialsHaveGroupName(allAdcredentials);
            if (result) {
                logger.debug("Ad creadentails have no group name don't sync");
                return;
            }
            String cloudName = cloud.getCloudName();
            long countOfPresentUsers = this.userDao.countOfPresentUsers(cloudId, cloudName, true);
            int noOfUsersAllowed = cloud.getNoOfUsersAllowed();
            boolean isSyncEnabled = this.isSyncEnabledInEnv(cloud.getCloudCustomisableDetails());
            boolean isBackupEnabled = this.isBackupEnabledInEnv(cloud.getCloudCustomisableDetails());
            boolean isO365Enabled = this.isO365EnabledInEnv(cloud.getCloudCustomisableDetails());
            long countOfPresentBackupUsers = this.userDao.countOfPresentBackupUsers(cloudId, cloudName, true, true);
            if ((long)cloud.getNoOfBackupUsersAllowed() <= countOfPresentBackupUsers) {
                isBackupEnabled = false;
            }
            if ((long)cloud.getNoOfSyncUsersAllowed() <= this.userDao.countOfPresentSyncUsers(cloudId, cloudName, true)) {
                isSyncEnabled = false;
            }
            if (!isBackupEnabled && !isSyncEnabled) {
                logger.debug("..User limit reached.........");
                return;
            }
            logger.debug(countOfPresentBackupUsers + "...count...." + cloud.getNoOfBackupUsersAllowed());
            logger.debug("..User limit not reached........." + isBackupEnabled + "...." + isSyncEnabled);
            block2: for (AdCredentials adCredentials : allAdcredentials) {
                if (adCredentials == null || StringUtils.isEmpty((String)adCredentials.getAdGroupName())) continue;
                String groupName = adCredentials.getAdGroupName().split("=")[1].split(",")[0];
                logger.debug("...groupName ..." + groupName);
                List adUsers = this.personDao.getAllPersonByGroupName(adCredentials, groupName);
                if (CollectionUtils.isEmpty((Collection)adUsers)) continue;
                for (Person adUser : adUsers) {
                    countOfPresentBackupUsers = this.userDao.countOfPresentBackupUsers(cloudId, cloudName, true, true);
                    if ((long)cloud.getNoOfBackupUsersAllowed() <= countOfPresentBackupUsers) {
                        isBackupEnabled = false;
                    }
                    if ((long)cloud.getNoOfSyncUsersAllowed() <= this.userDao.countOfPresentSyncUsers(cloudId, cloudName, true)) {
                        isSyncEnabled = false;
                    }
                    logger.debug(isBackupEnabled + ".....migration count.............." + countOfPresentBackupUsers + "/" + cloud.getNoOfBackupUsersAllowed());
                    if (!isBackupEnabled && !isSyncEnabled) {
                        logger.debug("..User limit reached.........");
                        continue block2;
                    }
                    if ((long)noOfUsersAllowed >= countOfPresentUsers) {
                        if (adUser != null && adUser.isAccountStatus()) {
                            boolean migrateUserBasedOnProductType = this.migrateUserBasedOnProductType(cloud, isSyncEnabled, isBackupEnabled, isO365Enabled, adUser);
                            if (migrateUserBasedOnProductType) {
                                logger.debug("...User created..." + adUser.getEmailId());
                                ++countOfPresentUsers;
                                continue;
                            }
                            logger.debug("...Failed to create user :" + adUser.getEmailId());
                            continue;
                        }
                        logger.debug("....Ad User is null or acount status is false...");
                        continue;
                    }
                    logger.debug("..User limit reached.........");
                    continue block2;
                }
            }
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    private boolean checkADCredentialsHaveGroupName(List<AdCredentials> adCredentials) {
        boolean results = false;
        for (AdCredentials adCredentail : adCredentials) {
            if (!StringUtils.isEmpty((String)adCredentail.getAdGroupName())) continue;
            logger.debug("In adcredntials " + adCredentail.getAdUrl() + " group name is empty so checkADCredentialsHaveGroupName return true");
            results = true;
            break;
        }
        return results;
    }

    private boolean isSyncEnabledInEnv(List<CloudCustomisableDetails> list) {
        boolean isSyncEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"Sync Enabled".equals(customisableDetails.getName())) continue;
            isSyncEnabled = true;
            break;
        }
        return isSyncEnabled;
    }

    private boolean isBackupEnabledInEnv(List<CloudCustomisableDetails> list) {
        boolean isBackupEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"Backup Enabled".equals(customisableDetails.getName())) continue;
            isBackupEnabled = true;
            break;
        }
        return isBackupEnabled;
    }

    private boolean isO365EnabledInEnv(List<CloudCustomisableDetails> list) {
        boolean isO365Enabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
            isO365Enabled = true;
        }
        return isO365Enabled;
    }

    private boolean migrateUserBasedOnProductType(Cloud cloud, Boolean isSyncEnabled, Boolean isBackupEnabled, boolean isO365Enabled, Person adUser) {
        boolean userMigrated = false;
        LdapUserElement ldapUser = new LdapUserElement();
        try {
            if (adUser != null) {
                ldapUser = this.getLdapUserElement(adUser);
                logger.debug(".....user migration...." + isSyncEnabled + "....." + isBackupEnabled);
                if (isSyncEnabled.booleanValue()) {
                    ldapUser.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
                }
                if (isBackupEnabled.booleanValue()) {
                    ldapUser.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
                }
                if (isO365Enabled) {
                    ldapUser.setDefaultO365Policy(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
                }
                if (isBackupEnabled.booleanValue() && isSyncEnabled.booleanValue()) {
                    if ("sync".equalsIgnoreCase(adUser.getAdGroupType())) {
                        isBackupEnabled = false;
                    }
                    if ("backup".equalsIgnoreCase(adUser.getAdGroupType())) {
                        isSyncEnabled = false;
                    }
                }
                logger.debug(String.valueOf(ldapUser) + ".....user migration1...." + isSyncEnabled + "....." + isBackupEnabled);
                boolean userCreated = this.createUserFromLdap(cloud, ldapUser, isSyncEnabled, isBackupEnabled, isO365Enabled);
                if (userCreated) {
                    userMigrated = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MigrationStatus migrationStatus = new MigrationStatus();
            migrationStatus.setMigratedBy("AUTO");
            migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
            migrationStatus.setMigrated(false);
            migrationStatus.setReason("Failed to get user form AD");
            migrationStatus.setUserName(ldapUser.getUserName());
            migrationStatus.setEmailId(ldapUser.getEmailId());
            this.migrationStatusDao.saveMigrationStatus(cloud.getCloudId(), migrationStatus);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return userMigrated;
    }

    private LdapUserElement getLdapUserElement(Person person) {
        LdapUserElement ldapUserElement = new LdapUserElement();
        ldapUserElement.setUserName(person.getFullName());
        ldapUserElement.setEmailId(person.getEmailId());
        ldapUserElement.setOrganizationUnit(person.getOrganizationalUnit());
        ldapUserElement.setAccountStatus(person.isAccountStatus());
        ldapUserElement.setLocation(person.getLocation());
        ldapUserElement.setDepartment(person.getDepartment());
        ldapUserElement.setDisplayName(person.getDisplayName());
        logger.debug("...display name... " + person.getDisplayName());
        return ldapUserElement;
    }

    private boolean createUserFromLdap(Cloud cloud, LdapUserElement ldapUserElement, boolean isSyncEnabled, boolean isBackupEnabled, boolean isO365Enabled) throws Exception {
        User userFromDB = this.userDao.getUserByUserNameOrEmail(cloud.getCloudId(), ldapUserElement.getUserName());
        if (userFromDB == null) {
            userFromDB = this.userDao.getUserByUserNameOrEmail(cloud.getCloudId(), ldapUserElement.getEmailId());
        }
        if (userFromDB != null && userFromDB.isGuest()) {
            this.userDao.removeUserbyID(cloud.getCloudId(), userFromDB.getUserId().toString());
        }
        boolean userMigrated = false;
        boolean isSoftBlockEnabled = false;
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(1);
        if (cloudProperties != null && cloudProperties.isSoftBlockEnabled()) {
            isSoftBlockEnabled = true;
        }
        try {
            User existingUser = this.userDao.getUserByUserNameOrAADLoginId(cloud.getCloudId(), ldapUserElement.getUserName());
            if (existingUser == null) {
                if (!StringUtils.isEmpty((String)ldapUserElement.getEmailId())) {
                    existingUser = this.userDao.getUserByUserNameOrEmail(cloud.getCloudId(), ldapUserElement.getUserName(), ldapUserElement.getEmailId());
                } else {
                    return false;
                }
            }
            if (existingUser == null) {
                User user = new User();
                UUID uuid = UUID.randomUUID();
                String recoveryKey = String.valueOf(uuid);
                user.setSecurityRecoveryKey(recoveryKey);
                user.setActive(true);
                user.setAdmin(false);
                user.setBackupEnabled(isBackupEnabled);
                user.setSyncEnabled(isSyncEnabled);
                user.setFirstLogin(true);
                user.setShareEnabled(true);
                user.setOnedriveBkpEnabled(isO365Enabled);
                user.setUserName(ldapUserElement.getUserName());
                user.setEmailId(ldapUserElement.getEmailId());
                user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
                user.setDisplayName(ldapUserElement.getDisplayName());
                user.setMigratedBy("AUTO");
                user.setLocalUser(false);
                user.setLocation(ldapUserElement.getLocation());
                user.setDepartment(ldapUserElement.getDepartment());
                user.setAccountStatus(ldapUserElement.isAccountStatus());
                user.setUserNameLowerCase(ldapUserElement.getUserName().toLowerCase());
                String googleSecretKey = this.getGoogleSecurityKey();
                logger.debug("googleSecretKey for AAD ....." + googleSecretKey);
                user.setGoogleSecretKey(googleSecretKey);
                if (!StringUtils.isEmpty((String)ldapUserElement.getDefaultPolicy())) {
                    user.setPolicyName(ldapUserElement.getDefaultPolicy());
                }
                if (!StringUtils.isEmpty((String)ldapUserElement.getDefaultSyncPolicy())) {
                    user.setSyncPolicyName(ldapUserElement.getDefaultSyncPolicy());
                }
                if (!StringUtils.isEmpty((String)ldapUserElement.getDefaultO365Policy())) {
                    user.setOneDrivePolicyName(ldapUserElement.getDefaultO365Policy());
                    user.setNewOdbUser(true);
                }
                this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), user);
                userMigrated = true;
                MigrationStatus migrationStatus = new MigrationStatus();
                migrationStatus.setMigratedBy("AUTO");
                migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
                migrationStatus.setMigrated(true);
                migrationStatus.setUserName(user.getUserName());
                migrationStatus.setEmailId(user.getEmailId());
                this.migrationStatusDao.saveMigrationStatus(cloud.getCloudId(), migrationStatus);
                this.saveStatisticToDatabase(cloud, "migrated", "AUTO", user.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
            } else {
                existingUser = this.userDao.getUserByUserNameOrAADLoginId(cloud.getCloudId(), ldapUserElement.getUserName());
                if (existingUser != null) {
                    logger.debug("User already present as status :" + existingUser.isActive() + " and Ad status :" + ldapUserElement.isAccountStatus());
                    if (ldapUserElement.isAccountStatus()) {
                        if (!existingUser.isActive()) {
                            logger.debug("In AD user is active so change the status");
                            if (isSoftBlockEnabled) {
                                existingUser.setActive(true);
                                existingUser.setSoftBlockEnabled(false);
                                this.userDao.updateUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                            } else {
                                this.userDao.blockUnblockUser(cloud.getCloudId(), existingUser.getUserName(), true);
                            }
                            this.saveStatisticToDatabase(cloud, "unblocked", "AUTO", existingUser.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
                            userMigrated = true;
                        } else if (isSoftBlockEnabled) {
                            existingUser.setActive(true);
                            existingUser.setSoftBlockEnabled(false);
                            this.userDao.updateUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                        }
                    } else if (existingUser.isActive()) {
                        logger.debug("In AD user is in active so change the status");
                        if (isSoftBlockEnabled) {
                            if (!existingUser.isSoftBlockEnabled()) {
                                existingUser.setSoftBlockEnabled(true);
                                existingUser.setSoftBlockedTime(System.currentTimeMillis());
                                this.userDao.updateUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                            }
                        } else {
                            this.userDao.blockUnblockUser(cloud.getCloudId(), existingUser.getUserName(), true);
                        }
                        this.saveAuditHistory(cloud, existingUser);
                    }
                } else {
                    logger.debug("email id already exists........");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" Exception  :..........." + String.valueOf(e));
            logger.debug(" Exception  :..........." + e.getMessage());
            throw new Exception(e);
        }
        return userMigrated;
    }

    private void saveStatisticToDatabase(Cloud cloud, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloud.getCloudId(), cloud.getCloudName(), audit);
    }

    private void saveAuditHistory(Cloud cloud, User user) {
        this.saveStatisticToDatabase(cloud, "Blocked", "AUTO", user.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
        List<Device> blockedDevices = this.blockUnblockDevicebyUserName(cloud.getCloudId(), cloud.getCloudName(), user.getUserName(), true);
        if (blockedDevices != null) {
            for (Device device : blockedDevices) {
                this.saveStatisticToDatabase(cloud, "Blocked Asset", "AUTO", device.getDeviceName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
            }
        }
    }

    private List<Device> blockUnblockDevicebyUserName(int cloudId, String cloudName, String userName, boolean toBlock) {
        List devices = new ArrayList();
        ArrayList<Device> blockedDevice = new ArrayList<Device>();
        devices = this.deviceDao.getDeviceByUserName(cloudId, userName);
        if (!CollectionUtils.isEmpty(devices)) {
            for (Device device : devices) {
                if (device.isBlocked()) continue;
                this.deviceDao.blockUnblockDevice(cloudId, cloudName, device, toBlock);
                this.deviceDao.updateDeviceStatusInOverview(cloudId, device.getDeviceUUID(), toBlock);
                if (toBlock) {
                    User user = this.userDao.getUserByName(cloudId, device.getUserName());
                    this.authorizationDao.deleteAuthTokenByUserAndUniqueID(cloudId, user, device.getDeviceUUID());
                }
                blockedDevice.add(device);
            }
        }
        return blockedDevice;
    }

    @Override
    public Person getPersonByUserName(String userName) {
        if (PCHelperConstant.isAzureVM()) {
            return this.getPersonFromAzure(userName);
        }
        return this.personDao.getPersonByUserName(userName);
    }

    @Override
    public Person getPersonByUserNameForSync(String userName) {
        if (PCHelperConstant.isAzureVM()) {
            return this.getPersonFromAzure(userName);
        }
        return this.personDao.getPersonByUserNameForSync(userName);
    }

    private String getGoogleSecurityKey() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        Base32 base32 = new Base32();
        String googleSecretKey = base32.encodeToString(bytes);
        return googleSecretKey;
    }
}

