/*
 * Decompiled with CFR 0.152.
 */
package com.pg.util;

import com.pg.helper.constant.GeneralHelperConstant;
import org.apache.commons.lang.StringUtils;

public final class PathConversionHelper {
    private PathConversionHelper() {
    }

    public static String getServerCompatiblePath(String path, boolean isAndroidDevice) {
        String devicePathSeparator;
        String validDevicePath = path;
        if (!isAndroidDevice && !(devicePathSeparator = "\\").equals(GeneralHelperConstant.CLOUD_PATH_SEPARATOR)) {
            validDevicePath = validDevicePath.replace(devicePathSeparator, "/");
        }
        if ((validDevicePath = validDevicePath.replace("//", "/")).endsWith("/")) {
            int lastIndex = validDevicePath.lastIndexOf(47);
            validDevicePath = validDevicePath.substring(0, lastIndex);
        }
        return validDevicePath;
    }

    public static String getDeviceCompatiblePath(String path, boolean isAndroidDevice) {
        String validDevicePath = path;
        if (!StringUtils.isEmpty((String)validDevicePath) && !isAndroidDevice) {
            validDevicePath = validDevicePath.replace("/", "\\");
        }
        return validDevicePath;
    }

    public static String getLowercaseConvertedPath(String path) {
        String validDevicePath = path;
        char collon = ':';
        int compareVal = Character.compare(path.charAt(1), collon);
        if (compareVal == 0) {
            if (path.length() > 3) {
                String pathWithoutDrive = path.substring(3);
                String driveLetterFrompath = path.substring(0, 3);
                pathWithoutDrive = pathWithoutDrive.toLowerCase();
                driveLetterFrompath = driveLetterFrompath.toUpperCase();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(driveLetterFrompath);
                stringBuilder.append(pathWithoutDrive);
                validDevicePath = stringBuilder.toString();
            } else {
                validDevicePath = path.toUpperCase();
            }
        }
        return validDevicePath;
    }
}

