/*
 * Decompiled with CFR 0.152.
 */
package com.pg.util;

import com.parablu.helper.clamavhelper.CheckClamAV;
import com.pg.exception.ParacloudBackupException;
import com.pg.helper.utils.MD5Generator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    private static Logger logger = LogManager.getLogger(FileUtils.class);
    public static final int BUFF_SIZE = 8192;
    public static final int RADIX = 16;
    private static final String PART_06_D_S = "part%06d.%s";
    private static final String PART_09_D_S = "part%09d.%s";

    private FileUtils() {
    }

    public static Map<String, String> splitAndWrite(String sourceFilePath, String destinationPath, String userName) throws IOException, NoSuchAlgorithmException {
        int maxChunkSize = 0x500000;
        File willBeRead = new File(sourceFilePath);
        HashMap<String, String> md5AndFileValueMap = new HashMap<String, String>();
        if (!willBeRead.exists()) {
            return md5AndFileValueMap;
        }
        long fileSize = willBeRead.length();
        int numberOfChunks = 0;
        byte[] temporary = null;
        long totalBytesRead = 0L;
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(willBeRead));){
            while (totalBytesRead < fileSize) {
                int bytesRead;
                String partName = Integer.toString(numberOfChunks);
                long bytesRemaining = fileSize - totalBytesRead;
                if (bytesRemaining < (long)maxChunkSize) {
                    maxChunkSize = Integer.parseInt(Long.toString(bytesRemaining));
                    logger.debug("CHUNK SIZE: " + maxChunkSize);
                }
                if ((bytesRead = ((InputStream)inStream).read(temporary = new byte[maxChunkSize], 0, maxChunkSize)) > 0) {
                    totalBytesRead += (long)bytesRead;
                    ++numberOfChunks;
                }
                String tempFileName = destinationPath + partName + willBeRead.getName() + userName;
                logger.trace(willBeRead.getName() + " NEW Temp name .................. " + tempFileName);
                FileUtils.write(temporary, tempFileName);
                File tempFile = new File(tempFileName);
                String tempFileMd5 = FileUtils.getMD5(tempFile);
                String newName = String.format(PART_06_D_S, numberOfChunks, tempFileMd5);
                File renameFile = new File(destinationPath + newName);
                tempFile.renameTo(renameFile);
                md5AndFileValueMap.put(tempFileMd5, newName);
            }
        }
        return md5AndFileValueMap;
    }

    public static Map<String, String> splitAndWrite(int[] chunkDetails, String sourceFilePath, String destinationPath, String userName) throws IOException, NoSuchAlgorithmException {
        int maxChunkSize = chunkDetails[0] * 1000 * 1000;
        int pftSize = chunkDetails[1] * 1024 * 1024;
        boolean isCompressionEnabled = chunkDetails[2] == 1;
        File willBeRead = new File(sourceFilePath);
        HashMap<String, String> chunkCheckSumMap = new HashMap<String, String>();
        if (!willBeRead.exists()) {
            return chunkCheckSumMap;
        }
        long fileSize = willBeRead.length();
        int numberOfChunks = 0;
        byte[] temporary = null;
        long totalBytesRead = 0L;
        boolean isFileInfected = false;
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(willBeRead));){
            if ((long)pftSize < fileSize) {
                while (totalBytesRead < fileSize) {
                    int bytesRead;
                    String partName = Integer.toString(numberOfChunks);
                    long bytesRemaining = fileSize - totalBytesRead;
                    if (bytesRemaining < (long)maxChunkSize) {
                        maxChunkSize = Integer.parseInt(Long.toString(bytesRemaining));
                        logger.debug("CHUNK SIZE: " + maxChunkSize);
                    }
                    if ((bytesRead = ((InputStream)inStream).read(temporary = new byte[maxChunkSize], 0, maxChunkSize)) > 0) {
                        totalBytesRead += (long)bytesRead;
                        ++numberOfChunks;
                    }
                    String tempFileName = destinationPath + partName + willBeRead.getName() + userName;
                    logger.trace(willBeRead.getName() + " NEW Temp name .................. " + tempFileName);
                    FileUtils.write(temporary, tempFileName);
                    File tempFile = new File(tempFileName);
                    String tempFileMd5 = FileUtils.generateMD5ForByteArray(temporary, isCompressionEnabled, maxChunkSize);
                    String newName = String.format(PART_09_D_S, numberOfChunks, tempFileMd5);
                    String destPath = destinationPath + newName;
                    String path = destinationPath + newName;
                    String newFileNameSuffix = "";
                    if (willBeRead.exists()) {
                        int dedupCount = 1;
                        while (new File(destPath).exists()) {
                            destPath = destinationPath + newName;
                            destPath = path + "_" + dedupCount;
                            newFileNameSuffix = String.valueOf(dedupCount);
                            ++dedupCount;
                        }
                        if (!StringUtils.isEmpty((String)newFileNameSuffix)) {
                            newName = newName + "_" + newFileNameSuffix;
                        }
                        logger.debug("....newName..." + newName);
                        File destFile = new File(destPath);
                        org.apache.commons.io.FileUtils.copyFile((File)tempFile, (File)destFile);
                        tempFile.delete();
                    }
                    logger.debug(tempFileMd5 + "....values......." + newName);
                    chunkCheckSumMap.put(newName, tempFileMd5);
                    logger.debug("....size........" + chunkCheckSumMap.size());
                }
                if (willBeRead.exists()) {
                    logger.debug("deleting file after splittting.." + willBeRead.getAbsolutePath());
                    willBeRead.delete();
                }
            } else {
                logger.debug("********md5 checksum lesser file *********" + destinationPath);
                String tempFileMd5 = MD5Generator.generateMD5OfFile(willBeRead);
                logger.debug(tempFileMd5 + "********md5 checksum lesser delete file *********" + destinationPath);
                String newName = tempFileMd5;
                String destPath = destinationPath + newName;
                String path = destinationPath + newName;
                String newFileNameSuffix = "";
                if (willBeRead.exists()) {
                    int dedupCount = 1;
                    while (new File(destPath).exists()) {
                        destPath = destinationPath + newName;
                        destPath = path + "_" + dedupCount;
                        newFileNameSuffix = String.valueOf(dedupCount);
                        ++dedupCount;
                    }
                    if (!StringUtils.isEmpty((String)newFileNameSuffix)) {
                        newName = newName + "_" + newFileNameSuffix;
                    }
                    logger.debug("....newName..." + newName);
                    File destFile = new File(destPath);
                    byte[] fileBytes = FileUtils.getBytesFromFile(willBeRead);
                    org.apache.commons.io.FileUtils.copyFile((File)willBeRead, (File)destFile);
                    willBeRead.delete();
                }
                chunkCheckSumMap.put(newName, tempFileMd5);
            }
        }
        return chunkCheckSumMap;
    }

    public static Map<String, String> splitAndWrite1(String sourceFilePath, int chunkSize, String destinationPath) throws IOException, NoSuchAlgorithmException {
        File willBeRead = new File(sourceFilePath);
        long fileSize = willBeRead.length();
        HashMap<String, String> md5AndFileValueMap = new HashMap<String, String>();
        int numberOfChunks = 0;
        byte[] temporary = null;
        long chunkSizeVal = chunkSize;
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(willBeRead));){
            long totalBytesRead = 0L;
            while (totalBytesRead < fileSize) {
                int bytesRead;
                String partName = Integer.toString(numberOfChunks);
                long bytesRemaining = fileSize - totalBytesRead;
                if (bytesRemaining < chunkSizeVal) {
                    chunkSizeVal = bytesRemaining;
                    logger.debug("maxChunkSize: " + chunkSizeVal);
                }
                if ((bytesRead = ((InputStream)inStream).read(temporary = new byte[chunkSize], 0, chunkSize)) > 0) {
                    totalBytesRead += (long)bytesRead;
                    ++numberOfChunks;
                }
                String destinationPathWithSlash = destinationPath + "/";
                FileUtils.write(temporary, destinationPathWithSlash + partName);
                File tempFile = new File(destinationPathWithSlash + partName);
                String tempFileMd5 = FileUtils.getMD5(tempFile);
                String newName = String.format(PART_06_D_S, numberOfChunks, tempFileMd5);
                File renameFile = new File(destinationPathWithSlash + newName);
                tempFile.renameTo(renameFile);
                md5AndFileValueMap.put(tempFileMd5, newName);
                logger.debug("Total Bytes Read: " + totalBytesRead);
            }
        }
        catch (Exception ex) {
            logger.trace((Object)ex);
            logger.error(" Exception while trying to splitAndWrite " + ex);
        }
        return md5AndFileValueMap;
    }

    public static void write(byte[] dataByteArray, String destinationFileName) {
        try {
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destinationFileName));
            ((OutputStream)output).write(dataByteArray);
            ((OutputStream)output).close();
        }
        catch (Exception e) {
            logger.error("  ********************EXCEPTION FAILED while writing of chunk file ***************** " + e);
        }
    }

    public static void merge(List<String> nameList, String chunkFilePath, String destinationPath, boolean isCompressed) {
        int fileNumber = nameList.size();
        logger.debug(" NUMBER  OF FILES " + fileNumber);
        try {
            Collections.sort(nameList);
            FileOutputStream fos = new FileOutputStream(destinationPath, true);
            for (String name : nameList) {
                logger.debug(isCompressed + " PAth   " + chunkFilePath + "/" + name);
                File file = new File(chunkFilePath + "/" + name);
                FileInputStream fis = new FileInputStream(file);
                FilterInputStream fif = new BufferedInputStream(fis);
                if (isCompressed) {
                    fif = new GZIPInputStream(fis);
                }
                byte[] fileBytes = new byte[(int)file.length()];
                ((InputStream)fif).read(fileBytes, 0, (int)file.length());
                fos.write(fileBytes);
                fos.flush();
                ((InputStream)fif).close();
            }
            fos.close();
        }
        catch (Exception e) {
            logger.error("Merge execution failed...!" + e);
        }
        logger.debug("Merge was executed successfully.!");
    }

    public static void merge(List<String> nameList, String chunkFilePath, String destinationPath) {
        int fileNumber = nameList.size();
        logger.debug(" NUMBER  OF FILES " + fileNumber);
        try {
            Collections.sort(nameList);
            FileOutputStream fos = new FileOutputStream(destinationPath, true);
            for (String name : nameList) {
                logger.debug(" PAth   " + chunkFilePath + "/" + name);
                File file = new File(chunkFilePath + "/" + name);
                FileInputStream fis = new FileInputStream(file);
                byte[] fileBytes = new byte[(int)file.length()];
                fis.read(fileBytes, 0, (int)file.length());
                fos.write(fileBytes);
                fos.flush();
                fis.close();
            }
            fos.close();
        }
        catch (Exception e) {
            logger.error("Merge execution failed...!" + e);
        }
        logger.debug("Merge was executed successfully.!");
    }

    public static String generateMD5ForByteArray(byte[] bytes, boolean isCompressionEnabled, int maxChunkSize) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream(maxChunkSize);
        try {
            OutputStream gzOutputStream = isCompressionEnabled ? new GZIPOutputStream(byteOutputStream) : byteOutputStream;
            gzOutputStream.write(bytes);
            gzOutputStream.close();
        }
        catch (IOException e) {
            logger.error("Exception while getting stream : ", (Throwable)e);
        }
        byte[] actualData = byteOutputStream.toByteArray();
        String md5 = null;
        try {
            md5 = new String(Hex.encodeHex((byte[])DigestUtils.md5((InputStream)new ByteArrayInputStream(actualData))));
        }
        catch (Exception exception) {
            logger.error("execption while genrating MD5 for stream", (Throwable)exception);
        }
        return md5;
    }

    public static String generateMD5OfFile(File file) {
        String md5 = null;
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
            md5 = new String(Hex.encodeHex((byte[])DigestUtils.md5((InputStream)input)));
        }
        catch (Exception exception) {
            logger.error("Exception : ", (Throwable)exception);
        }
        return md5;
    }

    public static String getMD5(File f) throws NoSuchAlgorithmException, FileNotFoundException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String output = "";
        byte[] buffer = new byte[8192];
        int read = 0;
        try (FileInputStream is = new FileInputStream(f);){
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            output = bigInt.toString(16);
        }
        catch (IOException e) {
            logger.error("IOException trying to get md5" + e);
        }
        return output;
    }

    public static List<String> getExistingFileNamesForGivenPath(String path) {
        File[] files;
        ArrayList<String> results = new ArrayList<String>();
        File intermediateFolder = new File(path);
        if (!intermediateFolder.exists() && !intermediateFolder.mkdirs()) {
            throw new ParacloudBackupException(intermediateFolder + " folder  Folder Not Created", 500);
        }
        for (File file : files = new File(path).listFiles()) {
            if (!file.isFile()) continue;
            results.add(file.getName());
        }
        return results;
    }

    public static byte[] getBytesFromFile(File file) {
        FileInputStream fis = null;
        byte[] bytesArray = null;
        try {
            bytesArray = new byte[(int)file.length()];
            fis = new FileInputStream(file);
            fis.read(bytesArray);
            fis.close();
        }
        catch (FileNotFoundException e) {
            logger.error("error to get bytes from file.." + e.getMessage());
        }
        catch (IOException e) {
            logger.error("error to get bytes from file1.." + e.getMessage());
        }
        return bytesArray;
    }

    private static boolean scanFilecontent(byte[] temporary) {
        boolean ifFileInfected = false;
        ifFileInfected = CheckClamAV.isFileInfected(temporary);
        if (ifFileInfected) {
            logger.debug("File is infected...");
        } else {
            logger.debug("File is  not infectedinfected...");
        }
        return ifFileInfected;
    }
}

