/*
 * Decompiled with CFR 0.152.
 */
package com.pg.helper.utils;

import com.pg.helper.utils.TimeoutMemoryStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;

public class MemoryStore {
    private static HashMap<String, Object> mem;

    private MemoryStore() {
    }

    public static String add(String key, Object obj) {
        return MemoryStore.add(key, obj, 0L);
    }

    public static String add(String key, Object obj, long timeout) {
        if (mem == null) {
            MemoryStore.erase();
        }
        String gen = StringUtils.isEmpty((String)key) ? MemoryStore.generate(16) : key;
        while (mem.containsKey(gen)) {
            gen = MemoryStore.generate(16);
        }
        mem.put(gen, obj);
        if (timeout > 0L) {
            new Timer().schedule((TimerTask)new TimeoutMemoryStore(gen), timeout);
        }
        return gen;
    }

    public static Object get(String key) {
        if (mem == null) {
            return null;
        }
        if (mem.containsKey(key)) {
            return mem.get(key);
        }
        return null;
    }

    public static boolean delete(String key) {
        if (mem == null) {
            mem = new HashMap();
            return true;
        }
        if (mem.containsKey(key)) {
            mem.remove(key);
            return true;
        }
        return false;
    }

    public static List<Object> values() {
        if (mem == null) {
            return new ArrayList<Object>();
        }
        return new ArrayList<Object>(mem.values());
    }

    public static List<Object> keys() {
        if (mem == null) {
            return new ArrayList<Object>();
        }
        return new ArrayList<Object>(mem.keySet());
    }

    public static void erase() {
        mem = new HashMap();
    }

    private static String generate(int length) {
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        int charLength = chars.length();
        StringBuilder pass = new StringBuilder("");
        for (int x = 0; x < length; ++x) {
            Random randomno = new Random();
            int i = randomno.nextInt(charLength);
            pass.append(Integer.toString(i));
        }
        return pass.toString();
    }
}

