/*
 * Decompiled with CFR 0.152.
 */
package com.pg.helper.constant;

import com.pg.helper.constant.GeneralHelperConstant;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public final class PCHelperConstant {
    private static Logger logger = LogManager.getLogger(PCHelperConstant.class);
    public static final String GRAPH_DRIVES_BASE_URL = "https://graph.microsoft.com/v1.0/drives";
    public static String propertyKeyDBHost = "db_host";
    public static String propertyKeyDBPort = "db_port";
    public static String propertyKeyDBHost1 = "db_host1";
    public static String propertyKeyDBPort1 = "db_port1";
    public static String propertyKeyDBHost2 = "db_host2";
    public static String propertyKeyDBPort2 = "db_port2";
    public static String propertyKeyDBHost3 = "db_host3";
    public static String propertyKeyDBPort3 = "db_port3";
    private static final String PROPERTY_FILE_SECONDARY_APPENDED_PRIMARY_VALUE_DEFAULT_SYNC_DOWNLOAD_PATH = "/sync-download/";
    public static final String MEDIA_BASE_FOLDER_NAME = "media";
    public static final String BACKUP_BASE_FOLDER_NAME = "backup";
    public static final String UPLOAD_BASE_FOLDER_NAME = "upload";
    private static String PROPERTY_FILE_VALUE_PARACLOUD_MOUNT_POINT;
    public static final String ADMIN_STOPPED_QUEUE_ERROR_CODE = "1310";
    public static final String ADMIN_STOPPED_SCAN_ERROR_CODE = "1311";
    private static String PROPERTY_MS_CLIENT_ID;
    private static String PROPERTY_MS_CLIENT_SECRET;
    private static String PROPERTY_MS_TENANTID;
    private static String PROPERTY_MS_SHARPOINT_URL;
    private static String PROPERTY_SEARCH_EXT_EXCLUSION;
    private static String ODBDownloadPriorityTimeStamp;
    private static boolean paracloud;
    private static String moveFileFromBkpToLocalInterval;
    private static String paracloudUrl;
    public static final String PARACLOUD_URL = "paracloudUrl";
    private static final String PROPERTY_FILE_KEY_COUCH_DB_PWD = "couchpwd";
    private static final String PROPERTY_FILE_KEY_AMAZONS3_STORAGE_ACCESS_KEY = "amazonS3AccessKey";
    private static final String PROPERTY_FILE_KEY_AMAZONS3_STORAGE_SECRET_KEY = "amazonS3SecretKey";
    private static final String PROPERTY_FILE_KEY_AMAZONS3_STORAGE_BUCKET_NAME = "amazonS3BucketName";
    public static final String OFFICE_THREADS = "officeDownloadThreads";
    public static final String PROPERTY_FILE_KEY_ENVIRONMENT = "environment";
    private static final String PROPERTY_FILE_KEY_UPLOAD_TO_LOCAL_FS = "fieUploadToLocalFS";
    private static final String PROPERTY_FILE_KEY_SSL_AUTH_ENABLED = "sslAuthEnabled";
    public static final String ENCRYPTION_ENABLED = "encryptionEnabled";
    public static final String SYNC_FTP_HOST = "ftpHost";
    public static final String SYNC_FTP_HOST_USER = "ftpUser";
    public static final String SYNC_FTP_HOST_PWD = "ftpPwd";
    public static final String QUERY_LIMIT_VALUE = "queryLimit";
    public static final String UPLOAD_FILE_SIZE_LIMIT_VALUE = "uploadFileSizeLimitInMB";
    public static final String ODB_FREQUENCY_CALL_LIMIT_VALUE = "odbFrequencyCallValue";
    private static final String PROPERTY_FILE_KEY_FAILED_JOB_THREAD = "noOfFailedJobThreads";
    public static final String RESTORE_QUERY_LIMIT_VALUE = "resoreQueryLimit";
    public static final String THREAD_LIMIT = "noOfThreads";
    public static final String HTTP_ENABLED = "httpEnabled";
    public static final String JOB_THREAD_LIMIT = "noOfJobThreads";
    public static final String SYNC_UPLOAD_PATH = "syncUploadPath";
    private static final String PROPERTY_FILE_KEY_BKP_LOCAL_STORAGE_PATH = "bkpLocalStoragePath";
    public static final String SYNC_FTP_ENABLED = "syncFtpEnabled";
    public static final String LOCAL_STORAGE_ENABLED = "localStorageEnabled";
    public static final String BACKUP_COL_QUERY_REQ = "bkpColQueryRequired";
    public static final String CHUNK_COL_QUERY_REQ = "chunkColQueryRequired";
    public static final String PG_OVERLOAD_LIMIT = "pgOverloadLimit";
    public static final String PG_O365_THREAD_LIMIT = "o365BkpThreadsLimit";
    public static final String PG_OVERLOAD_LIMIT_FREQ_CHECK = "pgOverLoadLimitFreqCheck";
    public static final String GRAPH_TIMEOUT_IN_MINS = "graphTimeoutInMins";
    public static final String PG_OVERLOAD_INACTIVITY_PERIOD = "pgOverLoadInactivityPeriod";
    private static final String PROPERTY_FILE_KEY_REPLICA_SAFE_LIMIT = "writeConcernLimit";
    private static final String PROPERTY_FILE_KEY_READ_PREFERENCE = "mongoReadPreference";
    private static final String PROPERTY_FILE_KEY_PG_WRITE_DELAY_LIMIT = "pgWriteDelayLimit";
    public static final String MAX_RETRY_CHUNK_UPDATE = "chunkUpdateMaxRetry";
    private static final String PROPERTY_FILE_KEY_REPORT_DISPLAY_RECORDS = "reportRows";
    public static final String PROXY_PORT = "proxyPort";
    public static final String PROXY_USERNAME = "proxyUserName";
    public static final String PROXY_PASSWORD = "proxyPassword";
    public static final String PROXY_HOST = "proxyHost";
    private static final String PROPERTY_FILE_KEY_EXPIRY_DELETE_SYNC_FILES_LIMIT = "expiryDaysForDeletingSyncFiles";
    private static final String PROPERTY_FILE_KEY_MNT_TEMP_CHUNK_PATH = "mntChunkPath";
    public static final String MEMCACHED_URL = "memcachedUri";
    public static final String MEMCACHED_PORT = "memchacedPort";
    public static final String MEMCACHED_TIMEOUT = "memcahedTimeOut";
    public static final String CHUNK_TOTAL_BUCKETS = "chunkTotalBuckets";
    private static final String PROPERTY_FILE_KEY_LOAD_BALANCER_IP = "loadBalancerIp";
    private static final String PROPERTY_FILE_KEY_BKP_FREQ_IN_DAYS = "daysToWaitForNextBackup";
    public static final String DELETE_BKPTBL_WHEN_CHUNKS_NOT_FOUND = "deleteBkpTblWhenChnkNotFound";
    public static final String UPDATEPGNAME_WHEN_CHUNK_NOT_FOUND_MULTIPGENV = "updateGatewayWhenChunkNotFound";
    public static final String GATEWAYNAME = "gatewayName";
    public static final String RETRY_FOLDER_VAL = "odbRetryFolderVal";
    public static final String ODB_DECOR = "odbUserAgentVal";
    public static final String PARACLOUD = "paracloud";
    public static final String PG_CRAWL_THREADS_LIMIT = "crawlThreadsLimit";
    private static String officeThreadsValue;
    private static String memcashedUrl;
    private static String memcashedPort;
    private static String memcachedTimeout;
    private static final String PROPERTY_FILE_VALUE_REPORT_DISPLAY_RECORDS;
    private static final String PROPERTY_FILE_SECONDARY_APPENDED_VALUE_PARABLU_FOLDER_BASE_PATH = "/f/";
    public static final String ODB_DOWNLOAD_PRIORITY_TIMESTAMP = "ODBDownloadPriorityTimeStamp";
    private static String syncFtpHost;
    private static String syncFtpHostUser;
    public static String syncFtpHostPwd;
    private static String couchDBUserName;
    private static final String PROPERTY_FILE_VALUE_COUCH_DB_PWD;
    private static final String PROPERTY_FILE_VALUE_AMAZONS3_STORAGE_ACCESS_KEY;
    private static final String PROPERTY_FILE_VALUE_AMAZONS3_STORAGE_SECRET_KEY;
    private static final String PROPERTY_FILE_VALUE_AMAZONS3_STORAGE_BUCKET_NAME;
    private static final String PROPERTY_FILE_VALUE_ENVIRONMENT;
    private static int skipOverLoadCount;
    private static int uploadLocalChunkLimit;
    private static String queryLimit;
    private static String uploadFileSizeLimitInMB;
    private static String odbFrequencyCallLimit;
    private static String retryFolderVal;
    private static final String PROPERTY_FILE_VALUE_FAILED_JOB_THREAD_LIMIT;
    private static String restoreQueryLimit;
    private static final String PROPERTY_FILE_VALUE_UPLOAD_TO_LOCAL_FS;
    private static String delayInUploadInSec;
    private static String delayIn429CaseInSec;
    private static String countOfContinuous429;
    private static String addn429WaitMultiplier;
    private static String countOfODBFiles;
    public static final String DELAY_IN_UPLOAD = "delayInUploadInSec";
    public static final String DELAY_IN_429_CASE = "delayIn429CaseInSec";
    public static final String COUNT_OF_CONTINUOUS_429 = "countOfContinuous429";
    public static final String COUNT_OF_ODB_FILES = "countOfODBFiles";
    public static final String ADD_429_WAIT_MULTIPLIER = "addn429WaitMultiplier";
    public static final String SKIP_UPLOAD_COUNT = "skipUploadCount";
    private static String PROPERTY_FILE_VALUE_SSL_AUTH_ENABLED;
    private static String encryptionEnabled;
    private static String noOfThreads;
    private static String graphAppName;
    private static String noOfO365BkpThreads;
    private static String jobThreadLimit;
    private static String syncUploadPath;
    private static String syncFtpEnabled;
    private static String localStorageEnabled;
    private static String backupColQueryReq;
    private static String chunkColQueryReq;
    private static String chunkTotalBuckets;
    private static final String PROPERTY_FILE_VALUE_BKP_FREQ_IN_DAYS;
    public static String pgOverloadLimit;
    public static String pgOverLoadLimitFreqCheck;
    public static String graphTimeoutInMins;
    private static String pgOverloadInActivityPeriodPgOverload;
    private static final String PROPERTY_FILE_VALUE_REPLICA_SAFE_LIMIT;
    private static final String PROPERTY_FILE_VALUE_PG_WRITE_DELAY_LIMIT;
    private static String proxyPort;
    private static String maxRetryChunkupdate;
    private static String proxyUserName;
    private static String proxyPassword;
    private static String proxyHost;
    private static final String PROPERTY_FILE_VALUE_READ_PREFERENCE;
    private static String uploadOdServiceAcc;
    private static final String PROPERTY_FILE_VALUE_BKP_LOCAL_STORAGE_PATH;
    private static final String PROPERTY_FILE_VALUE_EXPIRY_DELETE_SYNC_FILES_LIMIT;
    private static final String PROPERTY_FILE_VALUE_MNT_TEMP_CHUNK_PATH;
    private static String PROPERTY_FILE_VALUE_LOAD_BALANCER_IP;
    public static final String STOP_JOBS = "stopJobsEnabled";
    private static String stopJobsEnabled;
    private static boolean isMuxedEnabled;
    private static boolean isHttpEnabled;
    public static String crawlThreadsLimit;
    public static String propertyValueDBHost;
    public static String propertyValueDBPort;
    public static String propertyValueDBHost1;
    public static String propertyValueDBPort1;
    public static String propertyValueDBHost2;
    public static String propertyValueDBPort2;
    public static String propertyValueDBHost3;
    public static String propertyValueDBPort3;
    private static String componentName;
    private static String deleteBkptblWnenChunksNotFound;
    private static String updatePgNameWhenChunkNotFoundMultiPgenv;
    private static String gateWayName;
    private static String odbDecor;
    public static final String PROPERTY_FILE_SECONDARY_APPENDED_VALUE_PARABLU_THUMBNAILS_BASE_PATH = "/t/";
    public static final String PROPERTY_FILE_SECONDARY_APPENDED_VALUE_PARABLU_BACKUP_FOLDER_BASE_PATH = "/backup/";
    private static final String PROPERTY_FILE_SECONDARY_APPENDED_PRIMARY_VALUE_DEFAULT_UPLOAD_PATH = "/upload/";
    private static final String PROPERTY_FILE_SECONDARY_APPENDED_PRIMARY_VALUE_DEFAULT_SYNC_UPLOAD_PATH = "/sync-upload/";
    public static final String PROPERTY_FILE_SECONDARY_APPENDED_PRIMARY_VALUE_DEFAULT_EXTERNAL_DOWNLOAD_PATH = "/extdownload/";
    private static final String PROPERTY_FILE_SIEM_PATH = "/siem/";
    private static final String PERSONAL_URL = "/personal/";
    public static Map<String, Boolean> jobConfig;
    public static final String MOVE_FILES_FROM_BKP_TO_LOCAL_INTERVAL = "moveFileFromBkpToLocalInterval";
    public static boolean brevityLogging;
    public static boolean globalCheckForLocalStorage;
    public static String oneDriveBackupType;
    public static int clamAvScanDelayInSec;
    public static final String ACTION_FILE_UPLOAD = "uploaded";
    private static String c2cGraphClientId;
    private static String c2cGraphClientSecret;
    private static String c2cGraphTenantId;
    public static int numOfChunksToCheckPgOverloadLimit;
    public static boolean blobFusePresent;
    public static long lastUpdatedTimestamp;
    public static boolean blobFuseEnabled;
    public static final String NO_OF_THREADS_CONTENTCHUNK = "numOfThreadsToUseForContentChunkFile";
    public static String numOfThreadsToUseForContentChunkFile;
    public static int numOfThreadsToUseForPSTCreation;
    private static int delayInMillisecForChunksDuringUpload;
    public static final String NO_OF_THREADS_PSTCREATION = "numOfThreadsToUseForPSTCreation";
    public static final String DELAY_IN_MILLISEC_FOR_CHUNKS_DURING_UPLOAD = "delayInMillisecForChunksDuringUpload";
    public static int numOfSecsToWaitBeforeSEndDummyContentToAgent;
    public static final String NO_OF_SECS_WAIT_SEND_DUMMY_CONTENT_AGENT = "numOfSecsToWaitBeforeSEndDummyContentToAgent";
    public static boolean migratedTenant;
    private static String proxyParacloudUrl;
    public static final String PROXY_PARACLOUD_URL = "proxyParacloudUrl";
    public static int numOfHitsToDBForContentChunkCheck;

    public static String getGraphAppName() {
        return graphAppName;
    }

    public static void setGraphAppName(String graphAppName) {
        PCHelperConstant.graphAppName = graphAppName;
    }

    private PCHelperConstant() {
    }

    public static void setSkipOverLoadCount(int skipOverLoadCount1) {
        skipOverLoadCount = skipOverLoadCount1;
    }

    public static int getSkipOverloadCount() {
        if (skipOverLoadCount == 0) {
            logger.debug(" Empty skipOverLoadCount value so use 25000 ..... ");
            return 25000;
        }
        return skipOverLoadCount;
    }

    public static int getUploadLocalChunkLimit() {
        if (uploadLocalChunkLimit == 0) {
            logger.debug(" Empty uploadLocalChunkLimit value so set to 10 as default ..... ");
            return 10;
        }
        return uploadLocalChunkLimit;
    }

    public static void setUploadLocalChunkLimit(int uploadLocalChunkLimit1) {
        uploadLocalChunkLimit = uploadLocalChunkLimit1;
    }

    public static boolean isJobEnabled(String jobName) {
        boolean jobEnabled = true;
        if (jobConfig.get(jobName) != null) {
            jobEnabled = jobConfig.get(jobName);
        }
        return jobEnabled;
    }

    public static String getPropertyFileValueDefaultUploadPath(String cloudName) {
        return PROPERTY_FILE_VALUE_PARACLOUD_MOUNT_POINT + cloudName + PROPERTY_FILE_SECONDARY_APPENDED_PRIMARY_VALUE_DEFAULT_UPLOAD_PATH;
    }

    public static String getPropertyFileValueDefaultSyncUploadPath(String cloudName) {
        return PROPERTY_FILE_VALUE_PARACLOUD_MOUNT_POINT + cloudName + PROPERTY_FILE_SECONDARY_APPENDED_PRIMARY_VALUE_DEFAULT_SYNC_UPLOAD_PATH;
    }

    public static String getPropertyFileSIEMPath(String cloudName) {
        return PROPERTY_FILE_VALUE_PARACLOUD_MOUNT_POINT + cloudName + PROPERTY_FILE_SIEM_PATH;
    }

    public static String getPropertyFileValueForParacloudUrl() {
        return paracloudUrl;
    }

    public static void setPropertyFileValueParacloudUrl(String paracloudUrl1) {
        paracloudUrl = paracloudUrl1;
    }

    public static String getPropertyFileValueDefaultExtDownloadPath(String cloudName) {
        return PROPERTY_FILE_VALUE_PARACLOUD_MOUNT_POINT + cloudName + PROPERTY_FILE_SECONDARY_APPENDED_PRIMARY_VALUE_DEFAULT_EXTERNAL_DOWNLOAD_PATH;
    }

    public static String getCreateFolderUrl(String office365baseUrl, String accountId) {
        return office365baseUrl + PERSONAL_URL + PCHelperConstant.getEmailId(accountId) + "/_api/files";
    }

    public static String getParabluFolderUrl(String office365baseUrl, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty((String)pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = PCHelperConstant.getPersonalSite(office365baseUrl, accountId);
        return personalSite + "/_api/web/GetFolderByServerRelativeUrl('" + PERSONAL_URL + PCHelperConstant.getEmailId(accountId) + "/Documents/" + pbFolderName + "/" + userName + "/" + suffixFolderPath + "/')";
    }

    public static String getOfficeThreadsValue() {
        return officeThreadsValue;
    }

    public static void setOfficeThreadsValue(String officeThreadsVal) {
        officeThreadsValue = officeThreadsVal;
    }

    public static String getParabluLibraryUrl(String office365baseUrl, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty((String)pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = PCHelperConstant.getPersonalSite(office365baseUrl, accountId);
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return personalSite + "/_api/web/GetFolderByServerRelativeUrl('" + personalUrl + PCHelperConstant.getEmailId(accountId) + "/" + pbFolderName + userName + "/" + suffixFolderPath + "/')";
    }

    public static String getPersonalSite(String office365baseUrl, String accountId) {
        if (office365baseUrl.endsWith("/")) {
            office365baseUrl = office365baseUrl.substring(0, office365baseUrl.lastIndexOf(47));
        }
        if (accountId.contains("sites/")) {
            return office365baseUrl + "/" + PCHelperConstant.getEmailId(accountId);
        }
        return office365baseUrl + PERSONAL_URL + PCHelperConstant.getEmailId(accountId);
    }

    public static String getParabluLibraryUrlForFolderCheck(String office365baseUrl, String accountId, String pbFolderName) {
        if (StringUtils.isEmpty((String)pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = PCHelperConstant.getPersonalSite(office365baseUrl, accountId);
        return personalSite + "/_api/web/GetFolderByServerRelativeUrl('" + pbFolderName + "/')";
    }

    public static String getDownloadUrl(String office365baseUrl, String fileName, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty((String)pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return office365baseUrl + personalUrl + PCHelperConstant.getEmailId(accountId) + "/_api/web/GetFolderByServerRelativeUrl('" + personalUrl + PCHelperConstant.getEmailId(accountId) + "/Documents/" + pbFolderName + "/" + userName + "/" + suffixFolderPath + "')/Files('" + fileName + "')/$value";
    }

    public static String getLibraryDownloadUrl(String office365baseUrl, String fileName, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty((String)pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return office365baseUrl + personalUrl + PCHelperConstant.getEmailId(accountId) + "/_api/web/GetFolderByServerRelativeUrl('" + personalUrl + PCHelperConstant.getEmailId(accountId) + "/" + pbFolderName + "/" + userName + "/" + suffixFolderPath + "')/Files('" + fileName + "')/$value";
    }

    public static String getGraphClientDownloadUrl(String driveId, String userName, String suffixFolderPath, String fileName) {
        return "/drives/" + driveId + "/root:/" + userName + "/" + suffixFolderPath + "/" + fileName + ":/content";
    }

    public static String getGraphLibraryDownloadUrlWithItemId(String driveId, String itemId) {
        return "/drives/" + driveId + "/items/" + itemId + "/content";
    }

    public static String getGraphLibraryDownloadUrl(String driveId, String userName, String suffixFolderPath, String fileName) {
        return "https://graph.microsoft.com/v1.0/drives/" + driveId + "/root:/" + userName + "/" + suffixFolderPath + "/" + fileName + ":/content";
    }

    private static String getEmailId(String emailId) {
        String replacedEmailId = emailId.replace(".", "_");
        replacedEmailId = replacedEmailId.replace("@", "_");
        return replacedEmailId;
    }

    public static String getParabluLibrarySizeUrl(String office365baseUrl, String accountId, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        pbFolderName = "";
        if (StringUtils.isEmpty((String)pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = PCHelperConstant.getPersonalSite(office365baseUrl, accountId);
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return personalSite + "/_api/web/getFolderByServerRelativeUrl('" + personalUrl + PCHelperConstant.getEmailId(accountId) + "/" + pbFolderName1 + "/')?$select=StorageMetrics&$expand=Folders";
    }

    public static String getPropertyFileValueForCouchDBUserName() {
        return couchDBUserName;
    }

    public static String getPropertyFileValueForCouchDBPwd() {
        return PROPERTY_FILE_VALUE_COUCH_DB_PWD;
    }

    public static String getPropertyFileValueEnvironment() {
        return PROPERTY_FILE_VALUE_ENVIRONMENT;
    }

    public static String getPropertyFileValueUploadToLocalFs() {
        return PROPERTY_FILE_VALUE_UPLOAD_TO_LOCAL_FS;
    }

    public static String getPropertyFileValueParacloudMountPoint() {
        return PROPERTY_FILE_VALUE_PARACLOUD_MOUNT_POINT;
    }

    public static String getPropertyFileValueAmazonS3AccessKey() {
        return PROPERTY_FILE_VALUE_AMAZONS3_STORAGE_ACCESS_KEY;
    }

    public static String getPropertyFileValueAmazonS3SecretKey() {
        return PROPERTY_FILE_VALUE_AMAZONS3_STORAGE_SECRET_KEY;
    }

    public static String getPropertyFileValueAmazonS3BucketName() {
        return PROPERTY_FILE_VALUE_AMAZONS3_STORAGE_BUCKET_NAME;
    }

    public static String getPropertyFileValueSslAuthEnabled() {
        return PROPERTY_FILE_VALUE_SSL_AUTH_ENABLED;
    }

    public static String getPropertyFileValueEncryptionEnabled() {
        return encryptionEnabled;
    }

    public static void setPropertyFileValueEncryptionEnabled(String encryptionEnabled1) {
        encryptionEnabled = encryptionEnabled1;
    }

    public static String getSyncFtpHostProperty() {
        return syncFtpHost;
    }

    public static void setSyncFtpHostProperty(String ftpHost) {
        syncFtpHost = ftpHost;
    }

    public static String getSyncFtpUserProperty() {
        return syncFtpHostUser;
    }

    public static void setSyncFtpUserProperty(String ftpUser) {
        syncFtpHostUser = ftpUser;
    }

    public static String getSyncFtpPwdProperty() {
        return syncFtpHostPwd;
    }

    public static void setSyncFtpPwdProperty(String ftpPwd) {
        syncFtpHostPwd = ftpPwd;
    }

    public static int getQueryLimit() {
        if (StringUtils.isEmpty((String)queryLimit)) {
            return 20;
        }
        return Integer.parseInt(queryLimit);
    }

    public static void setQueryLimit(String queryLimit1) {
        queryLimit = queryLimit1;
    }

    public static int getRestoreQueryLimit() {
        if (StringUtils.isEmpty((String)restoreQueryLimit)) {
            return 100;
        }
        return Integer.parseInt(restoreQueryLimit);
    }

    public static void setRestoreQueryLimit(String restoreQueryLimit1) {
        restoreQueryLimit = restoreQueryLimit1;
    }

    public static int getThreadLimit() {
        if (StringUtils.isEmpty((String)noOfThreads)) {
            return 5;
        }
        return Integer.parseInt(noOfThreads);
    }

    public static int getNoOfO365BkpThreads() {
        if (StringUtils.isEmpty((String)noOfO365BkpThreads)) {
            return 2;
        }
        return Integer.parseInt(noOfO365BkpThreads);
    }

    public static void setNoOfO365BkpThreads(String noOfThreads1) {
        noOfO365BkpThreads = noOfThreads1;
    }

    public static void setThreadLimit(String noOfThreads1) {
        noOfThreads = noOfThreads1;
    }

    public static int getJobThreadLimit() {
        if (StringUtils.isEmpty((String)jobThreadLimit)) {
            return 5;
        }
        return Integer.parseInt(jobThreadLimit);
    }

    public static void setJobThreadLimit(String noOfJobThreads) {
        jobThreadLimit = noOfJobThreads;
    }

    public static String getPropertyFileValueSyncUploadPath() {
        return syncUploadPath;
    }

    public static void setPropertyFileValueSyncUploadPath(String syncUploadPath1) {
        syncUploadPath = syncUploadPath1;
    }

    public static String getPropertyFileValueBackupLocalStoragePath() {
        return PROPERTY_FILE_VALUE_BKP_LOCAL_STORAGE_PATH;
    }

    public static boolean getPropertyFileValueSyncFtpEnabled() {
        if (StringUtils.isEmpty((String)syncFtpEnabled)) {
            return false;
        }
        return Boolean.parseBoolean(syncFtpEnabled);
    }

    public static void setPropertyFileValueSyncFtpEnabled(String syncFtpEnabled1) {
        syncFtpEnabled = syncFtpEnabled1;
    }

    public static int getPGOverloadLimit() {
        if (StringUtils.isEmpty((String)pgOverloadLimit)) {
            logger.debug(" Empty  pgOverloadLimit  ..... ");
            return 50;
        }
        return Integer.parseInt(pgOverloadLimit);
    }

    public static void setPGOverloadLimit(String pgOverloadLimit1) {
        pgOverloadLimit = pgOverloadLimit1;
    }

    public static void setCrawlThreadsLimit(String crawlThreadsLimit1) {
        crawlThreadsLimit = crawlThreadsLimit1;
    }

    public static int getPGOverloadLimitFreqCheck() {
        if (StringUtils.isEmpty((String)pgOverLoadLimitFreqCheck)) {
            logger.debug(" Empty  pgOverLoadLimitFreqCheck  ..... ");
            return 30;
        }
        return Integer.parseInt(pgOverLoadLimitFreqCheck);
    }

    public static void setPGOverloadLimitFreqCheck(String pgOverLoadLimitFreqCheck1) {
        pgOverLoadLimitFreqCheck = pgOverLoadLimitFreqCheck1;
    }

    public static int getGraphTimeoutInMins() {
        if (StringUtils.isEmpty((String)graphTimeoutInMins)) {
            return 5;
        }
        return Integer.parseInt(graphTimeoutInMins);
    }

    public static void setGraphTimeoutInMins(String graphTimeoutInMins1) {
        graphTimeoutInMins = graphTimeoutInMins1;
    }

    public static int getPGOverLoadInactivityPeriod() {
        if (StringUtils.isEmpty((String)pgOverloadInActivityPeriodPgOverload)) {
            logger.debug(" Empty pgOverLoadInactivity value ..... ");
            return 300000;
        }
        return Integer.parseInt(pgOverloadInActivityPeriodPgOverload);
    }

    public static void setPGOverLoadInactivityPeriod(String pgOverLoadInactivityPeriod1) {
        pgOverloadInActivityPeriodPgOverload = pgOverLoadInactivityPeriod1;
    }

    public static int getReplicaSetLimit() {
        if (StringUtils.isEmpty((String)PROPERTY_FILE_VALUE_REPLICA_SAFE_LIMIT)) {
            return 1000;
        }
        return Integer.parseInt(PROPERTY_FILE_VALUE_REPLICA_SAFE_LIMIT);
    }

    public static boolean isReadPreferenceFromSecondary() {
        if (StringUtils.isEmpty((String)PROPERTY_FILE_VALUE_READ_PREFERENCE)) {
            return false;
        }
        return Boolean.parseBoolean(PROPERTY_FILE_VALUE_READ_PREFERENCE);
    }

    public static int getPGWriteDelayTime() {
        if (StringUtils.isEmpty((String)PROPERTY_FILE_VALUE_PG_WRITE_DELAY_LIMIT)) {
            return 10;
        }
        return Integer.parseInt(PROPERTY_FILE_VALUE_PG_WRITE_DELAY_LIMIT);
    }

    public static String getPropertyFileValueParabluFolderBasePath(String cloudName) {
        return PROPERTY_FILE_VALUE_PARACLOUD_MOUNT_POINT + cloudName + PROPERTY_FILE_SECONDARY_APPENDED_VALUE_PARABLU_FOLDER_BASE_PATH;
    }

    public static boolean getPropertyFileValueLocalStorageEnabled() {
        if (StringUtils.isEmpty((String)localStorageEnabled)) {
            return false;
        }
        return Boolean.parseBoolean(localStorageEnabled);
    }

    public static void setPropertyFileValueLocalStorageEnabled(String localStorageEnabled1) {
        localStorageEnabled = localStorageEnabled1;
    }

    public static int getProxyPort() {
        if (StringUtils.isEmpty((String)proxyPort)) {
            return 0;
        }
        return Integer.parseInt(proxyPort);
    }

    public static void setProxyPort(String proxyPort1) {
        proxyPort = proxyPort1;
    }

    public static String getProxyHost() {
        return proxyHost;
    }

    public static void setProxyHost(String proxyHost1) {
        proxyHost = proxyHost1;
    }

    public static String getProxyUserName() {
        return proxyUserName;
    }

    public static void setProxyUserName(String proxyUserName1) {
        proxyUserName = proxyUserName1;
    }

    public static String getProxyPassword() {
        return proxyPassword;
    }

    public static void setProxyPassword(String proxyPassword1) {
        proxyPassword = proxyPassword1;
    }

    public static int getMaxRetryForChunkUpdate() {
        if (StringUtils.isEmpty((String)maxRetryChunkupdate)) {
            return 1;
        }
        return Integer.parseInt(maxRetryChunkupdate);
    }

    public static void setMaxRetryForChunkUpdate(String chunkUpdateMaxRetry) {
        maxRetryChunkupdate = chunkUpdateMaxRetry;
    }

    public static int getReportDisplayRecords() {
        if (StringUtils.isEmpty((String)PROPERTY_FILE_VALUE_REPORT_DISPLAY_RECORDS)) {
            return 0;
        }
        return Integer.parseInt(PROPERTY_FILE_VALUE_REPORT_DISPLAY_RECORDS);
    }

    public static int getExpiryDaysForDeleteSyncFiles() {
        if (StringUtils.isEmpty((String)PROPERTY_FILE_VALUE_EXPIRY_DELETE_SYNC_FILES_LIMIT)) {
            return 0;
        }
        return Integer.parseInt(PROPERTY_FILE_VALUE_EXPIRY_DELETE_SYNC_FILES_LIMIT);
    }

    public static String getMntTempChunkPath() {
        if (StringUtils.isEmpty((String)PROPERTY_FILE_VALUE_MNT_TEMP_CHUNK_PATH)) {
            return PROPERTY_FILE_VALUE_PARACLOUD_MOUNT_POINT + "tmp-chunk/";
        }
        return PROPERTY_FILE_VALUE_MNT_TEMP_CHUNK_PATH + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
    }

    public static String getPropertyFileValueMemcachedUrl() {
        return memcashedUrl;
    }

    public static void setPropertyFileValueMemcachedUrl(String memcachedUri) {
        memcashedUrl = memcachedUri;
    }

    public static String getPropertyFileValueMemcachedPort() {
        return memcashedPort;
    }

    public static void setPropertyFileValueMemcachedPort(String memchacedPort) {
        memcashedPort = memchacedPort;
    }

    public static String getPropertyFileValueMemcachedTimeout() {
        return memcachedTimeout;
    }

    public static void setPropertyFileValueMemcachedTimeout(String memcachedTimeout1) {
        memcachedTimeout = memcachedTimeout1;
    }

    public static String getParabluFolderBasePath() {
        return PROPERTY_FILE_VALUE_PARACLOUD_MOUNT_POINT + "/";
    }

    public static int getODBCallFrequency() {
        if (StringUtils.isEmpty((String)odbFrequencyCallLimit)) {
            logger.debug(" Empty ODBCallFrequency ..... ");
            return 100;
        }
        return Integer.parseInt(odbFrequencyCallLimit);
    }

    public static void setODBCallFrequency(String odbFrequencyCallValue) {
        odbFrequencyCallLimit = odbFrequencyCallValue;
    }

    public static int getFailedJobThreadLimit() {
        if (StringUtils.isEmpty((String)PROPERTY_FILE_VALUE_FAILED_JOB_THREAD_LIMIT)) {
            return 5;
        }
        return Integer.parseInt(PROPERTY_FILE_VALUE_FAILED_JOB_THREAD_LIMIT);
    }

    public static boolean isBackupCollectionQueryRequired() {
        if (StringUtils.isEmpty((String)backupColQueryReq)) {
            return true;
        }
        return Boolean.parseBoolean(backupColQueryReq);
    }

    public static void setBackupCollectionQueryRequired(String bkpColQueryRequired) {
        backupColQueryReq = bkpColQueryRequired;
    }

    public static boolean isChunkCollectionQueryRequired() {
        if (StringUtils.isEmpty((String)chunkColQueryReq)) {
            return true;
        }
        return Boolean.parseBoolean(chunkColQueryReq);
    }

    public static void setChunkCollectionQueryRequired(String chunkColQueryRequired) {
        chunkColQueryReq = chunkColQueryRequired;
    }

    public static int getChunkTotalBuckets() {
        if (StringUtils.isEmpty((String)chunkTotalBuckets)) {
            return 101;
        }
        return Integer.parseInt(chunkTotalBuckets);
    }

    public static void setChunkTotalBuckets(String chunkTotalBuckets1) {
        chunkTotalBuckets = chunkTotalBuckets1;
    }

    public static String getPropertyFileValueLoadBalancerIp() {
        return PROPERTY_FILE_VALUE_LOAD_BALANCER_IP;
    }

    public static int getDaysToWaitForNextBkp() {
        if (StringUtils.isEmpty((String)PROPERTY_FILE_VALUE_BKP_FREQ_IN_DAYS)) {
            return 0;
        }
        return Integer.parseInt(PROPERTY_FILE_VALUE_BKP_FREQ_IN_DAYS);
    }

    public static boolean getPropertyFileValueDeleteBkptblWhenChunksNotFound() {
        if (StringUtils.isEmpty((String)deleteBkptblWnenChunksNotFound)) {
            return true;
        }
        return Boolean.parseBoolean(deleteBkptblWnenChunksNotFound);
    }

    public static void setPropertyFileValueDeleteBkptblWhenChunksNotFound(String deleteBkpTblWhenChnkNotFound) {
        deleteBkptblWnenChunksNotFound = deleteBkpTblWhenChnkNotFound;
    }

    public static boolean getPropertyFileValueUpdatepgnameWhenChunkNotFoundMultipgenv() {
        if (StringUtils.isEmpty((String)updatePgNameWhenChunkNotFoundMultiPgenv)) {
            return false;
        }
        return Boolean.parseBoolean(updatePgNameWhenChunkNotFoundMultiPgenv);
    }

    public static void setPropertyFileValueUpdatepgnameWhenChunkNotFoundMultipgenv(String updateGatewayWhenChunkNotFound) {
        updatePgNameWhenChunkNotFoundMultiPgenv = updateGatewayWhenChunkNotFound;
    }

    public static String getPropertyFileValueGatewayname() {
        return gateWayName;
    }

    public static void setPropertyFileValueGatewayname(String gatewayName) {
        gateWayName = gatewayName;
    }

    public static int getRetryOdbFolderValue() {
        if (StringUtils.isEmpty((String)retryFolderVal)) {
            return 3000;
        }
        return Integer.parseInt(retryFolderVal);
    }

    public static void setRetryOdbFolderValue(String odbRetryFolderVal) {
        retryFolderVal = odbRetryFolderVal;
    }

    public static String getODBDecorationValue() {
        return odbDecor;
    }

    public static void setODBDecorationValue(String odbUserAgentVal) {
        odbDecor = odbUserAgentVal;
    }

    public static void setPropertyFileValueParacloudMountPoint(String mntParacloudPath) {
        PROPERTY_FILE_VALUE_PARACLOUD_MOUNT_POINT = mntParacloudPath;
    }

    public static void setPropertyFileValueSslAuthEnabled(String sslAuthEnabled) {
        PROPERTY_FILE_VALUE_SSL_AUTH_ENABLED = sslAuthEnabled;
    }

    public static boolean isJobsStopEnabled() {
        if (StringUtils.isEmpty((String)stopJobsEnabled)) {
            return false;
        }
        return Boolean.parseBoolean(stopJobsEnabled);
    }

    public static void setJobsStopEnabled(String stopJobsEnabled1) {
        stopJobsEnabled = stopJobsEnabled1;
    }

    public static Map<String, Boolean> getJobConfig() {
        return jobConfig;
    }

    public static void setJobConfig(Map<String, Boolean> jobConfig) {
        PCHelperConstant.jobConfig = jobConfig;
    }

    public static String getComponentName() {
        return componentName;
    }

    public static void setComponentName(String componentName) {
        PCHelperConstant.componentName = componentName;
    }

    public static int getDelayInUploadInSec() {
        if (StringUtils.isEmpty((String)delayInUploadInSec)) {
            return 5;
        }
        return Integer.parseInt(delayInUploadInSec);
    }

    public static void setDelayInUploadInSec(String delayInUploadInSec1) {
        delayInUploadInSec = delayInUploadInSec1;
    }

    public static int getDelayIn429CaseInSec() {
        if (StringUtils.isEmpty((String)delayIn429CaseInSec)) {
            return 300;
        }
        return Integer.parseInt(delayIn429CaseInSec);
    }

    public static void setDelayIn429CaseInSec(String delayIn429CaseInSec1) {
        delayIn429CaseInSec = delayIn429CaseInSec1;
    }

    public static int getCountOfContinuous429() {
        if (StringUtils.isEmpty((String)countOfContinuous429)) {
            return 50;
        }
        return Integer.parseInt(countOfContinuous429);
    }

    public static void setCountOfContinuous429(String countOfContinuous429) {
        PCHelperConstant.countOfContinuous429 = countOfContinuous429;
    }

    public static int getCountOfODBFiles() {
        if (StringUtils.isEmpty((String)countOfODBFiles)) {
            return 4500;
        }
        return Integer.parseInt(countOfODBFiles);
    }

    public static void setCountOfODBFiles(String countOfODBFiles1) {
        countOfODBFiles = countOfODBFiles1;
    }

    public static long getAddn429WaitMultiplier() {
        if (StringUtils.isEmpty((String)addn429WaitMultiplier)) {
            return 1L;
        }
        return Long.parseLong(addn429WaitMultiplier);
    }

    public static void setAddn429WaitMultiplier(String addn429Wait1) {
        addn429WaitMultiplier = addn429Wait1;
    }

    public static void setSearchExclusionExtName(String searchExclusionExtName) {
        PROPERTY_SEARCH_EXT_EXCLUSION = searchExclusionExtName;
    }

    public static String getSearchExclusionExtName() {
        return PROPERTY_SEARCH_EXT_EXCLUSION;
    }

    public static String getODBDownloadPriorityTimeStamp() {
        return ODBDownloadPriorityTimeStamp;
    }

    public static void setODBDownloadPriorityTimeStamp(String oDBDownloadPriorityTimeStamp) {
        ODBDownloadPriorityTimeStamp = oDBDownloadPriorityTimeStamp;
    }

    public static boolean isParacloud() {
        return paracloud;
    }

    public static void setParacloud(boolean paracloud) {
        PCHelperConstant.paracloud = paracloud;
    }

    public static String getMoveFileFromBkpToLocalInterval() {
        if (StringUtils.isEmpty((String)moveFileFromBkpToLocalInterval)) {
            return "60000";
        }
        return moveFileFromBkpToLocalInterval;
    }

    public static void setMoveFileFromBkpToLocalInterval(String moveFileFromBkpToLocalInterval) {
        PCHelperConstant.moveFileFromBkpToLocalInterval = moveFileFromBkpToLocalInterval;
    }

    public static boolean isBrevityLogging() {
        return brevityLogging;
    }

    public static void setBrevityLogging(boolean brevityLogging) {
        PCHelperConstant.brevityLogging = brevityLogging;
    }

    public static boolean isGlobalCheckForLocalStorage() {
        return globalCheckForLocalStorage;
    }

    public static void setGlobalCheckForLocalStorage(boolean globalCheckForLocalStorage) {
        PCHelperConstant.globalCheckForLocalStorage = globalCheckForLocalStorage;
    }

    public static String getPropertyFileValueDefaultSyncDownloadPath(String cloudName) {
        return PROPERTY_FILE_VALUE_PARACLOUD_MOUNT_POINT + cloudName + PROPERTY_FILE_SECONDARY_APPENDED_PRIMARY_VALUE_DEFAULT_SYNC_DOWNLOAD_PATH;
    }

    public static String getMSClientId() {
        return PROPERTY_MS_CLIENT_ID;
    }

    public static void setMSClientId(String msClientId) {
        PROPERTY_MS_CLIENT_ID = msClientId;
    }

    public static String getMSClientSecret() {
        return PROPERTY_MS_CLIENT_SECRET;
    }

    public static void setMSClientSecret(String msClientSecret) {
        PROPERTY_MS_CLIENT_SECRET = msClientSecret;
    }

    public static String getMSTenantId() {
        return PROPERTY_MS_TENANTID;
    }

    public static void setMSTenantId(String msClientTenant) {
        PROPERTY_MS_TENANTID = msClientTenant;
    }

    public static String getMSSharePointUrl() {
        return PROPERTY_MS_SHARPOINT_URL;
    }

    public static void setMSSharePointUrl(String msSharePointUrl) {
        PROPERTY_MS_SHARPOINT_URL = msSharePointUrl;
    }

    public static String getOneDriveBackupType() {
        return oneDriveBackupType;
    }

    public static void setOneDriveBackupType(String oneDriveBackupType) {
        PCHelperConstant.oneDriveBackupType = oneDriveBackupType;
    }

    public static String getC2cGraphClientId() {
        return c2cGraphClientId;
    }

    public static void setC2cGraphClientId(String c2cGraphClientId) {
        PCHelperConstant.c2cGraphClientId = c2cGraphClientId;
    }

    public static String getC2cGraphClientSecret() {
        return c2cGraphClientSecret;
    }

    public static void setC2cGraphClientSecret(String c2cGraphClientSecret) {
        PCHelperConstant.c2cGraphClientSecret = c2cGraphClientSecret;
    }

    public static String getC2cGraphTenantId() {
        return c2cGraphTenantId;
    }

    public static void setC2cGraphTenantId(String c2cGraphTenantId) {
        PCHelperConstant.c2cGraphTenantId = c2cGraphTenantId;
    }

    public static int getClamAvScanDelayInSec() {
        return clamAvScanDelayInSec;
    }

    public static void setClamAvScanDelayInSec(int clamAvScanDelayInSec) {
        PCHelperConstant.clamAvScanDelayInSec = clamAvScanDelayInSec;
    }

    public static String getPropertyValueDBHost1() {
        return propertyValueDBHost1;
    }

    public static void setPropertyValueDBHost1(String propertyValueDBHost1) {
        PCHelperConstant.propertyValueDBHost1 = propertyValueDBHost1;
    }

    public static String getPropertyValueDBPort1() {
        return propertyValueDBPort1;
    }

    public static void setPropertyValueDBPort1(String propertyValueDBPort1) {
        PCHelperConstant.propertyValueDBPort1 = propertyValueDBPort1;
    }

    public static String getPropertyValueDBHost2() {
        return propertyValueDBHost2;
    }

    public static void setPropertyValueDBHost2(String propertyValueDBHost2) {
        PCHelperConstant.propertyValueDBHost2 = propertyValueDBHost2;
    }

    public static String getPropertyValueDBPort2() {
        return propertyValueDBPort2;
    }

    public static void setPropertyValueDBPort2(String propertyValueDBPort2) {
        PCHelperConstant.propertyValueDBPort2 = propertyValueDBPort2;
    }

    public static String getPropertyValueDBHost3() {
        return propertyValueDBHost3;
    }

    public static void setPropertyValueDBHost3(String propertyValueDBHost3) {
        PCHelperConstant.propertyValueDBHost3 = propertyValueDBHost3;
    }

    public static String getPropertyValueDBPort3() {
        return propertyValueDBPort3;
    }

    public static void setPropertyValueDBPort3(String propertyValueDBPort3) {
        PCHelperConstant.propertyValueDBPort3 = propertyValueDBPort3;
    }

    public static int getUploadFileSizeLimitInMB() {
        if (StringUtils.isEmpty((String)uploadFileSizeLimitInMB)) {
            return 1;
        }
        int fileSize = 0;
        logger.debug("...getUploadFileSizeLimitInMB..." + uploadFileSizeLimitInMB);
        if (uploadFileSizeLimitInMB.contains(".")) {
            logger.debug("...double value..." + uploadFileSizeLimitInMB);
            double doubVal = Double.parseDouble(uploadFileSizeLimitInMB) * 1000000.0;
            logger.debug("...double value after..." + doubVal);
            fileSize = (int)doubVal;
        } else {
            fileSize = Integer.parseInt(uploadFileSizeLimitInMB) * 1000000;
        }
        return fileSize;
    }

    public static void setUploadFileSizeLimitInMB(String uploadFileSizeLimitInMB) {
        PCHelperConstant.uploadFileSizeLimitInMB = uploadFileSizeLimitInMB;
    }

    public static int getNumOfChunksToCheckPgOverloadLimit() {
        return numOfChunksToCheckPgOverloadLimit;
    }

    public static void setNumOfChunksToCheckPgOverloadLimit(int numOfChunksToCheckPgOverloadLimit) {
        PCHelperConstant.numOfChunksToCheckPgOverloadLimit = numOfChunksToCheckPgOverloadLimit;
    }

    public static boolean isMuxedEnabled() {
        return isMuxedEnabled;
    }

    public static void setMuxedEnabled(boolean isMuxedEnabled) {
        PCHelperConstant.isMuxedEnabled = isMuxedEnabled;
    }

    public static boolean isHttpEnabled() {
        return isHttpEnabled;
    }

    public static void setHttpEnabled(boolean isHttpEnabled) {
        PCHelperConstant.isHttpEnabled = isHttpEnabled;
    }

    public static int getNumOfHitsToDBForContentChunkCheck() {
        return numOfHitsToDBForContentChunkCheck;
    }

    public static void setNumOfHitsToDBForContentChunkCheck(int numOfHitsToDBForContentChunkCheck) {
        PCHelperConstant.numOfHitsToDBForContentChunkCheck = numOfHitsToDBForContentChunkCheck;
    }

    public static int getNumOfThreadsToUseForContentChunkFile() {
        if (StringUtils.isEmpty((String)numOfThreadsToUseForContentChunkFile)) {
            return 50;
        }
        return Integer.parseInt(numOfThreadsToUseForContentChunkFile);
    }

    public static void setNumOfThreadsToUseForContentChunkFile(String numOfThreadsToUseForContentChunkFile) {
        PCHelperConstant.numOfThreadsToUseForContentChunkFile = numOfThreadsToUseForContentChunkFile;
    }

    public static boolean isMigratedTenant() {
        return migratedTenant;
    }

    public static void setMigratedTenant(boolean migratedTenant) {
        PCHelperConstant.migratedTenant = migratedTenant;
    }

    public static String getProxyParacloudUrl() {
        return proxyParacloudUrl;
    }

    public static void setProxyParacloudUrl(String proxyParacloudUrl) {
        PCHelperConstant.proxyParacloudUrl = proxyParacloudUrl;
    }

    public static int getCrawlThreadsLimit() {
        logger.debug("...crawlthreadlimit..." + crawlThreadsLimit);
        if (StringUtils.isEmpty((String)crawlThreadsLimit)) {
            logger.debug(" Empty  pgOverloadLimit  ..... ");
            return 50;
        }
        if ((crawlThreadsLimit = crawlThreadsLimit.trim()).contains(".")) {
            logger.debug("...double value..." + crawlThreadsLimit);
            double doubVal = Double.parseDouble(crawlThreadsLimit);
            logger.debug("...double value after..." + doubVal);
            return (int)doubVal;
        }
        return Integer.parseInt(crawlThreadsLimit);
    }

    public static int getNumOfThreadsToUseForPSTCreation() {
        if (numOfThreadsToUseForPSTCreation == 0) {
            numOfThreadsToUseForPSTCreation = 10;
        }
        return numOfThreadsToUseForPSTCreation;
    }

    public static void setNumOfThreadsToUseForPSTCreation(int numOfThreadsToUseForPSTCreation) {
        PCHelperConstant.numOfThreadsToUseForPSTCreation = numOfThreadsToUseForPSTCreation;
    }

    public static int getDelayInMillisecForChunksDuringUpload() {
        if (delayInMillisecForChunksDuringUpload == 0) {
            delayInMillisecForChunksDuringUpload = 1;
        }
        return delayInMillisecForChunksDuringUpload;
    }

    public static void setDelayInMillisecForChunksDuringUpload(int delayInMillisecForChunksDuringUpload) {
        PCHelperConstant.delayInMillisecForChunksDuringUpload = delayInMillisecForChunksDuringUpload;
    }

    public static int getNumOfSecsToWaitBeforeSEndDummyContentToAgent() {
        if (numOfSecsToWaitBeforeSEndDummyContentToAgent == 0) {
            return 10;
        }
        return numOfSecsToWaitBeforeSEndDummyContentToAgent;
    }

    public static void setNumOfSecsToWaitBeforeSEndDummyContentToAgent(int numOfSecsToWaitBeforeSEndDummyContentToAgent) {
        PCHelperConstant.numOfSecsToWaitBeforeSEndDummyContentToAgent = numOfSecsToWaitBeforeSEndDummyContentToAgent;
    }

    public static boolean getBlobFusePresent() {
        return blobFusePresent;
    }

    public static void setBlobFusePresent(boolean blobFusePresent) {
        PCHelperConstant.blobFusePresent = blobFusePresent;
    }

    public static long getLastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    public static void setLastUpdatedTimestamp(long lastUpdatedTimestamp) {
        PCHelperConstant.lastUpdatedTimestamp = lastUpdatedTimestamp;
    }

    public static boolean isBlobFuseEnabled() {
        return blobFuseEnabled;
    }

    public static void setBlobFuseEnabled(boolean blobFuseEnabled) {
        PCHelperConstant.blobFuseEnabled = blobFuseEnabled;
    }

    static {
        Properties props = null;
        try {
            ClassPathResource resource = new ClassPathResource("privacygateway.properties");
            props = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException e) {
            logger.error("  ********************EXCEPTION while trying to load " + e);
        }
        if (props == null) {
            couchDBUserName = null;
            PROPERTY_FILE_VALUE_COUCH_DB_PWD = null;
            PROPERTY_FILE_VALUE_AMAZONS3_STORAGE_ACCESS_KEY = null;
            PROPERTY_FILE_VALUE_AMAZONS3_STORAGE_SECRET_KEY = null;
            PROPERTY_FILE_VALUE_AMAZONS3_STORAGE_BUCKET_NAME = null;
            PROPERTY_FILE_VALUE_ENVIRONMENT = null;
            PROPERTY_FILE_VALUE_UPLOAD_TO_LOCAL_FS = null;
            PROPERTY_FILE_VALUE_SSL_AUTH_ENABLED = null;
            syncFtpHost = null;
            syncFtpHostUser = null;
            syncFtpHostPwd = null;
            queryLimit = null;
            uploadFileSizeLimitInMB = null;
            jobThreadLimit = null;
            syncFtpEnabled = null;
            localStorageEnabled = null;
            chunkColQueryReq = null;
            pgOverloadLimit = null;
            graphTimeoutInMins = null;
            pgOverloadInActivityPeriodPgOverload = null;
            PROPERTY_FILE_VALUE_REPLICA_SAFE_LIMIT = null;
            PROPERTY_FILE_VALUE_READ_PREFERENCE = null;
            PROPERTY_FILE_VALUE_PG_WRITE_DELAY_LIMIT = null;
            uploadOdServiceAcc = null;
            restoreQueryLimit = null;
            PROPERTY_FILE_VALUE_BKP_LOCAL_STORAGE_PATH = null;
            proxyPort = null;
            proxyUserName = null;
            proxyPassword = null;
            proxyHost = null;
            maxRetryChunkupdate = null;
            PROPERTY_FILE_VALUE_REPORT_DISPLAY_RECORDS = null;
            PROPERTY_FILE_VALUE_EXPIRY_DELETE_SYNC_FILES_LIMIT = null;
            PROPERTY_FILE_VALUE_MNT_TEMP_CHUNK_PATH = null;
            memcashedUrl = null;
            memcashedPort = null;
            memcachedTimeout = null;
            odbFrequencyCallLimit = null;
            PROPERTY_FILE_VALUE_FAILED_JOB_THREAD_LIMIT = null;
            PROPERTY_FILE_VALUE_BKP_FREQ_IN_DAYS = null;
            PROPERTY_FILE_VALUE_LOAD_BALANCER_IP = null;
            crawlThreadsLimit = null;
        } else {
            PROPERTY_FILE_VALUE_REPORT_DISPLAY_RECORDS = props.getProperty(PROPERTY_FILE_KEY_REPORT_DISPLAY_RECORDS);
            PROPERTY_FILE_VALUE_COUCH_DB_PWD = props.getProperty(PROPERTY_FILE_KEY_COUCH_DB_PWD);
            PROPERTY_FILE_VALUE_AMAZONS3_STORAGE_ACCESS_KEY = props.getProperty(PROPERTY_FILE_KEY_AMAZONS3_STORAGE_ACCESS_KEY);
            PROPERTY_FILE_VALUE_AMAZONS3_STORAGE_SECRET_KEY = props.getProperty(PROPERTY_FILE_KEY_AMAZONS3_STORAGE_SECRET_KEY);
            PROPERTY_FILE_VALUE_AMAZONS3_STORAGE_BUCKET_NAME = props.getProperty(PROPERTY_FILE_KEY_AMAZONS3_STORAGE_BUCKET_NAME);
            PROPERTY_FILE_VALUE_ENVIRONMENT = props.getProperty(PROPERTY_FILE_KEY_ENVIRONMENT);
            PROPERTY_FILE_VALUE_UPLOAD_TO_LOCAL_FS = props.getProperty(PROPERTY_FILE_KEY_UPLOAD_TO_LOCAL_FS);
            PROPERTY_FILE_VALUE_SSL_AUTH_ENABLED = props.getProperty(PROPERTY_FILE_KEY_SSL_AUTH_ENABLED);
            syncFtpHost = props.getProperty(SYNC_FTP_HOST);
            syncFtpHostUser = props.getProperty(SYNC_FTP_HOST_USER);
            syncFtpHostPwd = props.getProperty(SYNC_FTP_HOST_PWD);
            queryLimit = props.getProperty(QUERY_LIMIT_VALUE);
            uploadFileSizeLimitInMB = props.getProperty(UPLOAD_FILE_SIZE_LIMIT_VALUE);
            crawlThreadsLimit = props.getProperty(PG_CRAWL_THREADS_LIMIT);
            PROPERTY_FILE_VALUE_BKP_LOCAL_STORAGE_PATH = props.getProperty(PROPERTY_FILE_KEY_BKP_LOCAL_STORAGE_PATH);
            syncFtpEnabled = props.getProperty(SYNC_FTP_ENABLED);
            localStorageEnabled = props.getProperty(LOCAL_STORAGE_ENABLED);
            chunkColQueryReq = props.getProperty(CHUNK_COL_QUERY_REQ);
            pgOverloadLimit = props.getProperty(PG_OVERLOAD_LIMIT);
            pgOverLoadLimitFreqCheck = props.getProperty(PG_OVERLOAD_LIMIT_FREQ_CHECK);
            graphTimeoutInMins = props.getProperty(GRAPH_TIMEOUT_IN_MINS);
            pgOverloadInActivityPeriodPgOverload = props.getProperty(PG_OVERLOAD_INACTIVITY_PERIOD);
            PROPERTY_FILE_VALUE_REPLICA_SAFE_LIMIT = props.getProperty(PROPERTY_FILE_KEY_REPLICA_SAFE_LIMIT);
            PROPERTY_FILE_VALUE_READ_PREFERENCE = props.getProperty(PROPERTY_FILE_KEY_READ_PREFERENCE);
            PROPERTY_FILE_VALUE_PG_WRITE_DELAY_LIMIT = props.getProperty(PROPERTY_FILE_KEY_PG_WRITE_DELAY_LIMIT);
            restoreQueryLimit = props.getProperty(RESTORE_QUERY_LIMIT_VALUE);
            jobThreadLimit = props.getProperty(JOB_THREAD_LIMIT);
            proxyPort = props.getProperty(PROXY_PORT);
            proxyUserName = props.getProperty(PROXY_USERNAME);
            proxyPassword = props.getProperty(PROXY_PASSWORD);
            proxyHost = props.getProperty(PROXY_HOST);
            maxRetryChunkupdate = props.getProperty(MAX_RETRY_CHUNK_UPDATE);
            PROPERTY_FILE_VALUE_EXPIRY_DELETE_SYNC_FILES_LIMIT = props.getProperty(PROPERTY_FILE_KEY_EXPIRY_DELETE_SYNC_FILES_LIMIT);
            PROPERTY_FILE_VALUE_MNT_TEMP_CHUNK_PATH = props.getProperty(PROPERTY_FILE_KEY_MNT_TEMP_CHUNK_PATH);
            memcashedUrl = props.getProperty(MEMCACHED_URL);
            memcashedPort = props.getProperty(MEMCACHED_PORT);
            memcachedTimeout = props.getProperty(MEMCACHED_TIMEOUT);
            odbFrequencyCallLimit = props.getProperty(ODB_FREQUENCY_CALL_LIMIT_VALUE);
            PROPERTY_FILE_VALUE_FAILED_JOB_THREAD_LIMIT = props.getProperty(PROPERTY_FILE_KEY_FAILED_JOB_THREAD);
            PROPERTY_FILE_VALUE_LOAD_BALANCER_IP = props.getProperty(PROPERTY_FILE_KEY_LOAD_BALANCER_IP);
            PROPERTY_FILE_VALUE_BKP_FREQ_IN_DAYS = props.getProperty(PROPERTY_FILE_KEY_BKP_FREQ_IN_DAYS);
        }
        Properties credentialsProps = null;
        try {
            ClassPathResource resource = new ClassPathResource("privacygateway.properties");
            credentialsProps = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException e) {
            logger.trace("  ********************EXCEPTION while trying to load " + e);
        }
        if (credentialsProps != null) {
            logger.debug("........Loding pb-credentials....." + credentialsProps.getProperty(propertyKeyDBHost));
            propertyValueDBHost = credentialsProps.getProperty(propertyKeyDBHost);
            propertyValueDBPort = credentialsProps.getProperty(propertyKeyDBPort);
            propertyValueDBHost1 = credentialsProps.getProperty(propertyKeyDBHost1);
            propertyValueDBPort1 = credentialsProps.getProperty(propertyKeyDBPort1);
            propertyValueDBHost2 = credentialsProps.getProperty(propertyKeyDBHost2);
            propertyValueDBPort2 = credentialsProps.getProperty(propertyKeyDBPort2);
            propertyValueDBHost3 = credentialsProps.getProperty(propertyKeyDBHost3);
            propertyValueDBPort3 = credentialsProps.getProperty(propertyKeyDBPort3);
        }
    }

    public static enum BACKUP_STATUS {
        COMPLETED,
        INTERRUPTED,
        PAUSED,
        ABORTED,
        STOPPED,
        EXITED,
        SCANNING,
        STATUS_STARTED,
        STARTED,
        QUEUED;

    }

    public static enum RETRY_POLICY_OPERATION {
        DOWNLOAD,
        UPLOAD,
        GRAPHCALLS;

    }

    public static enum EVENTHUB_ACTION_STATUS {
        CREATED,
        RESTORE_CREATED,
        ACCESS_BY_AGENT;

    }

    public static enum EVENTHUB_ACTION {
        SYNCPOLICY_REFRESH,
        BACKUPPOLICY_REFRESH,
        START_BACKUP,
        FULL_BACKUP,
        STOP_BACKUP,
        PAUSE_BACKUP,
        PULL_AGENTLOGS,
        PULL_HISTORICAL_LOGS,
        STOP_BACKUP_WHILE_RESTORE,
        START_RESTORE;

    }

    public static enum REVISION_STATUS {
        MODIFIED,
        DELETED,
        ADDED,
        RESTORED;

    }
}

