/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.graph.core.DateOnly;
import com.microsoft.graph.models.PatternedRecurrence;
import com.microsoft.graph.models.RecurrenceRange;
import java.io.IOException;
import java.text.ParseException;

public class PatternedRecurrenceDeserializer
extends JsonDeserializer<PatternedRecurrence> {
    public PatternedRecurrence deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode rootNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        PatternedRecurrence patternedRecurrence = new PatternedRecurrence();
        JsonNode rangeNode = rootNode.get("range");
        if (rangeNode != null) {
            RecurrenceRange range = new RecurrenceRange();
            if (rangeNode.has("startDate")) {
                String startDateStr = rangeNode.get("startDate").asText();
                try {
                    range.startDate = DateOnly.parse((String)startDateStr);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (rangeNode.has("endDate")) {
                String endDateStr = rangeNode.get("endDate").asText();
                try {
                    range.endDate = DateOnly.parse((String)endDateStr);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            patternedRecurrence.range = range;
        }
        return patternedRecurrence;
    }
}

