/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.discovery;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.PlexusConfigurationMerger;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

public class PlexusXmlComponentDiscoverer
implements ComponentDiscoverer {
    private static final String PLEXUS_XML_RESOURCE = "META-INF/plexus/plexus.xml";
    private ComponentDiscovererManager manager;

    public void setManager(ComponentDiscovererManager manager) {
        this.manager = manager;
    }

    public List findComponents(Context context, ClassRealm classRealm) throws PlexusConfigurationException {
        PlexusConfiguration configuration = this.discoverConfiguration(context, classRealm);
        ArrayList<ComponentSetDescriptor> componentSetDescriptors = new ArrayList<ComponentSetDescriptor>();
        ComponentSetDescriptor componentSetDescriptor = this.createComponentDescriptors(configuration, classRealm);
        componentSetDescriptors.add(componentSetDescriptor);
        ComponentDiscoveryEvent event = new ComponentDiscoveryEvent(componentSetDescriptor);
        this.manager.fireComponentDiscoveryEvent(event);
        return componentSetDescriptors;
    }

    public PlexusConfiguration discoverConfiguration(Context context, ClassRealm classRealm) throws PlexusConfigurationException {
        PlexusConfiguration configuration = null;
        Enumeration resources = null;
        try {
            resources = classRealm.findResources(PLEXUS_XML_RESOURCE);
        }
        catch (IOException e) {
            throw new PlexusConfigurationException("Error retrieving configuration resources: META-INF/plexus/plexus.xml from class realm: " + classRealm.getId(), e);
        }
        Enumeration e = resources;
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            XmlStreamReader reader = null;
            try {
                reader = ReaderFactory.newXmlReader(url.openStream());
                ContextMapAdapter contextAdapter = new ContextMapAdapter(context);
                InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader(reader, contextAdapter);
                PlexusConfiguration discoveredConfig = PlexusTools.buildConfiguration(url.toExternalForm(), interpolationFilterReader);
                if (configuration == null) {
                    configuration = discoveredConfig;
                    continue;
                }
                configuration = PlexusConfigurationMerger.merge(configuration, discoveredConfig);
            }
            catch (IOException ex) {
                throw new PlexusConfigurationException("Error reading configuration from: " + url.toExternalForm(), ex);
            }
            finally {
                IOUtil.close(reader);
            }
        }
        return configuration;
    }

    private ComponentSetDescriptor createComponentDescriptors(PlexusConfiguration configuration, ClassRealm classRealm) throws PlexusConfigurationException {
        ComponentSetDescriptor componentSetDescriptor = new ComponentSetDescriptor();
        if (configuration != null) {
            ArrayList componentDescriptors = new ArrayList();
            PlexusConfiguration[] componentConfigurations = configuration.getChild("components").getChildren("component");
            for (int i = 0; i < componentConfigurations.length; ++i) {
                PlexusConfiguration componentConfiguration = componentConfigurations[i];
                ComponentDescriptor componentDescriptor = null;
                try {
                    componentDescriptor = PlexusTools.buildComponentDescriptor(componentConfiguration);
                }
                catch (PlexusConfigurationException e) {
                    throw new PlexusConfigurationException("Cannot build component descriptor from resource found in:\n" + Arrays.asList(classRealm.getURLs()), e);
                }
                componentDescriptor.setComponentType("plexus");
                componentDescriptor.setRealmId(classRealm.getId());
                componentDescriptors.add(componentDescriptor);
            }
            componentSetDescriptor.setComponents(componentDescriptors);
        }
        return componentSetDescriptor;
    }
}

