/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.reporting;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.doxia.sink.render.RenderingContext;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.utils.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMavenReport
extends AbstractMojo
implements MavenMultiPageReport {
    @Parameter(defaultValue="${project.reporting.outputDirectory}", readonly=true, required=true)
    protected File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}", readonly=true)
    private String inputEncoding;
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}", readonly=true)
    private String outputEncoding;
    @Component
    protected Renderer siteRenderer;
    private Sink sink;
    private SinkFactory sinkFactory;
    private File reportOutputDirectory;

    @Override
    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            return;
        }
        OutputStreamWriter writer = null;
        try {
            File outputDirectory = new File(this.getOutputDirectory());
            String filename = this.getOutputName() + ".html";
            Locale locale = Locale.getDefault();
            SiteRenderingContext siteContext = new SiteRenderingContext();
            siteContext.setDecoration(new DecorationModel());
            siteContext.setTemplateName("org/apache/maven/doxia/siterenderer/resources/default-site.vm");
            siteContext.setLocale(locale);
            siteContext.setTemplateProperties(this.getTemplateProperties());
            RenderingContext context = new RenderingContext(outputDirectory, filename);
            SiteRendererSink sink = new SiteRendererSink(context);
            this.generate(sink, null, locale);
            if (!this.isExternalReport()) {
                outputDirectory.mkdirs();
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outputDirectory, filename)), this.getOutputEncoding());
                this.getSiteRenderer().generateDocument(writer, sink, siteContext);
            }
        }
        catch (RendererException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", e);
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", e);
        }
        finally {
            IOUtil.close(writer);
        }
    }

    private Map<String, Object> getTemplateProperties() {
        HashMap<String, Object> templateProperties = new HashMap<String, Object>();
        templateProperties.put("project", this.getProject());
        templateProperties.put("inputEncoding", this.getInputEncoding());
        templateProperties.put("outputEncoding", this.getOutputEncoding());
        for (Map.Entry<Object, Object> entry : this.getProject().getProperties().entrySet()) {
            templateProperties.put((String)entry.getKey(), entry.getValue());
        }
        return templateProperties;
    }

    @Override
    public void generate(org.codehaus.doxia.sink.Sink aSink, Locale aLocale) throws MavenReportException {
        this.generate(aSink, null, aLocale);
    }

    public void generate(Sink aSink, Locale aLocale) throws MavenReportException {
        this.generate(aSink, null, aLocale);
    }

    @Override
    public void generate(Sink aSink, SinkFactory aSinkFactory, Locale aLocale) throws MavenReportException {
        if (aSink == null) {
            throw new MavenReportException("You must specify a sink.");
        }
        if (!this.canGenerateReport()) {
            this.getLog().info("This report cannot be generated as part of the current build. The report name should be referenced in this line of output.");
            return;
        }
        this.sink = aSink;
        this.sinkFactory = aSinkFactory;
        this.executeReport(aLocale);
        this.closeReport();
    }

    @Override
    public String getCategoryName() {
        return "Project Reports";
    }

    @Override
    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            this.reportOutputDirectory = new File(this.getOutputDirectory());
        }
        return this.reportOutputDirectory;
    }

    @Override
    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
        this.outputDirectory = reportOutputDirectory;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getInputEncoding() {
        return this.inputEncoding == null ? "ISO-8859-1" : this.inputEncoding;
    }

    protected String getOutputEncoding() {
        return this.outputEncoding == null ? "UTF-8" : this.outputEncoding;
    }

    protected void closeReport() {
        this.getSink().close();
    }

    public Sink getSink() {
        return this.sink;
    }

    public SinkFactory getSinkFactory() {
        return this.sinkFactory;
    }

    @Override
    public boolean isExternalReport() {
        return false;
    }

    @Override
    public boolean canGenerateReport() {
        return true;
    }

    protected abstract void executeReport(Locale var1) throws MavenReportException;
}

