/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.HashMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class UpadteUserPolicyMapping {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        try {
            MongoCollection<Document> userDBCollection = db.getCollection("USER");
            MongoCollection<Document> userBkpPolicyMapping = db.getCollection("USER_BACKUP_POLICY_MAPPING");
            MongoCollection<Document> bkPolicyColl = db.getCollection("BACKUP_POLICY");
            FindIterable<Document> users = userDBCollection.find();
            long taotalUsersCount = userDBCollection.count();
            System.out.println("Total User count : " + taotalUsersCount);
            HashMap<String, Document> policies = new HashMap<String, Document>();
            for (Document user : users) {
                Document bkpPolicyFromUser;
                if (!policies.containsKey(user.getString("policyName"))) {
                    bkpPolicyFromUser = (Document)bkPolicyColl.find(new Document("policyName", user.get("policyName"))).first();
                    policies.put(user.getString("policyName"), bkpPolicyFromUser);
                }
                if ((bkpPolicyFromUser = (Document)policies.get(user.getString("policyName"))) != null) {
                    Document userbkpMapping = (Document)userBkpPolicyMapping.find(new Document("user", new DBRef("USER", user.getObjectId("_id")))).first();
                    if (userbkpMapping != null) {
                        BasicDBObject updateFields = new BasicDBObject();
                        BasicDBObject updateQuery = new BasicDBObject();
                        updateFields.append("backupPolicy", new DBRef("BACKUP_POLICY", bkpPolicyFromUser.getObjectId("_id")));
                        updateFields.append("lastUpdatedTimeStamp", System.currentTimeMillis());
                        updateQuery.append("$set", updateFields);
                        BasicDBObject searchQuery = new BasicDBObject();
                        searchQuery.append("_id", userbkpMapping.get("_id"));
                        userBkpPolicyMapping.updateOne(searchQuery, updateQuery);
                        System.out.println("Successfuly Modified for user Name" + user.getString("userName"));
                        continue;
                    }
                    Document newBkpPolicyMapping = new Document();
                    newBkpPolicyMapping.put("user", (Object)new DBRef("USER", user.getObjectId("_id")));
                    newBkpPolicyMapping.put("backupPolicy", (Object)new DBRef("BACKUP_POLICY", bkpPolicyFromUser.getObjectId("_id")));
                    newBkpPolicyMapping.put("lastUpdatedTimeStamp", (Object)System.currentTimeMillis());
                    userBkpPolicyMapping.insertOne(newBkpPolicyMapping);
                    System.out.println("Successfuly added for :" + user.getString("userName"));
                    continue;
                }
                System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Invalid Policy " + user.get("policyName"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

