/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class MntFilesTrack {
    public static final String LOCAL = "_local";
    public static final String BACKUP_PG = "backup_pg";
    private static final String PRIVACY_GATEWAY_BACKUP = "privacy_gateway_backup_";
    public static final String PATH_SEPARATOR_ANDROID = "/";
    public static final String PATH_SEPARATOR_WINDOWS = "\\";

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String cloudName = config.getProperty("cloudName").toString();
        String deviceUUIDValue = config.getProperty("deviceUUID").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoClientURI localUri = new MongoClientURI("mongodb://neil:parablu@localhost:27017/blukrypt");
        MongoClient localclient = new MongoClient(localUri);
        MongoDatabase localDB = localclient.getDatabase(localUri.getDatabase());
        String localDBName = PRIVACY_GATEWAY_BACKUP + cloudName + LOCAL;
        System.out.println("connectivity success  ");
        MongoCollection<Document> privacyGatewayLocal = localDB.getCollection(localDBName.toUpperCase());
        MongoCollection<Document> usrCollection = db.getCollection("USER");
        MongoCollection<Document> deviceDBCollection = db.getCollection("DEVICE");
        BasicDBObject query = new BasicDBObject();
        if (!StringUtils.isEmpty(deviceUUIDValue)) {
            query = new BasicDBObject("deviceUUID", deviceUUIDValue);
        }
        FindIterable<Document> localFilesList = privacyGatewayLocal.find(query);
        int totalFileCount = 0;
        int notpressentFiles = 0;
        int deletedFiles = 0;
        for (Document localFile : localFilesList) {
            String status;
            BasicDBObject deviceQuery = new BasicDBObject("deviceUUID", localFile.getString("deviceUUID"));
            Document device = (Document)deviceDBCollection.find(deviceQuery).first();
            MongoCollection<Document> bkp = db.getCollection(device.getString("destCollection"));
            BasicDBObject andQuery = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("_id", localFile.getObjectId("_id")));
            andQuery.put("$and", whereQuery);
            int versionsCount = (int)bkp.count(andQuery);
            if (versionsCount == 0) {
                ++totalFileCount;
                ++notpressentFiles;
                System.out.println("File is not present in " + device.getString("destCollection") + " ....... " + localFile.getString("fileName") + " ande device path " + localFile.getString("filePath") + " object ID is " + localFile.getObjectId("_id"));
                continue;
            }
            Document bkpImage = (Document)bkp.find(andQuery).first();
            if (bkpImage == null || StringUtils.isEmpty(bkpImage.getString("status")) || !(status = bkpImage.getString("status")).equals("DELETED")) continue;
            ++totalFileCount;
            ++deletedFiles;
            System.out.println("File is DELETED status in " + device.getString("destCollection") + " ....... " + localFile.getString("fileName") + " ande device path " + localFile.getString("filePath") + " object ID is " + localFile.getObjectId("_id"));
        }
        System.out.println("toatl files count :" + totalFileCount + " notpressentFiles :" + notpressentFiles + " deletedFiles :" + deletedFiles);
    }
}

