/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.WriteResult;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class ConverLocalUserToNonLocal {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String userNames = config.getProperty("userNames").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        MongoCollection<Document> userBkpDBCollection = db.getCollection("USER_BKP");
        DB db1 = client.getDB("parablu001");
        DBCollection collection = db1.getCollection("USER");
        FindIterable<Document> users = userDBCollection.find();
        System.out.println("taking user collection backup in USER_BKP");
        for (Document user : users) {
            try {
                userBkpDBCollection.insertOne(user);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        System.out.println("taking user collection backup in USER_BKP is completed");
        ArrayList<String> userList = new ArrayList<String>();
        userNames = userNames.replace("[", "");
        userNames = userNames.replace("]", "");
        userList.addAll(Arrays.asList(userNames.split(",")));
        for (String userName : userList) {
            userName = userName.trim();
            System.out.println("Staring for userName " + userName);
            Document user = (Document)userDBCollection.find(new BasicDBObject("userName", userName)).first();
            if (user != null) {
                BasicDBObject query = new BasicDBObject((Map)new BasicDBObject("userName", userName));
                BasicDBObject update = new BasicDBObject();
                update.put("$unset", new BasicDBObject("passwdHash", ""));
                update.put("$set", new BasicDBObject("localUser", false));
                WriteResult update2 = collection.update(query, update);
                System.out.println("Update for userName " + userName + " is complted..." + update2.isUpdateOfExisting());
                continue;
            }
            System.out.println("userName " + userName + " not found in DB");
        }
    }
}

