/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;

public class BackupUtilsWithThread {
    private static int skipValue;
    private static TimerTask backupTimerTask;
    private static Timer timer;
    private static int count;
    int deviceuuidCount = 0;
    private static int threads;
    private static int limit;

    static {
        backupTimerTask = null;
        timer = null;
        count = 0;
    }

    public static void main(String[] args) throws Exception {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = "";
        String thread = config.getProperty("thread").toString();
        String skip = config.getProperty("skip").toString();
        String limitValue = config.getProperty("limit").toString();
        skipValue = Integer.parseInt(skip);
        limit = Integer.parseInt(limitValue);
        int threadCount = threads = Integer.parseInt(thread);
        if (config.getProperty("mongoPort") != null) {
            mongoPort = config.getProperty("mongoPort").toString();
        }
        if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
            System.out.println("mongoIP or mongo port is empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient mongo = new MongoClient(uri);
        DB parablu001DB = mongo.getDB("parablu001");
        DBCollection dbBackupCollection = parablu001DB.getCollection("BACKUP");
        int threadSizeVal = threadCount;
        ExecutorService executor = Executors.newFixedThreadPool(threadSizeVal);
        ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
        BackupUtilsWithThread.checkThreadStatusAndStartUpdate(dbBackupCollection, parablu001DB, pool);
        int i = 0;
        while (i < threadSizeVal) {
            System.out.println("Creating thread for first time>>>>>>>>> i value::");
            BackupUtilsWithThread.callUpdateDeviceUUID(dbBackupCollection, parablu001DB, pool);
            ++i;
        }
    }

    public static void checkThreadStatusAndStartUpdate(final DBCollection dbBackupCollection, final DB parablu001DB, final CompletionService<String> pool) {
        if (timer == null) {
            timer = new Timer();
        }
        if (backupTimerTask == null) {
            backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        Future future = pool.take();
                        if (future.isDone()) {
                            BackupUtilsWithThread.callUpdateDeviceUUID(dbBackupCollection, parablu001DB, pool);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            timer.schedule(backupTimerTask, 1000L, 1000L);
        }
    }

    private static void callUpdateDeviceUUID(DBCollection dbBackupCollection, DB parablu001DB, CompletionService<String> pool) {
        Runnable uploadJob = () -> {
            try {
                BackupUtilsWithThread.updateDeviceUUID(dbBackupCollection, parablu001DB);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        pool.submit(uploadJob, "");
    }

    public static synchronized int getSkipValue() {
        return ++skipValue;
    }

    public static synchronized void reduceSkip() {
        if (skipValue >= threads) {
            System.out.println("Inside Skip to 0");
            skipValue = 0;
        }
    }

    public static void updateDeviceUUID(DBCollection dbBackupCollection, DB parablu001DB) throws ConfigurationException {
        System.out.println(String.valueOf(String.valueOf(System.currentTimeMillis())) + "&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&  " + Thread.currentThread().getName());
        BasicDBObject query = new BasicDBObject("deviceUUID", new BasicDBObject("$exists", false));
        int skip = BackupUtilsWithThread.getSkipValue();
        DBCursor backupCursor = skip >= 1 ? dbBackupCollection.find(query).skip(skip * limit).limit(limit) : dbBackupCollection.find(query).limit(limit);
        HashMap<DBRef, String> deviceIdUUIdMap = new HashMap<DBRef, String>();
        System.out.println(String.valueOf(String.valueOf(Thread.currentThread().getName())) + " ..... after query ........." + System.currentTimeMillis());
        System.out.println("-----------------------------------------------" + backupCursor.size());
        while (backupCursor.hasNext()) {
            ++count;
            DBObject backupDBObject = backupCursor.next();
            System.out.println("backup object ID : " + backupDBObject.get("_id") + "....thread...." + Thread.currentThread().getName());
            DBRef deviceDBRef = (DBRef)backupDBObject.get("device");
            if (deviceDBRef == null || backupDBObject.get("deviceUUID") != null) continue;
            String deviceUUID = null;
            if (!deviceIdUUIdMap.containsKey(deviceDBRef)) {
                DBCollection deviceCollection = parablu001DB.getCollection("DEVICE");
                BasicDBObject deviceQueryFields = new BasicDBObject();
                deviceQueryFields.put("_id", deviceDBRef.getId());
                DBObject bkpDbObject = deviceCollection.findOne(deviceQueryFields);
                if (bkpDbObject != null) {
                    deviceUUID = bkpDbObject.get("deviceUUID").toString();
                    System.out.println("Device is Present and Its UUID is " + deviceUUID);
                    deviceIdUUIdMap.put(deviceDBRef, deviceUUID);
                }
            } else {
                deviceUUID = (String)deviceIdUUIdMap.get(deviceDBRef);
            }
            if (StringUtils.isEmpty(deviceUUID)) {
                deviceUUID = "DEV-NOT-FOUND-" + deviceDBRef.getId();
            }
            if (deviceUUID == null) continue;
            BasicDBObject searchQuery = new BasicDBObject();
            searchQuery.append("_id", backupDBObject.get("_id"));
            BasicDBObject updateQuery = new BasicDBObject();
            BasicDBObject updateFields = new BasicDBObject();
            updateFields.append("deviceUUID", deviceUUID);
            updateQuery.append("$set", updateFields);
            System.out.println(dbBackupCollection.update(searchQuery, updateQuery));
            System.out.println(String.valueOf(String.valueOf(skipValue)) + "deviceUUId updated successfully.." + " count value " + count);
        }
        BackupUtilsWithThread.reduceSkip();
        backupCursor.close();
        System.out.println("final skip vale :" + skipValue);
        System.out.println("finished ..................  count value " + count);
    }
}

