/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependencies.resolve.internal;

import java.util.Collection;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.apache.maven.shared.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.dependencies.resolve.DependencyResolverException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Component(role=DependencyResolver.class, hint="default")
public class DefaultDependencyResolver
implements DependencyResolver,
Contextualizable {
    private PlexusContainer container;

    @Override
    public Iterable<ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, Collection<Dependency> coordinates, Collection<Dependency> managedDependencies, TransformableFilter filter) throws DependencyResolverException {
        try {
            String hint = DefaultDependencyResolver.isMaven31() ? "maven31" : "maven3";
            DependencyResolver effectiveArtifactResolver = this.container.lookup(DependencyResolver.class, hint);
            return effectiveArtifactResolver.resolveDependencies(buildingRequest, coordinates, null, filter);
        }
        catch (ComponentLookupException e) {
            throw new DependencyResolverException(e.getMessage(), e);
        }
    }

    @Override
    public Iterable<ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, DependableCoordinate coordinate, TransformableFilter filter) throws DependencyResolverException {
        try {
            String hint = DefaultDependencyResolver.isMaven31() ? "maven31" : "maven3";
            DependencyResolver effectiveArtifactResolver = this.container.lookup(DependencyResolver.class, hint);
            return effectiveArtifactResolver.resolveDependencies(buildingRequest, coordinate, filter);
        }
        catch (ComponentLookupException e) {
            throw new DependencyResolverException(e.getMessage(), e);
        }
    }

    @Override
    public Iterable<ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, Model model, TransformableFilter filter) throws DependencyResolverException {
        try {
            String hint = DefaultDependencyResolver.isMaven31() ? "maven31" : "maven3";
            DependencyResolver effectiveArtifactResolver = this.container.lookup(DependencyResolver.class, hint);
            return effectiveArtifactResolver.resolveDependencies(buildingRequest, model, filter);
        }
        catch (ComponentLookupException e) {
            throw new DependencyResolverException(e.getMessage(), e);
        }
    }

    protected static boolean isMaven31() {
        return DefaultDependencyResolver.canFindCoreClass("org.eclipse.aether.artifact.Artifact");
    }

    private static boolean canFindCoreClass(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }
}

