/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.shared.artifact.filter.StatisticsReportingArtifactFilter;
import org.codehaus.plexus.logging.Logger;

public class PatternIncludesArtifactFilter
implements ArtifactFilter,
StatisticsReportingArtifactFilter {
    private final List<String> positivePatterns;
    private final List<String> negativePatterns;
    private final boolean actTransitively;
    private final Set<String> patternsTriggered = new HashSet<String>();
    private final List<String> filteredArtifactIds = new ArrayList<String>();

    public PatternIncludesArtifactFilter(Collection<String> patterns) {
        this(patterns, false);
    }

    public PatternIncludesArtifactFilter(Collection<String> patterns, boolean actTransitively) {
        this.actTransitively = actTransitively;
        ArrayList<String> pos = new ArrayList<String>();
        ArrayList<String> neg = new ArrayList<String>();
        if (patterns != null && !patterns.isEmpty()) {
            for (String pattern : patterns) {
                if (pattern.startsWith("!")) {
                    neg.add(pattern.substring(1));
                    continue;
                }
                pos.add(pattern);
            }
        }
        this.positivePatterns = pos;
        this.negativePatterns = neg;
    }

    @Override
    public boolean include(Artifact artifact) {
        boolean shouldInclude = this.patternMatches(artifact);
        if (!shouldInclude) {
            this.addFilteredArtifactId(artifact.getId());
        }
        return shouldInclude;
    }

    protected boolean patternMatches(Artifact artifact) {
        return this.positiveMatch(artifact) == Boolean.TRUE || this.negativeMatch(artifact) == Boolean.FALSE;
    }

    protected void addFilteredArtifactId(String artifactId) {
        this.filteredArtifactIds.add(artifactId);
    }

    private Boolean negativeMatch(Artifact artifact) {
        if (this.negativePatterns == null || this.negativePatterns.isEmpty()) {
            return null;
        }
        return this.match(artifact, this.negativePatterns);
    }

    protected Boolean positiveMatch(Artifact artifact) {
        if (this.positivePatterns == null || this.positivePatterns.isEmpty()) {
            return null;
        }
        return this.match(artifact, this.positivePatterns);
    }

    private boolean match(Artifact artifact, List<String> patterns) {
        List<String> depTrail;
        String shortId = ArtifactUtils.versionlessKey(artifact);
        String id = artifact.getDependencyConflictId();
        String wholeId = artifact.getId();
        if (this.matchAgainst(wholeId, patterns, false)) {
            return true;
        }
        if (this.matchAgainst(id, patterns, false)) {
            return true;
        }
        if (this.matchAgainst(shortId, patterns, false)) {
            return true;
        }
        if (this.actTransitively && (depTrail = artifact.getDependencyTrail()) != null && depTrail.size() > 1) {
            for (String trailItem : depTrail) {
                if (!this.matchAgainst(trailItem, patterns, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchAgainst(String value, List<String> patterns, boolean regionMatch) {
        String[] tokens = value.split(":");
        for (String pattern : patterns) {
            String[] patternTokens = pattern.split(":");
            if (patternTokens.length == 5 && tokens.length < 5) {
                if (!"*".equals(patternTokens[3])) {
                    return false;
                }
                patternTokens = new String[]{patternTokens[0], patternTokens[1], patternTokens[2], patternTokens[4]};
            }
            boolean matched = patternTokens.length <= tokens.length;
            for (int i = 0; matched && i < patternTokens.length; ++i) {
                matched = this.matches(tokens[i], patternTokens[i]);
            }
            if (!matched && patternTokens.length < tokens.length && this.isFirstPatternWildcard(patternTokens)) {
                matched = true;
                int tokenOffset = tokens.length - patternTokens.length;
                for (int i = 0; matched && i < patternTokens.length; ++i) {
                    matched = this.matches(tokens[i + tokenOffset], patternTokens[i]);
                }
            }
            if (matched) {
                this.patternsTriggered.add(pattern);
                return true;
            }
            if (!regionMatch || !value.contains(pattern)) continue;
            this.patternsTriggered.add(pattern);
            return true;
        }
        return false;
    }

    private boolean isFirstPatternWildcard(String[] patternTokens) {
        return patternTokens.length > 0 && "*".equals(patternTokens[0]);
    }

    private boolean matches(String token, String pattern) {
        boolean matches;
        if ("*".equals(pattern) || pattern.length() == 0) {
            matches = true;
        } else if (pattern.startsWith("*") && pattern.endsWith("*")) {
            String contains = pattern.substring(1, pattern.length() - 1);
            matches = token.contains(contains);
        } else if (pattern.startsWith("*")) {
            String suffix = pattern.substring(1, pattern.length());
            matches = token.endsWith(suffix);
        } else if (pattern.endsWith("*")) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            matches = token.startsWith(prefix);
        } else if (pattern.indexOf(42) > -1) {
            String[] parts = pattern.split("\\*");
            int lastPartEnd = -1;
            boolean match = true;
            for (String part : parts) {
                int idx = token.indexOf(part);
                if (idx <= lastPartEnd) {
                    match = false;
                    break;
                }
                lastPartEnd = idx + part.length();
            }
            matches = match;
        } else {
            matches = pattern.startsWith("[") || pattern.startsWith("(") ? this.isVersionIncludedInRange(token, pattern) : token.equals(pattern);
        }
        return matches;
    }

    private boolean isVersionIncludedInRange(String version, String range) {
        try {
            return VersionRange.createFromVersionSpec(range).containsVersion(new DefaultArtifactVersion(version));
        }
        catch (InvalidVersionSpecificationException e) {
            return false;
        }
    }

    @Override
    public void reportMissedCriteria(Logger logger) {
        if (!this.positivePatterns.isEmpty() || !this.negativePatterns.isEmpty()) {
            ArrayList<String> missed = new ArrayList<String>();
            missed.addAll(this.positivePatterns);
            missed.addAll(this.negativePatterns);
            missed.removeAll(this.patternsTriggered);
            if (!missed.isEmpty() && logger.isWarnEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("The following patterns were never triggered in this ");
                buffer.append(this.getFilterDescription());
                buffer.append(':');
                for (String pattern : missed) {
                    buffer.append("\no  '").append(pattern).append("'");
                }
                buffer.append("\n");
                logger.warn(buffer.toString());
            }
        }
    }

    public String toString() {
        return "Includes filter:" + this.getPatternsAsString();
    }

    protected String getPatternsAsString() {
        StringBuilder buffer = new StringBuilder();
        for (String pattern : this.positivePatterns) {
            buffer.append("\no '").append(pattern).append("'");
        }
        return buffer.toString();
    }

    protected String getFilterDescription() {
        return "artifact inclusion filter";
    }

    @Override
    public void reportFilteredArtifacts(Logger logger) {
        if (!this.filteredArtifactIds.isEmpty() && logger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder("The following artifacts were removed by this " + this.getFilterDescription() + ": ");
            for (String artifactId : this.filteredArtifactIds) {
                buffer.append('\n').append(artifactId);
            }
            logger.debug(buffer.toString());
        }
    }

    @Override
    public boolean hasMissedCriteria() {
        if (!this.positivePatterns.isEmpty() || !this.negativePatterns.isEmpty()) {
            ArrayList<String> missed = new ArrayList<String>();
            missed.addAll(this.positivePatterns);
            missed.addAll(this.negativePatterns);
            missed.removeAll(this.patternsTriggered);
            return !missed.isEmpty();
        }
        return false;
    }
}

