/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.tree;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.tree.DOTDependencyNodeVisitor;
import org.apache.maven.plugins.dependency.tree.GraphmlDependencyNodeVisitor;
import org.apache.maven.plugins.dependency.tree.TGFDependencyNodeVisitor;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.AbstractStrictPatternArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.filter.AncestorOrSelfDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.AndDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.ArtifactDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.traversal.BuildingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.FilteringDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.SerializingDependencyNodeVisitor;

@Mojo(name="tree", requiresDependencyCollection=ResolutionScope.TEST, threadSafe=true)
public class TreeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter(property="outputFile")
    private File outputFile;
    @Parameter(property="outputType", defaultValue="text")
    private String outputType;
    @Parameter(property="scope")
    private String scope;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="tokens", defaultValue="standard")
    private String tokens;
    @Parameter(property="includes")
    private String includes;
    @Parameter(property="excludes")
    private String excludes;
    private DependencyNode rootNode;
    @Parameter(property="appendOutput", defaultValue="false")
    private boolean appendOutput;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info("Skipping plugin execution");
            return;
        }
        try {
            ArtifactFilter artifactFilter = this.createResolvingArtifactFilter();
            if (this.verbose) {
                this.getLog().info("Verbose not supported since maven-dependency-plugin 3.0");
            }
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setProject(this.project);
            this.rootNode = this.dependencyGraphBuilder.buildDependencyGraph(buildingRequest, artifactFilter, this.reactorProjects);
            String dependencyTreeString = this.serializeDependencyTree(this.rootNode);
            if (this.outputFile != null) {
                DependencyUtil.write(dependencyTreeString, this.outputFile, this.appendOutput, this.getLog());
                this.getLog().info("Wrote dependency tree to: " + this.outputFile);
            } else {
                DependencyUtil.log(dependencyTreeString, this.getLog());
            }
        }
        catch (DependencyGraphBuilderException exception) {
            throw new MojoExecutionException("Cannot build project dependency graph", exception);
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Cannot serialise project dependency graph", exception);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public DependencyNode getDependencyGraph() {
        return this.rootNode;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private ArtifactFilter createResolvingArtifactFilter() {
        ScopeArtifactFilter filter;
        if (this.scope != null) {
            this.getLog().debug("+ Resolving dependency tree for scope '" + this.scope + "'");
            filter = new ScopeArtifactFilter(this.scope);
        } else {
            filter = null;
        }
        return filter;
    }

    private String serializeDependencyTree(DependencyNode theRootNode) {
        StringWriter writer = new StringWriter();
        DependencyNodeVisitor visitor = this.getSerializingDependencyNodeVisitor(writer);
        visitor = new BuildingDependencyNodeVisitor(visitor);
        DependencyNodeFilter filter = this.createDependencyNodeFilter();
        if (filter != null) {
            CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
            FilteringDependencyNodeVisitor firstPassVisitor = new FilteringDependencyNodeVisitor(collectingVisitor, filter);
            theRootNode.accept(firstPassVisitor);
            AncestorOrSelfDependencyNodeFilter secondPassFilter = new AncestorOrSelfDependencyNodeFilter(collectingVisitor.getNodes());
            visitor = new FilteringDependencyNodeVisitor(visitor, secondPassFilter);
        }
        theRootNode.accept(visitor);
        return writer.toString();
    }

    public DependencyNodeVisitor getSerializingDependencyNodeVisitor(Writer writer) {
        if ("graphml".equals(this.outputType)) {
            return new GraphmlDependencyNodeVisitor(writer);
        }
        if ("tgf".equals(this.outputType)) {
            return new TGFDependencyNodeVisitor(writer);
        }
        if ("dot".equals(this.outputType)) {
            return new DOTDependencyNodeVisitor(writer);
        }
        return new SerializingDependencyNodeVisitor(writer, this.toGraphTokens(this.tokens));
    }

    private SerializingDependencyNodeVisitor.GraphTokens toGraphTokens(String theTokens) {
        SerializingDependencyNodeVisitor.GraphTokens graphTokens;
        if ("whitespace".equals(theTokens)) {
            this.getLog().debug("+ Using whitespace tree tokens");
            graphTokens = SerializingDependencyNodeVisitor.WHITESPACE_TOKENS;
        } else if ("extended".equals(theTokens)) {
            this.getLog().debug("+ Using extended tree tokens");
            graphTokens = SerializingDependencyNodeVisitor.EXTENDED_TOKENS;
        } else {
            graphTokens = SerializingDependencyNodeVisitor.STANDARD_TOKENS;
        }
        return graphTokens;
    }

    private DependencyNodeFilter createDependencyNodeFilter() {
        AbstractStrictPatternArtifactFilter artifactFilter;
        List<String> patterns;
        ArrayList<DependencyNodeFilter> filters = new ArrayList<DependencyNodeFilter>();
        if (this.includes != null) {
            patterns = Arrays.asList(this.includes.split(","));
            this.getLog().debug("+ Filtering dependency tree by artifact include patterns: " + patterns);
            artifactFilter = new StrictPatternIncludesArtifactFilter(patterns);
            filters.add(new ArtifactDependencyNodeFilter(artifactFilter));
        }
        if (this.excludes != null) {
            patterns = Arrays.asList(this.excludes.split(","));
            this.getLog().debug("+ Filtering dependency tree by artifact exclude patterns: " + patterns);
            artifactFilter = new StrictPatternExcludesArtifactFilter(patterns);
            filters.add(new ArtifactDependencyNodeFilter(artifactFilter));
        }
        return filters.isEmpty() ? null : new AndDependencyNodeFilter(filters);
    }

    public static boolean containsVersion(VersionRange allowedRange, ArtifactVersion theVersion) {
        ArtifactVersion recommendedVersion = allowedRange.getRecommendedVersion();
        if (recommendedVersion == null) {
            List<Restriction> restrictions = allowedRange.getRestrictions();
            for (Restriction restriction : restrictions) {
                if (!restriction.containsVersion(theVersion)) continue;
                return true;
            }
        }
        return recommendedVersion.compareTo(theVersion) <= 0;
    }
}

