/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.Block;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class ODBChunkTracking {
    static Map<String, Integer> chunkMap = new HashMap<String, Integer>();
    static int count = 0;
    static Block<Document> doWork = new Block<Document>(){

        @Override
        public void apply(Document document) {
            if (chunkMap.containsKey(document.getString("_id"))) {
                int chunkCount = chunkMap.get(document.getString("_id")) + document.getInteger("count");
                chunkMap.put(document.getString("_id"), chunkCount);
            } else {
                chunkMap.put(document.getString("_id"), document.getInteger("count"));
            }
        }
    };

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        while (count < 101) {
            MongoCollection<Document> chunkCollection = db.getCollection("CHUNK_DETAIL_" + count);
            chunkCollection.aggregate(Arrays.asList(Aggregates.group("$cloudStoragePath", Accumulators.sum("count", 1)))).forEach(doWork);
            ++count;
        }
        System.out.println("source path , chunkName , destPath");
        int totalExtra = 0;
        int destFolder = 570;
        for (Map.Entry<String, Integer> entry : chunkMap.entrySet()) {
            if (entry.getValue() <= 5000) continue;
            int total = 5000 - entry.getValue();
            System.out.println(String.valueOf(entry.getKey()) + "," + total);
            totalExtra += total;
        }
        System.out.println("GRAND TOTAL :" + totalExtra);
    }

    private String convertStringTOBase64(String name) {
        String base64EncodeString = null;
        if (name != null) {
            byte[] bytes = DigestUtils.md5(name);
            byte[] bytesEncoded = Base64.encodeBase64(bytes);
            base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
        }
        return base64EncodeString;
    }
}

