/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import Utility.com.parablu.HttpClientUtil;
import Utility.com.parablu.Office365;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.util.JSON;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.PciAuthorizationTokenElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.bson.Document;

public class ODBCheckFileExists {
    private static final String PERSONAL_URL = "/personal/";
    private static final String BEARER = "Bearer ";
    public static final String HEADER_KEY_ACCEPT = "Accept";
    public static final String HEADER_VALUE_APPLICATION_JSON = "application/json;odata=verbose";
    public static final String HEADER_KEY_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_KEY_GATEWAY_TYPE = "gatewayType";
    private static final int BUFFER_CHUNK_SIZE = 1024;

    public static void main(String[] args) throws ConfigurationException, JsonParseException, JsonMappingException, IOException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String deviceUUID = config.getProperty("deviceUUID").toString();
        int chunkCollCount = Integer.parseInt(config.getProperty("chunkCollCount").toString());
        boolean oldVersion = Boolean.parseBoolean(config.getProperty("oldVersion").toString());
        if (StringUtils.isEmpty(mongoIP)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        andQuery.put("$and", whereQuery);
        Document device = (Document)deviceColl.find(andQuery).first();
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        MongoCollection<Document> bkpColl = db.getCollection(device.getString("destCollection"));
        Document userDBObject = null;
        if (oldVersion) {
            DBRef useRef = (DBRef)device.get("user");
            userDBObject = (Document)userDBCollection.find(new Document("_id", useRef.getId())).first();
        } else {
            userDBObject = (Document)userDBCollection.find(new Document("userName", device.getString("userName"))).first();
        }
        String userName = userDBObject.getString("userName");
        String userODBID = "";
        userODBID = !StringUtils.isEmpty(userDBObject.getString("odbLoginId")) ? userDBObject.getString("odbLoginId") : userDBObject.getString("emailId");
        ObjectMapper mapper = new ObjectMapper();
        MongoCollection<Document> tokenCollection = db.getCollection("PCI_AUTHORIZATION_TOKENS");
        Document tokenDoc = (Document)tokenCollection.find().first();
        PciAuthorizationTokenElement pciAuthorizationTokenElement = new PciAuthorizationTokenElement();
        pciAuthorizationTokenElement.setAccessToken(tokenDoc.getString("accessToken"));
        pciAuthorizationTokenElement.setAccountId(userODBID);
        pciAuthorizationTokenElement.setAuthenticationToken(tokenDoc.getString("authenticationToken"));
        pciAuthorizationTokenElement.setClientId(tokenDoc.getString("clientId"));
        pciAuthorizationTokenElement.setSharePointUrl(tokenDoc.getString("sharePointUrl"));
        pciAuthorizationTokenElement.setClientSecret(tokenDoc.getString("clientSecret"));
        pciAuthorizationTokenElement.setCloudName(tokenDoc.getString("cloudName"));
        pciAuthorizationTokenElement.setEmailId(userODBID);
        pciAuthorizationTokenElement.setRefreshToken(tokenDoc.getString("refreshToken"));
        List<Document> allFoldersList = ODBCheckFileExists.getFolderList(deviceUUID, bkpColl);
        int fileCount = 0;
        int failedFilesCount = 0;
        for (Document folder : allFoldersList) {
            String folderName = "";
            folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
            andQuery = new BasicDBObject();
            whereQuery = new ArrayList();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            whereQuery.add(new BasicDBObject("folder", false));
            whereQuery.add(new BasicDBObject("present", true));
            whereQuery.add(new BasicDBObject("devicePath", folderName));
            andQuery.put("$and", whereQuery);
            FindIterable<Document> files = bkpColl.find(andQuery);
            ArrayList<BackUpImage> allFilesList = new ArrayList<BackUpImage>();
            for (Document document : files) {
                String json = JSON.serialize(document);
                BackUpImage backUpImage = new BackUpImage();
                backUpImage = mapper.readValue(json, BackUpImage.class);
                if (StringUtils.isEmpty(backUpImage.getDevicePath()) || StringUtils.isEmpty(backUpImage.getFileName())) continue;
                allFilesList.add(backUpImage);
            }
            List<BackUpImage> list = ODBCheckFileExists.getFilteredBackupImageList(allFilesList);
            for (BackUpImage image : list) {
                if (StringUtils.isNotEmpty(image.getStoragePlace()) && !CollectionUtils.isEmpty(image.getChunkFiles())) {
                    try {
                        System.out.println("............stared for files " + image.getDevicePath() + "....." + image.getFileName() + ".....count...." + fileCount + "........." + System.currentTimeMillis());
                        ++fileCount;
                        boolean chunkFailed = false;
                        for (ChunkFile chunk : image.getChunkFiles()) {
                            if (chunk == null || !StringUtils.isNotEmpty(chunk.getMd5())) continue;
                            String chunkMD5 = chunk.getMd5();
                            ChunkFile chunkFromChunkDetail = ODBCheckFileExists.getChunkFiles(chunkMD5, db, chunkCollCount, userName);
                            if (chunkFromChunkDetail != null) {
                                int resposeCode;
                                if (chunkMD5.equalsIgnoreCase("e6e1ca2cb323c35ed29c37e9831359ba")) {
                                    System.out.println(".... md5..... " + chunk.toString());
                                }
                                if ((resposeCode = ODBCheckFileExists.downloadFileFromOneDrive(pciAuthorizationTokenElement, chunkFromChunkDetail.getFileName(), chunkFromChunkDetail, deviceUUID, userDBObject, oldVersion, image.getFileName())) != 200) {
                                    chunkFailed = true;
                                    System.out.println("##################### ERROR.........." + resposeCode + "........" + image.getDevicePath() + ".....AND FILE NAME..." + image.getFileName() + "..." + chunk.toString());
                                } else if (resposeCode == 200) {
                                    chunkFailed = false;
                                }
                            }
                            if (chunkFailed) {
                                ++failedFilesCount;
                            }
                            if (chunkFailed) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (fileCount % 1000 != 0) continue;
                System.out.println("######### processed.. " + failedFilesCount + " / " + fileCount);
            }
            System.out.println("######### failed files / proccess " + failedFilesCount + " / " + fileCount);
        }
    }

    private static ChunkFile getChunkFiles(String md5, MongoDatabase db, int chunkCollCount, String userName) {
        MongoCollection<Document> chunkColl = db.getCollection("CHUNK_DETAIL");
        ChunkFile chunkFile = null;
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("md5", md5));
        whereQuery.add(new BasicDBObject("userName", userName));
        andQuery.put("$and", whereQuery);
        Document chunk = null;
        try (MongoCursor cursor = chunkColl.find(andQuery).limit(1).iterator();){
            if (cursor.hasNext()) {
                Document next;
                chunk = next = (Document)cursor.next();
            }
        }
        if (chunk == null) {
            int hashCode = Arrays.hashCode(md5.getBytes());
            int chunkDetailDest = Math.abs(hashCode % chunkCollCount);
            chunkColl = db.getCollection("CHUNK_DETAIL_" + chunkDetailDest);
            try (MongoCursor cursor1 = chunkColl.find(andQuery).limit(1).iterator();){
                if (cursor1.hasNext()) {
                    Document next;
                    chunk = next = (Document)cursor1.next();
                }
            }
        }
        if (chunk != null) {
            chunkFile = new ChunkFile();
            chunkFile.setCloudStoragePath(chunk.getString("cloudStoragePath"));
            chunkFile.setFileName(chunk.getString("cloudChunkName"));
            chunkFile.setMd5(chunk.getString("md5"));
        }
        return chunkFile;
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    private static List<Document> getFolderList(String deviceUUID, MongoCollection bkpColl) {
        FindIterable folders;
        ArrayList<Document> allFoldersList = new ArrayList<Document>();
        int skip = 0;
        System.out.println("getting folders................");
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery.add(new BasicDBObject("folder", true));
        whereQuery.add(new BasicDBObject("present", true));
        andQuery.put("$and", whereQuery);
        while ((folders = bkpColl.find(andQuery).skip(skip * 500).limit(500)).first() != null) {
            for (Document document : folders) {
                allFoldersList.add(document);
            }
            ++skip;
        }
        System.out.println("Done folders   " + allFoldersList.size() + " for deviceUUID " + deviceUUID);
        return allFoldersList;
    }

    private static String convertStringTOBase64(String name) {
        String base64EncodeString = null;
        if (name != null) {
            byte[] bytes = DigestUtils.md5(name);
            byte[] bytesEncoded = Base64.encodeBase64(bytes);
            base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
            base64EncodeString = base64EncodeString.replaceAll("/", "_");
        }
        return base64EncodeString;
    }

    private static int downloadFileFromOneDrive(PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID, Document userDBObject, boolean oldVersion, String bkpFileName) {
        block11: {
            int responseCode;
            String fileNameTemp;
            block10: {
                fileNameTemp = fileName;
                if (fileName.equalsIgnoreCase("e6e1ca2cb323c35ed29c37e9831359ba.59ad1f49e4b0a48286d37f13")) {
                    System.out.println("... file name before .... " + fileNameTemp);
                }
                fileNameTemp = ODBCheckFileExists.convertStringTOBase64(fileNameTemp);
                if (fileName.equalsIgnoreCase("e6e1ca2cb323c35ed29c37e9831359ba.59ad1f49e4b0a48286d37f13")) {
                    System.out.println("... file name after .... " + fileNameTemp);
                }
                String pbFolderName = "PB";
                String userNameInPath = "";
                String downloadurl = ODBCheckFileExists.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileNameTemp, authorizationTokenElement.getAccountId(), userNameInPath, chunkFile.getCloudStoragePath(), pbFolderName);
                if (fileName.equalsIgnoreCase("e6e1ca2cb323c35ed29c37e9831359ba.59ad1f49e4b0a48286d37f13")) {
                    System.out.println("... file name downloadurl .... " + downloadurl);
                }
                HttpGet httpGet = new HttpGet(downloadurl);
                httpGet.addHeader("Authorization", BEARER + authorizationTokenElement.getAccessToken());
                httpGet.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
                httpGet.addHeader(HEADER_KEY_CONTENT_TYPE, "*/*");
                HttpResponse result = null;
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                int timeout = 3;
                System.out.println("url ........." + downloadurl + "............start time stamp ....." + System.currentTimeMillis());
                RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
                httpGet.setConfig(config);
                result = httpclient.execute(httpGet);
                responseCode = result.getStatusLine().getStatusCode();
                System.out.println(String.valueOf(responseCode) + "..................response timestamp.................." + System.currentTimeMillis());
                if (responseCode != 200) break block10;
                return 200;
            }
            try {
                if (responseCode == 401) {
                    Office365.getAccessToken(authorizationTokenElement);
                    if (authorizationTokenElement != null) {
                        if (authorizationTokenElement.isServiceAcct()) {
                            authorizationTokenElement.setServiceAcct(true);
                        }
                        return ODBCheckFileExists.retryDownloadFileFromOneDrive(authorizationTokenElement, fileNameTemp, chunkFile, deviceUUID, userDBObject, oldVersion);
                    }
                    break block11;
                }
                if (responseCode == 404) {
                    return ODBCheckFileExists.retryDownloadFileFromOneDrive(authorizationTokenElement, fileNameTemp, chunkFile, deviceUUID, userDBObject, oldVersion);
                }
                System.out.println("..............Download statuse code" + responseCode + "...................");
                return ODBCheckFileExists.retryDownloadFileFromOneDrive(authorizationTokenElement, fileNameTemp, chunkFile, deviceUUID, userDBObject, oldVersion);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 1;
    }

    public static int retryDownloadFileFromOneDrive(PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID, Document userDBObject, boolean oldVersion) {
        boolean retry;
        String pbFolderName = "PB";
        String userNameInPath = "";
        String downloadurl = ODBCheckFileExists.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), userNameInPath, chunkFile.getCloudStoragePath(), pbFolderName);
        String originalPath = chunkFile.getCloudStoragePath();
        boolean incrementPath = false;
        boolean decrementPath = false;
        boolean newPathCheck = false;
        boolean oldStylePath = false;
        boolean customOldStylePath = false;
        boolean increOldStylePath = false;
        boolean decreOldStylePath = false;
        boolean newPathCheckOnly = false;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 5000L * (long)sleepMultiplier;
        int responseCode = 0;
        do {
            retry = false;
            HttpGet httpGet = null;
            String modifiedPath = chunkFile.getCloudStoragePath();
            try {
                int path;
                String cloudPath;
                httpGet = new HttpGet(downloadurl);
                httpGet.addHeader("Authorization", BEARER + authorizationTokenElement.getAccessToken());
                httpGet.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
                httpGet.addHeader(HEADER_KEY_CONTENT_TYPE, "*/*");
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                int timeout = 3;
                RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
                httpGet.setConfig(config);
                HttpResponse result = httpclient.execute(httpGet);
                responseCode = result.getStatusLine().getStatusCode();
                System.out.println("Retry Response status code: " + responseCode + " ...Download Path ...." + downloadurl);
                if (responseCode == 200) {
                    return responseCode;
                }
                if (responseCode == 401) {
                    retry = true;
                    ++retryCount;
                    sleepTime = ODBCheckFileExists.sleepForGivenTime(sleepTime);
                    authorizationTokenElement = Office365.getAccessToken(authorizationTokenElement);
                    continue;
                }
                if (responseCode == 200) continue;
                retry = true;
                ++retryCount;
                sleepTime = responseCode != 404 ? ODBCheckFileExists.sleepForGivenTime(sleepTime) : 0L;
                if (responseCode != 404) continue;
                if (!increOldStylePath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = ODBCheckFileExists.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), "", cloudPath, pbFolderName);
                    modifiedPath = cloudPath;
                    increOldStylePath = true;
                    continue;
                }
                if (!newPathCheckOnly && ODBCheckFileExists.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    cloudPath = "" + ODBCheckFileExists.getRetryOdbFolderValue();
                    downloadurl = ODBCheckFileExists.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), userNameInPath, cloudPath, pbFolderName);
                    newPathCheckOnly = true;
                    modifiedPath = cloudPath;
                    continue;
                }
                if (!newPathCheck && ODBCheckFileExists.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + ODBCheckFileExists.getRetryOdbFolderValue());
                    }
                    downloadurl = ODBCheckFileExists.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), userNameInPath, cloudPath, pbFolderName);
                    newPathCheck = true;
                    modifiedPath = cloudPath;
                    continue;
                }
                if (!decrementPath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path - 1);
                    }
                    downloadurl = ODBCheckFileExists.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), userNameInPath, cloudPath, pbFolderName);
                    decrementPath = true;
                    modifiedPath = cloudPath;
                    continue;
                }
                if (!incrementPath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = ODBCheckFileExists.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), userNameInPath, cloudPath, pbFolderName);
                    modifiedPath = cloudPath;
                    incrementPath = true;
                    continue;
                }
                if (!oldStylePath) {
                    downloadurl = ODBCheckFileExists.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), "", chunkFile.getCloudStoragePath(), pbFolderName);
                    oldStylePath = true;
                    continue;
                }
                if (!customOldStylePath && ODBCheckFileExists.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + ODBCheckFileExists.getRetryOdbFolderValue());
                    }
                    downloadurl = ODBCheckFileExists.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), "", cloudPath, pbFolderName);
                    customOldStylePath = true;
                    modifiedPath = cloudPath;
                    continue;
                }
                if (decreOldStylePath) continue;
                cloudPath = chunkFile.getCloudStoragePath();
                if (StringUtils.isNotEmpty(cloudPath)) {
                    path = Integer.parseInt(cloudPath);
                    cloudPath = "" + (path - 1);
                }
                downloadurl = ODBCheckFileExists.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), "", cloudPath, pbFolderName);
                decreOldStylePath = true;
                modifiedPath = cloudPath;
            }
            catch (Exception e) {
                retry = true;
                ++retryCount;
                sleepTime = ODBCheckFileExists.sleepForGivenTime(sleepTime);
                e.printStackTrace();
            }
        } while (retry && retryCount < 8);
        return responseCode;
    }

    public static String getLibraryDownloadUrl(String office365baseUrl, String fileName, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(office365baseUrl) + personalUrl + ODBCheckFileExists.getEmailId(accountId) + "/_api/web/GetFolderByServerRelativeUrl('" + personalUrl + ODBCheckFileExists.getEmailId(accountId) + "/" + pbFolderName + "/" + userName + "/" + suffixFolderPath + "')" + "/Files('" + fileName + "')/$value";
    }

    private static String getEmailId(String emailId) {
        String replacedEmailId = emailId.replace(".", "_");
        replacedEmailId = replacedEmailId.replace("@", "_");
        return replacedEmailId;
    }

    private static int getRetryOdbFolderValue() {
        return 2000;
    }

    private static long sleepForGivenTime(long sleepTime) {
        long sleepTimeTemp = sleepTime;
        try {
            Thread.sleep(sleepTimeTemp);
            int sleepMultiplier = 2;
            sleepTimeTemp *= (long)sleepMultiplier;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return sleepTimeTemp;
    }

    public static String getParabluLibraryUrl(String office365baseUrl, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = ODBCheckFileExists.getPersonalSite(office365baseUrl, accountId);
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(personalSite) + "/_api/web/GetFolderByServerRelativeUrl('" + personalUrl + ODBCheckFileExists.getEmailId(accountId) + "/" + pbFolderName + userName + "/" + suffixFolderPath + "/')";
    }

    public static String getPersonalSite(String office365baseUrl, String accountId) {
        if (accountId.contains("sites/")) {
            return String.valueOf(office365baseUrl) + "/" + ODBCheckFileExists.getEmailId(accountId);
        }
        return String.valueOf(office365baseUrl) + PERSONAL_URL + ODBCheckFileExists.getEmailId(accountId);
    }

    private static String checkOneDriveStoragePath(String cloudName, String userName, boolean isSync, String userCloudStoragePath) {
        String cloudStoragePath = "1";
        if (isSync) {
            if (!StringUtils.isEmpty(userCloudStoragePath)) {
                cloudStoragePath = userCloudStoragePath;
            }
        } else if (!StringUtils.isEmpty(userCloudStoragePath)) {
            cloudStoragePath = userCloudStoragePath;
        }
        if (StringUtils.isEmpty(cloudStoragePath)) {
            cloudStoragePath = "1";
        }
        return cloudStoragePath;
    }
}

