/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class GlobleExclusionFix {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        boolean isWindows = Boolean.parseBoolean(config.getProperty("windows").toString());
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> userExcludedFoldersDBCollection = db.getCollection("USER_EXCLUDED_FOLDERS");
        MongoCollection<Document> bkpPolicyDBCollection = db.getCollection("BACKUP_POLICY");
        MongoCollection<Document> globalExclodedDBCollection = db.getCollection("GLOBAL_EXCLUDED_FOLDERS");
        BasicDBObject query = new BasicDBObject("userExcludedFolders", new BasicDBObject("$exists", true));
        FindIterable<Document> policyList = bkpPolicyDBCollection.find(query);
        for (Document policy : policyList) {
            if (policy.get("userExcludedFolders") == null) continue;
            List userExcludedFoldersList = (List)policy.get("userExcludedFolders");
            ArrayList<DBRef> removeableList = new ArrayList<DBRef>();
            for (DBRef userExcludedFolder : userExcludedFoldersList) {
                Document globleFolder;
                Document userExcludedFolders = (Document)userExcludedFoldersDBCollection.find(new BasicDBObject("_id", userExcludedFolder.getId())).first();
                if (userExcludedFolders == null || (globleFolder = (Document)globalExclodedDBCollection.find(new BasicDBObject("folderPath", userExcludedFolders.getString("folderPath"))).first()) == null) continue;
                removeableList.add(userExcludedFolder);
            }
            if (!CollectionUtils.isEmpty(removeableList)) {
                System.out.println("Folder before " + userExcludedFoldersList.size());
                userExcludedFoldersList.removeAll(removeableList);
                System.out.println("Folder after " + userExcludedFoldersList.size());
            }
            BasicDBObject bkpPolicySearchQuery = new BasicDBObject();
            bkpPolicySearchQuery.append("_id", policy.get("_id"));
            BasicDBObject bkpPolicydUpdateFields = new BasicDBObject();
            bkpPolicydUpdateFields.append("userExcludedFolders", userExcludedFoldersList);
            BasicDBObject updatebkpPolicyQuery = new BasicDBObject();
            updatebkpPolicyQuery.append("$set", bkpPolicydUpdateFields);
            bkpPolicyDBCollection.updateOne(bkpPolicySearchQuery, updatebkpPolicyQuery);
        }
        if (isWindows) {
            globalExclodedDBCollection.deleteMany(new BasicDBObject());
            System.out.println("In GLOBAL_EXCLUDED_FOLDERS windows folder is removed....");
            Document doc = new Document();
            doc.put("osType", (Object)"win");
            doc.put("folderPath", (Object)"{user.home}\\appdata");
            globalExclodedDBCollection.insertOne(doc);
            doc = new Document();
            doc.put("osType", (Object)"win");
            doc.put("folderPath", (Object)"c:\\$Recycle.Bin");
            globalExclodedDBCollection.insertOne(doc);
            doc = new Document();
            doc.put("osType", (Object)"win");
            doc.put("folderPath", (Object)"d:\\$Recycle.Bin");
            globalExclodedDBCollection.insertOne(doc);
            doc = new Document();
            doc.put("osType", (Object)"win");
            doc.put("folderPath", (Object)"e:\\$Recycle.Bin");
            globalExclodedDBCollection.insertOne(doc);
            doc = new Document();
            doc.put("osType", (Object)"win");
            doc.put("folderPath", (Object)"f:\\$Recycle.Bin");
            globalExclodedDBCollection.insertOne(doc);
            doc = new Document();
            doc.put("osType", (Object)"win");
            doc.put("folderPath", (Object)"g:\\$Recycle.Bin");
            globalExclodedDBCollection.insertOne(doc);
            BasicDBObject query1 = new BasicDBObject("osType", "win");
            FindIterable<Document> globleList = globalExclodedDBCollection.find(query1);
            BasicDBObject query2 = new BasicDBObject("osType", "windows");
            FindIterable<Document> policyList1 = bkpPolicyDBCollection.find(query2);
            for (Document pol : policyList1) {
                ArrayList<DBRef> userExcludedFoldersList = (ArrayList<DBRef>)pol.get("userExcludedFolders");
                if (userExcludedFoldersList == null) {
                    userExcludedFoldersList = new ArrayList<DBRef>();
                }
                for (Document excludedFolderDoc : globleList) {
                    DBRef dbRef = new DBRef("USER_EXCLUDED_FOLDERS", excludedFolderDoc.getObjectId("_id"));
                    if (userExcludedFoldersDBCollection.count(new BasicDBObject("folderPath", excludedFolderDoc.getString("folderPath"))) == 0L) {
                        Document userExcluderFolders = new Document();
                        doc.put("_id", (Object)excludedFolderDoc.getObjectId("_id"));
                        doc.put("folderPath", (Object)excludedFolderDoc.getString("folderPath"));
                        userExcludedFoldersDBCollection.insertOne(doc);
                    } else {
                        Document dd = (Document)userExcludedFoldersDBCollection.find(new BasicDBObject("folderPath", excludedFolderDoc.getString("folderPath"))).first();
                        dbRef = new DBRef("USER_EXCLUDED_FOLDERS", dd.getObjectId("_id"));
                    }
                    userExcludedFoldersList.add(dbRef);
                }
                BasicDBObject bkpPolicySearchQuery = new BasicDBObject();
                bkpPolicySearchQuery.append("_id", pol.get("_id"));
                BasicDBObject bkpPolicydUpdateFields = new BasicDBObject();
                bkpPolicydUpdateFields.append("userExcludedFolders", userExcludedFoldersList);
                BasicDBObject updatebkpPolicyQuery = new BasicDBObject();
                updatebkpPolicyQuery.append("$set", bkpPolicydUpdateFields);
                bkpPolicyDBCollection.updateOne(bkpPolicySearchQuery, updatebkpPolicyQuery);
            }
        }
    }
}

