/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class ChunksCleaning {
    private TimerTask backupTimerTask = null;
    private Timer backupTimer = null;

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String chunkCollName = config.getProperty("chunkCollName").toString();
        String bkpCollName = config.getProperty("bkpCollName").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> chunksDBCollection = db.getCollection(chunkCollName.toUpperCase());
        MongoCollection<Document> bkpDBCollection = db.getCollection(bkpCollName.toUpperCase());
        BasicDBObject query = new BasicDBObject("newRef", new BasicDBObject("$exists", false));
        FindIterable<Document> chunksList = chunksDBCollection.find(query).limit(2000);
        do {
            int loopCount = ChunksCleaning.updateTheRef(chunksDBCollection, bkpDBCollection, query, chunksList);
            System.out.println(".....LoopCount ..........:" + loopCount);
        } while ((chunksList = chunksDBCollection.find(query).limit(2000)) != null);
    }

    private static int updateTheRef(MongoCollection chunksDBCollection, MongoCollection bkpDBCollection, BasicDBObject query, FindIterable<Document> chunksList) {
        int loopCount = 0;
        int succesChunksCount = 0;
        int failedchunksCount = 0;
        long chunksCompleted = chunksDBCollection.count(query);
        for (Document chunk : chunksList) {
            ++chunksCompleted;
            BasicDBObject chunkSearchQuery = new BasicDBObject();
            chunkSearchQuery.append("_id", chunk.get("_id"));
            if (!StringUtils.isEmpty(chunk.getString("md5"))) {
                BasicDBObject updateChunkQuery;
                BasicDBObject chunkUpdateQuey;
                BasicDBObject andQuery = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                whereQuery.add(new BasicDBObject("chunkFiles.md5", chunk.getString("md5")));
                andQuery.put("$and", whereQuery);
                Document bkpFile = (Document)bkpDBCollection.find(andQuery).limit(1).first();
                if (bkpFile == null) {
                    chunkUpdateQuey = new BasicDBObject();
                    chunkUpdateQuey.append("newRef", false);
                    updateChunkQuery = new BasicDBObject();
                    updateChunkQuery.append("$set", chunkUpdateQuey);
                    chunksDBCollection.updateOne(chunkSearchQuery, updateChunkQuery);
                    System.out.println(".....CHUNK NOT FOUND ..........succesChunksCount : " + succesChunksCount + "....failedchunksCount :" + ++failedchunksCount + ".......chunksCompleted :" + chunksCompleted);
                    continue;
                }
                chunkUpdateQuey = new BasicDBObject();
                chunkUpdateQuey.append("newRef", true);
                updateChunkQuery = new BasicDBObject();
                updateChunkQuery.append("$set", chunkUpdateQuey);
                chunksDBCollection.updateOne(chunkSearchQuery, updateChunkQuery);
                System.out.println(".....CHUNK FOUND ..........succesChunksCount : " + ++succesChunksCount + "....failedchunksCount :" + failedchunksCount + ".......chunksCompleted :" + chunksCompleted);
                continue;
            }
            BasicDBObject chunkUpdateQuey = new BasicDBObject();
            chunkUpdateQuey.append("newRef", false);
            BasicDBObject updateChunkQuery = new BasicDBObject();
            updateChunkQuery.append("$set", chunkUpdateQuey);
            chunksDBCollection.updateOne(chunkSearchQuery, updateChunkQuery);
            System.out.println(".....CHUNK NOT FOUND ..........succesChunksCount : " + succesChunksCount + "....failedchunksCount :" + ++failedchunksCount + ".......chunksCompleted :" + chunksCompleted);
        }
        return loopCount;
    }

    public void checkThreadStatusAndStartUpload(ExecutorService executor, final CompletionService<String> pool) {
        if (this.backupTimer == null) {
            this.backupTimer = new Timer();
        }
        if (this.backupTimerTask == null) {
            this.backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        Future future = pool.take();
                        future.isDone();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            this.backupTimer.schedule(this.backupTimerTask, 1000L, 1000L);
        }
    }
}

