/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator.validwhen;

import java.io.StringReader;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.Resources;
import org.apache.struts.validator.validwhen.ValidWhenLexer;
import org.apache.struts.validator.validwhen.ValidWhenParser;

public class ValidWhen {
    private static final Log log = LogFactory.getLog(ValidWhen.class);
    private static MessageResources sysmsgs = MessageResources.getMessageResources("org.apache.struts.validator.LocalStrings");

    private static boolean isString(Object obj) {
        return obj == null ? true : String.class.isInstance(obj);
    }

    public static boolean validateValidWhen(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Object form = validator.getParameterValue("java.lang.Object");
        String value = null;
        boolean valid = false;
        int index = -1;
        if (field.isIndexed()) {
            String key = field.getKey();
            int leftBracket = key.indexOf("[");
            int rightBracket = key.indexOf("]");
            if (leftBracket > -1 && rightBracket > -1) {
                index = Integer.parseInt(key.substring(leftBracket + 1, rightBracket));
            }
        }
        value = ValidWhen.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString(bean, field.getProperty());
        String test2 = null;
        try {
            test2 = Resources.getVarValue("test", field, validator, request, true);
        }
        catch (IllegalArgumentException ex) {
            String logErrorMsg = sysmsgs.getMessage("validation.failed", (Object)"validwhen", (Object)field.getProperty(), (Object)ex.toString());
            log.error(logErrorMsg);
            String userErrorMsg = sysmsgs.getMessage("system.error");
            errors.add(field.getKey(), new ActionMessage(userErrorMsg, false));
            return false;
        }
        ValidWhenLexer lexer = null;
        try {
            lexer = new ValidWhenLexer(new StringReader(test2));
        }
        catch (Exception ex) {
            String logErrorMsg = "ValidWhenLexer Error for field ' " + field.getKey() + "' - " + ex;
            log.error(logErrorMsg);
            String userErrorMsg = sysmsgs.getMessage("system.error");
            errors.add(field.getKey(), new ActionMessage(userErrorMsg, false));
            return false;
        }
        ValidWhenParser parser = null;
        try {
            parser = new ValidWhenParser(lexer);
        }
        catch (Exception ex) {
            String logErrorMsg = "ValidWhenParser Error for field ' " + field.getKey() + "' - " + ex;
            log.error(logErrorMsg);
            String userErrorMsg = sysmsgs.getMessage("system.error");
            errors.add(field.getKey(), new ActionMessage(userErrorMsg, false));
            return false;
        }
        parser.setForm(form);
        parser.setIndex(index);
        parser.setValue(value);
        try {
            parser.expression();
            valid = parser.getResult();
        }
        catch (Exception ex) {
            String logErrorMsg = "ValidWhen Error for field ' " + field.getKey() + "' - " + ex;
            log.error(logErrorMsg);
            String userErrorMsg = sysmsgs.getMessage("system.error");
            errors.add(field.getKey(), new ActionMessage(userErrorMsg, false));
            return false;
        }
        if (!valid) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
            return false;
        }
        return true;
    }
}

