/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.AbstractDependencyMojo;
import org.apache.maven.shared.dependencies.collect.CollectorResult;
import org.apache.maven.shared.dependencies.collect.DependencyCollector;
import org.apache.maven.shared.dependencies.collect.DependencyCollectorException;

@Mojo(name="list-repositories", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ListRepositoriesMojo
extends AbstractDependencyMojo {
    @Component(role=DependencyCollector.class)
    private DependencyCollector dependencyCollector;

    @Override
    protected void doExecute() throws MojoExecutionException {
        try {
            CollectorResult collectResult = this.dependencyCollector.collectDependencies(this.session.getProjectBuildingRequest(), this.getProject().getModel());
            this.getLog().info("Repositories used by this build:");
            for (ArtifactRepository repo : collectResult.getRemoteRepositories()) {
                this.getLog().info(repo.toString());
            }
        }
        catch (DependencyCollectorException e) {
            throw new MojoExecutionException("Unable to resolve artifacts", e);
        }
    }
}

