/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Set;
import org.apache.maven.InternalErrorException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.LifecycleDebugLogger;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=BuilderCommon.class)
public class BuilderCommon {
    @Requirement
    private LifecycleDebugLogger lifecycleDebugLogger;
    @Requirement
    private LifecycleExecutionPlanCalculator lifeCycleExecutionPlanCalculator;
    @Requirement
    private ExecutionEventCatapult eventCatapult;
    @Requirement
    private Logger logger;

    public BuilderCommon() {
    }

    public BuilderCommon(LifecycleDebugLogger lifecycleDebugLogger, LifecycleExecutionPlanCalculator lifeCycleExecutionPlanCalculator, Logger logger) {
        this.lifecycleDebugLogger = lifecycleDebugLogger;
        this.lifeCycleExecutionPlanCalculator = lifeCycleExecutionPlanCalculator;
        this.logger = logger;
    }

    public MavenExecutionPlan resolveBuildPlan(MavenSession session, MavenProject project, TaskSegment taskSegment, Set<Artifact> projectArtifacts) throws PluginNotFoundException, PluginResolutionException, LifecyclePhaseNotFoundException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecycleNotFoundException, PluginVersionResolutionException, LifecycleExecutionException {
        Set<Plugin> unsafePlugins;
        MavenExecutionPlan executionPlan = this.lifeCycleExecutionPlanCalculator.calculateExecutionPlan(session, project, taskSegment.getTasks());
        this.lifecycleDebugLogger.debugProjectPlan(project, executionPlan);
        if (session.getRequest().isThreadConfigurationPresent() && !(unsafePlugins = executionPlan.getNonThreadSafePlugins()).isEmpty()) {
            this.logger.warn("*****************************************************************");
            this.logger.warn("* Your build is requesting parallel execution, but project      *");
            this.logger.warn("* contains the following plugin(s) that are not marked as       *");
            this.logger.warn("* @threadSafe to support parallel building.                     *");
            this.logger.warn("* While this /may/ work fine, please look for plugin updates    *");
            this.logger.warn("* and/or request plugins be made thread-safe.                   *");
            this.logger.warn("* If reporting an issue, report it against the plugin in        *");
            this.logger.warn("* question, not against maven-core                              *");
            this.logger.warn("*****************************************************************");
            this.logger.warn("The following plugins are not marked @threadSafe in " + project.getName() + ":");
            for (Plugin unsafePlugin : unsafePlugins) {
                this.logger.warn(unsafePlugin.getId());
            }
            this.logger.warn("*****************************************************************");
        }
        return executionPlan;
    }

    public void handleBuildError(ReactorContext buildContext, MavenSession rootSession, MavenProject mavenProject, Exception e, long buildStartTime) {
        if (e instanceof RuntimeException) {
            e = new InternalErrorException("Internal error: " + e, e);
        }
        buildContext.getResult().addException(e);
        long buildEndTime = System.currentTimeMillis();
        buildContext.getResult().addBuildSummary(new BuildFailure(mavenProject, buildEndTime - buildStartTime, e));
        this.eventCatapult.fire(ExecutionEvent.Type.ProjectFailed, rootSession, null);
        if (!"FAIL_NEVER".equals(rootSession.getReactorFailureBehavior())) {
            if ("FAIL_AT_END".equals(rootSession.getReactorFailureBehavior())) {
                buildContext.getReactorBuildStatus().blackList(mavenProject);
            } else if ("FAIL_FAST".equals(rootSession.getReactorFailureBehavior())) {
                buildContext.getReactorBuildStatus().halt();
            } else {
                throw new IllegalArgumentException("invalid reactor failure behavior " + rootSession.getReactorFailureBehavior());
            }
        }
    }

    public static void attachToThread(MavenProject currentProject) {
        ClassRealm projectRealm = currentProject.getClassRealm();
        if (projectRealm != null) {
            Thread.currentThread().setContextClassLoader(projectRealm);
        }
    }

    public static String getKey(MavenProject project) {
        return project.getGroupId() + ':' + project.getArtifactId() + ':' + project.getVersion();
    }
}

