/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.util.ByLineSource;
import org.codehaus.plexus.util.IOUtil;

public class ByLineReaderSource
implements ByLineSource {
    private LineNumberReader reader;
    private int lineNumber;
    private String lastLine;
    private boolean ungetted = false;

    public ByLineReaderSource(Reader in) {
        this.reader = new LineNumberReader(in);
        this.lineNumber = -1;
    }

    public final String getNextLine() throws ParseException {
        String line;
        if (this.reader == null) {
            return null;
        }
        if (this.ungetted) {
            this.ungetted = false;
            return this.lastLine;
        }
        try {
            line = this.reader.readLine();
            if (line == null) {
                this.reader.close();
                this.reader = null;
            } else {
                this.lineNumber = this.reader.getLineNumber();
            }
        }
        catch (IOException e) {
            throw new ParseException((Exception)e, this.lineNumber, 0);
        }
        this.lastLine = line;
        return line;
    }

    public final String getName() {
        return "";
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final void close() {
        IOUtil.close(this.reader);
        this.reader = null;
    }

    public final void ungetLine() {
        if (this.ungetted) {
            throw new IllegalStateException("we support only one level of ungetLine()");
        }
        this.ungetted = true;
    }

    public final void unget(String s) {
        if (s == null) {
            throw new IllegalArgumentException("argument can't be null");
        }
        if (s.length() != 0) {
            this.ungetLine();
            this.lastLine = s;
        }
    }
}

