/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.document.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.doxia.document.DocumentAuthor;
import org.apache.maven.doxia.document.DocumentCover;
import org.apache.maven.doxia.document.DocumentHyperlinkBehaviour;
import org.apache.maven.doxia.document.DocumentMeta;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentStatistic;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.document.DocumentTemplate;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DocumentXpp3Reader {
    private boolean addDefaultEntities = true;

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private void initParser(XmlPullParser parser) throws XmlPullParserException {
        if (this.addDefaultEntities) {
            parser.defineEntityReplacementText("nbsp", "\u00a0");
            parser.defineEntityReplacementText("iexcl", "\u00a1");
            parser.defineEntityReplacementText("cent", "\u00a2");
            parser.defineEntityReplacementText("pound", "\u00a3");
            parser.defineEntityReplacementText("curren", "\u00a4");
            parser.defineEntityReplacementText("yen", "\u00a5");
            parser.defineEntityReplacementText("brvbar", "\u00a6");
            parser.defineEntityReplacementText("sect", "\u00a7");
            parser.defineEntityReplacementText("uml", "\u00a8");
            parser.defineEntityReplacementText("copy", "\u00a9");
            parser.defineEntityReplacementText("ordf", "\u00aa");
            parser.defineEntityReplacementText("laquo", "\u00ab");
            parser.defineEntityReplacementText("not", "\u00ac");
            parser.defineEntityReplacementText("shy", "\u00ad");
            parser.defineEntityReplacementText("reg", "\u00ae");
            parser.defineEntityReplacementText("macr", "\u00af");
            parser.defineEntityReplacementText("deg", "\u00b0");
            parser.defineEntityReplacementText("plusmn", "\u00b1");
            parser.defineEntityReplacementText("sup2", "\u00b2");
            parser.defineEntityReplacementText("sup3", "\u00b3");
            parser.defineEntityReplacementText("acute", "\u00b4");
            parser.defineEntityReplacementText("micro", "\u00b5");
            parser.defineEntityReplacementText("para", "\u00b6");
            parser.defineEntityReplacementText("middot", "\u00b7");
            parser.defineEntityReplacementText("cedil", "\u00b8");
            parser.defineEntityReplacementText("sup1", "\u00b9");
            parser.defineEntityReplacementText("ordm", "\u00ba");
            parser.defineEntityReplacementText("raquo", "\u00bb");
            parser.defineEntityReplacementText("frac14", "\u00bc");
            parser.defineEntityReplacementText("frac12", "\u00bd");
            parser.defineEntityReplacementText("frac34", "\u00be");
            parser.defineEntityReplacementText("iquest", "\u00bf");
            parser.defineEntityReplacementText("Agrave", "\u00c0");
            parser.defineEntityReplacementText("Aacute", "\u00c1");
            parser.defineEntityReplacementText("Acirc", "\u00c2");
            parser.defineEntityReplacementText("Atilde", "\u00c3");
            parser.defineEntityReplacementText("Auml", "\u00c4");
            parser.defineEntityReplacementText("Aring", "\u00c5");
            parser.defineEntityReplacementText("AElig", "\u00c6");
            parser.defineEntityReplacementText("Ccedil", "\u00c7");
            parser.defineEntityReplacementText("Egrave", "\u00c8");
            parser.defineEntityReplacementText("Eacute", "\u00c9");
            parser.defineEntityReplacementText("Ecirc", "\u00ca");
            parser.defineEntityReplacementText("Euml", "\u00cb");
            parser.defineEntityReplacementText("Igrave", "\u00cc");
            parser.defineEntityReplacementText("Iacute", "\u00cd");
            parser.defineEntityReplacementText("Icirc", "\u00ce");
            parser.defineEntityReplacementText("Iuml", "\u00cf");
            parser.defineEntityReplacementText("ETH", "\u00d0");
            parser.defineEntityReplacementText("Ntilde", "\u00d1");
            parser.defineEntityReplacementText("Ograve", "\u00d2");
            parser.defineEntityReplacementText("Oacute", "\u00d3");
            parser.defineEntityReplacementText("Ocirc", "\u00d4");
            parser.defineEntityReplacementText("Otilde", "\u00d5");
            parser.defineEntityReplacementText("Ouml", "\u00d6");
            parser.defineEntityReplacementText("times", "\u00d7");
            parser.defineEntityReplacementText("Oslash", "\u00d8");
            parser.defineEntityReplacementText("Ugrave", "\u00d9");
            parser.defineEntityReplacementText("Uacute", "\u00da");
            parser.defineEntityReplacementText("Ucirc", "\u00db");
            parser.defineEntityReplacementText("Uuml", "\u00dc");
            parser.defineEntityReplacementText("Yacute", "\u00dd");
            parser.defineEntityReplacementText("THORN", "\u00de");
            parser.defineEntityReplacementText("szlig", "\u00df");
            parser.defineEntityReplacementText("agrave", "\u00e0");
            parser.defineEntityReplacementText("aacute", "\u00e1");
            parser.defineEntityReplacementText("acirc", "\u00e2");
            parser.defineEntityReplacementText("atilde", "\u00e3");
            parser.defineEntityReplacementText("auml", "\u00e4");
            parser.defineEntityReplacementText("aring", "\u00e5");
            parser.defineEntityReplacementText("aelig", "\u00e6");
            parser.defineEntityReplacementText("ccedil", "\u00e7");
            parser.defineEntityReplacementText("egrave", "\u00e8");
            parser.defineEntityReplacementText("eacute", "\u00e9");
            parser.defineEntityReplacementText("ecirc", "\u00ea");
            parser.defineEntityReplacementText("euml", "\u00eb");
            parser.defineEntityReplacementText("igrave", "\u00ec");
            parser.defineEntityReplacementText("iacute", "\u00ed");
            parser.defineEntityReplacementText("icirc", "\u00ee");
            parser.defineEntityReplacementText("iuml", "\u00ef");
            parser.defineEntityReplacementText("eth", "\u00f0");
            parser.defineEntityReplacementText("ntilde", "\u00f1");
            parser.defineEntityReplacementText("ograve", "\u00f2");
            parser.defineEntityReplacementText("oacute", "\u00f3");
            parser.defineEntityReplacementText("ocirc", "\u00f4");
            parser.defineEntityReplacementText("otilde", "\u00f5");
            parser.defineEntityReplacementText("ouml", "\u00f6");
            parser.defineEntityReplacementText("divide", "\u00f7");
            parser.defineEntityReplacementText("oslash", "\u00f8");
            parser.defineEntityReplacementText("ugrave", "\u00f9");
            parser.defineEntityReplacementText("uacute", "\u00fa");
            parser.defineEntityReplacementText("ucirc", "\u00fb");
            parser.defineEntityReplacementText("uuml", "\u00fc");
            parser.defineEntityReplacementText("yacute", "\u00fd");
            parser.defineEntityReplacementText("thorn", "\u00fe");
            parser.defineEntityReplacementText("yuml", "\u00ff");
            parser.defineEntityReplacementText("OElig", "\u0152");
            parser.defineEntityReplacementText("oelig", "\u0153");
            parser.defineEntityReplacementText("Scaron", "\u0160");
            parser.defineEntityReplacementText("scaron", "\u0161");
            parser.defineEntityReplacementText("Yuml", "\u0178");
            parser.defineEntityReplacementText("circ", "\u02c6");
            parser.defineEntityReplacementText("tilde", "\u02dc");
            parser.defineEntityReplacementText("ensp", "\u2002");
            parser.defineEntityReplacementText("emsp", "\u2003");
            parser.defineEntityReplacementText("thinsp", "\u2009");
            parser.defineEntityReplacementText("zwnj", "\u200c");
            parser.defineEntityReplacementText("zwj", "\u200d");
            parser.defineEntityReplacementText("lrm", "\u200e");
            parser.defineEntityReplacementText("rlm", "\u200f");
            parser.defineEntityReplacementText("ndash", "\u2013");
            parser.defineEntityReplacementText("mdash", "\u2014");
            parser.defineEntityReplacementText("lsquo", "\u2018");
            parser.defineEntityReplacementText("rsquo", "\u2019");
            parser.defineEntityReplacementText("sbquo", "\u201a");
            parser.defineEntityReplacementText("ldquo", "\u201c");
            parser.defineEntityReplacementText("rdquo", "\u201d");
            parser.defineEntityReplacementText("bdquo", "\u201e");
            parser.defineEntityReplacementText("dagger", "\u2020");
            parser.defineEntityReplacementText("Dagger", "\u2021");
            parser.defineEntityReplacementText("permil", "\u2030");
            parser.defineEntityReplacementText("lsaquo", "\u2039");
            parser.defineEntityReplacementText("rsaquo", "\u203a");
            parser.defineEntityReplacementText("euro", "\u20ac");
            parser.defineEntityReplacementText("fnof", "\u0192");
            parser.defineEntityReplacementText("Alpha", "\u0391");
            parser.defineEntityReplacementText("Beta", "\u0392");
            parser.defineEntityReplacementText("Gamma", "\u0393");
            parser.defineEntityReplacementText("Delta", "\u0394");
            parser.defineEntityReplacementText("Epsilon", "\u0395");
            parser.defineEntityReplacementText("Zeta", "\u0396");
            parser.defineEntityReplacementText("Eta", "\u0397");
            parser.defineEntityReplacementText("Theta", "\u0398");
            parser.defineEntityReplacementText("Iota", "\u0399");
            parser.defineEntityReplacementText("Kappa", "\u039a");
            parser.defineEntityReplacementText("Lambda", "\u039b");
            parser.defineEntityReplacementText("Mu", "\u039c");
            parser.defineEntityReplacementText("Nu", "\u039d");
            parser.defineEntityReplacementText("Xi", "\u039e");
            parser.defineEntityReplacementText("Omicron", "\u039f");
            parser.defineEntityReplacementText("Pi", "\u03a0");
            parser.defineEntityReplacementText("Rho", "\u03a1");
            parser.defineEntityReplacementText("Sigma", "\u03a3");
            parser.defineEntityReplacementText("Tau", "\u03a4");
            parser.defineEntityReplacementText("Upsilon", "\u03a5");
            parser.defineEntityReplacementText("Phi", "\u03a6");
            parser.defineEntityReplacementText("Chi", "\u03a7");
            parser.defineEntityReplacementText("Psi", "\u03a8");
            parser.defineEntityReplacementText("Omega", "\u03a9");
            parser.defineEntityReplacementText("alpha", "\u03b1");
            parser.defineEntityReplacementText("beta", "\u03b2");
            parser.defineEntityReplacementText("gamma", "\u03b3");
            parser.defineEntityReplacementText("delta", "\u03b4");
            parser.defineEntityReplacementText("epsilon", "\u03b5");
            parser.defineEntityReplacementText("zeta", "\u03b6");
            parser.defineEntityReplacementText("eta", "\u03b7");
            parser.defineEntityReplacementText("theta", "\u03b8");
            parser.defineEntityReplacementText("iota", "\u03b9");
            parser.defineEntityReplacementText("kappa", "\u03ba");
            parser.defineEntityReplacementText("lambda", "\u03bb");
            parser.defineEntityReplacementText("mu", "\u03bc");
            parser.defineEntityReplacementText("nu", "\u03bd");
            parser.defineEntityReplacementText("xi", "\u03be");
            parser.defineEntityReplacementText("omicron", "\u03bf");
            parser.defineEntityReplacementText("pi", "\u03c0");
            parser.defineEntityReplacementText("rho", "\u03c1");
            parser.defineEntityReplacementText("sigmaf", "\u03c2");
            parser.defineEntityReplacementText("sigma", "\u03c3");
            parser.defineEntityReplacementText("tau", "\u03c4");
            parser.defineEntityReplacementText("upsilon", "\u03c5");
            parser.defineEntityReplacementText("phi", "\u03c6");
            parser.defineEntityReplacementText("chi", "\u03c7");
            parser.defineEntityReplacementText("psi", "\u03c8");
            parser.defineEntityReplacementText("omega", "\u03c9");
            parser.defineEntityReplacementText("thetasym", "\u03d1");
            parser.defineEntityReplacementText("upsih", "\u03d2");
            parser.defineEntityReplacementText("piv", "\u03d6");
            parser.defineEntityReplacementText("bull", "\u2022");
            parser.defineEntityReplacementText("hellip", "\u2026");
            parser.defineEntityReplacementText("prime", "\u2032");
            parser.defineEntityReplacementText("Prime", "\u2033");
            parser.defineEntityReplacementText("oline", "\u203e");
            parser.defineEntityReplacementText("frasl", "\u2044");
            parser.defineEntityReplacementText("weierp", "\u2118");
            parser.defineEntityReplacementText("image", "\u2111");
            parser.defineEntityReplacementText("real", "\u211c");
            parser.defineEntityReplacementText("trade", "\u2122");
            parser.defineEntityReplacementText("alefsym", "\u2135");
            parser.defineEntityReplacementText("larr", "\u2190");
            parser.defineEntityReplacementText("uarr", "\u2191");
            parser.defineEntityReplacementText("rarr", "\u2192");
            parser.defineEntityReplacementText("darr", "\u2193");
            parser.defineEntityReplacementText("harr", "\u2194");
            parser.defineEntityReplacementText("crarr", "\u21b5");
            parser.defineEntityReplacementText("lArr", "\u21d0");
            parser.defineEntityReplacementText("uArr", "\u21d1");
            parser.defineEntityReplacementText("rArr", "\u21d2");
            parser.defineEntityReplacementText("dArr", "\u21d3");
            parser.defineEntityReplacementText("hArr", "\u21d4");
            parser.defineEntityReplacementText("forall", "\u2200");
            parser.defineEntityReplacementText("part", "\u2202");
            parser.defineEntityReplacementText("exist", "\u2203");
            parser.defineEntityReplacementText("empty", "\u2205");
            parser.defineEntityReplacementText("nabla", "\u2207");
            parser.defineEntityReplacementText("isin", "\u2208");
            parser.defineEntityReplacementText("notin", "\u2209");
            parser.defineEntityReplacementText("ni", "\u220b");
            parser.defineEntityReplacementText("prod", "\u220f");
            parser.defineEntityReplacementText("sum", "\u2211");
            parser.defineEntityReplacementText("minus", "\u2212");
            parser.defineEntityReplacementText("lowast", "\u2217");
            parser.defineEntityReplacementText("radic", "\u221a");
            parser.defineEntityReplacementText("prop", "\u221d");
            parser.defineEntityReplacementText("infin", "\u221e");
            parser.defineEntityReplacementText("ang", "\u2220");
            parser.defineEntityReplacementText("and", "\u2227");
            parser.defineEntityReplacementText("or", "\u2228");
            parser.defineEntityReplacementText("cap", "\u2229");
            parser.defineEntityReplacementText("cup", "\u222a");
            parser.defineEntityReplacementText("int", "\u222b");
            parser.defineEntityReplacementText("there4", "\u2234");
            parser.defineEntityReplacementText("sim", "\u223c");
            parser.defineEntityReplacementText("cong", "\u2245");
            parser.defineEntityReplacementText("asymp", "\u2248");
            parser.defineEntityReplacementText("ne", "\u2260");
            parser.defineEntityReplacementText("equiv", "\u2261");
            parser.defineEntityReplacementText("le", "\u2264");
            parser.defineEntityReplacementText("ge", "\u2265");
            parser.defineEntityReplacementText("sub", "\u2282");
            parser.defineEntityReplacementText("sup", "\u2283");
            parser.defineEntityReplacementText("nsub", "\u2284");
            parser.defineEntityReplacementText("sube", "\u2286");
            parser.defineEntityReplacementText("supe", "\u2287");
            parser.defineEntityReplacementText("oplus", "\u2295");
            parser.defineEntityReplacementText("otimes", "\u2297");
            parser.defineEntityReplacementText("perp", "\u22a5");
            parser.defineEntityReplacementText("sdot", "\u22c5");
            parser.defineEntityReplacementText("lceil", "\u2308");
            parser.defineEntityReplacementText("rceil", "\u2309");
            parser.defineEntityReplacementText("lfloor", "\u230a");
            parser.defineEntityReplacementText("rfloor", "\u230b");
            parser.defineEntityReplacementText("lang", "\u2329");
            parser.defineEntityReplacementText("rang", "\u232a");
            parser.defineEntityReplacementText("loz", "\u25ca");
            parser.defineEntityReplacementText("spades", "\u2660");
            parser.defineEntityReplacementText("clubs", "\u2663");
            parser.defineEntityReplacementText("hearts", "\u2665");
            parser.defineEntityReplacementText("diams", "\u2666");
        }
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    private DocumentAuthor parseDocumentAuthor(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentAuthor documentAuthor = new DocumentAuthor();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "firstName", null, parsed)) {
                documentAuthor.setFirstName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lastName", null, parsed)) {
                documentAuthor.setLastName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                documentAuthor.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "initials", null, parsed)) {
                documentAuthor.setInitials(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "title", null, parsed)) {
                documentAuthor.setTitle(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "position", null, parsed)) {
                documentAuthor.setPosition(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "email", null, parsed)) {
                documentAuthor.setEmail(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "phoneNumber", null, parsed)) {
                documentAuthor.setPhoneNumber(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "faxNumber", null, parsed)) {
                documentAuthor.setFaxNumber(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "companyName", null, parsed)) {
                documentAuthor.setCompanyName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "street", null, parsed)) {
                documentAuthor.setStreet(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "city", null, parsed)) {
                documentAuthor.setCity(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "postalCode", null, parsed)) {
                documentAuthor.setPostalCode(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "country", null, parsed)) {
                documentAuthor.setCountry(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "state", null, parsed)) {
                documentAuthor.setState(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return documentAuthor;
    }

    private DocumentCover parseDocumentCover(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentCover documentCover = new DocumentCover();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "coverTitle", null, parsed)) {
                documentCover.setCoverTitle(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "coverSubTitle", null, parsed)) {
                documentCover.setCoverSubTitle(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "coverVersion", null, parsed)) {
                documentCover.setCoverVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "coverType", null, parsed)) {
                documentCover.setCoverType(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "coverDate", null, parsed)) {
                String dateFormat = null;
                documentCover.setCoverDate(this.getDateValue(this.getTrimmedValue(parser.nextText()), "coverDate", dateFormat, parser));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "coverdate", null, parsed)) {
                documentCover.setCoverdate(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "authors", null, parsed)) {
                ArrayList<DocumentAuthor> authors = new ArrayList<DocumentAuthor>();
                documentCover.setAuthors(authors);
                while (parser.nextTag() == 2) {
                    if ("author".equals(parser.getName())) {
                        authors.add(this.parseDocumentAuthor(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "author", null, parsed)) {
                documentCover.setAuthor(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "projectName", null, parsed)) {
                documentCover.setProjectName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "projectLogo", null, parsed)) {
                documentCover.setProjectLogo(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "companyName", null, parsed)) {
                documentCover.setCompanyName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "companyLogo", null, parsed)) {
                documentCover.setCompanyLogo(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return documentCover;
    }

    private DocumentHyperlinkBehaviour parseDocumentHyperlinkBehaviour(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentHyperlinkBehaviour documentHyperlinkBehaviour = new DocumentHyperlinkBehaviour();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("targetFrame".equals(name)) {
                documentHyperlinkBehaviour.setTargetFrame(this.getTrimmedValue(value));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return documentHyperlinkBehaviour;
    }

    private DocumentMeta parseDocumentMeta(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentMeta documentMeta = new DocumentMeta();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String dateFormat;
            if (this.checkFieldWithDuplicate(parser, "title", null, parsed)) {
                documentMeta.setTitle(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "author", null, parsed)) {
                documentMeta.setAuthor(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "authors", null, parsed)) {
                ArrayList<DocumentAuthor> authors = new ArrayList<DocumentAuthor>();
                documentMeta.setAuthors(authors);
                while (parser.nextTag() == 2) {
                    if ("author".equals(parser.getName())) {
                        authors.add(this.parseDocumentAuthor(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "subject", null, parsed)) {
                documentMeta.setSubject(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "keywords", null, parsed)) {
                documentMeta.setKeywords(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "keyWords", null, parsed)) {
                ArrayList<String> keyWords = new ArrayList<String>();
                documentMeta.setKeyWords(keyWords);
                while (parser.nextTag() == 2) {
                    if ("keyWord".equals(parser.getName())) {
                        keyWords.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pageSize", null, parsed)) {
                documentMeta.setPageSize(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "generator", null, parsed)) {
                documentMeta.setGenerator(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "description", null, parsed)) {
                documentMeta.setDescription(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "initialCreator", null, parsed)) {
                documentMeta.setInitialCreator(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "creator", null, parsed)) {
                documentMeta.setCreator(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "printedBy", null, parsed)) {
                documentMeta.setPrintedBy(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "creationDate", null, parsed)) {
                dateFormat = null;
                documentMeta.setCreationDate(this.getDateValue(this.getTrimmedValue(parser.nextText()), "creationDate", dateFormat, parser));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "creationdate", null, parsed)) {
                documentMeta.setCreationdate(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "date", null, parsed)) {
                dateFormat = null;
                documentMeta.setDate(this.getDateValue(this.getTrimmedValue(parser.nextText()), "date", dateFormat, parser));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "modifydate", null, parsed)) {
                documentMeta.setModifydate(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "printDate", null, parsed)) {
                dateFormat = null;
                documentMeta.setPrintDate(this.getDateValue(this.getTrimmedValue(parser.nextText()), "printDate", dateFormat, parser));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "printdate", null, parsed)) {
                documentMeta.setPrintdate(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "template", null, parsed)) {
                documentMeta.setTemplate(this.parseDocumentTemplate(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "hyperlinkBehaviour", null, parsed)) {
                documentMeta.setHyperlinkBehaviour(this.parseDocumentHyperlinkBehaviour(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "language", null, parsed)) {
                documentMeta.setLanguage(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "editingCycles", null, parsed)) {
                documentMeta.setEditingCycles(this.getLongValue(this.getTrimmedValue(parser.nextText()), "editingCycles", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "editingDuration", null, parsed)) {
                documentMeta.setEditingDuration(this.getLongValue(this.getTrimmedValue(parser.nextText()), "editingDuration", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "documentStatistic", null, parsed)) {
                documentMeta.setDocumentStatistic(this.parseDocumentStatistic(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "confidential", null, parsed)) {
                documentMeta.setConfidential(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "confidential", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "draft", null, parsed)) {
                documentMeta.setDraft(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "draft", parser, "false"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return documentMeta;
    }

    private DocumentModel parseDocumentModel(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentModel documentModel = new DocumentModel();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            if ("outputName".equals(name)) {
                documentModel.setOutputName(this.getTrimmedValue(value));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "meta", null, parsed)) {
                documentModel.setMeta(this.parseDocumentMeta(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "toc", null, parsed)) {
                documentModel.setToc(this.parseDocumentTOC(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "cover", null, parsed)) {
                documentModel.setCover(this.parseDocumentCover(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return documentModel;
    }

    private DocumentStatistic parseDocumentStatistic(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentStatistic documentStatistic = new DocumentStatistic();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("pageCount".equals(name)) {
                documentStatistic.setPageCount(this.getLongValue(this.getTrimmedValue(value), "pageCount", parser, strict));
                continue;
            }
            if ("tableCount".equals(name)) {
                documentStatistic.setTableCount(this.getLongValue(this.getTrimmedValue(value), "tableCount", parser, strict));
                continue;
            }
            if ("drawCount".equals(name)) {
                documentStatistic.setDrawCount(this.getLongValue(this.getTrimmedValue(value), "drawCount", parser, strict));
                continue;
            }
            if ("imageCount".equals(name)) {
                documentStatistic.setImageCount(this.getLongValue(this.getTrimmedValue(value), "imageCount", parser, strict));
                continue;
            }
            if ("objectCount".equals(name)) {
                documentStatistic.setObjectCount(this.getLongValue(this.getTrimmedValue(value), "objectCount", parser, strict));
                continue;
            }
            if ("oleObjectCount".equals(name)) {
                documentStatistic.setOleObjectCount(this.getLongValue(this.getTrimmedValue(value), "oleObjectCount", parser, strict));
                continue;
            }
            if ("paragraphCount".equals(name)) {
                documentStatistic.setParagraphCount(this.getLongValue(this.getTrimmedValue(value), "paragraphCount", parser, strict));
                continue;
            }
            if ("wordCount".equals(name)) {
                documentStatistic.setWordCount(this.getLongValue(this.getTrimmedValue(value), "wordCount", parser, strict));
                continue;
            }
            if ("characterCount".equals(name)) {
                documentStatistic.setCharacterCount(this.getLongValue(this.getTrimmedValue(value), "characterCount", parser, strict));
                continue;
            }
            if ("rowCount".equals(name)) {
                documentStatistic.setRowCount(this.getLongValue(this.getTrimmedValue(value), "rowCount", parser, strict));
                continue;
            }
            if ("frameCount".equals(name)) {
                documentStatistic.setFrameCount(this.getLongValue(this.getTrimmedValue(value), "frameCount", parser, strict));
                continue;
            }
            if ("sentenceCount".equals(name)) {
                documentStatistic.setSentenceCount(this.getLongValue(this.getTrimmedValue(value), "sentenceCount", parser, strict));
                continue;
            }
            if ("syllableCount".equals(name)) {
                documentStatistic.setSyllableCount(this.getLongValue(this.getTrimmedValue(value), "syllableCount", parser, strict));
                continue;
            }
            if ("nonWhitespaceCharacterCount".equals(name)) {
                documentStatistic.setNonWhitespaceCharacterCount(this.getLongValue(this.getTrimmedValue(value), "nonWhitespaceCharacterCount", parser, strict));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return documentStatistic;
    }

    private DocumentTOC parseDocumentTOC(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentTOC documentTOC = new DocumentTOC();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                documentTOC.setName(this.getTrimmedValue(value));
                continue;
            }
            if ("depth".equals(name)) {
                documentTOC.setDepth(this.getIntegerValue(this.getTrimmedValue(value), "depth", parser, strict));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if ("item".equals(parser.getName())) {
                List<DocumentTOCItem> items = documentTOC.getItems();
                if (items == null) {
                    items = new ArrayList<DocumentTOCItem>();
                    documentTOC.setItems(items);
                }
                items.add(this.parseDocumentTOCItem(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return documentTOC;
    }

    private DocumentTOCItem parseDocumentTOCItem(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentTOCItem documentTOCItem = new DocumentTOCItem();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                documentTOCItem.setName(this.getTrimmedValue(value));
                continue;
            }
            if ("ref".equals(name)) {
                documentTOCItem.setRef(this.getTrimmedValue(value));
                continue;
            }
            if ("collapse".equals(name)) {
                documentTOCItem.setCollapse(this.getBooleanValue(this.getTrimmedValue(value), "collapse", parser, "false"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if ("item".equals(parser.getName())) {
                List<DocumentTOCItem> items = documentTOCItem.getItems();
                if (items == null) {
                    items = new ArrayList<DocumentTOCItem>();
                    documentTOCItem.setItems(items);
                }
                items.add(this.parseDocumentTOCItem(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return documentTOCItem;
    }

    private DocumentTemplate parseDocumentTemplate(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentTemplate documentTemplate = new DocumentTemplate();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("href".equals(name)) {
                documentTemplate.setHref(this.getTrimmedValue(value));
                continue;
            }
            if ("title".equals(name)) {
                documentTemplate.setTitle(this.getTrimmedValue(value));
                continue;
            }
            if ("date".equals(name)) {
                String dateFormat = null;
                documentTemplate.setDate(this.getDateValue(this.getTrimmedValue(value), "date", dateFormat, parser));
                continue;
            }
            if ("modifydate".equals(name)) {
                documentTemplate.setModifydate(this.getTrimmedValue(value));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return documentTemplate;
    }

    public DocumentModel read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = new MXParser();
        parser.setInput(reader);
        this.initParser(parser);
        return this.read(parser, strict);
    }

    public DocumentModel read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public DocumentModel read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in), strict);
    }

    public DocumentModel read(InputStream in) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in));
    }

    private DocumentModel read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"document".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'document' but found '" + parser.getName() + "'", parser, null);
                }
                DocumentModel documentModel = this.parseDocumentModel(parser, strict);
                documentModel.setModelEncoding(parser.getInputEncoding());
                return documentModel;
            }
            eventType = parser.next();
        }
        throw new XmlPullParserException("Expected root element 'document' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }
}

