/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.Block;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class WiproDBRefToUUIDUpdate {
    static MongoCollection deviceDBCollection;
    static Block<Document> printBlock;

    static {
        printBlock = new Block<Document>(){

            @Override
            public void apply(Document document) {
                if (document.getInteger("count") != 1) {
                    FindIterable overviews = deviceDBCollection.find(new Document("userName", document.get("_id")));
                    for (Document overview : overviews) {
                        File file = new File(String.valueOf(overview.getString("deviceUUID")) + ".js");
                        try {
                            file.createNewFile();
                            FileWriter writer = new FileWriter(file);
                            writer.write("use parablu001;\n");
                            writer.write("db.getCollection(\"TEMP_BKP_" + document.get("_id") + "\").update({\"device\":DBRef(\"DEVICE\"," + "ObjectId(\"" + overview.getObjectId("_id") + "\"))},{$set:{\"deviceUUID\":\"" + overview.getString("deviceUUID") + "\"}},{multi:true})");
                            writer.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
    }

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        try {
            deviceDBCollection = db.getCollection("DEVICE");
            deviceDBCollection.aggregate(Arrays.asList(Aggregates.group("$userName", Accumulators.sum("count", 1)))).forEach(printBlock);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

