/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.UpdateResult;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class UpdateUserNameInBKP {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        try {
            MongoCollection<Document> deviceDBCollection = db.getCollection("DEVICE");
            MongoCollection<Document> userDBCollection = db.getCollection("USER");
            FindIterable<Document> devices = deviceDBCollection.find();
            for (Document device : devices) {
                String deviceUUIDval = device.getString("deviceUUID");
                String destCollection = device.getString("destCollection");
                System.out.println("Strated for deviceUUID :" + deviceUUIDval + " destColl :" + destCollection);
                DBRef userDBRef = (DBRef)device.get("user");
                Document userDBObject = (Document)userDBCollection.find(new Document("_id", userDBRef.getId())).first();
                MongoCollection<Document> bkpDBCollection = db.getCollection(destCollection);
                BasicDBObject bkpQuery = new BasicDBObject();
                bkpQuery.put("deviceUUID", deviceUUIDval);
                bkpQuery.put("userName", null);
                BasicDBObject bkpdUpdateFields = new BasicDBObject();
                bkpdUpdateFields.append("userName", userDBObject.getString("userName"));
                BasicDBObject bkpSet = new BasicDBObject();
                bkpSet.append("$set", bkpdUpdateFields);
                UpdateResult updateMany = bkpDBCollection.updateMany(bkpQuery, bkpSet);
                System.out.println(String.valueOf(userDBObject.getString("userName")) + "...updated....." + updateMany.getMatchedCount());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

