/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class UdateDeviceBkpOverview {
    public static void main(String[] args) throws Exception {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        try {
            MongoCollection<Document> deviceDBCollection = db.getCollection("DEVICE");
            MongoCollection<Document> bkpOverviewDBCollection = db.getCollection("DEVICE_BACKUP_OVERVIEW");
            MongoCollection<Document> userDBCollection = db.getCollection("USER");
            FindIterable<Document> devices = deviceDBCollection.find();
            long taotalDeviceCount = deviceDBCollection.count();
            System.out.println("Total device count : " + taotalDeviceCount);
            for (Document device : devices) {
                System.out.println("Device ID : " + device.get("_id"));
                DBRef deviceBackupOverViewDBRef = (DBRef)device.get("deviceBackupOverView");
                DBRef userDBRef = (DBRef)device.get("user");
                Document userDBObject = null;
                Document bkpoverviewDBObject = null;
                if (userDBCollection != null) {
                    userDBObject = (Document)userDBCollection.find(new Document("_id", userDBRef.getId())).first();
                }
                if (deviceBackupOverViewDBRef != null) {
                    bkpoverviewDBObject = (Document)bkpOverviewDBCollection.find(new Document("_id", deviceBackupOverViewDBRef.getId())).first();
                }
                if (userDBObject == null && bkpoverviewDBObject == null) {
                    System.out.println(" userDBObject or deviceDBObject is null for deviceId " + device.get("_id") + " so skip");
                } else {
                    BasicDBObject deviceSearchQuery = new BasicDBObject();
                    deviceSearchQuery.append("_id", device.get("_id"));
                    BasicDBObject deviceUpdateQuery = new BasicDBObject();
                    BasicDBObject deviceUpdateFields = new BasicDBObject();
                    if (userDBObject != null && bkpoverviewDBObject == null) {
                        deviceUpdateFields.append("userName", userDBObject.getString("userName"));
                        deviceUpdateFields.append("userId", userDBObject.get("_id"));
                        deviceUpdateQuery.append("$set", deviceUpdateFields);
                        deviceDBCollection.updateOne(deviceSearchQuery, deviceUpdateQuery);
                        System.out.println("Updating device");
                    }
                }
                if (bkpoverviewDBObject == null) continue;
                BasicDBObject searchQuery = new BasicDBObject();
                searchQuery.append("_id", bkpoverviewDBObject.get("_id"));
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateFields = new BasicDBObject();
                updateFields.append("userName", userDBObject.getString("userName"));
                updateFields.append("isUserActive", userDBObject.getBoolean("active"));
                updateFields.append("isUserDeleted", userDBObject.getBoolean("deleted"));
                if (StringUtils.isNotEmpty(userDBObject.getString("emailId"))) {
                    updateFields.append("emailId", userDBObject.getString("emailId"));
                }
                if (StringUtils.isNotEmpty(userDBObject.getString("location"))) {
                    updateFields.append("location", userDBObject.getString("location"));
                }
                if (StringUtils.isNotEmpty(userDBObject.getString("department"))) {
                    updateFields.append("department", userDBObject.getString("department"));
                }
                if (userDBObject.get("accountStatus") != null) {
                    updateFields.append("accountStatus", Boolean.parseBoolean(userDBObject.get("accountStatus").toString()));
                }
                if (userDBObject.get("displayName") != null) {
                    updateFields.append("displayName", userDBObject.getString("displayName"));
                }
                updateFields.append("policyName", userDBObject.getString("policyName"));
                updateFields.append("deviceName", device.getString("deviceName"));
                updateFields.append("deviceUUID", device.getString("deviceUUID"));
                updateFields.append("isDeviceBolcked", device.getBoolean("blocked"));
                updateFields.append("isDeviceDeleted", device.getBoolean("deleted"));
                updateFields.append("clientVersion", device.getString("clientVersion"));
                updateFields.append("epaInstallationDate", device.getString("deviceCreatedDate"));
                updateQuery.append("$set", updateFields);
                bkpOverviewDBCollection.updateOne(searchQuery, updateQuery);
                System.out.println("Successfuly updated");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

