/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class SonyDataRestoreWithThread {
    private static int skipValue;
    private static TimerTask backupTimerTask;
    private static Timer timer;
    private static int count;
    int deviceuuidCount;
    private static int threads;
    private static int limit;

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String mainMongoIP = config.getProperty("mainMongoIP").toString();
        String mainMongoPort = config.getProperty("mainMongoPort").toString();
        int skip = Integer.parseInt(config.getProperty("skip").toString());
        int limit = Integer.parseInt(config.getProperty("limit").toString());
        String thread = config.getProperty("thread").toString();
        int threadCount = Integer.parseInt(thread);
        boolean updateDB = Boolean.parseBoolean(config.getProperty("updateDB").toString());
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mainMongoIP + ":" + mainMongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase mainPB001DB = client.getDatabase(uri.getDatabase());
        MongoClientURI urilocal = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/blukrypt");
        MongoClient clientLocal = new MongoClient(urilocal);
        MongoDatabase localBlukryptDb = clientLocal.getDatabase(urilocal.getDatabase());
        MongoClientURI uriDump = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/blukrypt");
        MongoClient clientDump = new MongoClient(uriDump);
        MongoDatabase dbDump = clientDump.getDatabase(uriDump.getDatabase());
        MongoCollection<Document> dumpPGCollection = dbDump.getCollection("DUMP_BACKUP_PG");
        MongoCollection<Document> deviceCollection = mainPB001DB.getCollection("DEVICE");
        MongoCollection<Document> deviceBkpOverviewCollection = mainPB001DB.getCollection("DEVICE_BACKUP_OVERVIEW");
        MongoCollection<Document> localDB = localBlukryptDb.getCollection("PRIVACY_GATEWAY_BACKUP_SONY_LOCAL");
        MongoCollection<Document> backupPGCollection = mainPB001DB.getCollection("BACKUP_PG");
        int threadSizeVal = threadCount;
        ExecutorService executor = Executors.newFixedThreadPool(threadSizeVal);
        ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
        SonyDataRestoreWithThread.checkThreadStatusAndStartUpdate(limit, updateDB, mainPB001DB, dbDump, dumpPGCollection, deviceCollection, deviceBkpOverviewCollection, localDB, backupPGCollection, pool);
        int i = 0;
        while (i < threadSizeVal) {
            System.out.println("Creating thread for first time>>>>>>>>> i value::");
            SonyDataRestoreWithThread.callUpdateDBEntries(limit, updateDB, mainPB001DB, dbDump, dumpPGCollection, deviceCollection, deviceBkpOverviewCollection, localDB, backupPGCollection, pool);
            ++i;
        }
        SonyDataRestoreWithThread.checkChunksAnuUpdateDB(limit, updateDB, mainPB001DB, dbDump, dumpPGCollection, deviceCollection, deviceBkpOverviewCollection, localDB, backupPGCollection);
    }

    public static void checkThreadStatusAndStartUpdate(final int limit, final boolean updateDB, final MongoDatabase mainPB001DB, final MongoDatabase dbDump, final MongoCollection dumpPGCollection, final MongoCollection deviceCollection, final MongoCollection deviceBkpOverviewCollection, final MongoCollection localDB, final MongoCollection backupPGCollection, final CompletionService<String> pool) {
        if (timer == null) {
            timer = new Timer();
        }
        if (backupTimerTask == null) {
            backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        Future future = pool.take();
                        if (future.isDone()) {
                            SonyDataRestoreWithThread.callUpdateDBEntries(limit, updateDB, mainPB001DB, dbDump, dumpPGCollection, deviceCollection, deviceBkpOverviewCollection, localDB, backupPGCollection, pool);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            timer.schedule(backupTimerTask, 1000L, 1000L);
        }
    }

    private static void callUpdateDBEntries(int limit, boolean updateDB, MongoDatabase mainPB001DB, MongoDatabase dbDump, MongoCollection dumpPGCollection, MongoCollection deviceCollection, MongoCollection deviceBkpOverviewCollection, MongoCollection localDB, MongoCollection backupPGCollection, CompletionService<String> pool) {
        Runnable uploadJob = () -> {
            try {
                SonyDataRestoreWithThread.checkChunksAnuUpdateDB(limit, updateDB, mainPB001DB, dbDump, dumpPGCollection, deviceCollection, deviceBkpOverviewCollection, localDB, backupPGCollection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        pool.submit(uploadJob, "");
    }

    public static synchronized int getSkipValue() {
        return ++skipValue;
    }

    private static void checkChunksAnuUpdateDB(int limit, boolean updateDB, MongoDatabase mainPB001DB, MongoDatabase dbDump, MongoCollection dumpPGCollection, MongoCollection deviceCollection, MongoCollection deviceBkpOverviewCollection, MongoCollection localDB, MongoCollection backupPGCollection) {
        HashMap<String, String> deviceMap = new HashMap<String, String>();
        long overAllUpdatedSize = 0L;
        int skip = SonyDataRestoreWithThread.getSkipValue();
        FindIterable pgFiles = skip == 0 ? dumpPGCollection.find().limit(limit) : dumpPGCollection.find().skip(skip * limit).limit(limit);
        System.out.println(String.valueOf(SonyDataRestoreWithThread.getDateInddMMMyyyy(System.currentTimeMillis())) + "....Skip value :" + skip + " limit value :" + limit + " count :" + count);
        for (Document pgFile : pgFiles) {
            try {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + "..started for.... " + pgFile.getObjectId("_id") + " ...count :" + ++count);
                String deviceUUID = pgFile.getString("deviceUUID");
                if (deviceMap.get(deviceUUID) == null) {
                    long sys = System.currentTimeMillis();
                    Document device1 = (Document)deviceCollection.find(new BasicDBObject("deviceUUID", deviceUUID)).first();
                    if (device1 != null) {
                        deviceMap.put(deviceUUID, device1.getString("destCollection"));
                    } else {
                        System.out.println(".....device is not present in db ... " + deviceUUID);
                        deviceMap.put(deviceUUID, null);
                    }
                    System.out.println("... device time taken ... " + (System.currentTimeMillis() - sys));
                }
                if (deviceMap.get(deviceUUID) != null) {
                    String destCollection = (String)deviceMap.get(deviceUUID);
                    MongoCollection<Document> bkpCollection = mainPB001DB.getCollection(destCollection);
                    long sys = System.currentTimeMillis();
                    System.out.println("... bkpFile time taken ... " + (System.currentTimeMillis() - sys));
                    String deviceTempPath = "/parablu/sony/upload/" + deviceUUID + "/" + pgFile.getString("batchId") + "/chunk";
                    List chunks = (List)pgFile.get("chunkFiles");
                    boolean chunksExists = false;
                    for (String chunkName : chunks) {
                        chunksExists = false;
                        File chunkFile = SonyDataRestoreWithThread.getFileFromChunkPath(pgFile, deviceTempPath, chunkName);
                        if (!chunkFile.exists()) {
                            System.out.println("Chunk For " + pgFile.getObjectId("_id") + " file not exists in " + chunkFile.getPath());
                            chunksExists = false;
                            break;
                        }
                        chunksExists = true;
                    }
                    if (chunksExists) {
                        System.out.println(String.valueOf(pgFile.getString("userName")) + "......bkpFile is NULL for :" + pgFile.getObjectId("_id") + " and all chunks present in /parablu so insert db entries..");
                        MongoCollection<Document> dumpBkpCollection = dbDump.getCollection("DUMP_" + destCollection);
                        Document dumpBkpFile = (Document)dumpBkpCollection.find(new BasicDBObject("_id", pgFile.getObjectId("_id"))).first();
                        if (dumpBkpFile != null) {
                            if (!updateDB) continue;
                            System.out.println("Inside save in db");
                            try {
                                Document deviceBkpOverview;
                                boolean bkpAlreadyInserted = false;
                                try {
                                    bkpCollection.insertOne(dumpBkpFile);
                                }
                                catch (Exception e) {
                                    bkpAlreadyInserted = true;
                                }
                                try {
                                    localDB.insertOne(pgFile);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    backupPGCollection.insertOne(pgFile);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                if (bkpAlreadyInserted || (deviceBkpOverview = (Document)deviceBkpOverviewCollection.find(new BasicDBObject("deviceUUID", pgFile.getString("deviceUUID"))).first()) == null) continue;
                                BasicDBObject searchQuery = new BasicDBObject();
                                searchQuery.append("deviceUUID", pgFile.getString("deviceUUID"));
                                BasicDBObject bkpUpdateFields = new BasicDBObject();
                                long size = deviceBkpOverview.getLong("storageUtilized");
                                long filesizeInKB = dumpBkpFile.getLong("size");
                                long updateSize = size + filesizeInKB;
                                overAllUpdatedSize += filesizeInKB;
                                bkpUpdateFields.append("storageUtilized", updateSize);
                                BasicDBObject updatebkpQuery = new BasicDBObject();
                                updatebkpQuery.append("$set", bkpUpdateFields);
                                deviceBkpOverviewCollection.updateOne(searchQuery, updatebkpQuery);
                                System.out.println(" latest completed updating overview in db... " + overAllUpdatedSize + "...count... " + count);
                            }
                            catch (Exception e) {
                                System.out.println("Exception while saving");
                                e.printStackTrace();
                            }
                            continue;
                        }
                        System.out.println(String.valueOf(destCollection) + ".....Info not present in DUMP DB" + pgFile.getObjectId("_id"));
                        continue;
                    }
                    System.out.println("All chunks are not present");
                    continue;
                }
                System.out.println(String.valueOf(deviceUUID) + ".... device is empty for pgFile id :" + pgFile.getObjectId("_id") + "...." + pgFile.getString("userName"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static File getFileFromChunkPath(Document pgFile, String deviceTempPath, String chunkName) {
        File dir;
        Object[] files;
        int occurance = StringUtils.countMatches(chunkName, ".");
        String md5 = SonyDataRestoreWithThread.getMd5FromFileName(chunkName, occurance);
        String fileNameExcludeId = chunkName;
        if (occurance > 1) {
            fileNameExcludeId = chunkName.substring(0, chunkName.lastIndexOf(46));
        } else if (occurance == 0) {
            chunkName = String.valueOf(chunkName) + "." + pgFile.getObjectId("_id").toString();
        }
        File file = new File(String.valueOf(deviceTempPath) + "/" + fileNameExcludeId);
        if (!file.exists() && ArrayUtils.isNotEmpty(files = (dir = new File(deviceTempPath)).list(new PrefixFileFilter(fileNameExcludeId)))) {
            file = new File(String.valueOf(deviceTempPath) + "/" + (String)files[0]);
        }
        return file;
    }

    private static String getMd5FromFileName(String fileName, int occurance) {
        String md5 = "";
        if (occurance == 1 && !fileName.startsWith("part")) {
            md5 = fileName.substring(0, fileName.lastIndexOf(46));
        } else if (occurance == 1 && fileName.startsWith("part")) {
            md5 = fileName.substring(fileName.lastIndexOf(46) + 1);
        } else if (occurance == 0) {
            md5 = fileName;
        } else if (occurance > 1) {
            md5 = fileName.substring(fileName.indexOf(46) + 1, fileName.lastIndexOf(46));
        }
        return md5;
    }

    public static String getDateInddMMMyyyy(long dateVal) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            Date dateD = new Date(dateVal);
            date = df2.format(dateD);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return date;
    }
}

