/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.result.UpdateResult;
import java.util.Arrays;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.bson.Document;

public class SonyCalucluateSizeInLocalDB {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String mainMongoIP = config.getProperty("mainMongoIP").toString();
        String mainMongoPort = config.getProperty("mainMongoPort").toString();
        boolean updateDB = Boolean.parseBoolean(config.getProperty("updateDB").toString());
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mainMongoIP + ":" + mainMongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase mainPB001DB = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoClientURI urilocal = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/blukrypt");
        MongoClient clientLocal = new MongoClient(urilocal);
        MongoDatabase localBlukryptDb = clientLocal.getDatabase(urilocal.getDatabase());
        MongoCollection<Document> deviceBkpOverviewCollection = mainPB001DB.getCollection("DEVICE_BACKUP_OVERVIEW");
        MongoCollection<Document> localDB = localBlukryptDb.getCollection("PRIVACY_GATEWAY_BACKUP_SONY_LOCAL");
        AggregateIterable<Document> aggregate = localDB.aggregate(Arrays.asList(Aggregates.group("$deviceUUID", Accumulators.sum("total", "$size"))));
        for (Object t : aggregate) {
            Document agregateResult = (Document)t;
            long updateSizeInKB = agregateResult.getLong("total") / 1024L;
            Document deviceBkpOverview = (Document)deviceBkpOverviewCollection.find(new BasicDBObject("deviceUUID", agregateResult.getString("_id"))).first();
            if (deviceBkpOverview == null) continue;
            System.out.println("For device " + agregateResult.getString("_id") + " Old size is " + deviceBkpOverview.getLong("storageUtilized") + " we need to add " + updateSizeInKB + " so new data is (" + deviceBkpOverview.getLong("storageUtilized") + updateSizeInKB + ")");
            if (!updateDB) continue;
            BasicDBObject searchQuery = new BasicDBObject();
            searchQuery.append("deviceUUID", agregateResult.getString("_id"));
            BasicDBObject bkpUpdateFields = new BasicDBObject();
            long size = deviceBkpOverview.getLong("storageUtilized");
            long updateSize = size + updateSizeInKB;
            bkpUpdateFields.append("storageUtilized", updateSize);
            BasicDBObject updatebkpQuery = new BasicDBObject();
            updatebkpQuery.append("$set", bkpUpdateFields);
            UpdateResult updateOne = deviceBkpOverviewCollection.updateOne(searchQuery, updatebkpQuery);
            System.out.println("update result :" + updateOne.getModifiedCount());
        }
    }
}

