/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.types.ObjectId;

public class PolicyMappingUtility {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uripar = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu");
        MongoClient clientpar = new MongoClient(uripar);
        MongoDatabase dbpar = clientpar.getDatabase(uripar.getDatabase());
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> userDB = db.getCollection("USER");
        MongoCollection<Document> userBkpMappingDB = db.getCollection("USER_BACKUP_POLICY_MAPPING");
        MongoCollection<Document> bkpPolicyDB = db.getCollection("BACKUP_POLICY");
        MongoCollection<Document> syncPolicyDB = db.getCollection("SYNC_POLICY");
        MongoCollection<Document> bkpOverviewDB = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        MongoCollection<Document> cloudDB = dbpar.getCollection("CLOUD_PROPERTIES");
        Document cloudProperties = (Document)cloudDB.find().first();
        System.out.println(cloudProperties.getString("defaultBkpPolicyName"));
        FindIterable<Document> users = userDB.find(new Document("deleted", false));
        for (Document user : users) {
            try {
                long count = userBkpMappingDB.count(new Document("user", new DBRef("USER", user.getObjectId("_id"))));
                System.out.println("...Mapping..." + count + " " + user.getString("userName"));
                if (count == 0L) {
                    System.out.println("...Mapping is not found...." + user.getString("userName"));
                    Document bkpPolicy = (Document)bkpPolicyDB.find(new Document("policyName", user.getString("policyName"))).first();
                    if (bkpPolicy == null) {
                        bkpPolicy = (Document)bkpPolicyDB.find(new Document("policyName", cloudProperties.getString("defaultBkpPolicyName"))).first();
                    }
                    BasicDBObject updateQuery = new BasicDBObject();
                    BasicDBObject updateFields = new BasicDBObject();
                    updateFields.append("policyName", bkpPolicy.getString("policyName"));
                    updateQuery.append("$set", updateFields);
                    userDB.updateOne(new Document("userName", user.getString("userName")), updateQuery);
                    bkpOverviewDB.updateOne(new Document("userName", user.getString("userName")), updateQuery);
                    Document syncPolicy = (Document)syncPolicyDB.find(new Document("policyName", user.getString("syncPolicyName"))).first();
                    DBRef userDBRef = new DBRef("USER", user.getObjectId("_id"));
                    DBRef bkpDBRef = new DBRef("BACKUP_POLICY", bkpPolicy.getObjectId("_id"));
                    Document userbkpOverview = new Document();
                    userbkpOverview.put("user", (Object)userDBRef);
                    userbkpOverview.put("backupPolicy", (Object)bkpDBRef);
                    if (syncPolicy != null) {
                        DBRef syncDBref = new DBRef("SYNC_POLICY", syncPolicy.getObjectId("_id"));
                        userbkpOverview.put("syncPolicy", (Object)syncDBref);
                        userbkpOverview.put("lastUpdatedSyncTimeStamp", (Object)System.currentTimeMillis());
                    }
                    userbkpOverview.put("lastUpdatedTimeStamp", (Object)System.currentTimeMillis());
                    userBkpMappingDB.insertOne(userbkpOverview);
                    continue;
                }
                if (count == 1L) {
                    Document userPolicyMapping = (Document)userBkpMappingDB.find(new Document("user", new DBRef("USER", user.getObjectId("_id")))).first();
                    if (userPolicyMapping.get("backupPolicy") == null) continue;
                    DBRef bkpPolicyDBRef = (DBRef)userPolicyMapping.get("backupPolicy");
                    Document bkpPolicy = (Document)bkpPolicyDB.find(new Document("_id", bkpPolicyDBRef.getId())).first();
                    BasicDBObject updateQuery = new BasicDBObject();
                    BasicDBObject updateFields = new BasicDBObject();
                    updateFields.append("policyName", bkpPolicy.getString("policyName"));
                    updateQuery.append("$set", updateFields);
                    UpdateResult updateOne = userDB.updateOne(new Document("_id", user.getObjectId("_id")), updateQuery);
                    bkpOverviewDB.updateOne(new Document("userName", user.getString("userName")), updateQuery);
                    continue;
                }
                if (count <= 1L) continue;
                Document usersBkpPolicesMapping = (Document)userBkpMappingDB.find(new Document("user", new DBRef("USER", user.getObjectId("_id")))).sort(new BasicDBObject("lastUpdatedTimeStamp", (Object)1)).first();
                FindIterable<Document> usersBkpPolicesMappingList = userBkpMappingDB.find(new Document("user", new DBRef("USER", user.getObjectId("_id"))));
                ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
                System.out.println(usersBkpPolicesMapping.getObjectId("_id"));
                for (Document map : usersBkpPolicesMappingList) {
                    if (map.getObjectId("_id").equals(usersBkpPolicesMapping.getObjectId("_id"))) continue;
                    ids.add(map.getObjectId("_id"));
                }
                for (ObjectId id : ids) {
                    System.out.println("............" + id);
                    userBkpMappingDB.findOneAndDelete(new BasicDBObject("_id", id));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

