/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import Utility.com.parablu.HttpClientUtil;
import Utility.com.parablu.MD5Generator;
import Utility.com.parablu.Office365;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.FileStatusElement;
import com.parablu.pcbd.domain.PciAuthorizationTokenElement;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.util.EntityUtils;
import org.bson.Document;
import org.json.JSONObject;

public class OneDriveChunksCleaning {
    private static final String PERSONAL_URL = "/personal/";
    private static final String BEARER = "Bearer ";
    public static final String HEADER_KEY_ACCEPT = "Accept";
    public static final String HEADER_VALUE_APPLICATION_JSON = "application/json;odata=verbose";
    public static final String HEADER_KEY_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_KEY_GATEWAY_TYPE = "gatewayType";

    public static void main(String[] args) throws ConfigurationException, JsonParseException, JsonMappingException, IOException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String deviceUUID = config.getProperty("deviceUUID").toString();
        String userName = config.getProperty("userName").toString();
        String chunkCollName = config.getProperty("chunkCollName").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        Document userDBObject = (Document)userDBCollection.find(new Document("userName", userName)).first();
        String userODBID = "";
        userODBID = !StringUtils.isEmpty(userDBObject.getString("odbLoginId")) ? userDBObject.getString("odbLoginId") : userDBObject.getString("emailId");
        MongoCollection<Document> tokenCollection = db.getCollection("PCI_AUTHORIZATION_TOKENS");
        MongoCollection<Document> chunkColl = db.getCollection("CHUNK_DETAIL");
        Document tokenDoc = (Document)tokenCollection.find().first();
        PciAuthorizationTokenElement pciAuthorizationTokenElement = new PciAuthorizationTokenElement();
        pciAuthorizationTokenElement.setAccessToken(tokenDoc.getString("accessToken"));
        pciAuthorizationTokenElement.setAccountId(userODBID);
        pciAuthorizationTokenElement.setAuthenticationToken(tokenDoc.getString("authenticationToken"));
        pciAuthorizationTokenElement.setClientId(tokenDoc.getString("clientId"));
        pciAuthorizationTokenElement.setSharePointUrl(tokenDoc.getString("sharePointUrl"));
        pciAuthorizationTokenElement.setClientSecret(tokenDoc.getString("clientSecret"));
        pciAuthorizationTokenElement.setCloudName(tokenDoc.getString("cloudName"));
        pciAuthorizationTokenElement.setEmailId(userODBID);
        pciAuthorizationTokenElement.setRefreshToken(tokenDoc.getString("refreshToken"));
        MongoCollection<Document> chunksDBCollection = db.getCollection(chunkCollName.toUpperCase());
        int totalCount = 0;
        int i = 0;
        while (i <= 200) {
            int itemCount = OneDriveChunksCleaning.getCountOfFilesInFolder(pciAuthorizationTokenElement, "" + i);
            totalCount = itemCount + totalCount;
            System.out.println("************* ITEM COUNT********* for " + i + " " + itemCount);
            ++i;
        }
        System.out.println("................totalCount...." + totalCount);
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("newRef", false));
        whereQuery.add(new BasicDBObject("deleted", new BasicDBObject("$exists", false)));
        andQuery.put("$and", whereQuery);
        boolean proccessCount = false;
        int skip = 0;
        FindIterable<Document> chunksList = chunksDBCollection.find(andQuery).limit(500);
        do {
            ++skip;
        } while ((chunksList = chunksDBCollection.find(andQuery).limit(500)) != null);
    }

    private static ChunkFile getChunkFiles(String md5, MongoDatabase db, int chunkCollCount, String userName) {
        MongoCollection<Document> chunkColl = db.getCollection("CHUNK_DETAIL");
        ChunkFile chunkFile = null;
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("md5", md5));
        whereQuery.add(new BasicDBObject("userName", userName));
        andQuery.put("$and", whereQuery);
        Document chunk = null;
        try (MongoCursor cursor = chunkColl.find(andQuery).limit(1).iterator();){
            if (cursor.hasNext()) {
                Document next;
                chunk = next = (Document)cursor.next();
            }
        }
        if (chunk == null) {
            int hashCode = Arrays.hashCode(md5.getBytes());
            int chunkDetailDest = Math.abs(hashCode % chunkCollCount);
            chunkColl = db.getCollection("CHUNK_DETAIL_" + chunkDetailDest);
            try (MongoCursor cursor1 = chunkColl.find(andQuery).limit(1).iterator();){
                if (cursor1.hasNext()) {
                    Document next;
                    chunk = next = (Document)cursor1.next();
                }
            }
        }
        if (chunk != null) {
            chunkFile = new ChunkFile();
            chunkFile.setCloudStoragePath(chunk.getString("cloudStoragePath"));
            chunkFile.setFileName(chunk.getString("cloudChunkName"));
            chunkFile.setMd5(chunk.getString("md5"));
        }
        return chunkFile;
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    private static List<Document> getFolderList(String deviceUUID, MongoCollection bkpColl) {
        FindIterable folders;
        ArrayList<Document> allFoldersList = new ArrayList<Document>();
        int skip = 0;
        System.out.println("getting folders................");
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery.add(new BasicDBObject("folder", true));
        whereQuery.add(new BasicDBObject("present", true));
        andQuery.put("$and", whereQuery);
        while ((folders = bkpColl.find(andQuery).skip(skip * 500).limit(500)).first() != null) {
            for (Document document : folders) {
                allFoldersList.add(document);
            }
            ++skip;
        }
        System.out.println("Done folders   " + allFoldersList.size() + " for deviceUUID " + deviceUUID);
        return allFoldersList;
    }

    private static String convertStringTOBase64(String name) {
        String base64EncodeString = null;
        if (name != null) {
            byte[] bytes = DigestUtils.md5(name);
            byte[] bytesEncoded = Base64.encodeBase64(bytes);
            base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
            base64EncodeString = base64EncodeString.replaceAll("/", "_");
        }
        return base64EncodeString;
    }

    private static int downloadFileFromOneDrive(PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID, Document userDBObject, boolean oldVersion, String bkpFileName) {
        block11: {
            int responseCode;
            String fileNameTemp;
            block10: {
                fileNameTemp = fileName;
                if (fileName.equalsIgnoreCase("e6e1ca2cb323c35ed29c37e9831359ba.59ad1f49e4b0a48286d37f13")) {
                    System.out.println("... file name before .... " + fileNameTemp);
                }
                fileNameTemp = OneDriveChunksCleaning.convertStringTOBase64(fileNameTemp);
                if (fileName.equalsIgnoreCase("e6e1ca2cb323c35ed29c37e9831359ba.59ad1f49e4b0a48286d37f13")) {
                    System.out.println("... file name after .... " + fileNameTemp);
                }
                String pbFolderName = "PB";
                String userNameInPath = "";
                String downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileNameTemp, authorizationTokenElement.getAccountId(), userNameInPath, chunkFile.getCloudStoragePath(), pbFolderName);
                if (fileName.equalsIgnoreCase("e6e1ca2cb323c35ed29c37e9831359ba.59ad1f49e4b0a48286d37f13")) {
                    System.out.println("... file name downloadurl .... " + downloadurl);
                }
                HttpGet httpGet = new HttpGet(downloadurl);
                httpGet.addHeader("Authorization", BEARER + authorizationTokenElement.getAccessToken());
                httpGet.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
                httpGet.addHeader(HEADER_KEY_CONTENT_TYPE, "*/*");
                HttpResponse result = null;
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                int timeout = 3;
                System.out.println("url ........." + downloadurl + "............start time stamp ....." + System.currentTimeMillis());
                RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
                httpGet.setConfig(config);
                result = httpclient.execute(httpGet);
                responseCode = result.getStatusLine().getStatusCode();
                System.out.println(String.valueOf(responseCode) + "..................response timestamp.................." + System.currentTimeMillis());
                if (responseCode != 200) break block10;
                return 200;
            }
            try {
                if (responseCode == 401) {
                    Office365.getAccessToken(authorizationTokenElement);
                    if (authorizationTokenElement != null) {
                        if (authorizationTokenElement.isServiceAcct()) {
                            authorizationTokenElement.setServiceAcct(true);
                        }
                        return OneDriveChunksCleaning.retryDownloadFileFromOneDrive(authorizationTokenElement, fileNameTemp, chunkFile, deviceUUID, userDBObject, oldVersion);
                    }
                    break block11;
                }
                if (responseCode == 404) {
                    return OneDriveChunksCleaning.retryDownloadFileFromOneDrive(authorizationTokenElement, fileNameTemp, chunkFile, deviceUUID, userDBObject, oldVersion);
                }
                System.out.println("..............Download statuse code" + responseCode + "...................");
                return OneDriveChunksCleaning.retryDownloadFileFromOneDrive(authorizationTokenElement, fileNameTemp, chunkFile, deviceUUID, userDBObject, oldVersion);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 1;
    }

    public static int retryDownloadFileFromOneDrive(PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID, Document userDBObject, boolean oldVersion) {
        boolean retry;
        String pbFolderName = "PB";
        String userNameInPath = "";
        String downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), userNameInPath, chunkFile.getCloudStoragePath(), pbFolderName);
        String originalPath = chunkFile.getCloudStoragePath();
        boolean incrementPath = false;
        boolean decrementPath = false;
        boolean newPathCheck = false;
        boolean oldStylePath = false;
        boolean customOldStylePath = false;
        boolean increOldStylePath = false;
        boolean decreOldStylePath = false;
        boolean newPathCheckOnly = false;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 5000L * (long)sleepMultiplier;
        int responseCode = 0;
        do {
            retry = false;
            HttpGet httpGet = null;
            String modifiedPath = chunkFile.getCloudStoragePath();
            try {
                int path;
                String cloudPath;
                httpGet = new HttpGet(downloadurl);
                httpGet.addHeader("Authorization", BEARER + authorizationTokenElement.getAccessToken());
                httpGet.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
                httpGet.addHeader(HEADER_KEY_CONTENT_TYPE, "*/*");
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                int timeout = 3;
                RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
                httpGet.setConfig(config);
                HttpResponse result = httpclient.execute(httpGet);
                responseCode = result.getStatusLine().getStatusCode();
                System.out.println("Retry Response status code: " + responseCode + " ...Download Path ...." + downloadurl);
                if (responseCode == 200) {
                    return responseCode;
                }
                if (responseCode == 401) {
                    retry = true;
                    ++retryCount;
                    sleepTime = OneDriveChunksCleaning.sleepForGivenTime(sleepTime);
                    authorizationTokenElement = Office365.getAccessToken(authorizationTokenElement);
                    continue;
                }
                if (responseCode == 200) continue;
                retry = true;
                ++retryCount;
                sleepTime = responseCode != 404 ? OneDriveChunksCleaning.sleepForGivenTime(sleepTime) : 0L;
                if (responseCode != 404) continue;
                if (!increOldStylePath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), "", cloudPath, pbFolderName);
                    modifiedPath = cloudPath;
                    increOldStylePath = true;
                    continue;
                }
                if (!newPathCheckOnly && OneDriveChunksCleaning.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    cloudPath = "" + OneDriveChunksCleaning.getRetryOdbFolderValue();
                    downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), userNameInPath, cloudPath, pbFolderName);
                    newPathCheckOnly = true;
                    modifiedPath = cloudPath;
                    continue;
                }
                if (!newPathCheck && OneDriveChunksCleaning.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + OneDriveChunksCleaning.getRetryOdbFolderValue());
                    }
                    downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), userNameInPath, cloudPath, pbFolderName);
                    newPathCheck = true;
                    modifiedPath = cloudPath;
                    continue;
                }
                if (!decrementPath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path - 1);
                    }
                    downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), userNameInPath, cloudPath, pbFolderName);
                    decrementPath = true;
                    modifiedPath = cloudPath;
                    continue;
                }
                if (!incrementPath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), userNameInPath, cloudPath, pbFolderName);
                    modifiedPath = cloudPath;
                    incrementPath = true;
                    continue;
                }
                if (!oldStylePath) {
                    downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), "", chunkFile.getCloudStoragePath(), pbFolderName);
                    oldStylePath = true;
                    continue;
                }
                if (!customOldStylePath && OneDriveChunksCleaning.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + OneDriveChunksCleaning.getRetryOdbFolderValue());
                    }
                    downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), "", cloudPath, pbFolderName);
                    customOldStylePath = true;
                    modifiedPath = cloudPath;
                    continue;
                }
                if (decreOldStylePath) continue;
                cloudPath = chunkFile.getCloudStoragePath();
                if (StringUtils.isNotEmpty(cloudPath)) {
                    path = Integer.parseInt(cloudPath);
                    cloudPath = "" + (path - 1);
                }
                downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElement.getSharePointUrl(), fileName, authorizationTokenElement.getAccountId(), "", cloudPath, pbFolderName);
                decreOldStylePath = true;
                modifiedPath = cloudPath;
            }
            catch (Exception e) {
                retry = true;
                ++retryCount;
                sleepTime = OneDriveChunksCleaning.sleepForGivenTime(sleepTime);
                e.printStackTrace();
            }
        } while (retry && retryCount < 8);
        return responseCode;
    }

    public static String getLibraryDownloadUrl(String office365baseUrl, String fileName, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(office365baseUrl) + personalUrl + OneDriveChunksCleaning.getEmailId(accountId) + "/_api/web/GetFolderByServerRelativeUrl('" + personalUrl + OneDriveChunksCleaning.getEmailId(accountId) + "/" + pbFolderName + "/" + userName + "/" + suffixFolderPath + "')" + "/Files('" + fileName + "')/$value";
    }

    private static String getEmailId(String emailId) {
        String replacedEmailId = emailId.replace(".", "_");
        replacedEmailId = replacedEmailId.replace("@", "_");
        return replacedEmailId;
    }

    private static int getRetryOdbFolderValue() {
        return 3000;
    }

    private static long sleepForGivenTime(long sleepTime) {
        long sleepTimeTemp = sleepTime;
        try {
            Thread.sleep(sleepTimeTemp);
            int sleepMultiplier = 2;
            sleepTimeTemp *= (long)sleepMultiplier;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return sleepTimeTemp;
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!StringUtils.isEmpty(deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString(deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }

    public static boolean deleteFileFromODB(PciAuthorizationTokenElement pciTokenElement, String fileName, String cloudStoragePath, String deviceUUID) {
        boolean retry;
        FileStatusElement fileStatus;
        String fileNameTemp = fileName;
        FileStatusElement fileStatusElement = new FileStatusElement();
        PciAuthorizationTokenElement authorizationTokenElementTemp = pciTokenElement;
        fileNameTemp = OneDriveChunksCleaning.convertStringTOBase64(fileNameTemp).replaceAll("/", "_");
        String userNameInPath = "";
        if (!StringUtils.isEmpty(deviceUUID)) {
            userNameInPath = OneDriveChunksCleaning.getUniqueODUserFolder(deviceUUID);
            System.out.println("....device unique id ....... " + userNameInPath);
        }
        if ((fileStatus = OneDriveChunksCleaning.getFilePathToDelete(pciTokenElement, fileNameTemp, cloudStoragePath)) == null) {
            System.out.println("File not found on any path so return false ");
            return false;
        }
        String deleteUrl = fileStatus.getDeleteFileUrl();
        String deleteFileUrl = deleteUrl.substring(0, deleteUrl.length() - 7);
        int retryCount = 0;
        boolean success = false;
        do {
            retry = false;
            System.out.println(String.valueOf(retryCount) + "..retrycount...url>>>>>>>>>>>" + deleteFileUrl);
            HttpPost httpPost = new HttpPost(deleteFileUrl);
            httpPost.addHeader("Authorization", BEARER + authorizationTokenElementTemp.getAccessToken());
            httpPost.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
            httpPost.addHeader("X-HTTP-Method", "DELETE");
            HttpResponse result = null;
            try {
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                int timeout = 3;
                RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
                httpPost.setConfig(config);
                result = httpclient.execute(httpPost);
                int responseCode = result.getStatusLine().getStatusCode();
                System.out.println(" Delete Response Code.." + responseCode);
                if (responseCode == 200) {
                    success = true;
                } else if (responseCode == 401) {
                    System.out.println("inside get access token...");
                    retry = true;
                    ++retryCount;
                    authorizationTokenElementTemp = Office365.getAccessToken(authorizationTokenElementTemp);
                    OneDriveChunksCleaning.deleteFileFromODB(pciTokenElement, fileName, cloudStoragePath, deviceUUID);
                }
                System.out.println("retry...." + retry + " count:" + retryCount);
            }
            catch (Exception e) {
                System.out.println("error while trying to delete file...." + e.getMessage());
                System.out.println("error while trying to delete file...." + e);
                return success;
            }
        } while (retry && retryCount < 2);
        return success;
    }

    public static String getParabluLibraryUrl(String office365baseUrl, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = OneDriveChunksCleaning.getPersonalSite(office365baseUrl, accountId);
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(personalSite) + "/_api/web/GetFolderByServerRelativeUrl('" + personalUrl + OneDriveChunksCleaning.getEmailId(accountId) + "/" + pbFolderName + userName + "/" + suffixFolderPath + "/')";
    }

    public static String getPersonalSite(String office365baseUrl, String accountId) {
        if (accountId.contains("sites/")) {
            return String.valueOf(office365baseUrl) + "/" + OneDriveChunksCleaning.getEmailId(accountId);
        }
        return String.valueOf(office365baseUrl) + PERSONAL_URL + OneDriveChunksCleaning.getEmailId(accountId);
    }

    public static FileStatusElement getFilePathToDelete(PciAuthorizationTokenElement authorizationTokenElement, String fileName, String chunkFilePath) {
        boolean retry;
        FileStatusElement fileStatusElement = new FileStatusElement();
        String pbFolderName = "PB";
        PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
        String userNameInPath = "";
        String downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), userNameInPath, chunkFilePath, pbFolderName);
        boolean incrementPath = false;
        boolean decrementPath = false;
        boolean newPathCheck = false;
        boolean oldStylePath = false;
        boolean customOldStylePath = false;
        boolean increOldStylePath = false;
        boolean decreOldStylePath = false;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 5000L * (long)sleepMultiplier;
        do {
            retry = false;
            HttpGet httpGet = null;
            String modifiedPath = chunkFilePath;
            try {
                int path;
                String cloudPath;
                System.out.println(String.valueOf(downloadurl) + "......attempt url........" + retryCount);
                httpGet = new HttpGet(downloadurl);
                httpGet.addHeader("Authorization", BEARER + authorizationTokenElementTemp.getAccessToken());
                httpGet.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
                httpGet.addHeader(HEADER_KEY_CONTENT_TYPE, "*/*");
                System.out.println(" without proxy ...");
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                HttpResponse result = httpclient.execute(httpGet);
                int responseCode = result.getStatusLine().getStatusCode();
                fileStatusElement.setDeleteStatuscode(responseCode);
                System.out.println(">>>>>>>>>>>>>>>>>file Response status code: " + responseCode);
                if (responseCode == 200) {
                    System.out.println("File found so return path is " + downloadurl);
                    fileStatusElement.setDeleteStatus(true);
                    fileStatusElement.setDeleteFileUrl(downloadurl);
                    return fileStatusElement;
                }
                if (responseCode == 401) {
                    retry = true;
                    ++retryCount;
                    sleepTime = OneDriveChunksCleaning.sleepForGivenTime(sleepTime);
                    authorizationTokenElementTemp = Office365.getAccessToken(authorizationTokenElementTemp);
                    continue;
                }
                if (responseCode == 200) continue;
                retry = true;
                sleepTime = responseCode != 404 ? OneDriveChunksCleaning.sleepForGivenTime(sleepTime) : 0L;
                System.out.println("..retry attempt for response code ...." + responseCode + "...." + ++retryCount);
                if (responseCode != 404) continue;
                if (!increOldStylePath) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), "", cloudPath, pbFolderName);
                    modifiedPath = cloudPath;
                    System.out.println("...increOldStylePath..." + modifiedPath);
                    increOldStylePath = true;
                    continue;
                }
                if (!newPathCheck && OneDriveChunksCleaning.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + OneDriveChunksCleaning.getRetryOdbFolderValue());
                    }
                    downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), userNameInPath, cloudPath, pbFolderName);
                    newPathCheck = true;
                    modifiedPath = cloudPath;
                    System.out.println("...newPathCheck ..." + modifiedPath);
                    continue;
                }
                if (!decrementPath) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path - 1);
                    }
                    downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), userNameInPath, cloudPath, pbFolderName);
                    decrementPath = true;
                    modifiedPath = cloudPath;
                    System.out.println("...decre new path..." + modifiedPath);
                    continue;
                }
                if (!incrementPath) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), userNameInPath, cloudPath, pbFolderName);
                    modifiedPath = cloudPath;
                    System.out.println("...incre new path..." + modifiedPath);
                    incrementPath = true;
                    continue;
                }
                if (!oldStylePath) {
                    downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), "", chunkFilePath, pbFolderName);
                    oldStylePath = true;
                    System.out.println("...oldStylePath restore ...");
                    continue;
                }
                if (!customOldStylePath && OneDriveChunksCleaning.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + OneDriveChunksCleaning.getRetryOdbFolderValue());
                    }
                    downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), "", cloudPath, pbFolderName);
                    customOldStylePath = true;
                    modifiedPath = cloudPath;
                    System.out.println("...customOldStylePath retryodbValue ..." + modifiedPath);
                    continue;
                }
                if (decreOldStylePath) continue;
                cloudPath = chunkFilePath;
                if (StringUtils.isNotEmpty(cloudPath)) {
                    path = Integer.parseInt(cloudPath);
                    cloudPath = "" + (path - 1);
                }
                downloadurl = OneDriveChunksCleaning.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), "", cloudPath, pbFolderName);
                decreOldStylePath = true;
                modifiedPath = cloudPath;
                System.out.println("...decreOldStylePath..." + modifiedPath);
            }
            catch (Exception e) {
                retry = true;
                ++retryCount;
                sleepTime = OneDriveChunksCleaning.sleepForGivenTime(sleepTime);
                System.out.println("Exception While Retying Download File From One Drive :" + e.getMessage());
            }
        } while (retry && retryCount < 8);
        return fileStatusElement;
    }

    public static int getCountOfFilesInFolder(PciAuthorizationTokenElement ppciTokenElement, String cloudStoragePath) {
        String userNameToGetUrl = "";
        PciAuthorizationTokenElement pciTokenElement = ppciTokenElement;
        String pbFolderName = "PB";
        String paraBluFolderPath = OneDriveChunksCleaning.getParabluLibraryUrl(pciTokenElement.getSharePointUrl(), pciTokenElement.getAccountId(), userNameToGetUrl, cloudStoragePath, pbFolderName);
        int count = 0;
        String fileUrl = String.valueOf(paraBluFolderPath) + "/itemcount";
        HttpGet httpGet = new HttpGet(fileUrl);
        httpGet.addHeader("Authorization", BEARER + pciTokenElement.getAccessToken());
        httpGet.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
        HttpResponse result = null;
        try {
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            result = httpclient.execute(httpGet);
            int statusCode = result.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                pciTokenElement = Office365.getAccessToken(pciTokenElement);
                int n = OneDriveChunksCleaning.getCountOfFilesInFolder(pciTokenElement, cloudStoragePath);
                return n;
            }
            if (statusCode != 200) {
                System.out.println(" path doesnot exists ......... " + statusCode);
                int n = count;
                return n;
            }
            try {
                String json = EntityUtils.toString(result.getEntity());
                JSONObject jsonObject = new JSONObject(json);
                String itemCount = jsonObject.optString("d");
                if (itemCount != null) {
                    jsonObject = new JSONObject(new String(itemCount));
                    itemCount = jsonObject.optString("ItemCount");
                    count = Integer.parseInt(itemCount);
                }
            }
            catch (Exception e) {
                System.out.println("" + e);
                System.out.println("Exception While Getting Count of Files In Folder :" + e.getMessage());
            }
        }
        finally {
            httpGet.releaseConnection();
        }
        return count;
    }

    private static String getChunkDetailCollections(String md5) {
        int hashCode = Arrays.hashCode(md5.getBytes());
        int chunkDetailDest = Math.abs(hashCode % 101);
        return "CHUNK_DETAIL_" + chunkDetailDest;
    }
}

