/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class MntFilesCleanning {
    public static final String LOCAL = "_local";
    public static final String BACKUP_PG = "backup_pg";
    private static final String PRIVACY_GATEWAY_BACKUP = "privacy_gateway_backup_";
    public static final String PATH_SEPARATOR_ANDROID = "/";
    public static final String PATH_SEPARATOR_WINDOWS = "\\";

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String cloudName = config.getProperty("cloudName").toString();
        String deviceUUIDValue = config.getProperty("deviceUUID").toString();
        int limit = Integer.parseInt(config.getProperty("limit").toString());
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + "27017" + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoClientURI localUri = new MongoClientURI("mongodb://neil:parablu@localhost:27017/blukrypt");
        MongoClient localclient = new MongoClient(localUri);
        MongoDatabase localDB = localclient.getDatabase(localUri.getDatabase());
        String localDBName = PRIVACY_GATEWAY_BACKUP + cloudName + LOCAL;
        System.out.println("connectivity success  ");
        MongoCollection<Document> privacyGatewayLocal = localDB.getCollection(localDBName.toUpperCase());
        MongoCollection<Document> usrCollection = db.getCollection("USER");
        MongoCollection<Document> deviceDBCollection = db.getCollection("DEVICE");
        BasicDBObject query = new BasicDBObject();
        if (!StringUtils.isEmpty(deviceUUIDValue)) {
            query = new BasicDBObject("deviceUUID", deviceUUIDValue);
        }
        FindIterable<Document> localFilesList = privacyGatewayLocal.find(query);
        int totalFileCount = 0;
        int notpressentFiles = 0;
        int deletedFiles = 0;
        MongoCollection<Document> bkpPG = db.getCollection("BACKUP_PG");
        int actualDeletedFiles = 0;
        for (Document localFile : localFilesList) {
            String status;
            BasicDBObject deviceQuery = new BasicDBObject("deviceUUID", localFile.getString("deviceUUID"));
            Document device = (Document)deviceDBCollection.find(deviceQuery).first();
            MongoCollection<Document> bkp = db.getCollection(device.getString("destCollection"));
            BasicDBObject andQuery = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("_id", localFile.getObjectId("_id")));
            andQuery.put("$and", whereQuery);
            int bkpFileCount = (int)bkp.count(andQuery);
            if (bkpFileCount == 0) {
                ++totalFileCount;
                ++notpressentFiles;
                System.out.println("File is not present in " + device.getString("destCollection") + " ....... " + localFile.getString("fileName") + " ande device path " + localFile.getString("filePath") + " object ID is " + localFile.getObjectId("_id"));
                String filePath = "/parablu/" + cloudName + "/upload/" + localFile.getString("deviceUUID") + PATH_SEPARATOR_ANDROID + localFile.getString("batchId") + "/chunk/";
                List chunkList = (List)localFile.get("chunkFiles");
                boolean allChunksDeleted = true;
                Iterator iterator = chunkList.iterator();
                while (iterator.hasNext()) {
                    File chunkFile;
                    String chunk;
                    String chunkName = chunk = (String)iterator.next();
                    if (chunk.startsWith("part")) {
                        chunkName = chunk.replaceAll("." + localFile.getObjectId("_id").toString(), "");
                    }
                    if (!(chunkFile = new File(String.valueOf(filePath) + chunkName)).exists()) {
                        File dir = new File(filePath);
                        Object[] files = dir.list(new PrefixFileFilter(chunkName));
                        if (ArrayUtils.isNotEmpty(files)) {
                            File fileDup = new File(String.valueOf(filePath) + PATH_SEPARATOR_ANDROID + (String)files[0]);
                            if (fileDup.delete()) continue;
                            System.out.println("chunk exists delete fails " + fileDup.getAbsolutePath());
                            allChunksDeleted = false;
                            continue;
                        }
                        allChunksDeleted = false;
                        System.out.println(".......Chunks not present at all......." + chunkFile);
                        continue;
                    }
                    if (chunkFile.delete()) continue;
                    System.out.println("chunk exists delete fails " + chunkFile.getAbsolutePath());
                    allChunksDeleted = false;
                }
                if (!allChunksDeleted) continue;
                System.out.println("File deleted " + localFile.getObjectId("_id"));
                ++actualDeletedFiles;
                bkpPG.findOneAndDelete(andQuery);
                privacyGatewayLocal.findOneAndDelete(andQuery);
                if (limit == 0) continue;
                if (actualDeletedFiles >= limit) {
                    System.out.println(String.valueOf(actualDeletedFiles) + " total " + limit + " -- files got deleted........");
                }
                return;
            }
            Document bkpImage = (Document)bkp.find(andQuery).first();
            if (bkpImage == null || StringUtils.isEmpty(bkpImage.getString("status")) || !(status = bkpImage.getString("status")).equals("DELETED")) continue;
            ++totalFileCount;
            ++deletedFiles;
            System.out.println("File is DELETED status in " + device.getString("destCollection") + " ....... " + localFile.getString("fileName") + " ande device path " + localFile.getString("filePath") + " object ID is " + localFile.getObjectId("_id"));
        }
        System.out.println("toatl files count :" + totalFileCount + " notpressentFiles :" + notpressentFiles + " deletedFiles :" + deletedFiles);
    }
}

