/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class CreateDeviceBkpOverview {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        try {
            MongoCollection<Document> deviceDBCollection = db.getCollection("DEVICE");
            MongoCollection<Document> bkpOverviewDBCollection = db.getCollection("DEVICE_BACKUP_OVERVIEW");
            MongoCollection<Document> userDBCollection = db.getCollection("USER");
            FindIterable<Document> devices = deviceDBCollection.find();
            long taotalDeviceCount = deviceDBCollection.count();
            System.out.println("Total device count : " + taotalDeviceCount);
            for (Document device : devices) {
                long deviceBkpOverviewCount = bkpOverviewDBCollection.count(new Document("deviceUUID", device.get("deviceUUID")));
                if (deviceBkpOverviewCount != 0L) continue;
                Document userDBObject = (Document)userDBCollection.find(new Document("userName", device.get("userName"))).first();
                Document newBkpOverview = new Document();
                newBkpOverview.put("userName", (Object)userDBObject.getString("userName"));
                newBkpOverview.put("isUserActive", (Object)userDBObject.getBoolean("active"));
                newBkpOverview.put("isUserDeleted", (Object)userDBObject.getBoolean("deleted"));
                if (StringUtils.isNotEmpty(userDBObject.getString("emailId"))) {
                    newBkpOverview.put("emailId", (Object)userDBObject.getString("emailId"));
                }
                if (StringUtils.isNotEmpty(userDBObject.getString("location"))) {
                    newBkpOverview.put("location", (Object)userDBObject.getString("location"));
                }
                if (StringUtils.isNotEmpty(userDBObject.getString("department"))) {
                    newBkpOverview.put("department", (Object)userDBObject.getString("department"));
                }
                if (userDBObject.get("accountStatus") != null) {
                    newBkpOverview.put("accountStatus", (Object)Boolean.parseBoolean(userDBObject.get("accountStatus").toString()));
                }
                if (userDBObject.get("displayName") != null) {
                    newBkpOverview.put("displayName", (Object)userDBObject.getString("displayName"));
                }
                newBkpOverview.put("policyName", (Object)userDBObject.getString("policyName"));
                newBkpOverview.put("deviceName", (Object)device.getString("deviceName"));
                newBkpOverview.put("deviceUUID", (Object)device.getString("deviceUUID"));
                newBkpOverview.put("isDeviceBolcked", (Object)device.getBoolean("blocked"));
                newBkpOverview.put("isDeviceDeleted", (Object)device.getBoolean("deleted"));
                newBkpOverview.put("clientVersion", (Object)device.getString("clientVersion"));
                newBkpOverview.put("epaInstallationDate", (Object)device.getString("deviceCreatedDate"));
                bkpOverviewDBCollection.insertOne(newBkpOverview);
                System.out.println("Update for deviceUUID :" + device.get("deviceUUID").toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

