/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.restore;

import com.google.common.util.concurrent.RateLimiter;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.service.backup.interfaces.CleanupInterface;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.RestoreAdapter;
import com.parablu.epa.core.element.RestoreElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartRestoreCallable
implements Callable<Integer> {
    private Logger logger = LoggerFactory.getLogger(MultipartRestoreCallable.class);
    List<BackupTO> chunkFileBatch;
    GatewayTO uploadGatewayTo;
    String requestURL;
    String backupBatchID;
    BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
    BackupActivityTO backupActivityTO = this.backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
    BackupPolicyTO backupPolicyTO;
    CleanupInterface<BackupTO> cleanupInterface;
    int priority;
    private RateLimiter rateLimiter;
    private static final String EXCEPTION_OCCURED = "Exception Occured";
    private static final String FALSE = "false";
    private int errorCode;
    private List<BackupTO> failedBackupTOs;
    private BlockingQueue<Future<BackupTO>> finishedBatchesQueue;
    RestoreAdapter multiThreadRestoreAdapter = null;
    RestoreElement restoreElement;
    RestoreElement restoreElement1;
    AtomicBoolean stopRestore;
    String restoreIp;
    AtomicInteger restoreCount;
    AtomicLong restoredSize;
    private AtomicInteger noOfBatches;

    public MultipartRestoreCallable(RestoreElement restoreElement, AtomicBoolean stopRestore, String restoreIp, AtomicInteger restoreCount, AtomicLong restoredSize, RestoreElement restoreElement1, AtomicInteger noOfBatches) {
        this.restoreElement = restoreElement;
        this.stopRestore = stopRestore;
        this.restoreIp = restoreIp;
        this.restoreCount = restoreCount;
        this.restoredSize = restoredSize;
        this.restoreElement1 = restoreElement1;
        this.noOfBatches = noOfBatches;
        this.logger.debug("MultipartRestoreCallable........." + restoreElement.getDevicePath());
    }

    @Override
    public Integer call() throws InterruptedException {
        boolean retry;
        try {
            this.logger.debug("Before creating adapter connection");
            this.multiThreadRestoreAdapter = new RestoreAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            this.logger.debug("After creating adapter connection");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            this.errorCode = 909;
            this.logger.trace("" + e1);
            this.logger.error("error in multipart restore adapter call" + e1.getMessage());
        }
        if (Thread.currentThread().isInterrupted()) {
            this.cancelUpload();
            return null;
        }
        AtomicInteger skipValue = new AtomicInteger(0);
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 60000L * (long)sleepMultiplier;
        this.stopRestore.set(false);
        Integer port = null;
        do {
            retry = false;
            if (SettingHelper.getHttpsPort() != null) {
                port = Integer.valueOf(SettingHelper.getHttpsPort());
            }
            try {
                if ((SettingHelper.getBackupLicenced().equalsIgnoreCase("true") || SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) && SettingHelper.getIsExternalStorageSelected().equalsIgnoreCase("true") && !StringUtils.isEmpty((String)this.restoreIp)) {
                    int response1 = this.multiThreadRestoreAdapter.downloadFileViaGateway1(this.restoreIp, port, SettingHelper.readTokenFromFile(), SettingHelper.getCloudName(), this.restoreElement, skipValue, SettingHelper.getDeviceUUId(), this.restoreElement1, SettingHelper.getOsName());
                    if (response1 == 204) {
                        NotificationHelper.successfulRestore = 5;
                    }
                    if (response1 == 429) {
                        this.stopRestore.set(true);
                        NotificationHelper.successfulRestore = 7;
                        return 429;
                    }
                    if (response1 != 4) {
                        this.logger.debug("....FILE_DOWNLOAD nots_SUCESS .");
                        NotificationHelper.successfulRestore = 0;
                    }
                    if (response1 == 4 && "0".equalsIgnoreCase(this.restoreElement1.getRestoreCount())) {
                        NotificationHelper.successfulRestore = 2;
                    }
                    this.restoreCount.addAndGet(Integer.valueOf(this.restoreElement.getRestoreCount().trim()));
                    this.restoredSize.addAndGet(this.restoreElement.getTotalRestoredSize());
                    this.restoreElement1.setRestoreCount("" + this.restoreCount.get());
                    this.restoreElement1.setTotalRestoredSize(this.restoredSize.get());
                    this.restoreElement1.setFileBeingRestored(this.restoreElement.getFileBeingRestored());
                    this.noOfBatches.incrementAndGet();
                    this.restoreElement1.setRestoredFolderCount(this.noOfBatches.get());
                    this.logger.debug(this.restoreElement.getFileBeingRestored() + " restore count and size:" + this.restoreCount.get() + " " + this.restoredSize.get());
                    return response1;
                }
                NotificationHelper.successfulRestore = 0;
                this.logger.debug("Restore Failed");
                return 0;
            }
            catch (CrawlAdapterException e) {
                this.logger.debug("Exception : " + e);
                this.logger.error("Crawl Adapter Exception:" + e.getMessage());
                this.logger.debug("retry after time interval>>>" + sleepTime);
                retry = true;
                ParabluFileSystemUtils.sleepForGivenTime((long)sleepTime);
                sleepTime = 60000L * (long)sleepMultiplier;
            }
            catch (Exception e) {
                NotificationHelper.successfulRestore = 0;
                this.logger.error("unsuccessfulRestore, Exception: ", (Throwable)e);
            }
        } while (retry && retryCount < 6);
        if (Thread.currentThread().isInterrupted()) {
            Thread.currentThread().interrupt();
            throw new InterruptedException();
        }
        return 0;
    }

    public void cancelUpload() {
        this.cleanupInterface.updateBackupCrawlTable(this.failedBackupTOs);
        this.failedBackupTOs.clear();
        if (this.multiThreadRestoreAdapter != null) {
            this.logger.debug("Canceling upload>>>>>>>>");
        } else {
            this.logger.debug("multiThreadBackupAdapter is null>>>>>>>>>>>>");
        }
    }
}

