#############################################################################
#                                                                           #
# SCRIPT: PatchUpdate.py                                                           #
# DATE:   12-Dec-2017                                                       #
# REV:    1.0                                                               #
# DEVELOPED BY: Sanjay Pandit                                               #
# PURPOSE: Script for updating the patch, creating a sfx file and uploading it to the dns server                #
# PLATFORM: Windows                                                         #
#############################################################################

import subprocess
import paramiko
import configparser
import tarfile
import os
import shutil
import sys
import errno
import datetime
import time
import win32com.client as win
from pip._vendor.distlib.compat import raw_input
from Constants import _Const
from configparser import ConfigParser



# Global variables
versionNumber = ""
cloudName = ""
EBMS_dom = ""
sub_EBMS_dom = ""
sub_EBMS_dom_1 = ""
sfx_conf_file = ""
use_sfx_conf_file = False
CONST = _Const()
tsToUse = ""
MailLink =""
Silent_NonSilent=""
Non_Bruteforce_Agent=""
Input=""
InputKey=""
HideAgent=""
Proxy_Enabled=""
SSO_Browser_Preference=""
Sleep_Time_To_Wait_And_Get_Authocode=""
Timer_Delay_to_Launch=""
Server_AGENT=""
# Class to run the windows commands. will have a run_command method
class runWindowsCommand:
    
    # constructor
    def __init__(self):
        # will do something useful here later on 
        # currently just pass
        pass
    
    # function which will run the desired command which has parameters being passed to it
    def runCommandWithArgs(self, cmdWithParams):
        # printNicely("Just completed the run for command {}",format(subprocess.list2cmdline(cmdWithParams)), False)
        p = subprocess.Popen(subprocess.list2cmdline(cmdWithParams),shell=True)
        stdout, stderr = p.communicate()
        return p.returncode
    
    # Function which will run a command without arguments
    def runSimpleCommand(self,cmdRecd):
        p = subprocess.Popen(cmdRecd, shell=True)
        # check out p.poll
        stdout, stderr = p.communicate()
        return p.returncode

  
# function to read the config file 
# file will have an extension .ini
# lines starting with # will be ignored          
# file will have sections defined by [<section name>
# followed by key value pairs of attributes/parameters in the format
# attribute: value
def readConfigFile(fileName):    
   
    Config.read(fileName)
    Config.sections()
    return
    
def pause(message = ""):
    printNicely(message, True)
    programPause = raw_input("Press the <ENTER> key to continue...")
    return
    

def ConfigSectionMap(section):
        
    dict1 = {}
    options = Config.options(section)
    for option in options:
        try:
            dict1[option] = Config.get(section, option)
            if dict1[option] == -1:
                printNicely("skip: %s" % option, False)
        except:
            printNicely("exception on %s!" % option, False)
            dict1[option] = None
    return dict1
        
def getConfigValue(section, option):
    return ConfigSectionMap(section)[option]
     

# The function will update the virus definition file
def updateVDF():
    printNicely(CONST.VDF_Update_Start,  True)
    # get the parameters from the config file
    execPath = Config.get(CONST.SECTION_ANTIVIRUS, CONST.AV_Path)
    Option = CONST.AV_Action_Option
    #logFileWithPath=Config.get(CONST.SECTION_ANTIVIRUS, CONST.Log_Path)
    logPath=Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BAT_LOG_FILE)
    
    logFileWithPath=logPath + CONST.LOG_FILE_NAME + tsToUse + CONST.LOG_FILE_EXT
    # Now call the exec windows command
    retval = mycmd.runCommandWithArgs([execPath, Option, r"/R:"+logFileWithPath])
    if (retval != 0):
        printNicely(CONST.DEBUG_VDF_ISSUE,  True)
        exit( 1)
    return

def downloadTarFile():
    global Input
    printNicely(CONST.DEBUG_GET_SRC_FILE,  True)
    try:
        # first get all parameters

        hostName = Config.get(CONST.SECTION_FTP,CONST.SOURCE_HOST_NAME )
        userName = Config.get(CONST.SECTION_FTP,CONST.SOURCE_USER_NAME)
        passWord = Config.get(CONST.SECTION_FTP,CONST.SOURCE_PWD)
        remPath = Config.get(CONST.SECTION_FTP,CONST.SOURCE_REMOTE_PATH)+ CONST.SRC_FILE_V +versionNumber + CONST.SRC_FILE_EXT
        portNum = Config.getint(CONST.SECTION_FTP,CONST.SOURCE_PORT)           
        localPath = Config.get(CONST.SECTION_FTP, CONST.SOURCE_LOCAL_PATH)+ CONST.SRC_FILE_V +versionNumber +CONST.SRC_FILE_EXT
        printNicely("Remote download path is  {0} {1}".format(remPath, portNum), True)
        # check if the file with the version number exists on the local server
        if (os.path.exists(localPath)):
            # Let the user know that a local file exists and ask
            # the user if they want to use this file or download
            # a new version. 
            printNicely( CONST.DEBUG_NOTIFY_LOCAL_COPY + localPath, True)
            # If the user opts to use the existing file
            # then return from thie function
            while Input == "":
                Ans =raw_input(CONST.DEBUG_CONFIRM_DOWNLOAD)        
                if ( check_user_input(Ans) == 1):
                    printNicely(CONST.DEBUF_LOCAL_COPY_USE_CONFIRMATION, True)
                    Input="yes"
                    return
                elif (check_user_input(Ans) ==2):
                    # if the the user chooses not to use the file and wants to 
                    # download a new copy, then delete the existing file
                    Input="NO"
                    try:
                        os.unlink(localPath)    
                    except Exception as e:
                        printNicely("Can not delete local copy of file - exiting", True)
                        print(e)
                        exit(1)
                else :
                    printNicely("Please enter the correct value",True)
        # if we have reached here, it means that either there was no existing local 
        # copy of the file or the user choose to download a fresh copy.
        # either way, we now need to download a fresh copy of the file
        
        printNicely(CONST.DEBUF_FTP_USE_CONFIRMATION,  True)
        printNicely("...................Connecting to {0} ".format(hostName), True)
        transport = paramiko.Transport((hostName, portNum))
        transport.connect(username = userName, password = passWord)
        sftp = paramiko.SFTPClient.from_transport(transport)
        printNicely("...................Connected As {0} for {1} {2}".format(userName, remPath, localPath), True)

        sftp.get(remPath, localPath)
        printNicely("...................Get As {0} {1} ".format(remPath, localPath), True)
        sftp.close()
        transport.close()
        
        # check if the local file exists. if not exit
        if (not os.path.exists(localPath)):
            printNicely("Was not able to FTP the file. Please check if it exists on the DNS server... Exiting",  True)
            exit(1)
    except Exception as e:
        # changing the line to catch ANY exception rather than specific ones such as OSError, IOError, FileNotFoundError
        printNicely(CONST.DEBUG_FTP_ERROR, True)
        print(e)
        exit(1)
    
    return

def check_user_input(userInput):
    if (userInput.strip().upper() == CONST.USER_INPUT_Y or userInput.strip().upper() == CONST.USER_INPUT_YES):
        return 1
    elif (userInput.strip().upper() == CONST.USER_INPUT_N or userInput.strip().upper() == CONST.USER_INPUT_NO):
        return 2
    else:
        return 3

   
 
# This function will unzip the file which was downloaded to the 
# local path
def unTarSources():
    
    printNicely(CONST.DEBUG_UNTAR_MSG,  True)
    # get the location of the tar file - this is where we downloaded the file
    # in the previous step
    sourceLoc = Config.get(CONST.SECTION_FTP, CONST.SOURCE_LOCAL_PATH)+CONST.SRC_FILE_V+versionNumber+ CONST.SRC_FILE_EXT
    targetLoc = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)

    # check if targetloc exists - if not, create it
    if (not os.path.exists(targetLoc)):
        os.makedirs(targetLoc)
    
    # make sure that it is an empty directory 
    try:
        for root, subdirs, files in os.walk(targetLoc):
            for file in files:
                os.unlink(os.path.join(root, file))
            for subdir in subdirs:
                shutil.rmtree(os.path.join(root, subdir))
    except Exception as e:
        printNicely("Unable to cleanup the directory. Please see exception message", True)
        print(e)
        exit(1)
        
    cwd = os.getcwd()
    os.chdir(targetLoc)
    
    # now untar the file
    try:
        tar = tarfile.open(sourceLoc, CONST.TARFILE_READ_OPTION)
        tar.extractall()
        basepth = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)
        tar.close()
    except Exception as e:
        printNicely("Unable to extract from zip file. Please see exception message", True)
        print(e)
        exit(1)
    
    # get back to the original dir
    os.chdir(cwd)
    
    return
def copyFolder(src, dest):
    try:
        shutil.copytree(src, dest)
    except OSError as e:
        # If the error was caused because the source wasn't a directory
        if e.errno == errno.ENOTDIR:
            shutil.copy(src, dest)
        else:
            print('Directory not copied. Error: %s' % e)
# This will copy all the static files required to be run in order to create the 
# patch. These need to be present in the 'BaseDirectory'
def copyPatchCreationScripts():
    printNicely(CONST.DEBUG_PATCH_SRC_CPY_MSG,  True)
    # get the path to where the patch creation .bat and associated files are
    # stored
    PatchCreationBase = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BAT_FILE_DIR)
    printNicely(" Patch creation base is {0}".format(PatchCreationBase))
    # see if that directory exists
    if (not os.path.exists(PatchCreationBase)):
        printNicely(CONST.DEBUG_NO_BAT_FILE,  True)
        exit(1)
    
    # now copy the files into the baseDir
    targetLoc = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)
    
    for root, subdirs, files in os.walk(PatchCreationBase, topdown=True, onerror=None, followlinks=True ):
        for filename in files:
            try:
                sourceFile = os.path.join(root, filename)
                destFile = sourceFile.replace(PatchCreationBase,targetLoc )
                # only copy if the file does not already exist in the dest loc
                if not os.path.exists(destFile):
                    if not os.path.exists(os.path.dirname(destFile)):
                        os.makedirs(os.path.dirname(destFile))
                    shutil.copy( sourceFile, destFile)
                else:
                    printNicely(CONST.DEBUG_ASK_DIRECTIONS + destFile,  True)
                
            except Exception as e:
            # changing the line to catch ANY exception rather than specific ones such as OSError, IOError, FileNotFoundError
                printNicely(CONST.DEBUG_BAT_FILE_COPY_ERROR + sourceFile,  True)
                print(e)
                exit(1)
              
    return  

# runs a scan for MEMORY and all files in dir to scan
def runAVScan(dirToScan):
    
    printNicely(CONST.DEBUG_Run_AV_SCAN,  True)
    execPath = getConfigValue(CONST.SECTION_ANTIVIRUS, CONST.AV_Path)
    Option = "SCAN"
    #logFileWithPath=getConfigValue(CONST.SECTION_ANTIVIRUS, CONST.Log_Path)
    logPath=Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BAT_LOG_FILE)
    
    logFileWithPath=logPath + CONST.LOG_FILE_NAME + tsToUse + CONST.LOG_FILE_EXT
    # Now call the exec windows command
    retval = mycmd.runCommandWithArgs([execPath, Option, "/MEMORY", dirToScan, r"/R:"+logFileWithPath])
    if (retval != 0):
        printNicely(CONST.DEBUG_SCAN_ISSUE + logFileWithPath,  True)
        exit( 1)
    return

### function which will create a file which the 
### anti virus software should recognize as a 
### virus. Based on the EICAR stds.
### more info @ https://support.kaspersky.com/viruses/general/459
def createEICARVirusFile():
    # open the file to write the virus string into it
    targetFile = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)+ CONST.INFECTED_FILE
    with open(targetFile, 'w') as outfile:
    
        newLine = CONST.INF_FILE_WARNING
        outfile.write(newLine)
        
    


# This process will do the bulk of heavy lifting. 
# - update vdf's
# download zip file
# unzip file to dest location
# scan it
def prepPatchCreation():
    global tsToUse
    # First ensure that the virus definition file is uptodate
    printNicely(CONST.DEBUG_ENV_PREP ,  True)
    
    # Get the datetime and store it in a gloabl variable
    tsToUse = datetime.datetime.now().strftime("_%Y%b%d_%H%M")
    #downloadTarFile()
    #unTarSources()
    if(Server_AGENT=="serveragent"):
        basepth = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)
        src= basepth+"\\Server Agent\\BluSync.exe"
        dest=basepth+"\\BluSync.exe"
        os.unlink(dest)
        shutil.copy(src, dest)
    pause("check for untared files")
    #copyPatchCreationScripts()
    updateVDF()
    createEICARVirusFile()
    runAVScan(Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR))
    

def createSFX():
    
    printNicely(CONST.DEBUG_SFX_PREP,  True)
    winrar=Config.get(CONST.SECTION_SFX,CONST.WINRAR)
    sfxConfig=Config.get(CONST.SECTION_SFX, CONST.SFX_CONFIG_FILE)
    basepth = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)
    
    #copying the folder sfxPackaging as sfxPackagingForUpdateService
    copyFolder(basepth+CONST.SFX_PKG_DIR,basepth+CONST.SFX_PKG_FOR_SERVICE_UPDATE_DIR)
    
    #Copying Config Files from sfxPackaging to sfxPackagingForUpdateService and making silent=false
    printNicely("Copying Config Files to service update and making silent=false",  True)
    inpFile = basepth + CONST.PARABLU_SRV_BAT_TEMPLATE
    outFile = basepth + CONST.PARABLU_SRV_BAT_TEMPLATE_OUTFILE
    newOutFile = basepth + CONST.PARABLU_SRV_BAT_TEMPLATE_NEW_OUTFILE
    sedEquiv(inpFile, outFile,[["isSilent=silent","isSilent=false"]])
    os.remove(inpFile)
    shutil.copy(outFile,newOutFile)
    os.remove(outFile)
    
    #to be added here
    #sedEquiv(bldCMD+CONST.PARABLU_BAT_TEMPLATE_OUTFILE, basepth+CONST.PARABLU_SRV_BAT_TEMPLATE_OUTFILE,[changeSignToolPath,changeWinInstallerPath ])
    # copy the parablu_EPA.exe to the sfx path rename it to exclude the version
    srcloc = basepth+CONST.EXE_SRC_ID+versionNumber+CONST.DOT_EXE
    destloc = basepth+CONST.EXE_DEST_ID
    
    try:

        shutil.copy( srcloc,destloc)
        
    except Exception as e:
        printNicely("Unable to copy exe file - see exception for details", True)
        print(e)
        exit(1)
        
    cwd = os.getcwd()
    os.chdir(basepth+ CONST.SFX_PKG_DIR)
    #retval = mycmd.runCommandWithArgs([winrar, "a", "-sfx", "-z"+basepth+sfxConfig, "Parablu_EPA", basepth+"\\sfxPackaging",basepth+"\\bin/Parablu_EPA_v1.2.3.exe"])
    retval = mycmd.runCommandWithArgs([winrar, "a", "-sfx", "-z"+basepth+"\\"+sfxConfig, "Parablu_EPA1", "*"])
    if retval !=0 :
        printNicely(CONST.DEBUG_SFX_CREATE_ISSUE, True)
        exit(1)
    os.chdir(cwd)
    # copy the sfx to a higher level and rename it 
    #shutil.copy(basepth+"\\sfxPackaging\\Parablu_EPA1.exe", basepth+"\\Parablu_EPA.exe")
    return
    
 #newchange(to add and winrar)   
def createSFXForServiceUpdate():
    
    printNicely("Creating service sfx ",  True)
    winrar=Config.get(CONST.SECTION_SFX,CONST.WINRAR)
    sfxConfig=Config.get(CONST.SECTION_SFX, CONST.SFX_CONFIG_FILE)
    basepth = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)

    # copy the parablu_service_update.exe to the sfxPackagingForUpdateService path rename it to exclude the version
    try:
        shutil.copy( basepth+CONST.EXE_SRV_UPD_SRC,basepth+CONST.EXE_SRV_UPD_DEST)
    except Exception as e:
        printNicely("Unable to copy exe file - see exception for details", True)
        print(e)
        exit(1)
        
    cwd = os.getcwd()
    os.chdir(basepth+ CONST.SFX_PKG_FOR_SERVICE_UPDATE_DIR)
    retval = mycmd.runCommandWithArgs([winrar, "a", "-sfx", "-z"+basepth+"\\"+sfxConfig, "Parablu_Service_Update1", "*"])
    if retval !=0 :
        printNicely(CONST.DEBUG_SFX_CREATE_ISSUE, True)
        exit(1)
    os.chdir(cwd)
    
    return
 


def printUsage():
    print (CONST.DEBUG_USAGE_LINE_1 )
    print(CONST.DEBUG_USAGE_LINE_2 )
    return

# function which will print 2 blank lines above the message and a tab
# on the line before the message
def printNicely(msg, flushit = True):
    if flushit!=True:
        flushit=False
    print(CONST.NICE_PRINT_FORMAT + msg, flush=flushit)


# read the cloudname from the file and return the value
def readSFXConfFile(sfx_conf_file):
    try:
        fileHandler=open(sfx_conf_file, "rt", encoding='utf-8')
        for line in fileHandler:
            parts = line.split(CONST.ARG_SPLIT_PATTERN)
            if (parts[0].strip() == CONST.CLOUD_NAME):
                fileHandler.close()
                return parts[1].strip()
            
    except Exception as e:
        # changing the line to catch ANY exception rather than specific ones such as OSError, IOError, FileNotFoundError
        printNicely(CONST.DEBUG_FILE_READ_ISSUE  + sfx_conf_file, False)
        print(e)
        exit(1)   
    
    # if we have reached here means that there was no line which had
    # Cloud-Name - which is an issue so exit
    
    printNicely(CONST.DEBUG_FILE_NO_CLOUD_ISSUE + sfx_conf_file, False)     
    fileHandler.close()
    exit(1)


# Function to process the input parameters
def processInputParams():
    global versionNumber
    global cloudName
    global EBMS_dom
    global sub_EBMS_dom
    global sub_EBMS_dom_1
    global sfx_conf_file
    global use_sfx_conf_file
    global MailLink
    global Silent_NonSilent
    global Non_Bruteforce_Agent
    global InputKey
    global HideAgent
    global Proxy_Enabled
    global SSO_Browser_Preference
    global Sleep_Time_To_Wait_And_Get_Authocode
    global Timer_Delay_to_Launch
    global Server_AGENT
    printNicely("before reading config file..")
    try:
        config = ConfigParser()
        config.read('ConfigFile.properties')
        versionNumber=config.get('config', 'versionNumber');
        cloudName=config.get('config', 'cloudName');
        EBMS_dom=config.get('config', 'EBMS_dom');
        sub_EBMS_dom=config.get('config', 'sub_EBMS_dom');
        sub_EBMS_dom_1=config.get('config', 'sub_EBMS_dom_1');
        MailLink=config.get('config', 'MailLink');
        Silent_NonSilent=config.get('config', 'Silent_NonSilent');
        Non_Bruteforce_Agent=config.get('config', 'Non_Bruteforce_Agent');
        Proxy_Enabled=config.get('config', 'Proxy_Enabled');
        SSO_Browser_Preference=config.get('config', 'SSO_Browser_Preference');
        HideAgent=config.get('config', 'HideAgent')
        Sleep_Time_To_Wait_And_Get_Authocode=config.get('config', 'Sleep_Time_To_Wait_And_Get_Authocode')
        Timer_Delay_to_Launch=config.get('config', 'Timer_Delay_to_Launch')
        Server_AGENT=config.get('config', 'Server_AGENT')
        if(cloudName=="" or EBMS_dom=="" or  MailLink=="" or Silent_NonSilent=="" or Non_Bruteforce_Agent=="" or versionNumber=="" or HideAgent=="" or Server_AGENT==""):
            printNicely("input values are empty so exit..", True)
            exit(1)
    except Exception as e:
        printNicely("Error in reading config file..", True)
        print(e)
        exit(1)

def createExecutables():
    
    printNicely(CONST.DEBUG_RUNNING_BAT_FILE,  True)
    bldScript= Config.get(CONST.SECTION_BUILD, CONST.BUILDSCRIPT)
    bldCMD=Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR) +"\\" + bldScript
    changeSignToolPath=[CONST.WIN_SIGN_TOOL_PATH_PAT, Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.SRC_DIR)]
    changeWinInstallerPath=[CONST.WIN_INST_PATH_PAT, Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)]
    windowsInstallerbatfile=Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)+"\\"+CONST.PARABLU_WINDOWSINSTALLER_ISS
    windowsInstallerbatfilecopy=Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)+"\\"+"Blusync_WindowsInstaller_CIcopy.bat"
    shutil.copy( windowsInstallerbatfile, windowsInstallerbatfilecopy)
    printNicely(windowsInstallerbatfile,  True)
    windowsInstalleriss = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)+"\\"+"Blusync_WindowsInstaller.iss"
    windowsInstallerisscopy = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)+"\\"+"Blusync_WindowsInstallerscopy.iss"
    #logFileName = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BAT_LOG_FILE)
    # we first create the bldCMD bat file by updating the template file
    if Silent_NonSilent =="NonsilentPackage":
        printNicely("Edit iss for Nonsilent Agent",  True)
        shutil.copy( windowsInstalleriss, windowsInstallerisscopy)
        sedEquivForISSbatfile(windowsInstallerisscopy ,windowsInstalleriss,[[";Name: \"{userdesktop}","Name: \"{userdesktop}"]])       		
    logPath=Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BAT_LOG_FILE)
    logFileName=logPath + CONST.LOG_FILE_NAME + tsToUse + CONST.LOG_FILE_EXT
    digicertFilePath=Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)+"\\DigiCert\\DigicertKey.txt"
    with open(digicertFilePath, 'r') as file:
        data = file.read().replace('\n', '')
    printNicely(data+"digicert key", True)
    sedEquiv(bldCMD+CONST.TEMPLATE_EXT, bldCMD,[changeSignToolPath,changeWinInstallerPath ])
    mycmd.runCommandWithArgs([bldCMD, versionNumber,Non_Bruteforce_Agent,data,">>", logFileName])
    #if retval != 0 :
        #printNicely("Error in creating the exe file. please check console output to see error", False)
        #exit(1)


def sedEquiv(sourceFile, targetFile,patterns):
    # open input and out file
    # for each line in input file, replace pattern and write to output file
    # patters is an array of arrays which contain pattern to match and pattern to replace
    try:
        with open(targetFile, 'w') as outfile, open(sourceFile, 'r', encoding='utf-8') as infile:
        
            for line in infile:
                for pattern in patterns:
                    newLine = line.replace(pattern[0], pattern[1])
                    line = newLine
                outfile.write(newLine)
    except Exception as e:
        printNicely("Error in creating file from template - see error on console for details in sedEquiv", True)
        print(e)
        exit(1)
def sedEquivForISSbatfile(sourceFile, targetFile,patterns):
    # open input and out file
    # for each line in input file, replace pattern and write to output file
    # patters is an array of arrays which contain pattern to match and pattern to replace
    try:
        with open(targetFile, 'w') as outfile, open(sourceFile, 'r', encoding='utf-8') as infile:
        
            for line in infile:
                for pattern in patterns:
                    newLine = line.replace(pattern[0], pattern[1])
                    line = newLine
                outfile.write(newLine)
    except Exception as e:
        printNicely("Error in creating file from template - see error on console for details in issbat", True)
        print(e)
        exit(1)
        
    

def modifyFilesToPackage():
    
    printNicely(CONST.DEBUG_USING_USERS_INPUT,  True)
    # add the cloud name to the ParabluInstaller.bat file and 
    # write it to the sfxPackaging Folder
    baseDir = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)
    inpFile = baseDir + CONST.PARABLU_BAT_TEMPLATE
    outFile = baseDir + CONST.PARABLU_BAT_TEMPLATE_OUTFILE
    if Silent_NonSilent =="NonsilentPackage":
        printNicely("started creating Nonsilent Installer.batfile ",  True)
        changeSilentArgument = ["/isSilent=silent",""]
        changecloudArgument = ["/cloudName=###CLOUDNAME###",""]
        changecerArgument = ["/certName=*.parablusys.com",""]
        changeDatavalue = ["###RegisterwithWindows###",HideAgent]
        changeProxySettings =["###ProxyEnabled###",Proxy_Enabled]
        chnageSleepTime=["###Sleep_Time_To_Wait_And_Get_Authocode###",Sleep_Time_To_Wait_And_Get_Authocode]
        chnageTimerDelaytoLaunch=["###Timer_Delay_to_Launch###",Timer_Delay_to_Launch]
        changeArrayForNonSilent = [changeSilentArgument,changecloudArgument, changecerArgument,changeDatavalue,changeProxySettings,chnageSleepTime,chnageTimerDelaytoLaunch]
    else:
        printNicely("started creating silent Installer.batfile ",  True)
        changeCloudNameIbBatFile = [CONST.CLOUD_NAME_PAT,cloudName]
        changeDatavalue = ["###RegisterwithWindows###",HideAgent]
        changeProxySettings =["###ProxyEnabled###",Proxy_Enabled]
        chnageSleepTime=["###Sleep_Time_To_Wait_And_Get_Authocode###",Sleep_Time_To_Wait_And_Get_Authocode]
        chnageTimerDelaytoLaunch=["###Timer_Delay_to_Launch###",Timer_Delay_to_Launch]
        changeArrayForNonSilent = [changeCloudNameIbBatFile,changeDatavalue,changeProxySettings,chnageSleepTime,chnageTimerDelaytoLaunch]
        
    sedEquiv(inpFile, outFile,changeArrayForNonSilent)      
    # check if the user passed a configuration file in the argument. if so, just use that
    # configuration file
    if (use_sfx_conf_file):
        shutil.copy( sfx_conf_file, baseDir+CONST.SFX_TGT_PATH)
    else:
        # use the template file to create a new conf file based on the input parameters    
        changeCloudName = [CONST.SED_CLOUD_NAME, cloudName]
        changeEBMSDOM = [CONST.SED_MAIN_EBMS, EBMS_dom]
        changeSubEBS = [CONST.SED_SUB_EBMS,sub_EBMS_dom ]
        changeSubEBS1 = [CONST.SED_SUB_EBMS_1, sub_EBMS_dom_1]
        changeMailLink =[CONST.SED_MAIL_LINK,MailLink]
        changeSSOBrowserPreference = ["###SSO-Browser-preference###",SSO_Browser_Preference]
        if(Server_AGENT=="serveragent"):
            changeBallonLabel = ["###Systray-Balloon-Label###","Parablu Server EPA"]
            changeTooltip = ["###Systray-Tooltip-Label###","Parablu Server EPA"]
            changeSuccessLabel  = ["###Success-Label###","You have successfully registered with Parablu Server EPA."]
            changeArray = [changeCloudName, changeEBMSDOM,changeSubEBS, changeSubEBS1, changeMailLink ,changeSSOBrowserPreference,changeBallonLabel,changeTooltip,changeSuccessLabel]
        else:
            changeBallonLabel = ["###Systray-Balloon-Label###","Parablu EPA"]
            changeTooltip = ["###Systray-Tooltip-Label###","Parablu EPA"]
            changeSuccessLabel  = ["###Success-Label###","You have successfully registered with Parablu EPA."]
            changeArray = [changeCloudName, changeEBMSDOM,changeSubEBS, changeSubEBS1, changeMailLink ,changeSSOBrowserPreference,changeBallonLabel,changeTooltip,changeSuccessLabel]
        sedEquiv(baseDir + CONST.CONF_TEMPLATE, baseDir + CONST.CONF_TEMPLATE_OUT, changeArray)
       # sedEquiv(baseDir + CONST.CONF_TEMPLATE, baseDir + CONST.CONF_TEMPLATE_OUT_FOR_SERVICE, changeArray)
        
    return 
    
    
def uploadSFX(patchDir, dtVerName):
    printNicely(CONST.DEBUG_STARTING_UPLOAD,  True)
    try:
        # first get all parameters
        hostName = Config.get(CONST.SECTION_FTP, CONST.TARGET_HOST_NAME)
        userName = Config.get(CONST.SECTION_FTP, CONST.TARGET_USER)
        passWord = Config.get(CONST.SECTION_FTP, CONST.TARGET_PWD)
        tremPath = Config.get(CONST.SECTION_FTP, CONST.TARGET_REM_PATH) 
        
        portNum = Config.getint(CONST.SECTION_FTP,CONST.TARGET_PORT)
        remPath = tremPath+ CONST.SLASH + dtVerName
         
        transport = paramiko.Transport((hostName, portNum))
        transport.connect(username = userName, password = passWord)
        sftp = paramiko.SFTPClient.from_transport(transport) 
        
        sftp.mkdir(remPath)
        # put the SXF file on the remote server
        localFile = patchDir + "\\Windows_"+versionNumber+"_"+CONST.LOCAL_EPA_PATH
        remoteFile = remPath + "/Windows_"+versionNumber+"_"+CONST.REM_EPA_PATH
            
        sftp.put(localFile, remoteFile)
        
        # Put the bsuodate.exe
        #localFile = patchDir + CONST.LOCAL_BS_PATH
        #remoteFile = remPath + CONST.REM_BS_PATH
            
        #sftp.put(localFile, remoteFile)
        
        # Put the updateServiceUpdate.exe
        #localFile = patchDir + CONST.LOCAL_SERVICE_UPDATE_PATH
        #remoteFile = remPath + CONST.REM_SERVICE_UPDATE_PATH
            
        #sftp.put(localFile, remoteFile)
        
        sftp.close()
        transport.close()
                
    except Exception as e:
        # changing the line to catch ANY exception rather than specific ones such as OSError, IOError, FileNotFoundError
        remoteFile
        printNicely("Failed to copy file to server", False)
        print(e)
        attempts = 0
        while attempts < 3:
            try:
                printNicely("before slp", True)
                printNicely("attempts"+str(attempts), True)
                time.sleep(30+15*attempts)
                transport = paramiko.Transport((hostName, portNum))
                transport.connect(username = userName, password = passWord)
                sftp = paramiko.SFTPClient.from_transport(transport)
                sftp.remove(remoteFile)
                sftp.close()
                transport.close()
                printNicely("Failed to copy file to server, deleted partial File from remote", True)
                exit(1)
            except Exception as e:
                printNicely("Can not delete remote copy of file - exiting", True)
                print(e)
                attempts = attempts + 1
               
        exit(1)
    
    return


def signSFX(patchDir):
    printNicely(CONST.DEBUG_SIGNING_EPA,  True)
    bldScript= Config.get(CONST.SECTION_BUILD, CONST.SIGN_SCRIPT )
    bldCMD=Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR) +"\\" + bldScript
    #logFileName = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BAT_LOG_FILE)
    logPath=Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BAT_LOG_FILE)
    
    logFileName=logPath + CONST.LOG_FILE_NAME + tsToUse + CONST.LOG_FILE_EXT
    changeSignToolPath=[CONST.WIN_SIGN_TOOL_PATH_PAT, Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.SRC_DIR)]
    changeWinInstallerPath=[CONST.WIN_INST_PATH_PAT, patchDir]
    # we first create the bldCMD bat file by updating the template file
    sedEquiv(bldCMD+ CONST.TEMPLATE_EXT, bldCMD,[changeSignToolPath,changeWinInstallerPath])
    mycmd.runCommandWithArgs([bldCMD, versionNumber, CONST.REDIR ,logFileName ])





# move the 2 executables (sfx and bsupdate.exe) to a new directory
# New directory name is based on the date, time and version number
def moveExesToPatchDir():
    # first get the patch base directory name
    patchBaseDir = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.PATCH_DIR)
    
    # get the date
    dtVerName = cloudName+ tsToUse + versionNumber
    patchDir = patchBaseDir+ CONST.SEPERATOR +dtVerName
    # create the directory
    try:
        os.makedirs(patchDir)
    
        # now get the source location from where the files will be copied
        basepth = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)
    
        shutil.copy(basepth+ CONST.FINAL_EXE_SRC_PATH, patchDir+"\\Windows_"+versionNumber+"_"+ CONST.FINAL_EXE_TGT_PATH)
        #shutil.copy(basepth+ CONST.FINAL_BS_SRC_PATH, patchDir+ CONST.FINAL_BS_TGT_PATH)
        #shutil.copy(basepth+ CONST.FINAL_UPDATE_SERVICE_SRC_PATH, patchDir+ CONST.FINAL_UPDATE_SERVICE_TGT_PATH)
        
    except Exception as e:
        printNicely("Error in copying files to patch dir. please check console output to see error", False)
        print(e)
        exit(1)
    return patchDir, dtVerName


    
if __name__ == "__main__":

    # create instances of classes required
    Config = configparser.ConfigParser() 
    mycmd = runWindowsCommand()
    # read the config file
    readConfigFile(CONST.ConfigFile)
	
    # The main processing starts here
    processInputParams()

    # Start the process of creating the sfx

    # first prep the system for creating the pathc
    prepPatchCreation()

    # Next run the bat file for the creation of the new executables etc.
    createExecutables()

    modifyFilesToPackage()

    # then run the creation of the sfx's
    createSFX()
    #createSFXForServiceUpdate()

    # move the 2 executables (sfx and bsupdate.exe) to a new directory
    # New directory name is based on the date, time and version number
    patchDir, dtVerName = moveExesToPatchDir()
    

    #scan the sfx
    runAVScan(patchDir)

    printNicely(CONST.DEBUG_NEED_TO_SIGN,  True)
    signSFX(patchDir)
    # we would need to upload the file to the DNS server
    uploadSFX(patchDir, dtVerName)

    printNicely(CONST.DONE,  True)

