; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "ParaBlu BluSync"
;#define MyAppVersion "2.3.6.9"
#define MyAppVersion version
#define MyAppPublisher "ParaBlu"
#define MyAppURL "http://www.parablu.com/"
#define MyAppExeName "parabluSvcUpdate.exe"
#define Mainclass "com/parablu/epa/view/BluSyncLauncher"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
SetupLogging=yes
AppId={{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={code:GetApplicationInstallationPath}
DefaultGroupName={#MyAppName}
DisableProgramGroupPage=yes
OutputDir=bin
OutputBaseFilename=parabluSvcUpdate
Compression=lzma
SolidCompression=no
PrivilegesRequired=admin
DisableDirPage=yes
VersionInfoVersion={#MyAppVersion}
VersionInfoCompany=ParaBlu
VersionInfoDescription=ParaBlu BluSync
VersionInfoProductName=BluSync
VersionInfoProductVersion={#MyAppVersion}
MinVersion=0,5.01sp1
DisableWelcomePage=True
DisableReadyPage=True
DisableReadyMemo=True
DisableFinishedPage=True
Uninstallable=no

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Files]

; Installer related bits
Source: "installinfo.exe";    Flags: dontcopy;

; Actuall installed binaries/script 
Source: "ParabluExt\VSSAPIProvider.dll";    DestDir: "{app}\lib\shell32"; Flags: ignoreversion;
Source: "BluSync.exe";                    DestDir: "{app}";             Flags: ignoreversion;
; what are we trying to do here? -- Ask praveen.
Source: "ParaLib.exe";                    DestDir: "{app}";             Flags: ignoreversion;
Source: "ParaBlu-BluSync-Extensions.exe"; DestDir: "{app}\bin";         Flags: ignoreversion;
Source: "StopPbluService.bat";          DestDir: "{app}";             Flags: ignoreversion ; AfterInstall: StopPbluService;
Source: "InstallParaBluSvc.bat";          DestDir: "{app}";             Flags: ignoreversion;
Source: "StartParaBluSvc.bat";          DestDir: "{app}";             Flags: ignoreversion;
Source: "ParaBluSvc.exe";                 DestDir: "{app}\bin";         Flags: ignoreversion;


Source: "rt\*"; DestDir: "{app}\rt";      Flags: ignoreversion onlyifdoesntexist recursesubdirs createallsubdirs;
Source: "rt\*"; DestDir: "{app}\bin\rt";  Flags: ignoreversion onlyifdoesntexist recursesubdirs createallsubdirs restartreplace;

; Configuration files to be installed
Source: "Parablu-log4j.properties";               DestDir: "{code:MyConst|UserProfileDirectory }\AppData\Roaming\ParaBlu\Blusync"; Flags: ignoreversion;
Source: "ServiceLog4j\ParaBluService-log4j.properties";  DestDir: "{app}\Blusync"; Flags: ignoreversion;
Source: "WL.properties";                          DestDir: "{code:MyConst|UserProfileDirectory }\AppData\Roaming\ParaBlu\Blusync"; Flags: ignoreversion; AfterInstall: InsertDomainNames;

; Shell extensions lets keep them seperate!

 ;Source: "MVC10\*";                            DestDir: "{app}\lib\shell";   Flags: ignoreversion onlyifdoesntexist recursesubdirs createallsubdirs uninsrestartdelete;Check: Not IsWin64; 
 ;Source: "ParabluExt\ParaBluIONS.dll";         DestDir: "{app}\lib\shell32"; Flags: ignoreversion onlyifdoesntexist uninsrestartdelete;Check: Not IsWin64; 
 ;Source: "ParabluExt\ParaBluIONS.dll.manifest";DestDir: "{app}\lib\shell32"; Flags: ignoreversion onlyifdoesntexist uninsrestartdelete;Check: Not IsWin64;
 ;Source: "ParabluExt\ParaBluIOS.dll";          DestDir: "{app}\lib\shell32"; Flags: ignoreversion onlyifdoesntexist uninsrestartdelete;Check: Not IsWin64; 
 ;Source: "ParabluExt\ParaBluIOS.dll.manifest"; DestDir: "{app}\lib\shell32"; Flags: ignoreversion onlyifdoesntexist uninsrestartdelete;Check: Not IsWin64; 
 ;Source: "ParabluExt\ParaBluExt.dll.manifest"; DestDir: "{app}\lib\shell";   Flags: ignoreversion onlyifdoesntexist uninsrestartdelete;Check: Not IsWin64;
 ;Source: "ParabluExt\ParaBluExt.dll";          DestDir: "{app}\lib\shell32"; Flags: ignoreversion onlyifdoesntexist uninsrestartdelete;Check: Not IsWin64;
 
 ;Source: "MVC10x64\*";                           DestDir: "{app}\lib\shell"; Flags: ignoreversion onlyifdoesntexist recursesubdirs createallsubdirs uninsrestartdelete;Check: IsWin64; 
 ;Source: "ParabluExt\ParaBluIONS64.dll";         DestDir: "{app}\lib\shell"; Flags: ignoreversion onlyifdoesntexist uninsrestartdelete;Check: IsWin64;
 ;Source: "ParabluExt\ParaBluIONS64.dll.manifest";DestDir: "{app}\lib\shell"; Flags: ignoreversion onlyifdoesntexist uninsrestartdelete;Check: IsWin64;
 ;Source: "ParabluExt\ParaBluIOS64.dll";          DestDir: "{app}\lib\shell"; Flags: ignoreversion onlyifdoesntexist uninsrestartdelete;Check: IsWin64;
 ;Source: "ParabluExt\ParaBluIOS64.dll.manifest"; DestDir: "{app}\lib\shell"; Flags: ignoreversion onlyifdoesntexist uninsrestartdelete;Check: IsWin64;
 ;Source: "ParabluExt\ParaBluExt64.dll.manifest"; DestDir: "{app}\lib\shell"; Flags: ignoreversion onlyifdoesntexist uninsrestartdelete;Check: IsWin64;
 ;Source: "ParabluExt\ParaBluExt64.dll";          DestDir: "{app}\lib\shell"; Flags: ignoreversion onlyifdoesntexist uninsrestartdelete;Check: IsWin64;


[Run]
; do we need this? --Ask praveen
Filename: "{app}\StartParaBluSvc.bat"; Parameters: """{app}"" ""{code:MyConst|UserProfileDirectory }"""; Flags: runhidden;
Filename: "{app}\BluSync.exe"; Parameters:{param:start} {param:exePath} {param:paraLibName} {#Mainclass} {param:isSilent} {param:cloudName} {param:cloudIP} {param:certName}; WorkingDir: "{app}"; Flags: nowait postinstall; Description: "{cm:LaunchProgram,{#StringChange(MyAppName, '&', '&&')}}";Check: WizardSilent;

[UninstallDelete]
Type: filesandordirs; Name: "{app}"; 

[Messages]
english.SetupWindowTitle=Parablu BluSync Setup Wizard

[Registry]
; 32 bit entries Not IsWin64
; =============================
Root: HKU; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; Flags: uninsdeletekey;  Check: Not IsWin64;
Root: HKU; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; ValueName: "Path";         ValueType: "string"; ValueData: "{app}"; Flags: preservestringtype; Check: Not IsWin64; 
Root: HKU; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; ValueName: "Version";      ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: Not IsWin64;
Root: HKU; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; ValueName: "UserProfile";  ValueType: "string"; ValueData: "{code:MyConst|UserProfileDirectory }"; Flags: preservestringtype; Check:Not IsWin64;

Root: HKLM; Subkey: "SOFTWARE\ParaBluSvc"; ValueName: "Path"; ValueType: "string"; ValueData: "{app}\bin"; Flags: preservestringtype;   Check: Not IsWin64;
Root: HKLM; Subkey: "SOFTWARE\ParaBluSvc"; ValueName: "Version"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: Not IsWin64;

;Uninstall version update
Root: HKU; Subkey: "{code:MyConst|SID }\Software\Microsoft\Windows\CurrentVersion\Uninstall\{{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_is1"; ValueName: "DisplayVersion"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: Not IsWin64 and isUninstallPathUserLevel;
Root: HKLM; Subkey: "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_{code:MyConst|UserName }_is1"; ValueName: "DisplayVersion"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: Not IsWin64 and isUninstallPathMachineLevel;

; 64 bit entries
; ===============
Root: HKU64; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; Flags: uninsdeletekey; Check: IsWin64; 
Root: HKU64; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; ValueName: "Path"; ValueType: "string"; ValueData: "{app}"; Flags: preservestringtype; Check: IsWin64;
Root: HKU64; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; ValueName: "Version"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: IsWin64;
Root: HKU64; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; ValueName: "UserProfile"; ValueType: "string"; ValueData: "{code:MyConst|UserProfileDirectory }"; Flags: preservestringtype; Check: IsWin64;

Root: HKLM; Subkey: "SOFTWARE\WOW6432Node\ParaBluSvc"; ValueName: "Path"; ValueType: "string"; ValueData: "{app}\bin"; Flags: preservestringtype;   Check: IsWin64;
Root: HKLM; Subkey: "SOFTWARE\WOW6432Node\ParaBluSvc"; ValueName: "Version"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: IsWin64;

;uninstall version update
Root: HKU64; Subkey: "{code:MyConst|SID }\Software\Microsoft\Windows\CurrentVersion\Uninstall\{{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_is1"; ValueName: "DisplayVersion"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: IsWin64 and isUninstallPathUserLevel;
Root: HKLM;  Subkey: "SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\{{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_{code:MyConst|UserName }_is1"; ValueName: "DisplayVersion"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: IsWin64 and isUninstallPathMachineLevel;

; VSSAPI related changes that are needed only on 32 bit.
Root: HKCR; Subkey: "Wow6432Node\CLSID\{{F2C2787D-95AB-40D4-942D-298F5F757874}"; ValueName: ""; ValueType: "string"; ValueData: "PSFactoryBuffer"; Flags: preservestringtype; Check: IsWin64;
Root: HKCR; Subkey: "WOW6432Node\CLSID\{{F2C2787D-95AB-40D4-942D-298F5F757874}\InProcServer32"; ValueName: ""; ValueType: "expandsz"; ValueData: "%systemroot%\SysWOW64\vss_ps.dll"; Flags: preservestringtype; Check: IsWin64;
Root: HKCR; Subkey: "WOW6432Node\CLSID\{{F2C2787D-95AB-40D4-942D-298F5F757874}\InProcServer32"; ValueName: "ThreadingModel"; ValueType: "string"; ValueData: "Both"; Flags: preservestringtype; Check: IsWin64;

[code]
#include "ServiceHelper.iss"

procedure TaskKill(FileName: String);
var
  ResultCode: Integer;
begin
    Exec(ExpandConstant('taskkill.exe'), '/f /im ' + '"' + FileName + '"', '', SW_HIDE,
     ewWaitUntilTerminated, ResultCode);
end;

function NextIntfromVersion(var version :String): Integer;
var
  P : Integer;
begin
  Result := 0;
  P := Pos('.', version);
  if P > 0 then
  begin
     Result := StrToInt(Copy(version, 1, P - 1));
     Delete(version, 1, P);
  end
  else 
  begin
    if version <> '' then
    begin
      Result := StrToInt(version);
      version := '';
    end
  end
end;

function CompareVersion(V1 :String; V2 :String): Integer;
var 
N1 : Integer;
N2 : Integer;
begin
  Result := 0;
  while (Result = 0) and ((V1 <> '') or (V2 <> '')) do
  begin
    N1 := NextIntfromVersion(V1);
    N2 := NextIntfromVersion(V2);   
    Result := N1 - N2  ;  
  end
end;

function CheckIfUpgradePossible: Boolean;
var
installedVersion : String;
begin
  Result := True;
  // If the version key is not present or if it is present and is less than the current version.
  if RegQueryStringValue(HKEY_LOCAL_MACHINE,'SOFTWARE\WOW6432Node\ParaBluSvc', 'Version',  installedVersion) then
  begin
    if(CompareVersion('{#SetupSetting("AppVersion")}', installedVersion) <= 0) then
    begin
      Log(Format('Unable to upgrade from {#SetupSetting("AppVersion")} to %s ',[installedVersion])); 
      Result := False;
    end 
    else 
    begin
      Log(Format('Upgrading to from {#SetupSetting("AppVersion")} to %s ',[installedVersion])); 
    end
  end //outer if  begin
end;  //main begin


function InitializeSetup(): Boolean;
var
  reInstallExt: Boolean;
  infofilePath: String;
  currentVersion: String;
  ErrorCode: Integer;
begin
  Log('Parablu_EPA version:# {#MyAppVersion} #');
  
  currentVersion := '{#SetupSetting("AppVersion")}';
  Result := False;  
  reInstallExt := False;
  ExtractTemporaryFile('installinfo.exe');
  infofilePath := '"'+expandconstant('{tmp}\ParabluInstallationInfo.properties')+'"';
  Log('Parablu_EPA infofilePath:#### #'+infofilePath);
  Log('Parablu_EPA Tmp info exe file path:#### #'+infofilePath);
  ShellExec('runas', '"'+ExpandConstant('{tmp}\installinfo.exe')+'"', infofilePath, '', SW_HIDE, ewWaitUntilTerminated, ErrorCode);  
  if CheckIfUpgradePossible() then
  begin
     TaskKill('ParaLib.exe');
     TaskKill('BluSync.exe');
     SimpleStopService('ParaBluSvc', True, True);
     Sleep(5000);
     Result := True;
     reInstallExt := False;
  end
end;

procedure InitializeWizard();
begin

  Log('Parablu_EPA version:# {#MyAppVersion} #');

  {
    WizardForm.BorderStyle := bsNone;  WizardForm.Width := 0;  WizardForm.Height := 0;
  }
end;

// Called just before Setup terminates. Note that this function is called even if the user exits Setup before anything is installed.
procedure DeinitializeSetup();
var
  logfilepathname, logfilename, newfilepathname: string;
begin
  logfilepathname := expandconstant('{log}');
  logfilename := ExtractFileName(logfilepathname);
  // Set the new target path as the directory where the installer is being run from
  newfilepathname := expandconstant('{%UserProfile}\AppData\Local\Temp\ParabluInstallation')+logfilename;
  filecopy(logfilepathname, newfilepathname, false);
end; 

{
called for read conf file if exists and insert
into properties file
}
procedure InsertDomainNames();
var
confFilePath: String;
S: AnsiString;
domainsFilePath: String;

begin

confFilePath:=ExpandConstant('{code:MyConst|UserProfileDirectory }')+'\AppData\Roaming\ParaBlu\Blusync\WL.properties';
domainsFilePath:= ExpandConstant('{drive:{win}}')+'\Windows\Temp\ParaBlu_EPA\ParabluConfig.conf';
Log('Parablu_EPA domainsFilePath :#### #'+domainsFilePath);
Log('Parablu_EPA Wl Path :#### #'+confFilePath);
  //ExtractTemporaryFile('testing.conf');
  if FileExists(domainsFilePath) then
  Log('File Exists');
  if LoadStringFromFile(domainsFilePath, S) then
  begin
  Log('Loaded String :'+S);
    //MsgBox(S, mbInformation, MB_OK);
    SaveStringToFile(confFilePath, S + #13#10, True);
    Log('After Save String');
  end;

end;

{
  called to uninstall service
}
procedure StopPbluService();
var
  ErrorCode: Integer;
  UninsServiceFilePath: String;
  reInstallExt: Boolean;
begin
  UninsServiceFilePath:=ExpandConstant('{app}')+'\StopPbluService.bat';
  reInstallExt:=true;
  while reInstallExt do 
  begin 
    Log('Deleting parablu Service:#  ');
    if ShellExec('runas', UninsServiceFilePath, '', '', SW_HIDE, ewWaitUntilTerminated, ErrorCode) then 
    begin
      reInstallExt:=false;
    end
    else 
    begin
      if MsgBox('Without admin access this Uninstallation will fail.Are you sure you want to proceed?',mbconfirmation,MB_YESNO) = IDYES  then 
      begin 
        WizardForm.Close;
        reInstallExt:=false;
      end    
     end
  end;
end;


{
  called to install service
}
procedure InstallPbluService();
var
  resultCode: Integer;
  InstallServiceFilePath: String;
  reInstallExt: Boolean;
begin
  Log('Installing service ' + ExpandConstant('{app}'));
  InstallServiceFilePath:=ExpandConstant('{app}')+'\InstallParaBluSvc.bat';
  reInstallExt:=true;
  while reInstallExt do 
  begin
    if ShellExec('runas',InstallServiceFilePath,ExpandConstant('{app}'),'', SW_HIDE, ewWaitUntilTerminated, resultCode) then 
    begin
      reInstallExt:=false;
    end
    else 
    begin
      if MsgBox('Without admin access this Uninstallation will fail.Are you sure you want to proceed?',mbconfirmation,MB_YESNO) = IDYES  then 
      begin 
        WizardForm.Close;
        reInstallExt:=false;
      end    
    end
  end
end;

function GetApplicationInstallationPath(Param: string): string;
var
  checkForFolderInstead: Boolean;
  installPath: String;
  SID: String;
  regQuery: String;
begin
  SID:= ExpandConstant('{code:MyConst|SID }');
  if IsWin64 then
  begin
    if RegQueryStringValue(HKU64,SID + '\Software\ParaBlu\BluSync', 'Path', installPath) then
    begin
      Result := installPath;
      Log('Parablu_EPA installPath from registry:#  #'+Result);
    end
    else 
    begin
      checkForFolderInstead := True;
    end
  end
  else 
  begin
    if RegQueryStringValue(HKU,SID + '\Software\ParaBlu\BluSync', 'Path', installPath) then
    begin
      Result := installPath;
      Log('Parablu_EPA installPath from registry:#  #'+Result);
    end
    else
    begin
      checkForFolderInstead := True;
    end
  end
end;

function MyConst(Param: String): String;
var  
  I: Integer;
  KeyPos: Integer;
  KeyFull: string;
  FileLines: TArrayOfString;
  infofilePath: string;
begin
  Result := Param;
  infofilePath:= expandconstant('{tmp}\ParabluInstallationInfo.properties');
   Log('Parablu_EPA install info file path while reading:#  #'+infofilePath);
  if LoadStringsFromFile(infofilePath, FileLines) then
  begin
  Log('Parablu_EPA install info file path:#  #'+FileLines[0]);
    KeyFull := Param + '= ';    
    for I := 0 to GetArrayLength(FileLines) - 1 do
    begin
      FileLines[I] := TrimLeft(FileLines[I]);
      KeyPos := Pos(KeyFull, FileLines[I]);
      Log('Parablu_EPA install info file path:#1111#'+FileLines[I]+'Key position:'+IntToStr(KeyPos));
      if KeyPos > 0 then
      begin
        Result := Copy(FileLines[I], Length(KeyFull) + 1, MaxInt);
        Result := Trim(Result);
        Log('Parablu_EPA install info file key value:#  #'+Result);
        Break;
      end
    end
  end
end;

{
Run during setup to install shell extensions
called after all dlls are moved
}
procedure RunPostInstallationSteps(fileType,installtype: String);
var
  exeFilePath: String;
  resultCode: Integer;
  resultCode1: Integer;
  reInstallExt: Boolean;
  serviceFilePath: String;
  installAppPath: String;
begin
  reInstallExt:=true;
  exeFilePath:=ExpandConstant('{app}')+'\bin\ParaBlu-BluSync-Extensions.exe';
  serviceFilePath:=ExpandConstant('{app}')+'\InstallParaBluSvc.bat';
  installAppPath:= ExpandConstant('"{app}"');
  SimpleStartService('ParaBluSvc', True, True); 
  if IsWin64 then begin  
    while reInstallExt do 
    begin
      Log('Parablu_EPA install info file path while reading:#  #'+installAppPath);
      reInstallExt:=false;
      Log('Parablu_EPA install info file path while reading:#  #'+installAppPath);
      Exec(ExpandConstant('{win}\explorer.exe'), '', '', SW_SHOW, ewNoWait, resultCode1);   
    end
  end
  else 
  begin
    while reInstallExt do 
    begin  
      if ShellExec('runas',serviceFilePath,'"'+ ExpandConstant('{app}')+'"','', SW_HIDE, ewWaitUntilTerminated, resultCode) then 
      begin
        reInstallExt:=false;
        Exec(ExpandConstant('{win}\explorer.exe'), '', '', SW_SHOW, ewNoWait, resultCode1);   
      end      
    end
  end
end;

function isUninstallPathMachineLevel() : Boolean;
var
  uninstallPath: String;
  userName: String;
begin
  result:=false;
  userName:= ExpandConstant('{code:MyConst|UserName }');
  if IsWin64 and RegKeyExists(HKEY_LOCAL_MACHINE,'SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_'+userName+'_is1') then 
  begin
    if RegQueryStringValue(HKEY_LOCAL_MACHINE,'SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_'+userName+'_is1',
       'UninstallString', uninstallPath) then
    begin
      if uninstallPath<>'' then
      begin
        Log('Machine Level');
        result:=true;
      end
    end
  end
  else if (not IsWin64) and RegKeyExists(HKEY_LOCAL_MACHINE,'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_'+userName+'_is1') then 
  begin
    if RegQueryStringValue(HKEY_LOCAL_MACHINE,'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_'+userName+'_is1',
       'UninstallString', uninstallPath) then
    begin
      if uninstallPath<>'' then
      begin
        Log('Machine Level');
        result:=true;
      end
    end
  end
end;

function isUninstallPathUserLevel(): Boolean;
var
  uninstallPath: String;
  SID: String;
begin
  result:=false;  
  SID:= ExpandConstant('{code:MyConst|SID }');
  if RegKeyExists(HKU, SID+'\Software\Microsoft\Windows\CurrentVersion\Uninstall\'+'{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_is1') then 
  begin
    if RegQueryStringValue(HKU, SID+'\Software\Microsoft\Windows\CurrentVersion\Uninstall\'+'{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_is1',
       'UninstallString', uninstallPath) then
    begin
      if uninstallPath<>'' then
      begin
        Log('User Level');
        result:=true;
      end
    end
  end
end;

procedure CurStepChanged(CurStep: TSetupStep);
begin  
  if CurStep = ssPostInstall then
  begin
    Log('Current step is post install');
    if IsWin64 then
    begin
      RunPostInstallationSteps('64','install');
    end
    else
    begin
      RunPostInstallationSteps('32','install');
    end
  end;
end;