/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.dedup.rabincarb;

import com.parablu.epa.common.service.dedup.rabincarb.RefLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Polynomial {
    public static final long IRR = 17349423945073011L;
    private static final Logger log = LoggerFactory.getLogger(Polynomial.class);
    static final Long FFFFFFFF00000000 = Long.parseUnsignedLong("ffffffff00000000", 16);
    static final Long ZERO_L = 0L;
    public long x;
    static final int randPolMaxTries = 10000000;

    public static long Add(long y, long x) {
        return x ^ y;
    }

    public static boolean mulOverflows(long a, long b) {
        if (Long.compareUnsigned(a, 1L) <= 0 || Long.compareUnsigned(b, 1L) <= 0) {
            return false;
        }
        long c = a * b;
        long d = Long.divideUnsigned(c, b);
        log.trace(" A=" + Long.toHexString(a).toUpperCase() + " * B=" + Long.toHexString(b).toUpperCase() + " = C" + Long.toHexString(c).toUpperCase() + " --- (C)/B => " + Long.toHexString(d).toUpperCase());
        return Long.compareUnsigned(d, a) != 0;
    }

    public static int Deg(long x) {
        long t = x;
        if (x == 0L) {
            return -1;
        }
        int r = 0;
        if (Long.compareUnsigned(x & FFFFFFFF00000000, 0L) > 0) {
            x >>>= 32;
            r |= 0x20;
        }
        if ((x & 0xFFFFFFFFFFFF0000L) > 0L) {
            x >>= 16;
            r |= 0x10;
        }
        if ((x & 0xFF00L) > 0L) {
            x >>= 8;
            r |= 8;
        }
        if ((x & 0xF0L) > 0L) {
            x >>= 4;
            r |= 4;
        }
        if ((x & 0xCL) > 0L) {
            x >>= 2;
            r |= 2;
        }
        if ((x & 2L) > 0L) {
            x >>= 1;
            r |= 1;
        }
        log.trace(" Degree calculation for  " + Long.toHexString(t) + " " + Long.toHexString(x) + " => " + r);
        return r;
    }

    public static long Mul(long x, long y) {
        if (x == 0L || y == 0L) {
            return 0L;
        }
        long res = 0L;
        for (int i = 0; i <= Polynomial.Deg(y); ++i) {
            if ((y & (long)(1 << i)) <= 0L) continue;
            res = Polynomial.Add(res, x << i);
        }
        return res;
    }

    public static long MulSafe(long x, long y) {
        if (Polynomial.mulOverflows(x, y)) {
            throw new ArithmeticException();
        }
        return Polynomial.Mul(x, y);
    }

    String Expand(long x) {
        if (x == 0L) {
            return "0";
        }
        Object s = new String();
        for (int i = Polynomial.Deg(x); i > 1; --i) {
            if ((x & (long)(1 << (int)x)) <= 0L) continue;
            s = (String)s + " + x^" + i;
        }
        if ((x & 2L) > 0L) {
            s = (String)s + "+x";
        }
        if ((x & 1L) > 0L) {
            s = (String)s + "+1";
        }
        return s;
    }

    public static void DivMod(long x, long d, RefLong q, RefLong r) {
        if (d == 0L) {
            throw new ArithmeticException();
        }
        if (x == 0L) {
            q.v = 0L;
            r.v = 0L;
            return;
        }
        int degD = Polynomial.Deg(d);
        int degDiff = Polynomial.Deg(x) - degD;
        if (degDiff < 0) {
            q.v = 0L;
            r.v = x;
            return;
        }
        long iq = 0L;
        while (degDiff >= 0) {
            long m = d << (int)((long)degDiff);
            iq |= (long)(1 << degDiff);
            x = Polynomial.Add(m, x);
            degDiff = Polynomial.Deg(x) - degD;
        }
        q.v = iq;
        r.v = x;
    }

    public static long Div(long x, long d) {
        RefLong q = new RefLong();
        RefLong r = new RefLong();
        Polynomial.DivMod(x, d, q, r);
        return q.v;
    }

    public static long Mod(long x, long d) {
        RefLong q = new RefLong();
        RefLong r = new RefLong();
        Polynomial.DivMod(x, d, q, r);
        return r.v;
    }

    static long RandomPolynomial() {
        return Polynomial.DerivePolynomial();
    }

    static long DerivePolynomial() {
        return 0L;
    }

    public static long GCD(long f, long x) {
        if (f == 0L) {
            return x;
        }
        if (x == 0L) {
            return f;
        }
        if (Polynomial.Deg(x) < Polynomial.Deg(f)) {
            long t = f;
            f = x;
            x = t;
        }
        return Polynomial.GCD(f, Polynomial.Mod(x, f));
    }

    public static boolean Irreducible(long x) {
        int degX = Polynomial.Deg(x) / 2;
        for (int i = 1; i <= degX; ++i) {
            long q = Polynomial.qp(i, x);
            if (Polynomial.GCD(x, q) == 1L) continue;
            return false;
        }
        return true;
    }

    public static long MulMod(long x, long f, long g) {
        if (x == 0L || f == 0L) {
            return 0L;
        }
        long res = 0L;
        int deg_f = Polynomial.Deg(f);
        for (int i = 0; i <= deg_f; ++i) {
            if ((f & 1L << i) == 0L) continue;
            long a = x;
            for (int j = 0; j < i; ++j) {
                a = Polynomial.Mod(Polynomial.Mul(a, 2L), g);
            }
            res = Polynomial.Mod(Polynomial.Add(res, a), g);
        }
        return res;
    }

    public static long qp(int p, long g) {
        long num = 1 << p;
        int i = 1;
        long res = 2L;
        while ((long)i < num) {
            res = Polynomial.MulMod(res, res, g);
            i *= 2;
        }
        return Polynomial.Mod(Polynomial.Add(res, 2L), g);
    }
}

