/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.google.common.util.concurrent.RateLimiter;
import com.parablu.epa.Impl.NoBackupSchedulesImpl;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.ChunkTableDAOImpl;
import com.parablu.epa.common.dao.NewBackUpCrawlDAOImpl;
import com.parablu.epa.common.service.backup.interfaces.CleanupInterface;
import com.parablu.epa.common.service.dedup.rabincarb.ChunkerHelper;
import com.parablu.epa.common.service.dedup.rabincarb.Polynomial;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.BackupHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.adapter.pcb.MultiPartBackupAdapter;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.element.BackupStatusElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.FileSystemUtility;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.ChunkFileTO;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.helper.utils.MD5Generator;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import com.parablu.epa.helper.utils.RegistryUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartDedupUploadCallable
implements Callable<BackupTO> {
    private static Logger logger = LoggerFactory.getLogger(MultipartDedupUploadCallable.class);
    private static Logger failedFileLog = LoggerFactory.getLogger((String)"failedFileLogger");
    private long restartId;
    List<BackupTO> chunkFileBatch;
    GatewayTO uploadGatewayTo;
    String requestURL;
    String backupBatchID;
    AtomicInteger uploadCount;
    AtomicLong totalUploadSize;
    BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
    BackupActivityTO backupActivityTO = this.backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
    BackupPolicyTO backupPolicyTO;
    CleanupInterface<BackupTO> cleanupInterface;
    int priority;
    MultiPartBackupAdapter multiPartBackupAdapter = null;
    ChunkTableDAOImpl chunkTableDAOImpl = new ChunkTableDAOImpl(SettingHelper.getBackUpDbUrl());
    NewBackUpCrawlDAOImpl newBackUpCrawlDAOImpl = new NewBackUpCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
    private RateLimiter rateLimiter;
    private static final String EXCEPTION_OCCURED = "Exception Occured";
    private static final String FALSE = "false";
    private int errorCode;
    private static boolean isFullBackup;
    private List<BackupTO> failedBackupTOs;
    private int uploadedChunkCount;
    private static String isBackupManual;
    private BlockingQueue<Future<BackupTO>> finishedBatchesQueue;
    private Polynomial p = new Polynomial();
    private long POLYNOMIAL = 17349423945073011L;
    private String tableNameHash = "";
    private long crc32Value = 0L;
    private String crc32nBkpBatch = "";
    private List<String> chunkNamesInList = new ArrayList<String>();
    private boolean startFromScratch = false;
    private static boolean isReBackup;

    public MultipartDedupUploadCallable(List<BackupTO> chuckFileBatch, GatewayTO uploadGatewayTo, String backupBatchID, AtomicInteger uploadCount, BackupPolicyTO currentPolicyTO, CleanupInterface<BackupTO> cleanupInterface, String requestURL, RateLimiter rateLimiter, int priority, boolean isFullBackup, AtomicLong totalUploadSize, String isBackupManual, BlockingQueue<Future<BackupTO>> finishedBatchesQueue) {
        this.restartId = NotificationHelper.getBackupRestartId();
        this.chunkFileBatch = chuckFileBatch;
        this.uploadGatewayTo = uploadGatewayTo;
        this.backupBatchID = backupBatchID;
        this.uploadCount = uploadCount;
        this.backupPolicyTO = currentPolicyTO;
        this.cleanupInterface = cleanupInterface;
        this.requestURL = "/upload/files/all/contentchunk";
        this.rateLimiter = rateLimiter;
        this.priority = priority;
        MultipartDedupUploadCallable.isFullBackup = isFullBackup;
        this.totalUploadSize = totalUploadSize;
        this.failedBackupTOs = new ArrayList<BackupTO>();
        this.finishedBatchesQueue = finishedBatchesQueue;
        MultipartDedupUploadCallable.isBackupManual = isBackupManual;
        if (requestURL.equalsIgnoreCase("/upload/files/rebkp")) {
            isReBackup = true;
        }
    }

    @Override
    public BackupTO call() {
        NoBackupSchedulesImpl noBackupSchedulesImpl;
        Thread.currentThread().setPriority(this.priority);
        for (BackupTO backupTO : this.chunkFileBatch) {
            block32: {
                if (Thread.currentThread().isInterrupted()) {
                    this.cleanupInterface.updateErrorCode(this.errorCode);
                    this.cancelUpload();
                    return null;
                }
                try {
                    logger.debug("Inside chunking of file :" + backupTO.getFileName());
                    boolean isCompressionEnabled = this.backupPolicyTO.isCompressionEnabled();
                    String filePath = ObjectUtils.getFileSnapshotPath((String)backupTO.getClientData());
                    File willBeRead = new File(filePath);
                    long fileSize = willBeRead.length();
                    int numberOfChunks = 1;
                    byte[] temporaryData = new byte[]{};
                    long totalBytesRead = 0L;
                    long totalSize = 0L;
                    byte[] actualData = null;
                    if (!ParabluFileSystemUtils.handleFileExist((String)filePath)) {
                        this.failedBackupTOs.add(backupTO);
                        logger.error(this.failedBackupTOs.size() + ">> File is not accessible or not found.." + filePath);
                        failedFileLog.error("Failed to access the file:" + filePath);
                        continue;
                    }
                    this.tableNameHash = MD5Generator.generateMD5OfString((String)ObjectUtils.getSnapShotPath((String)backupTO.getClientData()));
                    if (!this.chunkTableDAOImpl.isTableExists(this.tableNameHash, "temp")) {
                        logger.debug("temp table for snap does not exist so cehck actual");
                        if (!this.chunkTableDAOImpl.isTableExists(this.tableNameHash, "actual")) {
                            logger.debug("actual table for snap does not exist so create hash for original..");
                            this.tableNameHash = MD5Generator.generateMD5OfString((String)backupTO.getClientData());
                        }
                    }
                    this.setGatewayName(backupTO);
                    File createCRCFile = new File(filePath);
                    this.createCRC32Value(backupTO, createCRCFile);
                    logger.debug("CRC32 value:" + this.crc32Value);
                    createCRCFile = null;
                    boolean largeFile = false;
                    this.crc32nBkpBatch = MD5Generator.generateMD5OfString((String)(this.backupBatchID + String.valueOf(this.crc32Value)));
                    this.chunkTableDAOImpl.createTempBackupChunkTable(this.tableNameHash);
                    ChunkFileTO chunkFileTO = new ChunkFileTO();
                    chunkFileTO.setMd5Checksum("crc_" + String.valueOf(this.crc32Value));
                    this.chunkTableDAOImpl.insertChunkFileTO(this.tableNameHash, "temp", chunkFileTO);
                    this.chunkTableDAOImpl.updateCRC32Value(this.crc32Value, BluSyncSQLConstants.getTempBackupChunkTable((String)this.tableNameHash), false);
                    String largeFileextensions = this.backupPolicyTO.getFixedLengthBlockExtensions();
                    if (!StringUtils.isEmpty((String)largeFileextensions)) {
                        List<String> largeFileextensionsList = Arrays.asList(largeFileextensions.split(","));
                        String extension = willBeRead.getName().substring(willBeRead.getName().lastIndexOf(".") + 1);
                        boolean largeFileMatch = largeFileextensionsList.stream().anyMatch(ext -> ext.equalsIgnoreCase(extension));
                        if (largeFileMatch && fileSize > 524288000L) {
                            logger.debug("inside large file ");
                            largeFile = true;
                        }
                    }
                    this.createAdapterConnection();
                    try {
                        this.p.x = this.POLYNOMIAL;
                        ChunkerHelper.Chunker chunker = null;
                        chunker = largeFile ? ChunkerHelper.New(willBeRead, this.p, largeFile) : ChunkerHelper.New(willBeRead, this.p);
                        while (totalBytesRead < fileSize) {
                            if (Thread.currentThread().isInterrupted()) {
                                this.cleanupInterface.updateErrorCode(this.errorCode);
                                this.cancelUpload();
                                return null;
                            }
                            if (this.startFromScratch) {
                                logger.debug("Start from scratch enabled so break...");
                                numberOfChunks = 1;
                                totalBytesRead = 0L;
                                chunker = ChunkerHelper.New(willBeRead, this.p);
                                this.startFromScratch = false;
                                this.multiPartBackupAdapter.cancelUpload();
                                this.createAdapterConnection();
                            }
                            ChunkerHelper.Chunk chunk = chunker.Next(temporaryData, willBeRead);
                            int chunkLen = (int)chunk.Length;
                            logger.debug(chunk.Start + ":sTart chunk...." + chunkLen + ":Before Writng temp file: " + chunk.data.length);
                            temporaryData = this.readRandomWithoutCompression(willBeRead, chunk.Start, chunkLen);
                            Object[] obj = ParabluFileSystemUtils.writeOnStream((int)chunkLen, (boolean)isCompressionEnabled, (byte[])temporaryData, (long)totalSize);
                            actualData = (byte[])obj[0];
                            totalSize = (Long)obj[1];
                            logger.debug("Before adding file part in req" + totalSize);
                            this.addChunkDetailsForMultipart(backupTO, numberOfChunks, actualData, willBeRead, this.tableNameHash, chunk);
                            if (chunkLen > 0) {
                                totalBytesRead += (long)chunkLen;
                            }
                            this.updateChunkDetailForUI(backupTO, fileSize, totalBytesRead);
                            ++numberOfChunks;
                            logger.debug("Chunk Count :" + this.uploadedChunkCount + " and file Size " + fileSize);
                            if (totalBytesRead != fileSize) continue;
                            logger.debug("finished writing file");
                            break;
                        }
                        logger.debug("Chunk file uploaded");
                        this.uploadChunkNameListFile(backupTO, 0L, this.chunkNamesInList, null, FALSE);
                        break block32;
                    }
                    catch (SecurityException e) {
                        logger.debug("Access denied");
                        logger.trace("" + e);
                        this.failedBackupTOs.add(backupTO);
                        logger.error(this.failedBackupTOs.size() + ">> File is not accessible or not found.." + willBeRead.getAbsolutePath());
                        failedFileLog.error(this.failedBackupTOs.size() + ">> File is not accessible or not found.." + willBeRead.getAbsolutePath());
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        logger.debug("File not found");
                        logger.trace("" + e);
                        this.failedBackupTOs.add(backupTO);
                        logger.error(this.failedBackupTOs.size() + ">> File is not accessible or not found.." + willBeRead.getAbsolutePath());
                        failedFileLog.error(this.failedBackupTOs.size() + ">> File is not accessible or not found.." + willBeRead.getAbsolutePath());
                        continue;
                    }
                    catch (CrawlAdapterException e) {
                        logger.trace("" + e);
                        logger.debug(EXCEPTION_OCCURED + e.getMessage());
                        logger.error(this.failedBackupTOs.size() + ">>CrawlAdapter Exception filepath: " + willBeRead.getAbsolutePath());
                        failedFileLog.error(this.failedBackupTOs.size() + "CrawlAdapterException while backing up the file : " + willBeRead.getAbsolutePath());
                        if ("IO EXCeption".equalsIgnoreCase(e.getMessage())) continue;
                        this.errorCode = 909;
                        Thread.currentThread().interrupt();
                        this.cancelUpload();
                    }
                    catch (Exception e) {
                        logger.error("Exception", (Throwable)e);
                        logger.error(this.failedBackupTOs.size() + ">>Unknown Exception filepath: " + willBeRead.getAbsolutePath());
                        logger.debug(EXCEPTION_OCCURED + e.getMessage());
                        if (e.getMessage().equalsIgnoreCase("The cloud file provider is not running")) {
                            logger.debug("The cloud operation is not supported on a read-only volume so return...");
                            this.failedBackupTOs.add(backupTO);
                            failedFileLog.error(this.failedBackupTOs.size() + " >>Thrown " + e.getMessage() + " while backing up the file : " + willBeRead.getAbsolutePath());
                            continue;
                        }
                        if (e.getMessage().equalsIgnoreCase("The cloud file provider is not running")) {
                            logger.debug("The cloud file provider is not running..........");
                            this.failedBackupTOs.add(backupTO);
                            failedFileLog.error(this.failedBackupTOs.size() + " >>Thrown " + e.getMessage() + " while backing up the file : " + willBeRead.getAbsolutePath());
                            continue;
                        }
                        this.errorCode = 909;
                        if (e.getMessage().contains("BitLocker Drive Encryption")) {
                            logger.debug("Bitlocker exception:" + e.getMessage());
                            this.errorCode = 1212;
                            this.cleanupInterface.updateErrorCode(this.errorCode);
                            Thread.currentThread().interrupt();
                            this.cancelUpload();
                            break;
                        }
                        if ("IO EXCeption".equalsIgnoreCase(e.getMessage())) continue;
                        Thread.currentThread().interrupt();
                        this.cancelUpload();
                    }
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    this.failedBackupTOs.add(backupTO);
                    logger.debug(EXCEPTION_OCCURED + e.getMessage());
                    this.errorCode = 909;
                    if ("IO EXCeption".equalsIgnoreCase(e.getMessage())) break block32;
                    Thread.currentThread().interrupt();
                    this.cancelUpload();
                }
                break;
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            this.cleanupInterface.updateErrorCode(this.errorCode);
            this.cancelUpload();
            Thread.currentThread().interrupt();
            return null;
        }
        int status = this.multiPartBackupAdapter.finish();
        logger.debug("Batch finished and status is : " + status);
        if (!this.failedBackupTOs.isEmpty()) {
            this.cleanupInterface.updateBackupCrawlTable(this.failedBackupTOs);
            logger.debug("after  cleaning up database> 1111111>>>before removinf list<" + this.chunkFileBatch.size());
            this.removeFailedBackupTOs();
            logger.debug("After cleaning up database> 222222222>>>" + this.chunkFileBatch.size());
            this.failedBackupTOs.clear();
        }
        if ((noBackupSchedulesImpl = new NoBackupSchedulesImpl()).isNoBackupSchedule()) {
            this.cleanupInterface.updateErrorCode(1215);
            this.cleanupInterface.pauseBackup1(true, false);
        }
        if (!BackupHelper.validateNetworks()) {
            logger.debug("Network is not macthing so don't run backup......");
            this.cleanupInterface.updateErrorCode(1215);
            this.cleanupInterface.pauseBackup1(false, true);
        }
        if (status == 200) {
            try {
                List response = this.multiPartBackupAdapter.getResponse();
                String fileName = ObjectUtils.getFileSnapshotPath((String)this.chunkFileBatch.get(0).getClientData());
                File file = new File(fileName);
                this.createAdapterConnection();
                if (!response.isEmpty()) {
                    this.sendMissingChunks(response, file);
                }
                this.uploadChunkNameListFile(this.chunkFileBatch.get(0), 0L, this.chunkNamesInList, file, "true");
                status = this.multiPartBackupAdapter.finish();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.chunkTableDAOImpl.renameTable(this.tableNameHash, this.crc32Value);
            logger.debug("chunk file batch list>>>>>" + this.chunkFileBatch.size());
            if (this.chunkFileBatch.isEmpty()) {
                return new BackupTO();
            }
            BackupTO lastChunkFile = this.chunkFileBatch.get(this.chunkFileBatch.size() - 1);
            this.restartId = lastChunkFile.getRestartId();
            this.cleanupInterface.updateRestartId(this.restartId);
            for (BackupTO backupTO : this.chunkFileBatch) {
                this.cleanupInterface.updateUIWrapper(backupTO, this.uploadCount.addAndGet(1), this.totalUploadSize.addAndGet(backupTO.getFileSize()));
                this.cleanupInterface.runCleanup(backupTO, status);
            }
            this.cleanupInterface.updateTotalUploadSize();
            logger.debug("Batch finished returning backupTo to finished queue");
            return lastChunkFile;
        }
        this.errorCode = status == 449 ? 1981 : (status == 502 ? 1996 : (status == 428 ? 1208 : (status == 429 ? 1209 : (status == 543 ? 543 : (status == 405 ? 405 : status)))));
        this.cleanupInterface.updateErrorCode(this.errorCode);
        this.cancelUpload();
        Thread.currentThread().interrupt();
        return null;
    }

    private void setGatewayName(BackupTO backupTO) {
        if (StringUtils.isNotEmpty((String)backupTO.getGatewayIP()) && !backupTO.getGatewayIP().equalsIgnoreCase(this.uploadGatewayTo.getGatewayName())) {
            logger.debug(backupTO.getGatewayIP() + "gateway ip is changed so delete temp table and start fresh" + this.uploadGatewayTo.getGatewayName());
            this.chunkTableDAOImpl.clearEntireBackupChunkTable(this.tableNameHash, "temp");
        }
        backupTO.setGatewayIP(this.uploadGatewayTo.getGatewayName());
        this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(backupTO);
    }

    private void createCRC32Value(BackupTO backupTO, File willBeRead) {
        if (SettingHelper.getOsName().toLowerCase().startsWith("win")) {
            Map snapMap = RegistryUtils.getRegistryValueSet((String)"HKLM", (String)"SOFTWARE\\WOW6432Node\\ParaBlu\\SnapId");
            Map prevSnapMap = ParabluFileSystemUtils.getSnapIdMap();
            String driveName = backupTO.getClientData().substring(0, 3);
            driveName = driveName.toLowerCase();
            logger.debug("Drive name:" + driveName);
            if (!snapMap.isEmpty() && !prevSnapMap.isEmpty()) {
                logger.debug("snapMap:" + snapMap.toString());
                logger.debug("prevSnapMap:" + prevSnapMap.toString());
                if (snapMap.containsKey(driveName) && prevSnapMap.containsKey(driveName)) {
                    if (((String)snapMap.get(driveName)).equalsIgnoreCase((String)prevSnapMap.get(driveName))) {
                        logger.debug((String)snapMap.get(driveName) + " both snap id are same no need to create the crc32 value " + (String)prevSnapMap.get(driveName));
                        this.crc32Value = Long.valueOf(this.chunkTableDAOImpl.getCrc32Value(this.tableNameHash));
                        if (this.crc32Value != 0L) {
                            return;
                        }
                    } else {
                        logger.debug("current Snap or prev snap map does not match the snapid value");
                    }
                } else {
                    logger.debug(prevSnapMap.toString() + "current Snap or prev snap map does not contain key" + snapMap.toString());
                }
            } else {
                logger.debug("current Snap or prev snap map empty");
            }
        }
        this.crc32Value = MD5Generator.genrateCRC32ValueForFile((File)willBeRead);
    }

    private void createAdapterConnection() {
        try {
            logger.debug("Before creating adapter connection");
            this.multiPartBackupAdapter = new MultiPartBackupAdapter(this.uploadGatewayTo.getGatewayName(), null, this.requestURL, SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            logger.info("rate limiter>>" + this.rateLimiter);
            logger.debug("After creating adapter connection");
            logger.debug(this.finishedBatchesQueue.size() + "After creating adapter connection" + this.chunkFileBatch.size());
        }
        catch (IOException e1) {
            this.errorCode = 909;
            logger.trace("" + e1);
            logger.error("error in multipart backup adapter call" + e1.getMessage());
        }
    }

    private void sendMissingChunks(List<String> response, File file) throws NumberFormatException, IOException {
        try {
            logger.debug("missing chunks......" + response.size());
            logger.debug("response::::::::::::::::::" + response.get(0));
            String chunkListResponse = response.get(0);
            String[] chunkList = chunkListResponse.split("\\|");
            BackupTO backupTO = this.chunkFileBatch.get(0);
            logger.debug("chunk list after spliting by delimitr" + chunkList.length);
            for (String chunk : chunkList) {
                if (StringUtils.isEmpty((String)chunk)) {
                    return;
                }
                String[] chunkDetails = chunk.split(",");
                logger.debug(file + "chunk list after spliting by delimitr" + chunkDetails.length + "...." + Long.valueOf(chunkDetails[1]) + "..." + Integer.valueOf(chunkDetails[2]));
                byte[] actualData = this.readRandom(file, Long.valueOf(chunkDetails[1]), Integer.valueOf(chunkDetails[2]));
                this.multiPartBackupAdapter.addFormField();
                MultipartDedupUploadCallable.addHeaderToMultipart(this.multiPartBackupAdapter, backupTO, this.uploadGatewayTo, file, this.restartId, this.backupBatchID);
                String md5 = MD5Generator.generateMD5ForByteArray((byte[])actualData);
                String chunkName = chunkDetails[0];
                logger.debug("little hump:" + md5 + "Chunk Name is :" + chunkName + " for File Name is :" + backupTO.getFileName() + "tableNameHash:" + this.tableNameHash);
                this.addHeaderToMultipartforChunks(this.multiPartBackupAdapter, backupTO, md5, chunkName);
                this.multiPartBackupAdapter.addHeaderField("isAChunkFile", "true");
                this.multiPartBackupAdapter.addHeaderField("content-chunking", "true");
                this.multiPartBackupAdapter.addHeaderField("missing-chunk", "true");
                this.multiPartBackupAdapter.addHeaderField("content-chunk-data-present", "true");
                this.multiPartBackupAdapter.addHeaderField("offset", String.valueOf(chunkDetails[1]));
                this.multiPartBackupAdapter.addHeaderField("chunkFileSize", String.valueOf(actualData.length));
                this.multiPartBackupAdapter.addFilePart((InputStream)new ByteArrayInputStream(actualData), this.rateLimiter);
                logger.debug("inside chunk data  present missing chunks.....");
            }
        }
        catch (Exception e) {
            logger.error("Exception ..", (Throwable)e);
        }
    }

    private void removeFailedBackupTOs() {
        Iterator<BackupTO> iter = this.chunkFileBatch.iterator();
        block0: while (iter.hasNext()) {
            BackupTO to = iter.next();
            for (BackupTO backupTo : this.failedBackupTOs) {
                if (to.getRestartId() != backupTo.getRestartId()) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    private void uploadChunkNameListFile(BackupTO backupTO, long fileSize, List<String> chunkNamesInList, File file, String isChunkList) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        StringBuilder chunkNames = new StringBuilder();
        logger.debug("chunknames list size........." + chunkNamesInList.size());
        for (String name : chunkNamesInList) {
            chunkNames.append(name);
        }
        this.cleanupInterface.updateChunkFileDetail(backupTO, this.uploadedChunkCount);
        this.multiPartBackupAdapter.addFormField();
        logger.debug("Before adding header in req");
        MultipartDedupUploadCallable.addHeaderToMultipart(this.multiPartBackupAdapter, backupTO, this.uploadGatewayTo, file, this.restartId, this.backupBatchID);
        logger.debug("Before adding chunk header in req");
        String md5 = MD5Generator.generateMD5ForByteArray((byte[])chunkNames.toString().getBytes());
        this.addHeaderToMultipartforChunks(this.multiPartBackupAdapter, backupTO, md5, "chunkvalues");
        this.multiPartBackupAdapter.addHeaderField("isAChunkFile", FALSE);
        this.multiPartBackupAdapter.addHeaderField("isChunkList", isChunkList);
        this.multiPartBackupAdapter.addFilePart((InputStream)new ByteArrayInputStream(chunkNames.toString().getBytes()), this.rateLimiter);
        logger.debug("Upload chunk name list file completed");
    }

    private void addChunkDetailsForMultipart(BackupTO backupTO, int numberOfChunks, byte[] actualData, File file, String tableNameHash, ChunkerHelper.Chunk chunk) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.multiPartBackupAdapter.addFormField();
        MultipartDedupUploadCallable.addHeaderToMultipart(this.multiPartBackupAdapter, backupTO, this.uploadGatewayTo, file, this.restartId, this.backupBatchID);
        String md5 = MD5Generator.generateMD5ForByteArray((byte[])actualData);
        String chunkName = String.format("part%09d.%s", numberOfChunks, md5);
        logger.debug(md5 + ":Actual data md5...Chunk Name is :" + chunkName + " for File Name is :" + backupTO.getFileName() + "tableNameHash:" + tableNameHash);
        logger.debug("...actual data size..." + String.valueOf(actualData.length));
        boolean isChunkExists = this.chunkTableDAOImpl.isChunkExists(tableNameHash, md5, "temp");
        logger.debug("chunk exists....11111" + isChunkExists);
        if (!isChunkExists) {
            isChunkExists = this.chunkTableDAOImpl.isChunkExists(tableNameHash, md5, "actual");
            logger.debug("chunk exists....11111" + isChunkExists);
        }
        this.addHeaderToMultipartforChunks(this.multiPartBackupAdapter, backupTO, md5, chunkName);
        this.multiPartBackupAdapter.addHeaderField("isAChunkFile", "true");
        this.multiPartBackupAdapter.addHeaderField("content-chunking", "true");
        if (!isChunkExists) {
            this.multiPartBackupAdapter.addHeaderField("content-chunk-data-present", "true");
            this.multiPartBackupAdapter.addHeaderField("offset", String.valueOf(chunk.Start));
            this.multiPartBackupAdapter.addHeaderField("endOffset", String.valueOf(chunk.Length));
            this.multiPartBackupAdapter.addHeaderField("chunkFileSize", String.valueOf(actualData.length));
            this.multiPartBackupAdapter.addFilePart((InputStream)new ByteArrayInputStream(actualData), this.rateLimiter);
            ChunkFileTO chunkFileTO = new ChunkFileTO();
            chunkFileTO.setMd5Checksum(md5);
            this.chunkTableDAOImpl.insertChunkFileTO(tableNameHash, "temp", chunkFileTO);
            logger.debug("inside chunk data  present.....");
        } else {
            this.multiPartBackupAdapter.addHeaderField("content-chunk-data-present", FALSE);
            this.multiPartBackupAdapter.addHeaderField("offset", String.valueOf(chunk.Start));
            this.multiPartBackupAdapter.addHeaderField("endOffset", String.valueOf(chunk.Length));
            this.multiPartBackupAdapter.addFilePart((InputStream)new ByteArrayInputStream("a".getBytes()), this.rateLimiter);
            logger.debug("inside chunk data not present.....");
        }
        this.chunkNamesInList.add(chunkName + ",");
    }

    private void updateChunkDetailForUI(BackupTO backupTO, long fileSize, long totalBytesRead) {
        this.uploadedChunkCount = (int)((double)totalBytesRead / (double)fileSize * 100.0);
        this.cleanupInterface.updateChunkFileDetail(backupTO, this.uploadedChunkCount);
    }

    private void addHeaderToMultipartforChunks(MultiPartBackupAdapter multiPartBackupAdapter, BackupTO fileToUpload, String md5, String fileName) {
        multiPartBackupAdapter.addHeaderField("fileChunkNamesa", "");
        multiPartBackupAdapter.addHeaderField("prevBackupId", fileToUpload.getBackupId());
        multiPartBackupAdapter.addHeaderField("chunkFileMD5", md5);
        multiPartBackupAdapter.addHeaderField("chunkFileName", fileName);
        multiPartBackupAdapter.addHeaderField("isNormalFile", FALSE);
        multiPartBackupAdapter.addHeaderField("isCompressed", String.valueOf(this.backupPolicyTO.isCompressionEnabled()));
        multiPartBackupAdapter.addHeaderField("tableNameHash", this.tableNameHash + "_" + this.crc32nBkpBatch + "_" + this.backupBatchID);
    }

    private static void addHeaderToMultipart(MultiPartBackupAdapter multiPartBackupAdapter, BackupTO fileToUpload, GatewayTO currentUploadGatewayToUse, File file, long restartId, String batchIdForBackup) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        multiPartBackupAdapter.addHeaderField("gatewayName", currentUploadGatewayToUse.getGatewayName());
        multiPartBackupAdapter.addHeaderField("fileMD5", fileToUpload.getMd5checksum());
        multiPartBackupAdapter.addHeaderField("dedupifiedBackupId", "");
        multiPartBackupAdapter.addHeaderField("maxVersions", String.valueOf(SettingHelper.getMaxVersionsToKeep()));
        multiPartBackupAdapter.addHeaderField("is-base-folder", String.valueOf(fileToUpload.isBaseFolder()));
        multiPartBackupAdapter.addHeaderField("is-folder", String.valueOf(fileToUpload.isFolder()));
        multiPartBackupAdapter.addHeaderField("is-exists", String.valueOf(true));
        multiPartBackupAdapter.addHeaderField("modified", String.valueOf(fileToUpload.getLastModifiedTimestamp()));
        multiPartBackupAdapter.addHeaderField("accessTime", String.valueOf(file != null ? Long.valueOf(FileSystemUtility.getFileAccessTime((File)file)) : "0"));
        multiPartBackupAdapter.addHeaderField("creationTime", String.valueOf(file != null ? Long.valueOf(FileSystemUtility.getFileCreatedTime((File)file)) : "0"));
        multiPartBackupAdapter.addHeaderField("backupBatchId", batchIdForBackup);
        multiPartBackupAdapter.addHeaderField("userUnderLegalHold", FALSE);
        multiPartBackupAdapter.addHeaderField("userName", SettingHelper.getUserName().toLowerCase());
        multiPartBackupAdapter.addHeaderField("deviceUUID", SettingHelper.getDeviceUUId());
        multiPartBackupAdapter.addHeaderField("file-path", fileToUpload.getAbstractFilePath());
        multiPartBackupAdapter.addHeaderField("file-name", fileToUpload.getFileName());
        multiPartBackupAdapter.addHeaderField("cloudName", SettingHelper.getCloudName());
        multiPartBackupAdapter.addHeaderField("prevGatewayName", "");
        multiPartBackupAdapter.addHeaderField("token", SettingHelper.readTokenFromFile());
        multiPartBackupAdapter.addHeaderField("osType", SettingHelper.getOsName());
        multiPartBackupAdapter.addHeaderField("file-size", String.valueOf(file != null ? Long.valueOf(file.length()) : "0"));
        multiPartBackupAdapter.addHeaderField("restartId", String.valueOf(fileToUpload.getRestartId()));
        multiPartBackupAdapter.addHeaderField("backupId", fileToUpload.getBackupId());
        multiPartBackupAdapter.addHeaderField("isFullBackup", Boolean.toString(isFullBackup));
        multiPartBackupAdapter.addHeaderField("gatewayType", currentUploadGatewayToUse.getType());
        multiPartBackupAdapter.addHeaderField("isBackupManual", isBackupManual);
        multiPartBackupAdapter.addHeaderField("isReBackup", String.valueOf(isReBackup));
        multiPartBackupAdapter.addHeaderField("isSync", String.valueOf(fileToUpload.isSync()));
        multiPartBackupAdapter.addHeaderField("miniCloudId", fileToUpload.getMiniCloudId());
        if (fileToUpload.isSync()) {
            multiPartBackupAdapter.addHeaderField("crawlTimestamp", String.valueOf(fileToUpload.getCrawlTimestamp()));
        }
        logger.debug("check rebackup falg" + String.valueOf(isReBackup));
    }

    public void cancelUpload() {
        this.cleanupInterface.updateBackupCrawlTable(this.failedBackupTOs);
        this.failedBackupTOs.clear();
        if (this.multiPartBackupAdapter != null) {
            logger.debug("Canceling upload>>>>>>>>");
            this.multiPartBackupAdapter.cancelUpload();
        } else {
            logger.debug("multiThreadBackupAdapter is null>>>>>>>>>>>>");
        }
    }

    private byte[] readRandom(File file, long offset, int length) throws Exception {
        RandomAccessFile raf = new RandomAccessFile(file.getAbsolutePath(), "rw");
        raf.seek(offset);
        byte[] data = new byte[length];
        logger.debug(length + ":length..............startOffset:" + offset);
        int bytesRead = raf.read(data, 0, length);
        logger.debug("bytes read...." + bytesRead);
        raf.close();
        Object[] obj = ParabluFileSystemUtils.writeOnStream((int)bytesRead, (boolean)this.backupPolicyTO.isCompressionEnabled(), (byte[])data, (long)0L);
        return (byte[])obj[0];
    }

    private byte[] readRandomWithoutCompression(File file, long offset, int length) throws Exception {
        RandomAccessFile raf = new RandomAccessFile(file.getAbsolutePath(), "rw");
        raf.seek(offset);
        byte[] data = new byte[length];
        logger.debug(length + ":length..............startOffset:" + offset);
        int bytesRead = raf.read(data, 0, length);
        logger.debug("bytes read...." + bytesRead);
        raf.close();
        return data;
    }

    private int getStatusOfBackup(boolean isLastSuccessfulBackup) {
        BackupStatusElement statusElement = null;
        BackupAdapter backupAdapter = null;
        int backupStatus = 0;
        try {
            backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            statusElement = backupAdapter.getBackupStatus(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.readTokenFromFile(), "BACKUP", SettingHelper.getDeviceName(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), isLastSuccessfulBackup);
            if (statusElement.getResponseCode() == 421) {
                throw new CrawlAdapterException("Session Expired");
            }
            if (statusElement.getResponseCode() == 420) {
                throw new CrawlAdapterException(" User Device Blocked");
            }
            if (statusElement.getResponseCode() == 200) {
                backupStatus = statusElement.getResponseCode();
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Error in get backup status.", (Object)e.getMessage());
        }
        return backupStatus;
    }

    static {
        isReBackup = false;
    }
}

