/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;

public class CMSVersion
implements DEREncodable {
    private DERInteger version;

    public CMSVersion(BigInteger bigInteger) {
        this.setVersion(bigInteger);
    }

    public CMSVersion(DERInteger dERInteger) {
        this.version = dERInteger;
    }

    public CMSVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion.version;
    }

    public static CMSVersion getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CMSVersion) {
            return (CMSVersion)object;
        }
        if (object instanceof DERInteger) {
            return new CMSVersion((DERInteger)object);
        }
        if (object instanceof BERTaggedObject) {
            return CMSVersion.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid CMSVersion");
    }

    public static CMSVersion newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CMSVersion) {
            return new CMSVersion((CMSVersion)object);
        }
        if (object instanceof DERInteger) {
            return new CMSVersion((DERInteger)object);
        }
        if (object instanceof BERTaggedObject) {
            return CMSVersion.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid CMSVersion");
    }

    public BigInteger getVersion() {
        return this.version.getValue();
    }

    private void setVersion(BigInteger bigInteger) {
        this.version = new DERInteger(bigInteger);
    }

    public DERObject getDERObject() {
        return this.version;
    }
}

