#############################################################################
#                                                                           #
# SCRIPT: PatchUpdate.py                                                           #
# DATE:   12-Dec-2017                                                       #
# REV:    1.0                                                               #
# DEVELOPED BY: Sanjay Pandit                                               #
# PURPOSE: Script for updating the patch, creating a sfx file and uploading it to the dns server                #
# PLATFORM: Windows                                                         #
#############################################################################

import subprocess
import paramiko
import configparser
import tarfile
import os
import shutil
import sys
import errno
import datetime
import time
import win32com.client as win
from pip._vendor.distlib.compat import raw_input
from Constants import _Const
from configparser import ConfigParser
from subprocess import call
import git
import stat



# Global variables
versionNumber = ""
cloudName = ""
EBMS_dom = ""
sub_EBMS_dom = ""
sub_EBMS_dom_1 = ""
sfx_conf_file = ""
use_sfx_conf_file = False
CONST = _Const()
tsToUse = ""
MailLink =""
Silent_NonSilent=""
Non_Bruteforce_Agent=""
Input=""
InputKey=""
HideAgent=""
Proxy_Enabled=""
SSO_Browser_Preference=""
Sleep_Time_To_Wait_And_Get_Authocode=""
Timer_Delay_to_Launch=""
Server_AGENT=""
Override_Ip_Settings=""

# Class to run the windows commands. will have a run_command method
class runWindowsCommand:
    
    # constructor
    def __init__(self):
        # will do something useful here later on 
        # currently just pass
        pass
    
    # function which will run the desired command which has parameters being passed to it
    def runCommandWithArgs(self, cmdWithParams):
        # printNicely("Just completed the run for command {}",format(subprocess.list2cmdline(cmdWithParams)), False)
        p = subprocess.Popen(subprocess.list2cmdline(cmdWithParams),shell=True)
        stdout, stderr = p.communicate()
        return p.returncode
    
    # Function which will run a command without arguments
    def runSimpleCommand(self,cmdRecd):
        p = subprocess.Popen(cmdRecd, shell=True)
        # check out p.poll
        stdout, stderr = p.communicate()
        return p.returncode

  
# function to read the config file 
# file will have an extension .ini
# lines starting with # will be ignored          
# file will have sections defined by [<section name>
# followed by key value pairs of attributes/parameters in the format
# attribute: value
def readConfigFile(fileName):    
   
    Config.read(fileName)
    Config.sections()
    return
    
def pause(message = ""):
    printNicely(message, True)
    programPause = raw_input("Press the <ENTER> key to continue...")
    return
    

def ConfigSectionMap(section):
        
    dict1 = {}
    options = Config.options(section)
    for option in options:
        try:
            dict1[option] = Config.get(section, option)
            if dict1[option] == -1:
                printNicely("skip: %s" % option, False)
        except:
            printNicely("exception on %s!" % option, False)
            dict1[option] = None
    return dict1
        
def getConfigValue(section, option):
    return ConfigSectionMap(section)[option]
     

def downloadTarFile():
    global Input
    printNicely(CONST.DEBUG_GET_SRC_FILE,  True)
    try:
        # first get all parameters

        hostName = Config.get(CONST.SECTION_FTP,CONST.SOURCE_HOST_NAME )
        userName = Config.get(CONST.SECTION_FTP,CONST.SOURCE_USER_NAME)
        passWord = Config.get(CONST.SECTION_FTP,CONST.SOURCE_PWD)
        remPath = Config.get(CONST.SECTION_FTP,CONST.SOURCE_REMOTE_PATH)+ CONST.SRC_FILE_V +versionNumber + CONST.SRC_FILE_EXT
        portNum = Config.getint(CONST.SECTION_FTP,CONST.SOURCE_PORT)           
        localPath = Config.get(CONST.SECTION_FTP, CONST.SOURCE_LOCAL_PATH)+ CONST.SRC_FILE_V +versionNumber +CONST.SRC_FILE_EXT
        printNicely("Remote download path is  {0} {1}".format(remPath, portNum), True)
        # check if the file with the version number exists on the local server
        if (os.path.exists(localPath)):
            # Let the user know that a local file exists and ask
            # the user if they want to use this file or download
            # a new version. 
            printNicely( CONST.DEBUG_NOTIFY_LOCAL_COPY + localPath, True)
            # If the user opts to use the existing file
            # then return from thie function
            while Input == "":
                Ans =raw_input(CONST.DEBUG_CONFIRM_DOWNLOAD)        
                if ( check_user_input(Ans) == 1):
                    printNicely(CONST.DEBUF_LOCAL_COPY_USE_CONFIRMATION, True)
                    Input="yes"
                    return
                elif (check_user_input(Ans) ==2):
                    # if the the user chooses not to use the file and wants to 
                    # download a new copy, then delete the existing file
                    Input="NO"
                    try:
                        os.unlink(localPath)    
                    except Exception as e:
                        printNicely("Can not delete local copy of file - exiting", True)
                        print(e)
                        exit(1)
                else :
                    printNicely("Please enter the correct value",True)
        # if we have reached here, it means that either there was no existing local 
        # copy of the file or the user choose to download a fresh copy.
        # either way, we now need to download a fresh copy of the file
        
        printNicely(CONST.DEBUF_FTP_USE_CONFIRMATION,  True)
        printNicely("...................Connecting to {0} ".format(hostName), True)
        transport = paramiko.Transport((hostName, portNum))
        transport.connect(username = userName, password = passWord)
        sftp = paramiko.SFTPClient.from_transport(transport)
        printNicely("...................Connected As {0} for {1} {2}".format(userName, remPath, localPath), True)

        sftp.get(remPath, localPath)
        printNicely("...................Get As {0} {1} ".format(remPath, localPath), True)
        sftp.close()
        transport.close()
        
        # check if the local file exists. if not exit
        if (not os.path.exists(localPath)):
            printNicely("Was not able to FTP the file. Please check if it exists on the DNS server... Exiting",  True)
            exit(1)
    except Exception as e:
        # changing the line to catch ANY exception rather than specific ones such as OSError, IOError, FileNotFoundError
        printNicely(CONST.DEBUG_FTP_ERROR, True)
        print(e)
        exit(1)
    
    return

def check_user_input(userInput):
    if (userInput.strip().upper() == CONST.USER_INPUT_Y or userInput.strip().upper() == CONST.USER_INPUT_YES):
        return 1
    elif (userInput.strip().upper() == CONST.USER_INPUT_N or userInput.strip().upper() == CONST.USER_INPUT_NO):
        return 2
    else:
        return 3

   
 
# This function will unzip the file which was downloaded to the 
# local path
def unTarSources():
    
    printNicely(CONST.DEBUG_UNTAR_MSG,  True)
    # get the location of the tar file - this is where we downloaded the file
    # in the previous step
    sourceLoc = Config.get(CONST.SECTION_FTP, CONST.SOURCE_LOCAL_PATH)+CONST.SRC_FILE_V+versionNumber+ CONST.SRC_FILE_EXT
    targetLoc = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)

    # check if targetloc exists - if not, create it
    if (not os.path.exists(targetLoc)):
        os.makedirs(targetLoc)
    
    # make sure that it is an empty directory
    for subdir, dirs, files in os.walk(Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)+"\\DigiCert\\"):
        for filename in files:
            filepath = subdir + os.sep + filename
            os.chmod(filepath,stat.S_IWRITE | stat.S_IRUSR | stat.S_IRGRP | stat.S_IROTH)
        
    try:
        for root, subdirs, files in os.walk(targetLoc):
            for file in files:
                os.unlink(os.path.join(root, file))
            for subdir in subdirs:
                shutil.rmtree(os.path.join(root, subdir))
    except Exception as e:
        printNicely("Unable to cleanup the directory. Please see exception message", True)
        print(e)
        exit(1)
        
    cwd = os.getcwd()
    os.chdir(targetLoc)
    repo = git.Repo.clone_from("https://github.com/ParabluInc/DigicertKey.git" , Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)+"\\DigiCert", branch='master')

    # now untar the file
    try:
        tar = tarfile.open(sourceLoc, CONST.TARFILE_READ_OPTION)
        tar.extractall()
        basepth = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)
        tar.close()
    except Exception as e:
        printNicely("Unable to extract from zip file. Please see exception message", True)
        print(e)
        exit(1)
    
    # get back to the original dir
    os.chdir(cwd)
    
    return
def copyFolder(src, dest):
    try:
        shutil.copytree(src, dest)
    except OSError as e:
        # If the error was caused because the source wasn't a directory
        if e.errno == errno.ENOTDIR:
            shutil.copy(src, dest)
        else:
            print('Directory not copied. Error: %s' % e)
# This will copy all the static files required to be run in order to create the 
# patch. These need to be present in the 'BaseDirectory'
def copyPatchCreationScripts():
    printNicely(CONST.DEBUG_PATCH_SRC_CPY_MSG,  True)
    # get the path to where the patch creation .bat and associated files are
    # stored
    PatchCreationBase = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BAT_FILE_DIR)
    printNicely(" Patch creation base is {0}".format(PatchCreationBase))
    # see if that directory exists
    if (not os.path.exists(PatchCreationBase)):
        printNicely(CONST.DEBUG_NO_BAT_FILE,  True)
        exit(1)
    
    # now copy the files into the baseDir
    targetLoc = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)
    
    for root, subdirs, files in os.walk(PatchCreationBase, topdown=True, onerror=None, followlinks=True ):
        for filename in files:
            try:
                sourceFile = os.path.join(root, filename)
                destFile = sourceFile.replace(PatchCreationBase,targetLoc )
                # only copy if the file does not already exist in the dest loc
                if not os.path.exists(destFile):
                    if not os.path.exists(os.path.dirname(destFile)):
                        os.makedirs(os.path.dirname(destFile))
                    shutil.copy( sourceFile, destFile)
                else:
                    printNicely(CONST.DEBUG_ASK_DIRECTIONS + destFile,  True)
                
            except Exception as e:
            # changing the line to catch ANY exception rather than specific ones such as OSError, IOError, FileNotFoundError
                printNicely(CONST.DEBUG_BAT_FILE_COPY_ERROR + sourceFile,  True)
                print(e)
                exit(1)
              
    return  

# runs a scan for MEMORY and all files in dir to scan
### function which will create a file which the 
### anti virus software should recognize as a 
### virus. Based on the EICAR stds.
### more info @ https://support.kaspersky.com/viruses/general/459
def prepPatchCreation():
    global tsToUse
    # First ensure that the virus definition file is uptodate
    printNicely(CONST.DEBUG_ENV_PREP ,  True)
    
    # Get the datetime and store it in a gloabl variable
    downloadTarFile()
    unTarSources()
    pause("check for untared files")
	
    copyPatchCreationScripts()    

def printUsage():
    print (CONST.DEBUG_USAGE_LINE_1 )
    print(CONST.DEBUG_USAGE_LINE_2 )
    return

# function which will print 2 blank lines above the message and a tab
# on the line before the message
def printNicely(msg, flushit = True):
    if flushit!=True:
        flushit=False
    print(CONST.NICE_PRINT_FORMAT + msg, flush=flushit)

# Function to process the input parameters
def processInputParams():
    global versionNumber
    global cloudName
    global EBMS_dom
    global sub_EBMS_dom
    global sub_EBMS_dom_1
    global sfx_conf_file
    global use_sfx_conf_file
    global MailLink
    global Silent_NonSilent
    global Non_Bruteforce_Agent
    global InputKey
    global HideAgent
    global Proxy_Enabled
    global SSO_Browser_Preference
    global Sleep_Time_To_Wait_And_Get_Authocode
    global Timer_Delay_to_Launch
    global Server_AGENT
    global Override_Ip_Settings
	
    printNicely("Please enter the details when asked, leave empty if value not needed.")
    while versionNumber =="":
        versionNumber=raw_input("Enter Patch/Tag number :")
        if versionNumber == "":
            printNicely("versionNumber name cannot be empty")
        else:
            break
    while cloudName =="":
        cloudName=raw_input("Enter cloud name :")
        if cloudName == "":
            printNicely("cloud name cannot be empty")
        else:
            break
    while EBMS_dom =="":
        EBMS_dom=raw_input("Enter EBMS Domain :")
        if EBMS_dom == "":
            printNicely("EBMS Domain name cannot be empty")
        else:
            break
    sub_EBMS_dom=raw_input("Enter sub ebms :")
    sub_EBMS_dom_1=raw_input("Enter sub ebms1 :")
    shell = win.Dispatch("WScript.Shell").SendKeys("mailto:support@parablu.com")
    MailLink=raw_input("Enter MailLink :")
    printNicely("would you like to create silent package", True)
    while Silent_NonSilent == "":
        Ans =raw_input("(press y for silent package else n for Nonsilentpackage):")
        if (check_user_input(Ans) == 1):
            Silent_NonSilent="silentPackage"
        elif (check_user_input(Ans) ==2):
            Silent_NonSilent="NonsilentPackage"
        else:
            printNicely("please enter the correct value", True)
                    
      
    printNicely("would you like to create Non_bruteforce Agent", True)
    while Non_Bruteforce_Agent =="":
        Ans =raw_input("(press y for Non_Bruteforce Agent  else n for Bruteforce Agent):")
        if (check_user_input(Ans) == 1):
            Non_Bruteforce_Agent="Non_Bruteforce_Agent"
        elif (check_user_input(Ans) == 2):
            Non_Bruteforce_Agent="Bruteforce_Agent"
        else:
            printNicely("please enter the correct value", True)
    printNicely("would you like to Hide Agent from control Panel...", True)
    while HideAgent =="":
        Ans =raw_input("(press y for Hide Agent from control Panel else n for show Agent in control Panel):")
        if (check_user_input(Ans) == 1):
            HideAgent="1"
        elif (check_user_input(Ans) == 2):
            HideAgent="0"
        else:
            printNicely("please enter the correct value", True)
    printNicely("would you like to Enable Proxy ..  ...", True)
    while Proxy_Enabled =="":
        printNicely("Note:Proxy field is applicable only from 2.5.2.15 agent onwards..", True)
        Ans =raw_input("(press y to Enable Proxy else n to disable Proxy):")
        if (check_user_input(Ans) == 1):
            Proxy_Enabled="true"
        elif (check_user_input(Ans) == 2):
            Proxy_Enabled="false"
        else:
            printNicely("please enter the correct value", True)
    printNicely("would you like to mention preferred browser if any for SSO login", True)
    if Silent_NonSilent =="silentPackage":
        printNicely("Note:Browser preferences field is applicable only from 2.5.2.15 (as of now only chrome is supported,2.5.3.1 onwards we support chrome,firefox,edge) onwards..", True)
        Ans =raw_input("(preferred browser if any for SSO login(eg:chrome):(leave it blank for default browser)):")
        SSO_Browser_Preference=Ans
    if Silent_NonSilent =="silentPackage":
        printNicely("Note:sleep time to wait and get authcode field if aad enabled, is apllicable only from 2.5.3.1 agent onwards..", True)
        Ans =raw_input("(Please enter the sleep time in min):")
        Sleep_Time_To_Wait_And_Get_Authocode=Ans
    printNicely("Note:time interval to launch blusync agent if not running.(applicable only from 2.5.3.1 agent onwards)..", True)
    Ans =raw_input("(Please enter the time interval in min):")
    Timer_Delay_to_Launch=Ans
    while Server_AGENT =="":
        printNicely("Note:Server_AGENT field is applicable only from 2.5.3.4 agent onwards..", True)
        Ans =raw_input("(press y to create server agent else n to create normal agent):")
        if (check_user_input(Ans) == 1):
            Server_AGENT="serveragent"
        elif (check_user_input(Ans) == 2):
            Server_AGENT="nonserveragent"
        else:
            printNicely("please enter the correct value", True)
    printNicely("would you like to over ride ip settings", True)
    while Override_Ip_Settings =="":
        printNicely("Note:over ride ip settings field is applicable only from 2.5.3.4.1 agent onwards..", True)
        Ans =raw_input("(press y to over ride ip settings else n):")
        if (check_user_input(Ans) == 1):
            Override_Ip_Settings="true"
        elif (check_user_input(Ans) == 2):
            Override_Ip_Settings="false"
        else:
            printNicely("please enter the correct value", True)
    printNicely("You sure all details entered are correct?", True)
			
    while InputKey =="":
        Ans =raw_input("(press y to continue or to re-enter press n:)")
        if (check_user_input(Ans) == 2):
            #printNicely("Do you want to re enter details Agins , press y to re enter detalils else no", True)
            versionNumber=""
            cloudName=""
            EBMS_dom=""
            Silent_NonSilent=""
            Non_Bruteforce_Agent=""
            HideAgent=""
            sub_EBMS_dom=""
            sub_EBMS_dom_1=""
            Proxy_Enabled=""
            SSO_Browser_Preference=""
            Sleep_Time_To_Wait_And_Get_Authocode=""
            Timer_Delay_to_Launch=""
            Server_AGENT=""
            Override_Ip_Settings=""
            processInputParams()
        elif (check_user_input(Ans) == 1):
            InputKey="yes"
            return
        else:
            printNicely("please enter the correct value", True)

def saveUserInputsInConfig():
    try:
        config = ConfigParser()
        config.add_section("config")
        config.set("config", "versionNumber", versionNumber)
        config.set("config", "cloudName", cloudName)
        config.set("config", "EBMS_dom", EBMS_dom)
        config.set("config", "sub_EBMS_dom", sub_EBMS_dom)
        config.set("config", "sub_EBMS_dom_1", sub_EBMS_dom_1)
        config.set("config", "MailLink", MailLink)
        config.set("config", "Silent_NonSilent", Silent_NonSilent)
        config.set("config", "Non_Bruteforce_Agent", Non_Bruteforce_Agent)
        config.set("config", "HideAgent", HideAgent)
        config.set("config", "Proxy_Enabled", Proxy_Enabled)
        config.set("config", "SSO_Browser_Preference", SSO_Browser_Preference)
        config.set("config", "Sleep_Time_To_Wait_And_Get_Authocode", Sleep_Time_To_Wait_And_Get_Authocode)
        config.set("config", "Timer_Delay_to_Launch", Timer_Delay_to_Launch)
        config.set("config", "Server_AGENT", Server_AGENT)
        config.set("config", "Override_Ip_Settings", Override_Ip_Settings)
        config.write(open("ConfigFile.properties", "w"))
    except Exception as e:
        printNicely("Error in creating  config file..", True)
        print(e)
        exit(1)
    
if __name__ == "__main__":
    # The main processing starts here
    processInputParams()
    # create instances of classes required
    Config = configparser.ConfigParser() 
    mycmd = runWindowsCommand()
    # read the config file
    readConfigFile(CONST.ConfigFile)

    # Start the process of creating the sfx

    # first prep the system for creating the pathc
    prepPatchCreation()
    saveUserInputsInConfig()
    packageFile = Config.get(CONST.SECTION_ASSEMBLE_PATCH, CONST.BASE_DIR)+"\CreatePackage.py"
    #os.system('py'  packageFile)
    #execfile(packageFile)
    call(["python", packageFile])
    printNicely(CONST.DONE,  True)

