/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.BackupLifeCycle;
import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.RestoreActivityHistoryDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.DeviceElement;
import com.parablu.epa.core.element.FileElement;
import com.parablu.epa.core.element.RestoreElement;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.to.DeviceTo;
import com.parablu.epa.core.to.RestoreActivityTO;
import com.parablu.epa.view.FontsManager;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileLock;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreBackup
extends Shell {
    private Logger logger = LoggerFactory.getLogger(RestoreBackup.class);
    FontsManager fontsManager;
    private BackupAdapter backupAdapter = null;
    private DeviceTo selectedItem;
    private DeviceTo selectedFolder;
    private DeviceTo previousSelectedFolder;
    private String folderPath;
    private TimerTask restoreTimerTask = null;
    private Timer restoreTimer = null;
    private int lengthForFileName = 25;
    private Image shellImage = null;
    private ImageData shellImageData = null;
    Button restoreButton;
    Label restoreStatus;
    Label currentFileBeingRestoredLabel;
    Label currentRestoreStatusLabel;
    private boolean restoreLoadingStatus = true;
    private Integer port;
    private Button closeButton;
    public String deviceuid;
    int restoreFolderorDevice = 0;
    private List<DeviceTo> listDevices = null;
    private List<DeviceTo> listFolders = null;
    String fullPath = null;
    String previousFolderPath = null;
    public int cnt = 1;
    public int restoredCount = 0;
    public int totalnoOfFilesToBeRestored = 0;
    public long totalSizeToBeRestored = 0L;
    public long currentSizeRestored = 0L;
    private Thread restoreThread = null;
    private FileLock fileLock = null;
    Button checkBox;
    Button checkBoxbtn;
    private boolean restoreAllVersionSelected = false;
    private static final String EXCEPTION = "Exception :";
    private static final String RESTORE_DEFAULT = "Restore default Closing shell cause of error";
    RestoreElement restoreElement = new RestoreElement();
    Group restoreFolderGroup = null;
    Group restoreGroup = null;
    Group queryGroup = null;
    DeviceElement deviceElement;
    private Image imageBack = null;
    Label showPathLabel;
    Button backLabel = null;
    private static String backImageLocation = "resource\\img\\glyphicons_221_unshare.png";
    String batchId = "";
    String uploadIpForGateway = null;

    public RestoreBackup(Shell shell) throws Exception {
        super(shell, 65632);
        this.setLocation(shell.getLocation());
        this.disableEscapeKey();
    }

    public RestoreBackup(Shell parent, int style) throws Exception {
        super(parent, style);
        this.setLocation(parent.getLocation());
        this.disableEscapeKey();
    }

    public RestoreBackup(FileLock uiFileLock) throws Exception {
        super(65760);
        this.fileLock = uiFileLock;
        int xAxisLocation = this.getShell().getDisplay().getClientArea().width / 2 - 150;
        int yAxisLocation = this.getShell().getDisplay().getClientArea().height / 2 - 240;
        this.getShell().setLocation(xAxisLocation, yAxisLocation);
        this.disableEscapeKey();
    }

    private void disableEscapeKey() {
        Listener listener = e -> {
            if (e.detail == 2) {
                e.doit = false;
            }
        };
        this.getShell().addListener(31, listener);
    }

    public boolean openShell() throws Exception {
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        NotificationHelper.successfulRestore = 3;
        boolean result = false;
        this.fontsManager = new FontsManager(this.getShell().getDisplay());
        final Shell shell = this.getShell();
        this.shellImageData = new ImageData(SyncConstants.PARABLU_NAMED_IMAGE);
        this.shellImage = new Image((Device)shell.getDisplay(), this.shellImageData.scaledTo(72, 72));
        shell.setText(this.getText());
        shell.setImage(this.shellImage);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 10;
        gridLayout.marginTop = 10;
        shell.setLayout((Layout)gridLayout);
        shell.setLocation(shell.getLocation());
        this.imageBack = new Image((Device)shell.getDisplay(), new ImageData(backImageLocation).scaledTo(20, 20));
        Composite composite = new Composite((Composite)shell, 0x1000000);
        GridLayout compositeGridLayout = new GridLayout();
        compositeGridLayout.marginHeight = 0;
        compositeGridLayout.marginBottom = 0;
        compositeGridLayout.marginTop = 0;
        compositeGridLayout.numColumns = 2;
        compositeGridLayout.verticalSpacing = 5;
        compositeGridLayout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)compositeGridLayout);
        composite.setLayoutData((Object)new GridData(768));
        GridData contactGroupGridData = new GridData(768);
        final Table table = this.createDeviceUI(composite, contactGroupGridData);
        final Table foldertable = this.createFolderRestoreInUI(composite);
        foldertable.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent event) {
                if (foldertable.getSelectionIndex() != -1) {
                    TableItem item = foldertable.getItem(foldertable.getSelectionIndex());
                    RestoreBackup.this.selectedFolder = (DeviceTo)item.getData();
                    if (RestoreBackup.this.selectedFolder == null || item.getText().startsWith(" Version")) {
                        RestoreBackup.this.logger.debug("Selected folder is null:");
                        RestoreBackup.this.fullPath = RestoreBackup.this.previousFolderPath;
                        return;
                    }
                    RestoreBackup.this.logger.debug("Selected folder : " + RestoreBackup.this.selectedFolder.getFilePath());
                    RestoreBackup.this.logger.debug("Selected folder/file name: " + RestoreBackup.this.selectedFolder.getFileName());
                    RestoreBackup.this.folderPath = RestoreBackup.this.selectedFolder.getFilePath();
                    RestoreBackup.this.previousSelectedFolder = RestoreBackup.this.selectedFolder;
                    if (RestoreBackup.this.fullPath == null) {
                        RestoreBackup.this.fullPath = RestoreBackup.this.folderPath;
                        RestoreBackup.this.previousFolderPath = RestoreBackup.this.folderPath;
                    } else {
                        RestoreBackup.this.previousFolderPath = RestoreBackup.this.fullPath;
                        RestoreBackup.this.fullPath = RestoreBackup.this.fullPath + "/" + RestoreBackup.this.folderPath;
                        RestoreBackup.this.logger.debug("fullPath is: " + RestoreBackup.this.fullPath);
                        RestoreBackup.this.logger.debug("previousPath: " + RestoreBackup.this.previousFolderPath);
                    }
                    try {
                        if (!RestoreBackup.this.selectedFolder.getFolder().equals("true")) {
                            RestoreBackup.this.logger.debug("Current selected file is a folde:" + RestoreBackup.this.selectedFolder.getFolder());
                            RestoreBackup.this.showupRevisions(foldertable, RestoreBackup.this.selectedFolder.getFilePath(), RestoreBackup.this.selectedFolder.getFileName());
                        } else {
                            RestoreBackup.this.getBasePathFromServer(foldertable, RestoreBackup.this.fullPath);
                        }
                        RestoreBackup.this.showPathLabel.setText(RestoreBackup.this.fullPath);
                        RestoreBackup.this.showPathLabel.setToolTipText(RestoreBackup.this.fullPath);
                    }
                    catch (Exception e1) {
                        RestoreBackup.this.logger.trace("" + e1);
                        RestoreBackup.this.logger.error(RestoreBackup.EXCEPTION + e1.getMessage());
                    }
                }
            }
        });
        foldertable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ++RestoreBackup.this.cnt;
                RestoreBackup.this.restoreFolderorDevice = 0;
                if (foldertable.getSelectionIndex() != -1) {
                    TableItem item = foldertable.getItem(foldertable.getSelectionIndex());
                    RestoreBackup.this.selectedFolder = (DeviceTo)item.getData();
                    if (item.getText().startsWith(" Version") && RestoreBackup.this.checkBoxbtn != null) {
                        RestoreBackup.this.checkBox.setSelection(false);
                        RestoreBackup.this.restoreAllVersionSelected = RestoreBackup.this.checkBoxbtn.getSelection();
                    }
                    if (RestoreBackup.this.selectedFolder == null) {
                        RestoreBackup.this.selectedFolder = RestoreBackup.this.previousSelectedFolder;
                        RestoreBackup.this.folderPath = RestoreBackup.this.selectedFolder.getFilePath();
                        RestoreBackup.this.logger.debug("Selected restore folder : " + RestoreBackup.this.fullPath + "/" + RestoreBackup.this.selectedFolder.getFilePath());
                        return;
                    }
                    if (RestoreBackup.this.fullPath == null) {
                        RestoreBackup.this.logger.debug("Selected folder for restore: " + RestoreBackup.this.selectedFolder.getFilePath());
                    } else {
                        RestoreBackup.this.logger.debug("Selected folder: " + RestoreBackup.this.fullPath + "/" + RestoreBackup.this.selectedFolder.getFilePath());
                        RestoreBackup.this.logger.debug(" Selected folder backupid: " + RestoreBackup.this.selectedFolder.getBackupId());
                    }
                }
            }
        });
        this.pullRestoreDeviceListFromServer(table);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestoreBackup.this.restoreFolderorDevice = 1;
                if (table.getSelectionIndex() != -1) {
                    NotificationHelper.successfulRestore = 8;
                    RestoreBackup.this.restoreFolderGroup.setVisible(true);
                    TableItem item = table.getItem(table.getSelectionIndex());
                    RestoreBackup.this.selectedItem = (DeviceTo)item.getData();
                    RestoreBackup.this.deviceuid = RestoreBackup.this.selectedItem.getDeviceUid();
                    RestoreBackup.this.logger.debug("Selected device: " + RestoreBackup.this.selectedItem.getDeviceName());
                }
            }
        });
        table.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent event) {
                if (table.getSelectionIndex() != -1) {
                    TableItem item = table.getItem(table.getSelectionIndex());
                    RestoreBackup.this.selectedItem = (DeviceTo)item.getData();
                    RestoreBackup.this.logger.debug("Selected device: " + RestoreBackup.this.selectedItem.getDeviceName());
                    RestoreBackup.this.logger.debug("Device ID is:" + RestoreBackup.this.selectedItem.getDeviceId());
                    RestoreBackup.this.deviceuid = RestoreBackup.this.selectedItem.getDeviceUid();
                    try {
                        RestoreBackup.this.fullPath = null;
                        RestoreBackup.this.previousFolderPath = null;
                        RestoreBackup.this.getBasePathFromServer(foldertable, RestoreBackup.this.fullPath);
                        RestoreBackup.this.showPathLabel.setText("");
                    }
                    catch (Exception e1) {
                        RestoreBackup.this.logger.trace("" + e1);
                        RestoreBackup.this.logger.error(RestoreBackup.EXCEPTION + e1.getMessage());
                    }
                }
            }
        });
        GridData tableData = new GridData(768);
        tableData.heightHint = 50;
        table.setLayoutData((Object)tableData);
        GridData tableFolderData = new GridData(768);
        tableFolderData.minimumHeight = 70;
        foldertable.setLayoutData((Object)tableFolderData);
        this.queryGroup = new Group(composite, 0x1000000);
        GridLayout queryGroupGridLayout = new GridLayout();
        queryGroupGridLayout.numColumns = 2;
        queryGroupGridLayout.makeColumnsEqualWidth = false;
        this.queryGroup.setLayout((Layout)queryGroupGridLayout);
        GridData queryGroupGridData = new GridData(768);
        queryGroupGridData.horizontalSpan = 2;
        this.queryGroup.setLayoutData((Object)queryGroupGridData);
        this.queryGroup.setText("Select the destination folder");
        this.queryGroup.setFont(this.fontsManager.getSmallNormalFont());
        final Text subtext = new Text((Composite)this.queryGroup, 2052);
        GridData subGridData = new GridData(768);
        subGridData.widthHint = 170;
        subtext.setLayoutData((Object)subGridData);
        Button folderSelectButton = new Button((Composite)this.queryGroup, 8);
        folderSelectButton.setText("Select Folder");
        folderSelectButton.setFont(this.fontsManager.getMediumNormalFont());
        Label showDestinationFolderHelpLabel = new Label((Composite)this.queryGroup, 0);
        showDestinationFolderHelpLabel.setLayoutData((Object)queryGroupGridData);
        showDestinationFolderHelpLabel.setText("Restored data will be downloaded to this folder");
        showDestinationFolderHelpLabel.setFont(this.fontsManager.getSmallNormalFont());
        folderSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(shell);
                dlg.setFilterPath(subtext.getText());
                dlg.setText("ParaBlu");
                dlg.setMessage("Select the directory you want to restore to");
                String dir = dlg.open();
                if (dir != null) {
                    subtext.setText(dir);
                }
            }
        });
        Composite restoreStartGroup = new Composite(composite, 0x1000000);
        GridLayout restoreStartGroupGridLayout = new GridLayout();
        restoreStartGroupGridLayout.numColumns = 2;
        restoreStartGroupGridLayout.makeColumnsEqualWidth = false;
        restoreStartGroup.setLayout((Layout)restoreStartGroupGridLayout);
        GridData restoreStartGroupGridData = new GridData(768);
        contactGroupGridData.horizontalSpan = 2;
        restoreStartGroup.setLayoutData((Object)restoreStartGroupGridData);
        this.restoreStatus = new Label(restoreStartGroup, 16384);
        GridData restoreGridData = new GridData(768);
        this.restoreStatus.setLayoutData((Object)restoreGridData);
        this.restoreStatus.setText("Loading information");
        this.restoreStatus.setFont(this.fontsManager.getSmallNormalFont());
        Label dummy = new Label(restoreStartGroup, 16384);
        GridData dummygrid = new GridData(768);
        dummy.setLayoutData((Object)dummygrid);
        dummy.setVisible(false);
        Composite currentFileGroup = new Composite(composite, 0x1000000);
        GridLayout currentFileLayout = new GridLayout();
        currentFileLayout.numColumns = 1;
        currentFileLayout.makeColumnsEqualWidth = false;
        currentFileGroup.setLayout((Layout)currentFileLayout);
        GridData currentFileGridData = new GridData(768);
        currentFileGridData.horizontalSpan = 2;
        currentFileGroup.setLayoutData((Object)currentFileGridData);
        this.currentFileBeingRestoredLabel = new Label(currentFileGroup, 16384);
        this.currentFileBeingRestoredLabel.setLayoutData((Object)new GridData(768));
        this.currentRestoreStatusLabel = new Label(currentFileGroup, 16384);
        this.currentRestoreStatusLabel.setLayoutData((Object)new GridData(768));
        Composite restoreButtonComposite = new Composite(composite, 0x1000000);
        GridLayout restoreButtonLayout = new GridLayout();
        restoreButtonLayout.numColumns = 2;
        restoreButtonLayout.makeColumnsEqualWidth = false;
        restoreButtonLayout.horizontalSpacing = 170;
        restoreButtonComposite.setLayout((Layout)restoreButtonLayout);
        GridData restoreButtonGridData = new GridData(768);
        restoreButtonGridData.horizontalSpan = 2;
        restoreButtonComposite.setLayoutData((Object)restoreButtonGridData);
        this.restoreButton = new Button(restoreButtonComposite, 8);
        GridData buttonGridData = new GridData();
        this.restoreButton.setLayoutData((Object)buttonGridData);
        this.restoreButton.setEnabled(false);
        this.restoreButton.setText("Restore");
        this.restoreButton.setFont(this.fontsManager.getMediumNormalFont());
        Composite checkBoxComposite = new Composite(composite, 0x1000000);
        GridLayout checkBoxButtonLayout = new GridLayout();
        checkBoxButtonLayout.numColumns = 2;
        checkBoxButtonLayout.makeColumnsEqualWidth = false;
        checkBoxButtonLayout.horizontalSpacing = 170;
        checkBoxComposite.setLayout((Layout)checkBoxButtonLayout);
        GridData checkGridData = new GridData(768);
        checkGridData.horizontalSpan = 2;
        this.checkBox = new Button(checkBoxComposite, 32);
        this.checkBox.setBounds(330, 225, 75, 20);
        this.checkBox.setText("Restore all versions");
        this.checkBox.setFont(this.fontsManager.getMediumNormalFont());
        this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RestoreBackup.this.checkBoxbtn = (Button)event.getSource();
                RestoreBackup.this.restoreAllVersionSelected = RestoreBackup.this.checkBoxbtn.getSelection();
                RestoreBackup.this.logger.debug("check box selected:" + RestoreBackup.this.restoreAllVersionSelected);
                if (RestoreBackup.this.checkBoxbtn.getSelection()) {
                    MessageBox msg = new MessageBox(shell, 34);
                    msg.setText("Restore Alert");
                    msg.setMessage("Selecting all versions may result in a long restore operation and take a lot of space on your hard drive \n Make sure there is enough disk space available");
                    msg.open();
                }
            }
        });
        this.restoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RestoreBackup.this.logger.debug("The selected item is:(file-1/folder-0):" + RestoreBackup.this.restoreFolderorDevice);
                RestoreActivityTO restoreActivityTo = new RestoreActivityTO();
                RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = new RestoreActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
                NotificationHelper.setShowFileBeingRestored((boolean)false);
                RestoreBackup.this.totalnoOfFilesToBeRestored = 0;
                RestoreBackup.this.restoredCount = 0;
                if (NotificationHelper.restoreStarted) {
                    return;
                }
                MessageBox msg = new MessageBox(shell, 34);
                String destinationFolder = subtext.getText();
                File file = new File(destinationFolder);
                if (RestoreBackup.this.selectedItem == null) {
                    msg.setText("No device selected");
                    msg.setMessage("Please select a device to restore from");
                    msg.open();
                } else if (destinationFolder == "") {
                    msg.setText("No folder selected");
                    msg.setMessage("Please select a folder to restore to");
                    msg.open();
                } else if (!file.isDirectory()) {
                    msg.setText("Error");
                    msg.setMessage("The selected path is not a valid folder");
                    msg.open();
                } else {
                    if (file.list().length > 0) {
                        msg.setText("Folder not empty");
                        msg.setMessage("The destination folder is not empty. Please note that any file with the same name will be overwritten.");
                        msg.open();
                    }
                    NotificationHelper.successfulRestore = 1;
                    if (RestoreBackup.this.restoreFolderorDevice == 0 || RestoreBackup.this.restoreFolderorDevice == 1) {
                        RestoreBackup.this.logger.debug("Folder RESTORE");
                        RestoreBackup.this.restoreButton.setEnabled(false);
                        RestoreBackup.this.closeButton.setEnabled(false);
                        NotificationHelper.setRestoreStarted((boolean)true);
                        NotificationHelper.restoreFinished = false;
                        Runnable runnable = () -> {
                            try {
                                RestoreBackup.this.restoredCount = 0;
                                String status = BackupLifeCycle.STARTED.toString();
                                RestoreBackup.this.logger.debug("Status" + status);
                                RestoreBackup.this.batchId = RestoreBackup.this.restoreBatchInitiated(status, "", "0/0");
                                RestoreBackup.this.restoreElement = new RestoreElement();
                                String selectedPathForRestore = destinationFolder;
                                NotificationHelper.setShowFileBeingRestored((boolean)true);
                                if (!RestoreBackup.this.batchId.equals("") && !"-1".equals(RestoreBackup.this.batchId)) {
                                    RestoreBackup.this.validatePreviousBatchStatus(restoreActivityHistoryDAOImpl);
                                    RestoreBackup.this.logger.debug("Inserting into restore table");
                                    restoreActivityTo.setRestoreBatchStatus(status);
                                    restoreActivityTo.setRestoreBatchId(RestoreBackup.this.batchId);
                                    restoreActivityHistoryDAOImpl.addEventToRestoreActivity(restoreActivityTo);
                                }
                                if (RestoreBackup.this.restoreFolderorDevice == 0) {
                                    if (RestoreBackup.this.selectedFolder.getFolder().equalsIgnoreCase("true")) {
                                        selectedPathForRestore = destinationFolder + StringLiterals.FILE_SEPARATOR + RestoreBackup.this.selectedFolder.getFilePath().replace(":", "_DRIVE");
                                        FileElement fileElement = ObjectUtils.convertToFileElement((DeviceTo)RestoreBackup.this.selectedFolder);
                                        RestoreBackup.this.restoreElement.setDevicePath(fileElement.getFileCompletePath());
                                        RestoreBackup.this.restoreElement.setFileUserOwner(RestoreBackup.this.selectedFolder.getFileUserOwner());
                                    } else if (RestoreBackup.this.selectedFolder.getFolder().equalsIgnoreCase("false")) {
                                        RestoreBackup.this.restoreElement.setDevicePath(RestoreBackup.this.selectedFolder.getFileName());
                                        RestoreBackup.this.restoreElement.setFileName(RestoreBackup.this.selectedFolder.getFilePath());
                                        RestoreBackup.this.restoreElement.setFileUserOwner(RestoreBackup.this.selectedFolder.getFileUserOwner());
                                        if (!RestoreBackup.this.restoreAllVersionSelected) {
                                            RestoreBackup.this.logger.debug("all versions not selected so set backup id>>>>>>" + RestoreBackup.this.selectedFolder.getFileUserOwner());
                                            RestoreBackup.this.restoreElement.setFileBackupId(RestoreBackup.this.selectedFolder.getBackupId());
                                        }
                                    }
                                } else if (RestoreBackup.this.restoreFolderorDevice == 1) {
                                    RestoreBackup.this.restoreElement.setFileUserOwner(SettingHelper.getUserName());
                                }
                                RestoreBackup.this.restoreElement.setCloudName(SettingHelper.getCloudName());
                                RestoreBackup.this.restoreElement.setRestoreBatchId(RestoreBackup.this.batchId);
                                RestoreBackup.this.restoreElement.setDestinationPath(selectedPathForRestore);
                                RestoreBackup.this.restoreElement.setDeviceUUid(RestoreBackup.this.deviceuid);
                                RestoreBackup.this.restoreElement.setRestoreAllVersions(RestoreBackup.this.restoreAllVersionSelected);
                                this.getUploadIPForGateway();
                                this.downloadFile(selectedPathForRestore);
                                return;
                            }
                            catch (Exception e1) {
                                NotificationHelper.successfulRestore = 0;
                                RestoreBackup.this.logger.trace("" + e1);
                                RestoreBackup.this.logger.error("unsuccessfulRestore, Exception e1: ", (Object)e1.getMessage());
                            }
                            finally {
                                if (NotificationHelper.successfulRestore == 1) {
                                    String status = BackupLifeCycle.COMPLETED.toString();
                                    String restoreCount = RestoreBackup.this.restoreElement.getRestoreCount();
                                    RestoreBackup.this.batchId = RestoreBackup.this.restoreBatchInitiated(status, RestoreBackup.this.batchId, restoreCount);
                                    if (RestoreBackup.this.batchId != null && RestoreBackup.this.batchId != "-1") {
                                        restoreActivityTo.setRestoreBatchStatus(status);
                                        restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                                    }
                                } else {
                                    String status = BackupLifeCycle.FAILED.toString();
                                    String restoreCount = RestoreBackup.this.restoreElement.getRestoreCount();
                                    RestoreBackup.this.batchId = RestoreBackup.this.restoreBatchInitiated(status, RestoreBackup.this.batchId, restoreCount);
                                    if (RestoreBackup.this.batchId != null && RestoreBackup.this.batchId != "-1") {
                                        restoreActivityTo.setRestoreBatchStatus(status);
                                        restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                                    }
                                }
                                NotificationHelper.setRestoreStarted((boolean)false);
                                NotificationHelper.restoreFinished = true;
                            }
                        };
                        RestoreBackup.this.restoreThread = new Thread(runnable);
                        RestoreBackup.this.restoreThread.start();
                    }
                }
            }

            private void downloadFile(String selectedPathForRestore) {
                try {
                    if ((SettingHelper.getIsEnableBackupPolicy().equalsIgnoreCase("true") || SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) && SettingHelper.getIsExternalStorageSelected().equalsIgnoreCase("true")) {
                        RestoreBackup.this.logger.debug("Selected path for restore: " + selectedPathForRestore);
                        int response1 = RestoreBackup.this.backupAdapter.downloadFileViaGateway1(RestoreBackup.this.uploadIpForGateway, RestoreBackup.this.port, SettingHelper.readTokenFromFile(), SettingHelper.getCloudName(), RestoreBackup.this.restoreElement);
                        RestoreBackup.this.logger.debug("New restore all versions selected:" + RestoreBackup.this.restoreAllVersionSelected);
                        if (response1 == 204) {
                            NotificationHelper.successfulRestore = 5;
                        }
                        if (response1 != 4) {
                            NotificationHelper.successfulRestore = 0;
                        }
                    }
                }
                catch (Exception e) {
                    NotificationHelper.successfulRestore = 0;
                    RestoreBackup.this.logger.error("unsuccessfulRestore, Exception: ", e);
                }
            }

            private void getUploadIPForGateway() {
                if ((SettingHelper.getIsEnableBackupPolicy().equalsIgnoreCase("true") || SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) && SettingHelper.getLdapEnabled().equals("true")) {
                    try {
                        RestoreBackup.this.uploadIpForGateway = PolicyManagementServerHelper.getPrivacyGatewayIP((String)"ANY");
                    }
                    catch (Exception e) {
                        RestoreBackup.this.logger.trace("" + e);
                        RestoreBackup.this.logger.debug("Error in get privacy gateway ip" + e.getMessage());
                    }
                    RestoreBackup.this.logger.debug("Restore Privacy Gateway IP:" + RestoreBackup.this.uploadIpForGateway);
                }
            }
        });
        this.closeButton = new Button(restoreButtonComposite, 8);
        GridData buttonGridDatax = new GridData();
        this.closeButton.setLayoutData((Object)buttonGridDatax);
        this.closeButton.setText("Close");
        this.closeButton.setFont(this.fontsManager.getMediumNormalFont());
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                shell.close();
            }
        });
        Listener listener = arg0 -> {
            this.logger.debug("closing the restore SHELL");
            try {
                this.restoreTimer.cancel();
                NotificationHelper.restoreFinished = false;
                if (NotificationHelper.isRestoreStarted() && this.restoreThread != null && this.restoreThread.isAlive()) {
                    this.restoreThread.stop();
                    NotificationHelper.setRestoreStarted((boolean)false);
                    this.logger.debug("Stopping thread for restore....");
                }
                if (this.fileLock != null) {
                    this.fileLock.release();
                }
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Restore Timer not cancelled" + e.getMessage());
            }
        };
        shell.addListener(21, listener);
        shell.pack();
        shell.open();
        return result;
    }

    private Table createDeviceUI(Composite composite, GridData contactGroupGridData) {
        this.restoreGroup = new Group(composite, 0x1000000);
        GridLayout groupGridLayout = new GridLayout();
        groupGridLayout.numColumns = 2;
        groupGridLayout.makeColumnsEqualWidth = false;
        this.restoreGroup.setLayout((Layout)groupGridLayout);
        contactGroupGridData.horizontalSpan = 2;
        this.restoreGroup.setLayoutData((Object)contactGroupGridData);
        this.restoreGroup.setText("Select the device to restore");
        this.restoreGroup.setFont(this.fontsManager.getSmallNormalFont());
        Table table = new Table((Composite)this.restoreGroup, 68356);
        Label showHelpLabel = new Label((Composite)this.restoreGroup, 0);
        showHelpLabel.setLayoutData((Object)contactGroupGridData);
        showHelpLabel.setText("Single click a device to restore all data");
        showHelpLabel.setFont(this.fontsManager.getSmallNormalFont());
        Label showHelpLabel1 = new Label((Composite)this.restoreGroup, 0);
        showHelpLabel1.setLayoutData((Object)contactGroupGridData);
        showHelpLabel1.setText("Double click a device to select a specific folder or a file");
        showHelpLabel1.setFont(this.fontsManager.getSmallNormalFont());
        return table;
    }

    private Table createFolderRestoreInUI(Composite composite) {
        this.restoreFolderGroup = new Group(composite, 0x1000000);
        this.restoreFolderGroup.setVisible(false);
        GridLayout groupFolderGridLayout = new GridLayout();
        groupFolderGridLayout.numColumns = 2;
        groupFolderGridLayout.makeColumnsEqualWidth = false;
        this.restoreFolderGroup.setLayout((Layout)groupFolderGridLayout);
        GridData contactGroupFolderGridData = new GridData(768);
        contactGroupFolderGridData.horizontalSpan = 2;
        GridData gdBtnNewButton3 = new GridData(4, 4, false, false, 1, 1);
        gdBtnNewButton3.heightHint = 27;
        gdBtnNewButton3.widthHint = 24;
        this.showPathLabel = new Label((Composite)this.restoreFolderGroup, 0);
        this.showPathLabel.setLayoutData((Object)gdBtnNewButton3);
        this.showPathLabel.setText("");
        this.backLabel = new Button((Composite)this.restoreFolderGroup, 0);
        this.backLabel.setLayoutData((Object)gdBtnNewButton3);
        this.backLabel.setText("");
        this.backLabel.setImage(this.imageBack);
        this.restoreFolderGroup.setLayoutData((Object)contactGroupFolderGridData);
        this.restoreFolderGroup.setText("Select a folder or a file to restore");
        this.restoreFolderGroup.setFont(this.fontsManager.getSmallNormalFont());
        final Table foldertable = new Table((Composite)this.restoreFolderGroup, 68356);
        this.backLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    if (RestoreBackup.this.fullPath == null) {
                        return;
                    }
                    if (RestoreBackup.this.fullPath.contains("/")) {
                        String tmpPath;
                        RestoreBackup.this.fullPath = tmpPath = RestoreBackup.this.getPreviousPathforBackButton();
                        RestoreBackup.this.logger.debug("Temp Path in back function is:" + tmpPath);
                        RestoreBackup.this.showPathLabel.setText(RestoreBackup.this.fullPath);
                        RestoreBackup.this.showPathLabel.setToolTipText(RestoreBackup.this.fullPath);
                        RestoreBackup.this.getBasePathFromServer(foldertable, RestoreBackup.this.fullPath);
                        RestoreBackup.this.backLabel.setEnabled(false);
                    } else {
                        RestoreBackup.this.fullPath = null;
                        RestoreBackup.this.getBasePathFromServer(foldertable, RestoreBackup.this.fullPath);
                        RestoreBackup.this.showPathLabel.setText("");
                        RestoreBackup.this.backLabel.setEnabled(false);
                    }
                }
                catch (Exception e1) {
                    RestoreBackup.this.logger.trace("" + e1);
                    RestoreBackup.this.logger.error(RestoreBackup.EXCEPTION + e1.getMessage());
                }
            }
        });
        Label showFolderHelpLabel = new Label((Composite)this.restoreFolderGroup, 0);
        showFolderHelpLabel.setLayoutData((Object)contactGroupFolderGridData);
        showFolderHelpLabel.setText("Selecting a folder will result in restoring all files");
        showFolderHelpLabel.setFont(this.fontsManager.getSmallNormalFont());
        return foldertable;
    }

    String getPreviousPathforBackButton() {
        String delimiter = "\\/";
        String[] tmpArray = this.fullPath.split(delimiter);
        String tmpPath = null;
        for (int i = 0; i < tmpArray.length - 1; ++i) {
            tmpPath = tmpPath == null ? tmpArray[i] : tmpPath + "/" + tmpArray[i];
        }
        return tmpPath;
    }

    public void getBasePathFromServer(Table foldertable, String folderPath) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        foldertable.removeAll();
        this.restoreButton.setEnabled(false);
        NotificationHelper.successfulRestore = 3;
        NotificationHelper.restoreFinished = false;
        Runnable runnable = () -> {
            this.listFolders = null;
            try {
                this.listFolders = this.backupAdapter.getAllBasePathForRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), null, this.selectedItem.getDeviceId(), SettingHelper.readTokenFromFile(), folderPath);
                if (this.listFolders == null && SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && SettingHelper.getHttpsPort() != null) {
                    this.port = Integer.valueOf(SettingHelper.getHttpsPort());
                    this.listFolders = this.backupAdapter.getAllBasePathForRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), this.port, this.selectedItem.getDeviceId(), SettingHelper.readTokenFromFile(), folderPath);
                }
            }
            catch (Exception e) {
                this.logger.debug(EXCEPTION, e);
            }
            if (this.isDisposed() || this.getDisplay() == null) {
                return;
            }
            if (this.listFolders == null) {
                this.logger.debug(RESTORE_DEFAULT);
                Runnable runbl = () -> {
                    this.showErrorMessage();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runbl);
                return;
            }
            Runnable runn = () -> {
                this.addFolderDevicesToTable(foldertable);
                this.restoreButton.setEnabled(true);
                NotificationHelper.successfulRestore = 8;
                this.backLabel.setEnabled(true);
            };
            this.getDisplay().syncExec(runn);
        };
        new Thread(runnable).start();
    }

    public void showupRevisions(Table foldertable, String fileName, String folderPath) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        foldertable.removeAll();
        this.restoreButton.setEnabled(false);
        NotificationHelper.successfulRestore = 3;
        NotificationHelper.restoreFinished = false;
        Runnable runable1 = () -> {
            this.listFolders = null;
            try {
                this.listFolders = this.backupAdapter.getAllRevisionsForAFile(SettingHelper.getCurrentCloudIpAddress(), null, this.selectedItem.getDeviceId(), SettingHelper.readTokenFromFile(), folderPath, fileName);
            }
            catch (Exception e) {
                this.logger.debug(EXCEPTION, e);
            }
            this.logger.debug(RESTORE_DEFAULT);
            if (this.isDisposed() || this.getDisplay() == null) {
                return;
            }
            if (this.listFolders == null) {
                this.logger.debug(RESTORE_DEFAULT);
                Runnable runnable = () -> {
                    this.showErrorMessage();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runnable);
                return;
            }
            Runnable runbl = () -> {
                this.showRevisionsInTable(foldertable);
                this.restoreButton.setEnabled(true);
                NotificationHelper.successfulRestore = 8;
                this.backLabel.setEnabled(true);
            };
            this.getDisplay().syncExec(runbl);
        };
        new Thread(runable1).start();
    }

    private void pullRestoreDeviceListFromServer(Table table) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        NotificationHelper.restoreFinished = false;
        NotificationHelper.successfulRestore = 3;
        Runnable runnable = () -> {
            this.listDevices = null;
            try {
                this.listDevices = this.backupAdapter.getAllRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), null, SettingHelper.readTokenFromFile());
                if (this.listDevices == null && SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && SettingHelper.getHttpsPort() != null) {
                    this.port = Integer.valueOf(SettingHelper.getHttpsPort());
                    this.listDevices = this.backupAdapter.getAllRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), this.port, SettingHelper.readTokenFromFile());
                }
            }
            catch (Exception e) {
                this.logger.debug(EXCEPTION, e);
            }
            if (this.isDisposed() || this.getDisplay() == null) {
                Runnable runbl = () -> {
                    this.showErrorMessage();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runbl);
                return;
            }
            if (this.listDevices == null || this.listDevices.isEmpty()) {
                this.logger.debug(RESTORE_DEFAULT);
                Runnable runn = () -> {
                    this.showErrorMessageForDeviceListEmpty();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runn);
                return;
            }
            Runnable runnable1 = () -> {
                this.logger.debug("Displaing list of devices");
                this.addDevicesToTable(this.listDevices, table);
                this.restoreButton.setEnabled(true);
                NotificationHelper.successfulRestore = 4;
            };
            this.getDisplay().asyncExec(runnable1);
        };
        new Thread(runnable).start();
    }

    private void addDevicesToTable(List<DeviceTo> listDevices, Table table) {
        Comparator comparator = (d1, d2) -> d1.getDeviceName().compareTo(d2.getDeviceName());
        Collections.sort(listDevices, comparator);
        for (DeviceTo deviceTo : listDevices) {
            TableItem item = new TableItem(table, 0);
            item.setText(deviceTo.getDeviceName());
            item.setData((Object)deviceTo);
        }
    }

    private void addFolderDevicesToTable(Table foldertable) {
        this.logger.debug("Adding folders to the table");
        this.sortByFolders(this.listFolders);
        ArrayList<String> set = new ArrayList<String>();
        HashMap<String, DeviceTo> map = new HashMap<String, DeviceTo>();
        for (DeviceTo deviceTo : this.listFolders) {
            if (deviceTo == null || deviceTo.getFilePath() == null) continue;
            set.add(deviceTo.getFilePath());
            map.put(deviceTo.getFilePath(), deviceTo);
        }
        if (set.isEmpty() && this.previousFolderPath != null) {
            this.logger.debug("ListSet is Empty:" + set.isEmpty());
            this.showPathLabel.setText(this.previousFolderPath);
            this.showPathLabel.setToolTipText(this.previousFolderPath);
            this.fullPath = this.previousFolderPath;
            try {
                this.logger.debug("Full Path is:" + this.previousFolderPath);
                this.getBasePathFromServer(foldertable, this.previousFolderPath);
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error(EXCEPTION + e.getMessage());
            }
        } else {
            for (String s : set) {
                TableItem item1 = new TableItem(foldertable, 0);
                item1.setText(s);
                item1.setData(map.get(s));
            }
        }
    }

    private void sortByFolders(List<DeviceTo> listDevices) {
        Comparator comparator = (d1, d2) -> new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append((Object)d1.getFilePath().toLowerCase(), (Object)d2.getFilePath().toLowerCase()).toComparison();
        Collections.sort(listDevices, comparator);
    }

    private void showRevisionsInTable(Table foldertable) {
        this.logger.debug("Adding folders to the table");
        ArrayList<String> set = new ArrayList<String>();
        HashMap<String, DeviceTo> map = new HashMap<String, DeviceTo>();
        int count = this.listFolders.size() + 1;
        for (DeviceTo deviceTo : this.listFolders) {
            --count;
            if (deviceTo.getFilePath() == null || !deviceTo.isExists()) continue;
            set.add(" Version " + count);
            map.put(" Version " + count, deviceTo);
        }
        if (set.isEmpty() && this.previousFolderPath != null) {
            this.logger.debug("ListSet is Empty:" + set.isEmpty());
            this.showPathLabel.setText(this.previousFolderPath);
            this.showPathLabel.setToolTipText(this.previousFolderPath);
            this.fullPath = this.previousFolderPath;
            try {
                this.logger.debug("Full Path is:" + this.previousFolderPath);
                this.getBasePathFromServer(foldertable, this.previousFolderPath);
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error(EXCEPTION + e.getMessage());
            }
        } else {
            for (String s : set) {
                TableItem item1 = new TableItem(foldertable, 0);
                item1.setText(s);
                item1.setData(map.get(s));
                ++count;
            }
        }
    }

    private void showErrorMessage() {
        MessageBox msg = new MessageBox(this.getShell(), 34);
        msg.setText("Server unreachable");
        msg.setMessage("Cannot connect to Backup Server. Please check network connection and try again. For more details, contact administrator.");
        msg.open();
    }

    protected void createTempFile(File oldTempFile) throws IOException, InterruptedException {
        if (!oldTempFile.getParentFile().exists()) {
            oldTempFile.getParentFile().mkdirs();
        }
        if (oldTempFile.exists()) {
            oldTempFile.delete();
        }
        oldTempFile.createNewFile();
        oldTempFile.deleteOnExit();
    }

    public void startRestoreBackup() {
        if (this.restoreTimer == null) {
            this.restoreTimer = new Timer();
        }
        if (this.restoreTimerTask == null) {
            this.restoreTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        RestoreBackup.this.updateRestoreDisplay();
                    }
                    catch (Exception e) {
                        RestoreBackup.this.logger.error("Error in updateRestoreDisplay", e);
                    }
                }
            };
            this.restoreTimer.schedule(this.restoreTimerTask, 1000L, 1000L);
        }
    }

    protected void updateRestoreDisplay() {
        if (this.getDisplay() == null) {
            return;
        }
        Runnable runnable = () -> {
            if (this.restoreButton == null || this.restoreButton.isDisposed()) {
                return;
            }
            try {
                if (NotificationHelper.isRestoreStarted()) {
                    String fileBeingRestored;
                    this.restoreButton.setEnabled(false);
                    this.closeButton.setEnabled(false);
                    this.restoreStatus.setText("Restoration in progress");
                    this.restoreStatus.setFont(this.fontsManager.getSmallNormalFont());
                    this.restoreFolderGroup.setEnabled(false);
                    this.restoreGroup.setEnabled(false);
                    this.checkBox.setEnabled(false);
                    if (!StringUtils.isEmpty((String)this.restoreElement.getFileBeingRestored())) {
                        NotificationHelper.setFileBeingRestored((String)this.restoreElement.getFileBeingRestored());
                    }
                    if ((fileBeingRestored = this.restoreElement.getFileBeingRestored()) != null && NotificationHelper.isShowFileBeingRestored()) {
                        this.currentFileBeingRestoredLabel.setVisible(true);
                        this.currentRestoreStatusLabel.setVisible(true);
                        this.currentFileBeingRestoredLabel.setFont(this.fontsManager.getMediumNormalFont());
                        this.currentFileBeingRestoredLabel.setToolTipText(NotificationHelper.getFileBeingRestored());
                        this.currentRestoreStatusLabel.setFont(this.fontsManager.getMediumNormalFont());
                        String filesCount = this.restoreElement.getRestoreCount();
                        this.currentRestoreStatusLabel.setToolTipText("Restore in Progress. " + filesCount + "files ");
                        this.currentRestoreStatusLabel.setText("Restore in Progress. " + filesCount + "files ");
                        if (fileBeingRestored.length() > this.lengthForFileName) {
                            fileBeingRestored = new StringBuffer().append(fileBeingRestored.substring(0, this.lengthForFileName)).append("...").toString();
                        }
                        this.currentFileBeingRestoredLabel.setText("File being restored: " + fileBeingRestored);
                    }
                } else {
                    this.closeButton.setEnabled(true);
                    this.checkBox.setEnabled(true);
                    if (NotificationHelper.successfulRestore != 3) {
                        this.restoreButton.setEnabled(true);
                    }
                    this.currentFileBeingRestoredLabel.setVisible(false);
                    this.currentRestoreStatusLabel.setVisible(false);
                    this.currentRestoreStatusLabel.setText("");
                    if (NotificationHelper.restoreFinished) {
                        this.restoreFolderGroup.setEnabled(true);
                        this.restoreGroup.setEnabled(true);
                        this.checkBox.setEnabled(true);
                        if (NotificationHelper.successfulRestore == 1) {
                            this.restoreStatus.setText("Restored successfully");
                        } else if (NotificationHelper.successfulRestore == 2) {
                            this.restoreStatus.setText("You do not have any files to be restored.");
                        } else if (NotificationHelper.successfulRestore == 0) {
                            this.restoreStatus.setText("Restore failed with one or multiple files");
                        } else if (NotificationHelper.successfulRestore == 5) {
                            this.restoreStatus.setText("Error during restore.Token expired");
                        }
                    } else {
                        if (NotificationHelper.successfulRestore == 3) {
                            this.restoreGroup.setEnabled(false);
                            this.restoreFolderGroup.setEnabled(false);
                            this.queryGroup.setEnabled(false);
                            this.checkBox.setEnabled(false);
                            if (this.restoreLoadingStatus) {
                                this.restoreStatus.setText("Loading information..");
                            } else {
                                this.restoreStatus.setText("Loading information...");
                            }
                            this.restoreLoadingStatus = !this.restoreLoadingStatus;
                        } else {
                            this.restoreGroup.setEnabled(true);
                            this.restoreFolderGroup.setEnabled(true);
                            this.queryGroup.setEnabled(true);
                            this.checkBox.setEnabled(true);
                            this.restoreStatus.setText("Click Restore to start restoration");
                            this.restoreStatus.setFont(this.fontsManager.getSmallNormalFont());
                        }
                        if (NotificationHelper.successfulRestore == 4) {
                            this.restoreStatus.setText("Select Device/Folder to restore");
                            this.restoreStatus.setFont(this.fontsManager.getSmallNormalFont());
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("error in restoreStatus toggle", e);
            }
        };
        this.getDisplay().asyncExec(runnable);
    }

    protected void checkSubclass() {
    }

    public void validatePreviousBatchStatus(RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl) {
        RestoreActivityTO activityTO = restoreActivityHistoryDAOImpl.getCurrentStatusFromRestoreActivityHistoryTable();
        if (activityTO != null && activityTO.getRestoreBatchStatus().equals(BackupLifeCycle.STARTED.toString())) {
            this.logger.debug("User exit the app or network connection failed. so failed status to be sent");
            activityTO.setRestoreBatchStatus(BackupLifeCycle.FAILED.toString());
            String currentBatchId = activityTO.getRestoreBatchId();
            this.logger.debug("Batchid is" + currentBatchId);
            restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(activityTO);
            this.restoreBatchInitiated(activityTO.getRestoreBatchStatus(), currentBatchId, "0/0");
        }
    }

    public String restoreBatchInitiated(String batchStatus, String batchId, String restoreCount) {
        String restoreBatchId;
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        String jobType = "RESTORE";
        try {
            restoreBatchId = this.backupAdapter.sendEmailNotification(batchStatus, SettingHelper.getCurrentCloudIpAddress(), SettingHelper.readTokenFromFile(), batchId, jobType, SettingHelper.getDeviceName(), this.restoredCount, 909, SettingHelper.getDeviceUUId(), 0L, restoreCount, 0, "0");
        }
        catch (Exception e) {
            restoreBatchId = "-1";
            this.logger.trace("" + e);
            this.logger.debug(" Exception inside send email notification  " + e.getMessage());
        }
        return restoreBatchId;
    }

    private void showErrorMessageForDeviceListEmpty() {
        MessageBox msg = new MessageBox(this.getShell(), 34);
        msg.setText("Device List is Empty");
        msg.setMessage("There is no device backedup for the user " + SettingHelper.getUserName());
        msg.open();
    }
}

