/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.settings;

import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.to.BluVaultTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluVaultIPHelper {
    private static final Logger logger = LoggerFactory.getLogger(BluVaultIPHelper.class);

    public String getNearestBluVaultByResponseTime() {
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List<BluVaultTO> ebmsList = this.getBluVaultList();
        List<BluVaultTO> ebmsListFromPolicy = backupPolicyDAOImpl.getBluVaultList();
        ArrayList<String> ebmsNameList = new ArrayList<String>();
        for (BluVaultTO ebms : ebmsList) {
            ebmsNameList.add(ebms.getBluVaultName());
        }
        if (ebmsListFromPolicy != null && !ebmsListFromPolicy.isEmpty()) {
            logger.debug("Adding bluvault from policy to list");
            for (BluVaultTO bluVaultTO : ebmsListFromPolicy) {
                if (ebmsNameList.contains(bluVaultTO.getBluVaultName())) continue;
                ebmsList.add(bluVaultTO);
            }
        }
        ArrayList<BluVaultTO> removeBluVaultList = new ArrayList<BluVaultTO>();
        ArrayList<Long> minimumTime = new ArrayList<Long>();
        if (ebmsList != null && !ebmsList.isEmpty()) {
            for (BluVaultTO bluVaultTO : ebmsList) {
                int response;
                logger.debug("BluVault is:" + bluVaultTO.getBluVaultName());
                long beforeTime = System.currentTimeMillis();
                try {
                    BackupAdapter backUpAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
                    response = backUpAdapter.pingParacloud(bluVaultTO.getBluVaultName());
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error("Error in get bluVault IP" + e.getMessage());
                    removeBluVaultList.add(bluVaultTO);
                    continue;
                }
                if (response == 400) {
                    long totalHitTime = System.currentTimeMillis() - beforeTime;
                    bluVaultTO.setHitTime(totalHitTime);
                    minimumTime.add(totalHitTime);
                    continue;
                }
                logger.error("Error in ping bluvault IP ");
                removeBluVaultList.add(bluVaultTO);
            }
            for (BluVaultTO bluVaultTO : removeBluVaultList) {
                ebmsList.remove(bluVaultTO);
            }
            logger.debug("BluVault list size after ping:" + ebmsList.size());
            Collections.sort(minimumTime);
            Random r = new Random();
            int random = r.nextInt(1000);
            if (!ebmsList.isEmpty()) {
                random %= ebmsList.size();
            }
            for (int i = 0; i < ebmsList.size(); ++i) {
                if (ebmsList.get(random).getHitTime() == ((Long)minimumTime.get(0)).longValue()) {
                    logger.debug("Minimum time for bluvault is:" + ebmsList.get(random).getHitTime() + " bluvault name is:" + ebmsList.get(random).getBluVaultName() + " random no:" + random);
                    return ebmsList.get(random).getBluVaultName();
                }
                random = (random + 1) % ebmsList.size();
            }
        }
        return PropertyHelper.MAIN_EBMS_DOMAIN;
    }

    private List<BluVaultTO> getBluVaultList() {
        ArrayList<BluVaultTO> ebmstos = new ArrayList<BluVaultTO>();
        ArrayList<String> bluVaultIPs = new ArrayList<String>();
        bluVaultIPs.add(PropertyHelper.MAIN_EBMS_DOMAIN);
        if (!StringUtils.isEmpty((String)PropertyHelper.SUB_EBMS_DOMAIN)) {
            bluVaultIPs.add(PropertyHelper.SUB_EBMS_DOMAIN);
        }
        if (!StringUtils.isEmpty((String)PropertyHelper.SUB_EBMS_DOMAIN_1)) {
            bluVaultIPs.add(PropertyHelper.SUB_EBMS_DOMAIN_1);
        }
        for (String bluVault : bluVaultIPs) {
            BluVaultTO bluVaultTO = new BluVaultTO();
            bluVaultTO.setBluVaultName(bluVault);
            ebmstos.add(bluVaultTO);
        }
        return ebmstos;
    }
}

