/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.runnables;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.RateLimiter;
import com.parablu.epa.common.service.backup.MultipartUploadCallable;
import com.parablu.epa.common.service.backup.interfaces.CleanupInterface;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.helper.about.SystemInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(DelegateRunnable.class);
    private BlockingQueue<BackupTO> chunkFileQueue;
    private ExecutorService multiPartUploadService;
    private String uploadIPForGateway;
    private BackupPolicyTO currentPolicy;
    private AtomicInteger uploadCount;
    private String batchIdForBackup;
    private BlockingQueue<Future<BackupTO>> finishedBatchesQueue;
    private AtomicInteger noOfBatches;
    private AtomicBoolean loopFinished;
    private CleanupInterface cleanupInterface;
    private String requestURL;
    private RateLimiter rateLimiter;
    private int threadPriority = 5;
    private MultipartUploadCallable multipartUploadCallable;

    public DelegateRunnable(BlockingQueue<BackupTO> chunkFileQueue, ExecutorService multiPartUploadService, String uploadIPForGateway, BackupPolicyTO currentPolicy, AtomicInteger uploadCount, String batchIdForBackup, BlockingQueue<Future<BackupTO>> finishedBatchesQueue, AtomicInteger noOfBatches, AtomicBoolean loopFinished, CleanupInterface cleanupInterface, String requestURL, RateLimiter rateLimiter) {
        this.chunkFileQueue = chunkFileQueue;
        this.multiPartUploadService = multiPartUploadService;
        this.uploadIPForGateway = uploadIPForGateway;
        this.currentPolicy = currentPolicy;
        this.uploadCount = uploadCount;
        this.batchIdForBackup = batchIdForBackup;
        this.finishedBatchesQueue = finishedBatchesQueue;
        this.noOfBatches = noOfBatches;
        this.loopFinished = loopFinished;
        this.cleanupInterface = cleanupInterface;
        this.requestURL = requestURL;
        this.rateLimiter = rateLimiter;
    }

    @Override
    public void run() {
        int retries = 3;
        while (retries >= 0) {
            ArrayList<BackupTO> backupTOs = new ArrayList<BackupTO>(50);
            try {
                Queues.drain(this.chunkFileQueue, backupTOs, (int)50, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                this.logger.debug("BACKUPTO  BATCH START SIZE > :" + backupTOs.size());
                if (!backupTOs.isEmpty()) {
                    retries = 10;
                    if (this.isCpuThrottleReached() && !backupTOs.isEmpty()) {
                        this.logger.debug("FIRST TIME SO LOWER THE THREAD DONT STOP BACKUP");
                    } else {
                        this.logger.debug("CPU THROTTLE IS NOT REACHED");
                    }
                    this.multipartUploadCallable = new MultipartUploadCallable(backupTOs, this.uploadIPForGateway, this.batchIdForBackup, this.uploadCount, this.currentPolicy, this.cleanupInterface, this.requestURL, this.rateLimiter, this.threadPriority);
                    Future<BackupTO> result = this.multiPartUploadService.submit(this.multipartUploadCallable);
                    this.finishedBatchesQueue.put(result);
                    this.noOfBatches.incrementAndGet();
                    continue;
                }
                if (!this.loopFinished.get()) continue;
                --retries;
            }
            catch (InterruptedException e) {
                this.logger.debug("Exception occured: " + e.getMessage());
                if (this.multipartUploadCallable == null) break;
                this.logger.debug("MULTIPARTUPLOADCALLABLE IS NOT NULL");
                try {
                    this.logger.debug("THREAD INTERRUPTED CANCELLING THE PROCESS");
                    this.finishedBatchesQueue.take().cancel(true);
                }
                catch (InterruptedException e1) {
                    this.logger.trace("" + e1);
                    this.logger.error("Interrupted Exception" + e1.getMessage());
                }
                this.multipartUploadCallable.cancelUpload();
                break;
            }
        }
        try {
            this.finishedBatchesQueue.put((Future<BackupTO>)Futures.immediateFuture(null));
        }
        catch (InterruptedException e) {
            this.logger.trace("" + e);
            this.logger.error("Interrupted Exception" + e.getMessage());
        }
    }

    private void setThreadPriority() {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        Iterator<Thread> i = threadSet.iterator();
        try {
            while (i.hasNext()) {
                String threadName = i.next().getName().toLowerCase();
                if (i.next() == null) continue;
                Thread thread = i.next();
                if (!threadName.startsWith("multipart")) continue;
                this.logger.debug("THREAD FOUND > " + threadName);
                if (thread.getPriority() == 1) continue;
                thread.setPriority(1);
                this.logger.debug("FOUND THREAD PRIORITY > " + thread.getPriority());
            }
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("error in setting the thread priority" + e.getMessage());
        }
    }

    private boolean isCpuThrottleReached() {
        boolean isReached = false;
        try {
            SystemInfo info = new SystemInfo();
            double percentage = info.getCPUIdlePerc();
            this.logger.debug("CURRENT POLICY CPU UTILIZATION : " + this.currentPolicy.getCpuUtilization());
            double cpuUsedPerc = 100.0 - percentage;
            this.logger.debug("CPU USED PERCENTAGE IS : " + cpuUsedPerc);
            if ((double)this.currentPolicy.getCpuUtilization() >= cpuUsedPerc) {
                return isReached;
            }
            isReached = true;
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("EXCEPTION IN ISCPUTHROTTLEREACHED : " + e.getMessage());
        }
        return isReached;
    }
}

