/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.parablu.epa.common.constants.BackupLifeCycle;
import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackUpImageDAOImpl;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.BackupCrawlDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.dao.BackupStatisticsDAOImpl;
import com.parablu.epa.common.dao.NewBackUpCrawlDAOImpl;
import com.parablu.epa.common.dao.NewBackupImageDAOImpl;
import com.parablu.epa.common.service.backup.FilesBeSkippedAsPerPolicy;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.CrawlLifecycle;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.BackupElement;
import com.parablu.epa.core.element.BackupListResponseElement;
import com.parablu.epa.core.element.BackupStatusElement;
import com.parablu.epa.core.element.BackupValidationElement;
import com.parablu.epa.core.element.FileElement;
import com.parablu.epa.core.element.FileListElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.helper.enumeration.BackupFoldersToBeSkipped;
import com.parablu.epa.core.service.sync.BaseJob;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.service.transformer.Xmlparser;
import com.parablu.epa.core.to.BackUpCrawlFileTO;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.BackupResultTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.ContainerDetailsTo;
import com.parablu.epa.core.to.DedupTO;
import com.parablu.epa.core.to.GzipTO;
import com.parablu.epa.helper.exceptions.BaseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NewBackUpJob
extends BaseJob {
    private Logger logger = LoggerFactory.getLogger(NewBackUpJob.class);
    private BackUpFolderDAOImpl backUpFolderDAOImpl = null;
    private BackUpImageDAOImpl backUpImageDAOImpl = null;
    private BackupAdapter backupAdapter = null;
    boolean isFirstTimeCrawl = true;
    protected String currentIP = SettingHelper.getCurrentCloudIpAddress();
    boolean manual = false;
    protected Integer currentPort = null;
    Set<File> crawledFileList = new HashSet<File>();
    private Set<File> backupImageList = new HashSet<File>();
    private final int crawlFileLimit = this.getCrawlLimit();
    private static final int CRAWL_LIMIT_FOR_DB_INSERT = 5000;
    private int noOfDBWritesForCrawlFileLimit = 0;
    Set<DedupTO> dedupToSet = new HashSet<DedupTO>();
    private String backupType = "INCREMENTAL";
    BackupCrawlDAOImpl backupCrawlDAOImpl = new BackupCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
    BackupStatisticsDAOImpl backupStatisticsDAOImpl = new BackupStatisticsDAOImpl(SettingHelper.getBackUpDbUrl());
    NewBackUpCrawlDAOImpl newBackUpCrawlDAOImpl = new NewBackUpCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
    NewBackupImageDAOImpl newBackupImageDAOImpl = new NewBackupImageDAOImpl(SettingHelper.getBackUpDbUrl());
    BackupStatusElement backupStatusElement = null;
    protected String crawlTimeStamp;
    boolean restart = false;
    long restartId = 0L;
    public static long backupSizeOnDisk = 0L;
    private static List<BackupFolderTO> bkpFolderList = new ArrayList<BackupFolderTO>();
    String serverBackupStatusId = null;
    private static final String RUNNING = "RUNNING";
    private static final String POSTBACKUPF = "postBackupF";
    private static final String BEFORE_CALLING_DELETE = "Before calling delete";
    private static final String COMPLETED = "COMPLETED";
    private static final String BACKUP = "BACKUP";
    private static final String FAILED = "FAILED";

    public NewBackUpJob(boolean manualVal) {
        this.backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
        this.backUpImageDAOImpl = new BackUpImageDAOImpl(SettingHelper.getBackUpDbUrl());
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        this.manual = manualVal;
    }

    public abstract void updateSystrayImageAccordingToStage(String var1);

    protected abstract void scanFileSystemByType(BackupFolderTO var1);

    public void run() {
        block55: {
            BackupActivityTO backupActivityTO = new BackupActivityTO();
            BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
            try {
                String totalSize;
                int crawlFileCount;
                if (NotificationHelper.backUpStarted) {
                    this.logger.debug("backUpStarted:" + NotificationHelper.backUpStarted);
                    return;
                }
                NotificationHelper.backUpStarted = true;
                NotificationHelper.setTotalBackupCount(0);
                NotificationHelper.setNoOfFilesToBeBackedUp(0);
                this.createTablesIfNotExist();
                this.validatePreviousBackupStatus();
                this.logger.debug("Device Blocked: " + SettingHelper.isDeviceBlocked());
                this.logger.debug("After validating previous backup.");
                long lastSuccessfullCrawlTime = this.backupStatusElement.getLastSuccessfulCrawlTimeStamp();
                if (lastSuccessfullCrawlTime == 0L) {
                    this.backupType = "FULL";
                }
                if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                    this.restart = false;
                }
                if (!this.restart) {
                    this.logger.debug("Inside restart False.");
                    ArrayList<BackupFolderTO> listOfFolder = new ArrayList();
                    List<BackupFolderTO> listOfAllFolder = this.backUpFolderDAOImpl.getAllFolderToBackUpFiles();
                    BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
                    BackupFolderTO backUpFolderTo = new BackupFolderTO();
                    if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                        this.sendServerBackupStatus();
                        List<ContainerDetailsTo> containerDetailsTos = backupPolicyDAOImpl.getCurrentContainerDetails(NotificationHelper.getCurrentContainerName(), true);
                        if (containerDetailsTos != null && "flatfiles".equalsIgnoreCase(containerDetailsTos.iterator().next().getContainerType())) {
                            NotificationHelper.setCurrentContainerType(containerDetailsTos.iterator().next().getContainerType());
                            backUpFolderTo.setFolderPath(containerDetailsTos.iterator().next().getContainerLocation());
                            backUpFolderTo.setPolicyName(containerDetailsTos.iterator().next().getPolicyname());
                            for (BackupFolderTO backupFolder : listOfAllFolder) {
                                if (!NotificationHelper.getCurrentPolicyName().equals(backupFolder.getPolicyName())) continue;
                                this.logger.debug("policy matched..... true ");
                                backUpFolderTo.setCreateBy(backupFolder.getCreateBy());
                                backUpFolderTo.setLastSyncTime(backupFolder.getLastSyncTime());
                                backUpFolderTo.setId(backupFolder.getId());
                                break;
                            }
                            listOfFolder.add(backUpFolderTo);
                        } else {
                            if (containerDetailsTos != null) {
                                NotificationHelper.setCurrentContainerType(containerDetailsTos.iterator().next().getContainerType());
                            }
                            for (BackupFolderTO backupFolderTO : listOfAllFolder) {
                                this.logger.debug("bkpto polname : " + backupFolderTO.getPolicyName());
                                this.logger.debug("pol name Nooti : " + NotificationHelper.getCurrentPolicyName());
                                if (!backupFolderTO.getPolicyName().equals(NotificationHelper.getCurrentPolicyName())) continue;
                                listOfFolder.add(backupFolderTO);
                            }
                        }
                        if (!(PolicyManagementServerHelper.getsServerBackupDeviceDetails().isBlocked() || this.runScripts("preBackup", this.manual) || containerDetailsTos == null || "flatfiles".equalsIgnoreCase(containerDetailsTos.iterator().next().getContainerType()))) {
                            this.logger.debug("Script failed to run hence terminating");
                            PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, FAILED, "pid", String.valueOf(backupSizeOnDisk), 4, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, "0");
                            NotificationHelper.setCurrentContainerJobId("0");
                            NotificationHelper.backUpStarted = false;
                            this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
                            this.runScripts(POSTBACKUPF, this.manual);
                            return;
                        }
                    } else {
                        listOfFolder = listOfAllFolder;
                    }
                    bkpFolderList = listOfFolder;
                    this.logger.debug("os " + SettingHelper.getOsName().toLowerCase());
                    this.logger.debug("VSS ENABLED " + SettingHelper.getIsVssEnabled());
                    if (SettingHelper.getOsName().toLowerCase().contains("win") && SettingHelper.getIsVssEnabled() != null && "true".equalsIgnoreCase(SettingHelper.getIsVssEnabled())) {
                        this.logger.debug(BEFORE_CALLING_DELETE);
                        this.deleteVsnapshot(listOfFolder);
                        this.logger.debug("Before calling create after delete");
                        this.createVsnapshot(listOfFolder);
                        this.logger.debug("After creating snapshot");
                    }
                    HashSet<BackupTO> backUpSet = new HashSet<BackupTO>();
                    HashSet<BackupTO> deletedSet = new HashSet<BackupTO>();
                    this.validatePreviousBackupCrawlStatus();
                    backupActivityTO.setBackupActivityStatus(CrawlLifecycle.SCANNING.toString());
                    backupActivityTO.setBackupActivityTimeStamp(String.valueOf(System.currentTimeMillis()));
                    backupActivityTO.setBatchId("-1");
                    backupActivityTO.setBackupActivityID(backupActivityHistoryDAOImpl.addEventToBackupActivityHistoryTable(backupActivityTO));
                    this.scanFileSystem(listOfFolder, lastSuccessfullCrawlTime);
                    if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                        PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, RUNNING, "pid", String.valueOf(backupSizeOnDisk), 2, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, "0");
                        this.logger.debug("==================================2-==========================bkpze " + backupSizeOnDisk);
                    }
                    this.updateCrawlTableAndGetDeletedFiles(deletedSet);
                    this.checkIfPathExists(listOfFolder);
                    crawlFileCount = this.newBackUpCrawlDAOImpl.getCountOfTable(false);
                    this.logger.debug("count from crawl table is:" + crawlFileCount);
                    if (lastSuccessfullCrawlTime != 0L) {
                        List<BackupTO> backUpList = this.newBackUpCrawlDAOImpl.readAllEntriesFromBackupImageTable();
                        if (!deletedSet.isEmpty() || !backUpList.isEmpty()) {
                            backUpSet.addAll(backUpList);
                            this.chunkBackupFilesAndCallForUpload(backUpSet, deletedSet);
                        }
                    }
                    totalSize = String.valueOf(crawlFileCount);
                    if (crawlFileCount == 0) {
                        this.logger.debug("Backup List is zero");
                        backupActivityTO.setBackupActivityStatus(CrawlLifecycle.FINISHED.toString());
                        backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                        if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                            PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, COMPLETED, "pid", String.valueOf(backupSizeOnDisk), 4, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, Long.toString(System.currentTimeMillis()));
                            this.runScripts(POSTBACKUPF, this.manual);
                            NotificationHelper.setCurrentContainerJobId("0");
                        }
                        if (SettingHelper.getOsName().toLowerCase().contains("win") && SettingHelper.getIsVssEnabled() != null && "true".equalsIgnoreCase(SettingHelper.getIsVssEnabled())) {
                            this.logger.debug(BEFORE_CALLING_DELETE);
                            this.deleteVsnapshot(bkpFolderList);
                        }
                        NotificationHelper.backUpStarted = false;
                        this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
                        return;
                    }
                    NotificationHelper.setNoOfFilesToBeBackedUp(crawlFileCount);
                    this.logger.debug("BACKUPLIST SIZE :" + totalSize);
                } else {
                    this.validatePreviousRestartId();
                    if (this.restartId == 0L) {
                        this.restartId = this.newBackUpCrawlDAOImpl.getIdForRestart();
                        this.logger.debug("INSIDE RESTART ID IS 0 SO GET IT FROM TABLE " + this.restartId);
                    }
                    if (this.restartId == 1L) {
                        crawlFileCount = this.newBackUpCrawlDAOImpl.getCountOfTable(false);
                        this.restartId = 0L;
                    } else {
                        crawlFileCount = this.newBackUpCrawlDAOImpl.getCountOfTableForGivenId((int)this.restartId);
                    }
                    this.logger.debug("CRAWL COUNT : " + crawlFileCount);
                    NotificationHelper.setNoOfFilesToBeBackedUp(crawlFileCount);
                    totalSize = String.valueOf(crawlFileCount);
                    List<DedupTO> dedupTOs = this.newBackupImageDAOImpl.getListOfDedupsFromTable();
                    if (dedupTOs != null) {
                        this.dedupToSet.addAll(dedupTOs);
                    }
                    if (crawlFileCount == 0) {
                        this.logger.debug("BACKUP LIST IS ZERO");
                        backupActivityTO.setBackupActivityStatus(CrawlLifecycle.FINISHED.toString());
                        backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                        BackupActivityTO backupActivityTO1 = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
                        this.backupBatchInitiated(COMPLETED, this.backupStatusElement.getBatchId(), 0, backupActivityTO1.getFailCode(), backupActivityTO1.getTotalUploadSize(), backupActivityTO1.getBackupUploadCount(), crawlFileCount, backupActivityTO1.getBackupActivityTimeStamp());
                        if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                            PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, COMPLETED, "pid", String.valueOf(backupSizeOnDisk), 4, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, Long.toString(System.currentTimeMillis()));
                            this.runScripts(POSTBACKUPF, this.manual);
                            NotificationHelper.setCurrentContainerJobId("0");
                        }
                        if (SettingHelper.getOsName().toLowerCase().contains("win") && SettingHelper.getIsVssEnabled() != null && "true".equalsIgnoreCase(SettingHelper.getIsVssEnabled())) {
                            this.logger.debug(BEFORE_CALLING_DELETE);
                            this.deleteVsnapshot(bkpFolderList);
                        }
                        NotificationHelper.backUpStarted = false;
                        this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
                        return;
                    }
                    backupActivityTO.setBackupActivityStatus(CrawlLifecycle.SCANNING.toString());
                    backupActivityTO.setBackupActivityTimeStamp(String.valueOf(System.currentTimeMillis()));
                    backupActivityTO.setBatchId("-1");
                    backupActivityTO.setBackupActivityID(backupActivityHistoryDAOImpl.addEventToBackupActivityHistoryTable(backupActivityTO));
                    backupActivityTO.setRestartID(this.restartId);
                    backupActivityHistoryDAOImpl.updateRestartIdINBackupActivityHistoryTable(backupActivityTO);
                }
                String status = BackupLifeCycle.STARTED.toString();
                backupActivityTO.setBatchStatus(status);
                String batchId = this.backupBatchInitiated(status, "", 0, backupActivityTO.getFailCode(), 0L, "0/" + totalSize, crawlFileCount, this.crawlTimeStamp);
                if ("".equals(batchId) || "-1".equals(batchId)) {
                    backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
                    backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                    this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_NOINTERNET_ICON);
                    NotificationHelper.setBackupStatus(0);
                    if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                        PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, "ABORTED", "pid", String.valueOf(backupSizeOnDisk), 4, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, Long.toString(System.currentTimeMillis()));
                    }
                    this.runScripts(POSTBACKUPF, this.manual);
                    NotificationHelper.setCurrentContainerJobId("0");
                    NotificationHelper.backUpStarted = false;
                    return;
                }
                this.logger.debug("batch id for this backup is:" + batchId + "status:" + status);
                backupActivityTO.setBatchId(batchId);
                this.validatePreviousBackupActivity(backupActivityHistoryDAOImpl);
                backupActivityTO.setBackupActivityStatus(CrawlLifecycle.INPROGRESS.toString());
                backupActivityTO.setBackupActivityTimeStamp(this.crawlTimeStamp);
                backupActivityTO.setBackupUploadCount("0/" + totalSize);
                backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                this.logger.debug("BEFORE STARTING BACKUP THREAD");
                if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                    PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, RUNNING, backupActivityTO.getBatchId(), String.valueOf(backupSizeOnDisk), 3, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, "0");
                }
                this.startBackUpThread(this.dedupToSet, this.restart, this.restartId, this.backupType);
                this.dedupToSet = null;
                this.logger.debug("BACKUP FINISHED");
                SettingHelper.setLastSuccessfulBackup(System.currentTimeMillis());
                if (String.valueOf(NotificationHelper.getTotalBackupCount()).equals(totalSize)) {
                    backupActivityTO.setBackupActivityStatus(CrawlLifecycle.FINISHED.toString());
                } else {
                    backupActivityTO.setBackupActivityStatus(CrawlLifecycle.STOPPED.toString());
                }
                backupActivityTO.setBackupUploadCount(NotificationHelper.getTotalBackupCount() + "/" + totalSize);
                backupActivityTO.setTotalUploadSize(NotificationHelper.getTotalUploadSize());
                backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                int totalFilesUploaded = NotificationHelper.getTotalBackupCount();
                this.logger.debug("TOTAL FILES UPLOADED " + totalFilesUploaded);
                this.logger.debug("TOTAL SIZE " + totalSize);
                if (String.valueOf(totalFilesUploaded).equals(totalSize)) {
                    status = BackupLifeCycle.COMPLETED.toString();
                    backupActivityTO.setBatchStatus(status);
                    backupActivityTO.setFailCode(0);
                    long totalUploadSize = backupActivityTO.getTotalUploadSize();
                    String uploadedList = backupActivityTO.getBackupUploadCount();
                    int errorCode = backupActivityTO.getFailCode();
                    batchId = this.backupBatchInitiated(status, batchId, NotificationHelper.getTotalBackupCount(), errorCode, totalUploadSize, uploadedList, crawlFileCount, backupActivityTO.getBackupActivityTimeStamp());
                    if (!"-1".equals(batchId)) {
                        this.logger.debug("BATCH ID FOR THIS BACKUP IS : " + batchId + "STATUS : " + status);
                        backupActivityTO.setBatchId(batchId);
                        backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                        if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                            this.logger.debug("is full backup ::: " + NotificationHelper.getServerBackupType());
                            PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, COMPLETED, "pid", String.valueOf(backupSizeOnDisk), 4, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, Long.toString(System.currentTimeMillis()));
                            this.logger.debug("============================4=============================");
                            NotificationHelper.setCurrentContainerJobId("0");
                            if (NotificationHelper.getServerBackupType().contains("F")) {
                                new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl()).updateFullBackupTimestamp(backupActivityTO.getBackupActivityTimeStamp(), NotificationHelper.getCurrentContainerName());
                            }
                        }
                        if (SettingHelper.getOsName().toLowerCase().contains("win") && SettingHelper.getIsVssEnabled() != null && "true".equalsIgnoreCase(SettingHelper.getIsVssEnabled())) {
                            this.logger.debug(BEFORE_CALLING_DELETE);
                            this.deleteVsnapshot(bkpFolderList);
                        }
                    }
                } else {
                    BackupActivityTO backupActivityTO1 = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
                    if (backupActivityTO1.getFailCode() != 912 && backupActivityTO1.getFailCode() != 1992 && backupActivityTO1.getFailCode() != 1981 && backupActivityTO1.getFailCode() != 1996) {
                        int response = this.backupAdapter.pingParacloud(this.currentIP);
                        if (response == 400) {
                            if (backupActivityTO1.getFailCode() == 2304) {
                                PolicyManagementServerHelper.updateFailCodeToActivityHistory(2304);
                                PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit(BackupLifeCycle.FAILED.toString());
                            } else {
                                PolicyManagementServerHelper.updateFailCodeToActivityHistory(909);
                                PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit(BackupLifeCycle.FAILED.toString());
                            }
                        }
                    } else if (backupActivityTO1.getFailCode() == 1992 || backupActivityTO1.getFailCode() == 1981 || backupActivityTO1.getFailCode() == 1996) {
                        PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit(BackupLifeCycle.FAILED.toString());
                    }
                    if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                        this.logger.debug("is full backup ::: " + NotificationHelper.getServerBackupType());
                        PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, FAILED, "pid", String.valueOf(backupSizeOnDisk), 4, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, Long.toString(System.currentTimeMillis()));
                        NotificationHelper.setCurrentContainerJobId("0");
                    }
                }
                if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                    this.runScripts(POSTBACKUPF, this.manual);
                }
                NotificationHelper.backUpStarted = false;
                this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
                return;
            }
            catch (BaseException baseException) {
                this.logger.error("baseException ", (Throwable)baseException);
                backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
                backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_NOINTERNET_ICON);
                NotificationHelper.setBackupStatus(0);
                if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                    try {
                        PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, "ABORTED", "pid", String.valueOf(backupSizeOnDisk), 4, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, Long.toString(System.currentTimeMillis()));
                        NotificationHelper.setCurrentContainerJobId("0");
                    }
                    catch (Exception e) {
                        this.logger.debug("Could not update Status " + e);
                    }
                }
            }
            catch (RuntimeException e) {
                this.logger.trace("" + e);
                this.logger.error("Exception :", (Object)e.getMessage());
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Unkown Exception :", (Object)e.getMessage());
                backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
                backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_NOINTERNET_ICON);
                NotificationHelper.setBackupStatus(0);
                if (!"true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) break block55;
                try {
                    PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, FAILED, "pid", String.valueOf(backupSizeOnDisk), 4, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, Long.toString(System.currentTimeMillis()));
                    NotificationHelper.setCurrentContainerJobId("0");
                }
                catch (Exception e1) {
                    this.logger.trace("" + e1);
                    this.logger.debug("Could not update Status " + e1.getMessage());
                }
            }
        }
        this.jobSucceded = false;
        NotificationHelper.backUpStarted = false;
    }

    private void sendServerBackupStatus() {
        try {
            this.serverBackupStatusId = PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, RUNNING, "pid", "0", 1, false, SettingHelper.readTokenFromFile(), "", "0");
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("error while send backup status" + e.getMessage());
        }
    }

    private void validatePreviousBackupCrawlStatus() {
        this.logger.debug("Validating previous backup crawl status.");
        BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        BackupActivityTO activityTO = backupActivityHistoryDAOImpl.getScanStatusFromBackupActivityHistoryTable();
        if (activityTO != null && activityTO.getBackupActivityStatus().contentEquals(CrawlLifecycle.SCANNING.toString())) {
            this.logger.debug("INSIDE ROLL BACK PREVIOUS CRAWL");
            this.newBackUpCrawlDAOImpl.deleteEntireTable();
            this.newBackUpCrawlDAOImpl.copyNewToPrevOrPrevToNewBkupCrawlTable("PrevNewBackupCrawlToNewBkupCrawl");
            this.newBackUpCrawlDAOImpl.deleteEntirePrevCrawlTable();
            this.newBackUpCrawlDAOImpl.copyPrevToOldOrOldToPrevBkupCrawlTable("OldBkupToNewPrevBkup");
            this.newBackupImageDAOImpl.clearEntireTable();
            this.newBackupImageDAOImpl.copyNewToPrevOrPrevToNewBackUpImageTable("NewPrevBackupToNewBackupImageTable");
            this.newBackupImageDAOImpl.clearEntirePrevBackupImageTable();
            this.newBackupImageDAOImpl.copyOldToPrevOrPrevToOldBkUpImgTable("OldPrevBKITtoNewPrevBKIT");
            activityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(activityTO);
        }
    }

    private void validatePreviousBackupStatus() {
        this.backupStatusElement = this.getStatusOfBackup();
        this.logger.debug("After validate previous backup status");
        if (this.backupStatusElement != null && this.backupStatusElement.getResponseCode() == 200) {
            if (!"".equals(this.backupStatusElement.getBatchId()) && this.backupStatusElement.getLastSuccessfulCrawlTimeStamp() != 0L) {
                if (!this.backupStatusElement.getStatus().equalsIgnoreCase(BackupLifeCycle.COMPLETED.toString())) {
                    this.crawlTimeStamp = String.valueOf(this.backupStatusElement.getLastSuccessfulCrawlTimeStamp());
                    boolean success = this.getBackupCrawlTableStatus();
                    if (success) {
                        this.restart = true;
                    }
                }
            } else if (!"".equals(this.backupStatusElement.getBatchId()) && this.backupStatusElement.getLastSuccessfulCrawlTimeStamp() == 0L) {
                this.logger.debug("inside crawl time stamp 0 so take it from local activity");
                BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
                BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
                if (backupActivityTO != null) {
                    this.backupStatusElement.setLastSuccessfulCrawlTimeStamp(Long.valueOf(backupActivityTO.getBackupActivityTimeStamp()).longValue());
                    this.logger.debug("local activity activity timestamp..." + this.backupStatusElement.getLastSuccessfulCrawlTimeStamp());
                    this.createPrevBKITFromOldBkpImage();
                    this.logger.debug("After creating the prev bkit with old table");
                    this.restart = false;
                }
            } else {
                this.backupStatusElement.setLastSuccessfulCrawlTimeStamp(0L);
                this.restart = false;
            }
        } else {
            throw new CrawlAdapterException("Get backup status failed");
        }
    }

    private void createPrevBKITFromOldBkpImage() {
        List<BackupTO> backUpFileTOs = this.backUpImageDAOImpl.readAllEntriesFromBackupImageTable();
        if (backUpFileTOs != null) {
            this.newBackupImageDAOImpl.insertListOfBackupTOsIntoTable(backUpFileTOs);
        }
    }

    private boolean getBackupCrawlTableStatus() {
        int count = this.newBackUpCrawlDAOImpl.getCountOfRemainingFilesForBackup(true);
        return count != 0;
    }

    private void updateCrawlTableAndGetDeletedFiles(Set<BackupTO> deletedSet) {
        List<BackUpCrawlFileTO> deletedFiles;
        if (this.backupStatusElement.getLastSuccessfulCrawlTimeStamp() == 0L) {
            return;
        }
        List<BackUpCrawlFileTO> backupCrawlTOs = this.newBackupImageDAOImpl.getAddedORDeletedFilesByComparing("ADDED");
        List backupTOs = null;
        if (backupCrawlTOs != null) {
            backupTOs = ObjectUtils.createBackupElementForFileNames(backupCrawlTOs);
        }
        if (backupTOs != null) {
            this.newBackUpCrawlDAOImpl.checkFileExistsAndInsertFiles(backupTOs);
        }
        if ((deletedFiles = this.newBackupImageDAOImpl.getAddedORDeletedFilesByComparing("DELETED")) != null) {
            List deletedList = ObjectUtils.createBackupElementForDeletedFiles(deletedFiles);
            deletedSet.addAll(deletedList);
            this.logger.debug("DELETED SET SIZE:" + deletedSet.size());
        }
        ArrayList<BackupTO> failedFromPrevBkupFiles = new ArrayList<BackupTO>();
        List failedFilesFromPrevBkup = new ArrayList();
        if (this.backupStatusElement.getBackupLogElement() != null && this.backupStatusElement.getBackupLogElement().getFailedFiles() != null) {
            failedFilesFromPrevBkup = this.backupStatusElement.getBackupLogElement().getFailedFiles();
        }
        for (FileElement backupElement : failedFilesFromPrevBkup) {
            BackupTO backupTO = new BackupTO();
            ObjectUtils.copyFileElemenToBackupTO((FileElement)backupElement, (BackupTO)backupTO);
            failedFromPrevBkupFiles.add(backupTO);
        }
        if (!failedFromPrevBkupFiles.isEmpty()) {
            this.newBackUpCrawlDAOImpl.checkFileExistsAndInsertFiles(failedFromPrevBkupFiles);
        }
    }

    private BackupStatusElement getStatusOfBackup() {
        BackupStatusElement statusElement = null;
        try {
            statusElement = this.backupAdapter.getBackupStatus(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.readTokenFromFile(), BACKUP, SettingHelper.getDeviceName(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName());
            if (this.isBadRequest(statusElement) || this.isServerDown(statusElement)) {
                statusElement = this.retryBackupStatusUsingUpdatedIp();
            } else {
                if (statusElement.getResponseCode() == 421) {
                    this.sessionExpired = true;
                    throw new CrawlAdapterException("Session Expired");
                }
                if (statusElement.getResponseCode() == 420) {
                    this.deviceBlocked = true;
                    throw new CrawlAdapterException(" User Device Blocked");
                }
            }
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Error in get backup status.", (Object)e.getMessage());
            statusElement = this.retryBackupStatusUsingUpdatedIp();
        }
        return statusElement;
    }

    private boolean isBadRequest(BackupStatusElement statusElement) {
        return statusElement == null || statusElement.getResponseCode() == 404;
    }

    private boolean isServerDown(BackupStatusElement statusElement) {
        return statusElement.getResponseCode() == 400 || statusElement.getResponseCode() == 503 || statusElement.getResponseCode() == 500;
    }

    private BackupStatusElement retryBackupStatusUsingUpdatedIp() {
        boolean retry;
        BackupStatusElement statusElement = null;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 60000L * (long)sleepMultiplier;
        do {
            retry = false;
            try {
                SettingHelper.checkAndUpdateIpAddress();
                statusElement = this.backupAdapter.getBackupStatus(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.readTokenFromFile(), BACKUP, SettingHelper.getDeviceName(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName());
                if (this.isBadRequest(statusElement)) {
                    retry = true;
                    ++retryCount;
                    sleepTime = this.sleepForGivenTime(statusElement, sleepTime);
                } else if (statusElement.getResponseCode() == 200) {
                    return statusElement;
                }
            }
            catch (CrawlAdapterException e) {
                this.logger.trace("" + (Object)((Object)e));
                this.logger.error("Crawl Exception  getting backup status so retry.." + e.getMessage());
                retry = true;
                ++retryCount;
                try {
                    this.logger.debug("SleepTime is" + sleepTime);
                    Thread.sleep(sleepTime);
                    sleepMultiplier = 2;
                    sleepTime *= (long)sleepMultiplier;
                }
                catch (InterruptedException e1) {
                    this.logger.trace("" + e1);
                    this.logger.error("Thread interupted error" + e1.getMessage());
                }
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Error while getting backup status" + e.getMessage());
            }
        } while (retry && retryCount < 4);
        return statusElement;
    }

    private long sleepForGivenTime(BackupStatusElement statusElement, long sleepTime) {
        long sleepTimeTemp = sleepTime;
        try {
            this.logger.debug("SleepTime is" + sleepTimeTemp);
            if (statusElement != null) {
                this.logger.debug("response code:" + statusElement.getResponseCode());
            }
            Thread.sleep(sleepTimeTemp);
            int sleepMultiplier = 2;
            sleepTimeTemp *= (long)sleepMultiplier;
        }
        catch (InterruptedException e1) {
            this.logger.error("Thread interupted error");
        }
        return sleepTimeTemp;
    }

    private void checkIfPathExists(List<BackupFolderTO> listOfFolder) {
        ArrayList<String> listOfNotExistingFolders = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (BackupFolderTO backupFolder : listOfFolder) {
            File file = new File(backupFolder.getFolderPath());
            if (file.exists()) continue;
            listOfNotExistingFolders.add(backupFolder.getFolderPath());
            buffer.append(backupFolder.getFolderPath());
            buffer.append("\n");
        }
        if (!listOfNotExistingFolders.isEmpty()) {
            String toolTipMessage = "Following Folder OR Drive does Not Exists";
            String toolTipmessage1 = buffer.toString();
            this.updateSystrayToolTipNotification(toolTipMessage, toolTipmessage1);
        }
    }

    private void validatePreviousBackupActivity(BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl) {
        BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
        if (backupActivityTO != null && backupActivityTO.getBatchStatus().equals(BackupLifeCycle.STARTED.toString())) {
            backupActivityTO.setBatchStatus(BackupLifeCycle.FAILED.toString());
            String batchId = backupActivityTO.getBatchId();
            int errorCode = backupActivityTO.getFailCode();
            this.logger.debug("the fail code is:" + errorCode);
            long totalUploadSize = backupActivityTO.getTotalUploadSize();
            String uploadedList = backupActivityTO.getBackupUploadCount();
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
            batchId = this.backupBatchInitiated(backupActivityTO.getBatchStatus(), batchId, 0, errorCode, totalUploadSize, uploadedList, 0, backupActivityTO.getBackupActivityTimeStamp());
            if (batchId != null && batchId != "-1") {
                this.logger.debug("batch id for this backup is:" + batchId + "status:failed");
            }
        }
        if (backupActivityTO != null && backupActivityTO.getBackupActivityStatus().equals(CrawlLifecycle.INPROGRESS.toString())) {
            backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
        }
    }

    private void validatePreviousRestartId() {
        if (this.backupStatusElement.getBackupLogElement() != null) {
            this.restartId = this.backupStatusElement.getBackupLogElement().getRestartId();
            this.logger.debug("Restart Id is: " + this.restartId);
        }
    }

    public abstract void startBackUpThread(Set<DedupTO> var1, boolean var2, long var3, String var5) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException;

    public abstract void pauseBackup(boolean var1);

    private void chunkBackupFilesAndCallForUpload(Set<BackupTO> backUpList, Set<BackupTO> deletedSet) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        HashSet<BackupTO> chunkBackupFilesTOSet = new HashSet<BackupTO>();
        HashSet<BackupTO> chunkDeletedFilesTOSet = new HashSet<BackupTO>();
        ArrayList<BackupTO> removeList = new ArrayList<BackupTO>();
        Iterator<BackupTO> iterator = backUpList.iterator();
        while (iterator.hasNext()) {
            chunkBackupFilesTOSet.add(iterator.next());
            if (chunkBackupFilesTOSet.size() != this.crawlFileLimit) continue;
            this.createAndSendRequestAndUpdatedatabase(chunkBackupFilesTOSet, new HashSet<BackupTO>(), removeList);
            chunkBackupFilesTOSet.clear();
        }
        iterator = deletedSet.iterator();
        while (iterator.hasNext()) {
            chunkDeletedFilesTOSet.add(iterator.next());
            if (chunkBackupFilesTOSet.size() != this.crawlFileLimit) continue;
            this.createAndSendRequestAndUpdatedatabase(new HashSet<BackupTO>(), chunkDeletedFilesTOSet, removeList);
            chunkDeletedFilesTOSet.clear();
        }
        this.createAndSendRequestAndUpdatedatabase(chunkBackupFilesTOSet, chunkDeletedFilesTOSet, removeList);
        chunkBackupFilesTOSet.clear();
        this.logger.debug("Final remove list size:" + removeList.size() + "Backuplist size before:" + backUpList.size());
        backUpList.removeAll(removeList);
    }

    private void createAndSendRequestAndUpdatedatabase(Set<BackupTO> backUpList, Set<BackupTO> deletedSet, List<BackupTO> removeList) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        byte[] bs = this.createWebRequest(backUpList, deletedSet);
        if (bs == null) {
            throw new BaseException("gzip byte array is null,serialization failed");
        }
        List<BackupTO> filesNotToUpload = this.sendWebRequest(bs);
        removeList.addAll(filesNotToUpload);
    }

    private byte[] createWebRequest(Set<BackupTO> backUpList, Set<BackupTO> deletedSet) {
        ArrayList<FileElement> newBackupFileElements = new ArrayList<FileElement>();
        ArrayList<FileElement> deletedBackupFileElements = new ArrayList<FileElement>();
        this.convertBackupTOListToBackupElementList(backUpList, newBackupFileElements);
        this.convertBackupTOListToBackupElementList(deletedSet, deletedBackupFileElements);
        FileListElement newBackupFileListElement = new FileListElement();
        FileListElement deletedBackupFileListElement = new FileListElement();
        newBackupFileListElement.setFileElementList(newBackupFileElements);
        deletedBackupFileListElement.setFileElementList(deletedBackupFileElements);
        BackupValidationElement backupValidationElement = new BackupValidationElement();
        backupValidationElement.setFilesToAddList(newBackupFileListElement);
        backupValidationElement.setFilesToDeleteList(deletedBackupFileListElement);
        byte[] bs = CreateXmlObject.createGzipByteArrayForValidateBackUpRequest((BackupValidationElement)backupValidationElement);
        return bs;
    }

    private List<BackupTO> sendWebRequest(byte[] bs) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        GzipTO gzipResponse;
        this.currentIP = SettingHelper.getCurrentCloudIpAddress();
        if (SettingHelper.getCurrentHttpsPort() != null) {
            this.currentPort = Integer.valueOf(SettingHelper.getCurrentHttpsPort());
        }
        if ((gzipResponse = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, null, false, SettingHelper.readTokenFromFile())) == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400 || gzipResponse.getResponseCode() == 503) {
            gzipResponse = this.retryUsingUpdatedIp(bs, gzipResponse);
        }
        if (gzipResponse == null) {
            throw new CrawlAdapterException(" null gzipResponse (connection error)");
        }
        int responseCode = gzipResponse.getResponseCode();
        if (responseCode == 400 || responseCode == 404) {
            throw new CrawlAdapterException(" HTTP_DEVICE_SESSION_EXPIRED or HTTP_BAD_REQUEST or HTTP_NOT_FOUND:" + responseCode);
        }
        if (responseCode == 416) {
            this.licenseExpired = true;
            throw new CrawlAdapterException(" License Expired");
        }
        if (responseCode == 420) {
            this.deviceBlocked = true;
            throw new CrawlAdapterException(" User Device Blocked");
        }
        if (responseCode == 417) {
            throw new CrawlAdapterException("User Limit Reached");
        }
        if (responseCode == 421) {
            this.sessionExpired = true;
            throw new CrawlAdapterException("Session Expired");
        }
        if (responseCode == 401) {
            throw new CrawlAdapterException("Unauthorized");
        }
        if (responseCode != 200) {
            throw new CrawlAdapterException(" Server Error: " + responseCode);
        }
        byte[] responseByte = gzipResponse.getResponse();
        BackupListResponseElement backupListResponseElement = Xmlparser.parseBackupListResponse((byte[])responseByte);
        if (backupListResponseElement == null) {
            throw new CrawlAdapterException(" backupListResponseElement; parsed response null");
        }
        List<DedupTO> dedupTOs = this.getDedupListFromResponse(backupListResponseElement);
        this.logger.debug("Dedup list is: " + dedupTOs.size());
        this.insertDedupIntoTable(dedupTOs);
        this.dedupToSet.addAll(dedupTOs);
        return ObjectUtils.convertFileElementToBackupTO((List)backupListResponseElement.getFilesNotToAddList().getFileElementList(), (String)"0");
    }

    private void insertDedupIntoTable(List<DedupTO> dedupTOs) {
        if (dedupTOs != null && !dedupTOs.isEmpty()) {
            try {
                this.newBackupImageDAOImpl.insertListOfDedupsIntoTable(dedupTOs);
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Error in insert dedup entries" + e.getMessage());
            }
        }
    }

    private List<DedupTO> getDedupListFromResponse(BackupListResponseElement backupListResponseElement) {
        List dedupTOs = ObjectUtils.convertKeyValueElementToDedupTO((List)backupListResponseElement.getFilesNotToAddList().getMd5AndDedupedIdList());
        return dedupTOs;
    }

    private GzipTO retryUsingUpdatedIp(byte[] bs, GzipTO gzipRes) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        SettingHelper.checkAndUpdateIpAddress();
        GzipTO gzipResponse = gzipRes;
        if (gzipResponse == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400) {
            this.currentIP = SettingHelper.getGaeLocalIpAddress();
            this.currentPort = null;
            gzipResponse = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, this.currentPort, this.isFirstTimeCrawl, SettingHelper.readTokenFromFile());
        }
        if (gzipResponse == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400) {
            this.currentIP = SettingHelper.getPublicIpAddress();
            this.currentPort = null;
            gzipResponse = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, this.currentPort, this.isFirstTimeCrawl, SettingHelper.readTokenFromFile());
        }
        if (gzipResponse == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400 && SettingHelper.getHttpsPort() != null) {
            this.currentIP = SettingHelper.getPublicIpAddress();
            this.currentPort = Integer.valueOf(SettingHelper.getHttpsPort());
            gzipResponse = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, this.currentPort, this.isFirstTimeCrawl, SettingHelper.readTokenFromFile());
        }
        if (gzipResponse != null && gzipResponse.getResponseCode() != 404 && gzipResponse.getResponseCode() != 400) {
            SettingHelper.setCurrentHttpsPort(this.currentPort == null ? null : String.valueOf(this.currentPort));
            SettingHelper.setCurrentCloudIpAddress(this.currentIP);
            SettingHelper.applyChangesToSharedPreferences(false);
        }
        return gzipResponse;
    }

    private void convertBackupTOListToBackupElementList(Set<BackupTO> fileTOList, List<FileElement> fileElementList) {
        for (BackupTO fileTO : fileTOList) {
            BackupElement fileElement = new BackupElement();
            ObjectUtils.copyBackupTOtoFileElement((BackupTO)fileTO, (FileElement)fileElement);
            fileElementList.add((FileElement)fileElement);
        }
    }

    private void createTablesIfNotExist() {
        this.backUpFolderDAOImpl.createBackUpTable();
        this.backUpImageDAOImpl.createTable();
        this.newBackUpCrawlDAOImpl.createTable();
        this.newBackupImageDAOImpl.createNewBackUpImageTable();
        this.newBackupImageDAOImpl.createNewPrevBackUpImageTable();
        this.newBackUpCrawlDAOImpl.createNewPrevBackupCrawlTable();
        this.newBackupImageDAOImpl.createDedupTable();
        this.newBackupImageDAOImpl.createOldPrevBackUpImageTable();
        this.newBackUpCrawlDAOImpl.createOldBackupCrawlTable();
    }

    private void scanFileSystem(List<BackupFolderTO> files, long lastSuccessfullCrawlTime) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        boolean success = this.doDataBaseChanges();
        this.logger.debug("Database changes done" + success);
        if (!files.isEmpty()) {
            List<String> excludedFoldersFromPolicy = null;
            this.logger.debug("START CRAWL " + System.currentTimeMillis());
            if ("true".equalsIgnoreCase(SettingHelper.getIsEnableBackupPolicy())) {
                FilesBeSkippedAsPerPolicy.setLegalHoldDetails();
                BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
                FilesBeSkippedAsPerPolicy.allowedSize = FilesBeSkippedAsPerPolicy.getCurrentPolicyMaxSize();
                FilesBeSkippedAsPerPolicy.extensions = this.backUpFolderDAOImpl.getInclusionExtensions();
                excludedFoldersFromPolicy = backupPolicyDAOImpl.getExcludedFoldersList();
            }
            this.crawlTimeStamp = Long.toString(System.currentTimeMillis());
            for (BackupFolderTO file : files) {
                try {
                    ArrayList<File> fileList;
                    if (excludedFoldersFromPolicy != null && !excludedFoldersFromPolicy.isEmpty() && FilesBeSkippedAsPerPolicy.skipExcludedFolders(excludedFoldersFromPolicy, file.getFolderPath())) continue;
                    this.scanFileSystemByType(file.getFolderPath(), lastSuccessfullCrawlTime);
                    if (!this.backupImageList.isEmpty()) {
                        this.logger.debug(" Files to be inserted in backupimage table" + this.backupImageList.size());
                        ++this.noOfDBWritesForCrawlFileLimit;
                        fileList = new ArrayList<File>();
                        fileList.addAll(this.backupImageList);
                        this.newBackupImageDAOImpl.insertListOfFileNamesIntoTable(fileList);
                        this.backupImageList.clear();
                        fileList.clear();
                    }
                    if (this.crawledFileList.isEmpty()) continue;
                    this.logger.debug("#1 Files to be inserted in crawl table " + this.crawledFileList.size());
                    ++this.noOfDBWritesForCrawlFileLimit;
                    fileList = new ArrayList();
                    fileList.addAll(this.crawledFileList);
                    List backupTOs = ObjectUtils.createBackupElementForFiles(fileList);
                    this.newBackUpCrawlDAOImpl.insertListIntoTable(backupTOs);
                    this.crawledFileList.clear();
                    fileList.clear();
                }
                catch (Exception e) {
                    this.logger.trace("" + e);
                    this.logger.error("exception while crawl" + e.getMessage());
                }
            }
            this.logger.debug("END CRAWL" + System.currentTimeMillis());
            this.logger.debug("noOfDBWritesForCrawlFileLimit:## " + this.noOfDBWritesForCrawlFileLimit);
        }
    }

    private boolean doDataBaseChanges() {
        boolean success = false;
        List<BackupTO> failedFiles = this.newBackUpCrawlDAOImpl.getFailedBackupListFromTableForRemoveBkupImageTable();
        this.logger.debug("Failed Files for delete from bkit count is" + failedFiles.size());
        this.newBackupImageDAOImpl.deleteFailedFilesFromBackupImageTable(failedFiles);
        this.newBackupImageDAOImpl.clearDedupTable();
        this.newBackUpCrawlDAOImpl.deleteEntireOldBackpCrawlTable();
        this.newBackUpCrawlDAOImpl.copyPrevToOldOrOldToPrevBkupCrawlTable("NewPrevBkupToOldBkup");
        boolean delSuccess = this.newBackUpCrawlDAOImpl.deleteEntirePrevCrawlTable();
        boolean copySuccess = false;
        if (delSuccess) {
            copySuccess = this.newBackUpCrawlDAOImpl.copyNewToPrevOrPrevToNewBkupCrawlTable("NewBkupCrawlToPrevNewBackupCrawl");
        }
        if (copySuccess) {
            this.newBackUpCrawlDAOImpl.deleteEntireTable();
        }
        copySuccess = false;
        this.newBackupImageDAOImpl.clearEntireOldBackupImageTable();
        this.newBackupImageDAOImpl.copyOldToPrevOrPrevToOldBkUpImgTable("NewPrevBKITtoOldPrevBKIT");
        delSuccess = this.newBackupImageDAOImpl.clearEntirePrevBackupImageTable();
        if (delSuccess) {
            copySuccess = this.newBackupImageDAOImpl.copyNewToPrevOrPrevToNewBackUpImageTable("NewBackupToNewPrevBackupImageTable");
        }
        if (copySuccess) {
            this.newBackupImageDAOImpl.clearEntireTable();
        }
        if (delSuccess && copySuccess) {
            success = true;
        }
        return success;
    }

    public String backupBatchInitiated(String batchStatus, String batchId, int totalCount, int errorCode, long totalUploadSize, String totalUploadedCount, int crawlCount, String crawlTimeStamp) {
        String jobType = BACKUP;
        String recivedBatchId = batchId;
        try {
            this.logger.debug("the STATUS:" + batchStatus);
            recivedBatchId = this.backupAdapter.sendEmailNotification(batchStatus, SettingHelper.getCurrentCloudIpAddress(), SettingHelper.readTokenFromFile(), recivedBatchId, jobType, SettingHelper.getDeviceName(), totalCount, errorCode, SettingHelper.getDeviceUUId(), totalUploadSize, totalUploadedCount, crawlCount, crawlTimeStamp);
        }
        catch (Exception e) {
            recivedBatchId = "-1";
            this.logger.trace("" + e);
            this.logger.error(" Exception inside  put batch " + e.getMessage());
        }
        return recivedBatchId;
    }

    private BackupResultTO scanFileSystemByType(String completeParentPath, long lastSuccessfullCrawlTime) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        File currentFolder;
        File[] childFileAndFolderNames;
        ArrayList<File> fileList;
        String recivedCompleteParentPath = completeParentPath;
        if (this.backupImageList.size() > 5000) {
            this.logger.debug("Files to be inserted in backupimage table" + this.backupImageList.size());
            ++this.noOfDBWritesForCrawlFileLimit;
            fileList = new ArrayList<File>();
            fileList.addAll(this.backupImageList);
            this.newBackupImageDAOImpl.insertListOfFileNamesIntoTable(fileList);
            this.backupImageList.clear();
            fileList.clear();
        }
        if (this.crawledFileList.size() > 5000) {
            this.logger.debug("Files to be inserted in crawl table " + this.crawledFileList.size());
            ++this.noOfDBWritesForCrawlFileLimit;
            fileList = new ArrayList();
            fileList.addAll(this.crawledFileList);
            List backupTOs = ObjectUtils.createBackupElementForFiles(fileList);
            this.newBackUpCrawlDAOImpl.insertListIntoTable(backupTOs);
            this.crawledFileList.clear();
            fileList.clear();
        }
        if ((childFileAndFolderNames = (currentFolder = new File(recivedCompleteParentPath = this.checkForMacBasePath(recivedCompleteParentPath))).listFiles()) == null) {
            return null;
        }
        for (File currentProcessingFile : childFileAndFolderNames) {
            if (currentProcessingFile.getName().startsWith(".pbsdn")) {
                currentProcessingFile.delete();
                continue;
            }
            this.logger.debug("currentFile: " + currentProcessingFile.getName());
            if (currentProcessingFile.getName().startsWith("pbchnkz") || currentProcessingFile.getName().startsWith(".pbchnkz")) {
                if (currentProcessingFile.isDirectory()) {
                    String[] children = currentProcessingFile.list();
                    for (int j = 0; j < children.length; ++j) {
                        new File(currentProcessingFile, children[j]).delete();
                    }
                }
                currentProcessingFile.delete();
                continue;
            }
            boolean isParabluAppDir = false;
            if (this.isParaBluAppDirectory(currentProcessingFile)) {
                isParabluAppDir = true;
            }
            boolean fileToBeSkipped = this.isFileToBeSkipped(currentProcessingFile.getAbsolutePath());
            boolean isFileToBeSkippedAsperPolicy = false;
            if (!currentProcessingFile.isDirectory() && "true".equalsIgnoreCase(SettingHelper.getLdapEnabled()) && "true".equalsIgnoreCase(SettingHelper.getIsEnableBackupPolicy())) {
                isFileToBeSkippedAsperPolicy = FilesBeSkippedAsPerPolicy.checkVariousPolicies(currentProcessingFile);
            }
            if (fileToBeSkipped || isFileToBeSkippedAsperPolicy || isParabluAppDir) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            this.backupImageList.add(currentProcessingFile);
            if (currentProcessingFile.lastModified() > lastSuccessfullCrawlTime) {
                this.crawledFileList.add(currentProcessingFile);
                backupSizeOnDisk += currentProcessingFile.length();
            }
            if (!isFileADirectory) continue;
            BackupResultTO backupResult = this.scanFileSystemByType(currentProcessingFile.getAbsolutePath(), lastSuccessfullCrawlTime);
            if (backupResult != null && backupResult.getCrawledFileList() != null) {
                this.crawledFileList.addAll(backupResult.getCrawledFileList());
            }
            if (backupResult == null || backupResult.getBackupImageList() == null) continue;
            this.backupImageList.addAll(backupResult.getBackupImageList());
        }
        if (this.backupImageList.size() > 5000) {
            ++this.noOfDBWritesForCrawlFileLimit;
            ArrayList<File> fileList2 = new ArrayList<File>();
            fileList2.addAll(this.backupImageList);
            this.logger.debug("Files to be inserted " + this.backupImageList.size());
            this.newBackupImageDAOImpl.insertListOfFileNamesIntoTable(fileList2);
            this.backupImageList.clear();
        }
        if (this.crawledFileList.size() > 5000) {
            this.logger.debug("Files to be inserted " + this.crawledFileList.size());
            ++this.noOfDBWritesForCrawlFileLimit;
            ArrayList<File> fileList3 = new ArrayList<File>();
            fileList3.addAll(this.crawledFileList);
            List backupTOs = ObjectUtils.createBackupElementForFiles(fileList3);
            this.newBackUpCrawlDAOImpl.insertListIntoTable(backupTOs);
            this.crawledFileList.clear();
            fileList3.clear();
        }
        BackupResultTO backupResult = new BackupResultTO();
        backupResult.setBackupImageList(this.backupImageList);
        backupResult.setCrawledFileList(this.crawledFileList);
        return backupResult;
    }

    public boolean isPotentialValidLink(File file) {
        int minimumLength = 100;
        boolean isPotentiallyValid = false;
        try (FileInputStream fis = new FileInputStream(file);){
            isPotentiallyValid = file.isFile() && file.getName().toLowerCase().endsWith(".lnk") && ((InputStream)fis).available() >= 100;
        }
        catch (IOException e) {
            this.logger.trace("" + e);
            this.logger.error("exception while reading file" + e.getMessage());
        }
        return isPotentiallyValid;
    }

    private boolean isParaBluAppDirectory(File currentProcessingFile) {
        boolean isAppDir = false;
        String paraBluDir = SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + "AppData" + StringLiterals.FILE_SEPARATOR + "Roaming" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBlu";
        if (currentProcessingFile.getAbsolutePath().toLowerCase().contains(paraBluDir.toLowerCase())) {
            isAppDir = true;
        }
        return isAppDir;
    }

    public static String rootDirectory() {
        return File.listRoots()[0].getAbsolutePath();
    }

    private boolean isFileToBeSkipped(String fileName) {
        if (FilesBeSkippedAsPerPolicy.isBackupSystemFilesEnabled()) {
            return false;
        }
        String rootDirectory = NewBackUpJob.rootDirectory().toLowerCase();
        for (BackupFoldersToBeSkipped beSkipped : BackupFoldersToBeSkipped.values()) {
            String folderBeSkipped = (rootDirectory + beSkipped.name()).toLowerCase();
            String currentFolder = fileName.toLowerCase();
            if (!currentFolder.contains(folderBeSkipped) && !currentFolder.contains(rootDirectory + "program files")) continue;
            return true;
        }
        return false;
    }

    private String checkForMacBasePath(String completeParentPath) {
        String mac = "Macintosh";
        if (completeParentPath.startsWith("Macintosh" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(9);
        }
        return completeParentPath;
    }

    private int getCrawlLimit() {
        if (!StringUtils.isEmpty((String)SettingHelper.getBackupCrawlLimit())) {
            this.logger.debug("returning crawl limit" + SettingHelper.getBackupCrawlLimit());
            return Integer.valueOf(SettingHelper.getBackupCrawlLimit());
        }
        return 500;
    }

    public abstract void deleteVsnapshot(List<BackupFolderTO> var1);

    public abstract void createVsnapshot(List<BackupFolderTO> var1);

    public abstract boolean runScripts(String var1, boolean var2);
}

